#ifndef  NO_SCCS_ID
static char SCCS_ID [] = "@(#)finger.c (TWG)  1.1     89/05/17 ";
#define NO_SCCS_ID
#endif /*NO_SCCS_ID*/
/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */
/* "@(#)finger.c	4.5 (Berkeley) 9/16/83"; */


/*  This is a finger program.  It prints out useful information about users
 *  by digging it up from various system files.  It is not very portable
 *  because the most useful parts of the information (the full user name,
 *  office, and phone numbers) are all stored in the VAX-unused gecos field
 *  of /etc/passwd, which, unfortunately, other UNIXes use for other things.
 *
 *  There are three output formats, all of which give login name, teletype
 *  line number, and login time.  The short output format is reminiscent
 *  of finger on ITS, and gives one line of information per user containing
 *  in addition to the minimum basic requirements (MBR), the full name of
 *  the user, his idle time and office location and phone number.  The
 *  quick style output is UNIX who-like, giving only name, teletype and
 *  login time.  Finally, the long style output give the same information
 *  as the short (in more legible format), the home directory and shell
 *  of the user, and, if it exits, a copy of the file .plan in the users
 *  home directory.  Finger may be called with or without a list of people
 *  to finger -- if no list is given, all the people currently logged in
 *  are fingered.
 *
 *  The program is validly called by one of the following:
 *
 *	finger			{short form list of users}
 *	finger -l		{long form list of users}
 *	finger -b		{briefer long form list of users}
 *	finger -q		{quick list of users}
 *	finger -i		{quick list of users with idle times}
 *	finger namelist		{long format list of specified users}
 *	finger -s namelist	{short format list of specified users}
 *	finger -w namelist	{narrow short format list of specified users}
 *
 *  where 'namelist' is a list of users login names.
 *  The other options can all be given after one '-', or each can have its
 *  own '-'.  The -f option disables the printing of headers for short and
 *  quick outputs.  The -b option briefens long format outputs.  The -p
 *  option turns off plans for long format outputs.
 */

#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sgtty.h>
#include	<utmp.h>
#include	<signal.h>
#include	<pwd.h>
#include	<stdio.h>
#include	<ctype.h>
#ifdef notdef
# include	<sccs.h>
#endif
#include	<time.h>
#include	<malloc.h>

#define		ASTERISK	'*'	/* ignore this in real name */
#define		BLANK		' '	/* blank character (i.e. space) */
#define		CAPITALIZE	0137&	/* capitalize character macro */
#define		COMMA		','	/* separator in pw_gecos field */
#define		COMMAND		'-'	/* command line flag char */
#define		CORY		'C'	/* cory hall office */
#define		EVANS		'E'	/* evans hall office */
#define		LINEBREAK	012	/* line feed */
#define		NULLSTR		""	/* a null string, opposed to a null */
#define		SAMENAME	'&'	/* repeat login name in real name */
#define		TALKABLE	0222	/* tty is writeable if 222 mode */

struct  person  {			/* one for each person fingered */
	char		name[12];	/* login name */
	char		tty[12];	/* NULL terminated tty line */
	long		loginat;	/* time of login */
	long		idletime;	/* how long idle (if logged in) */
	short		loggedin;	/* flag for being logged in */
	short		writeable;	/* flag for tty being writeable */
	char		*realname;	/* pointer to full name */
	char		*office;	/* pointer to office name */
	char		*officephone;	/* pointer to office phone no. */
	char		*homephone;	/* pointer to home phone no. */
	char		*random;	/* for any random stuff in pw_gecos */
	struct  passwd	*pwd;		/* structure of /etc/passwd stuff */
	struct  person	*link;		/* link to next person */
};

struct  passwd			*NILPWD = 0;
struct  person			*NILPERS = 0;

int		persize		= sizeof( struct person );
int		pwdsize		= sizeof( struct passwd );

char		USERLOG[]	= "/etc/utmp";		/* who is logged in */
char		outbuf[BUFSIZ];				/* output buffer */
char		*ctime();

int		unbrief		= 1;		/* -b option default */
int		header		= 1;		/* -f option default */
int		hack		= 1;		/* -h option default */
int		idle		= 0;		/* -i option default */
int		large		= 0;		/* -l option default */
int		match		= 1;		/* -m option default */
int		plan		= 1;		/* -p option default */
int		unquick		= 1;		/* -q option default */
int		small		= 0;		/* -s option default */
int		wide		= 1;		/* -w option default */

long		tloc;				/* current time */

main(argc,argv)
int argc;
char *argv[];
{
	if(index(argv[1],'@')) tcpfinger(argc,argv);
	else finger(argc,argv);
}
finger( argc, argv )

    int		argc;
    char	*argv[];

{
	FILE			*fp,  *fopen();		/* for plans */
	struct  passwd		*getpwent();		/* read /etc/passwd */
	struct  person		*person1,  *p,  *pend;	/* people */
	struct  passwd		*pw;			/* temporary */
	struct  utmp		user;			/*   ditto   */
	char			*s,  *pn,  *ln;
	char			c;
	char			*PLAN = "/.plan";	/* what plan file is */
	char			*PROJ = "/.project";	/* what project file */
	int			PLANLEN = strlen( PLAN );
	int			PROJLEN = strlen( PROJ );
	int			numnames = 0;
	int			orgnumnames;
	int			uf;
	int			usize = sizeof user;
	int			unshort;
	int			i, j;
	int			fngrlogin;

	setbuf( stdout, outbuf );			/* buffer output */

    /*  parse command line for (optional) arguments */

	i = 1;
	if(  strcmp( *argv, "sh" )  )  {
	    fngrlogin = 0;
	    while( i++ < argc  &&  (*++argv)[0] == COMMAND )  {
		for( s = argv[0] + 1; *s != NULL; s++ )  {
			switch  (*s)  {

			    case 'b':
				    unbrief = 0;
				    break;

			    case 'f':
				    header = 0;
				    break;

			    case 'h':
				    hack = 0;
				    break;

			    case 'i':
				    idle = 1;
				    unquick = 0;
				    break;

			    case 'l':
				    large = 1;
				    break;

			    case 'm':
				    match = 0;
				    break;

			    case 'p':
				    plan = 0;
				    break;

			    case 'q':
				    unquick = 0;
				    break;

			    case 's':
				    small = 1;
				    break;

			    case 'w':
				    wide = 0;
				    break;

			    default:
				fprintf( stderr, "finger: Usage -- 'finger [-bfhilmpqsw] [login1 [login2 ...] ]'\n" );
				exit( 1 );
			}
		}
	    }
	}
	else  {
	    fngrlogin = 1;
	}
	if( unquick )  {
	    time( &tloc );
	}
	else  {
	    if( idle )  {
		time( &tloc );
	    }
	}

    /*  i > argc means no login names given so get them by reading USERLOG */

	if(  (i > argc)  ||  fngrlogin  )  {
	    unshort = large;
	    if(  ( uf = open(USERLOG, 0) ) >= 0  )  {
		user.ut_name[0] = NULL;
		while( user.ut_name[0] == NULL )  {
		    if( read( uf, (char *) &user, usize ) != usize )  {
			printf( "\nNo one logged on\n" );
			exit( 0 );
		    }
#ifdef USG
		    if ( user.ut_type != USER_PROCESS )
				user.ut_name[0] = '\0' ;
#endif /* USG */
		}
		person1 = (struct person  *) malloc( persize );
		for( j = 0; j < 12; j++ )  {
		    person1->tty[j] = user.ut_line[j];
		    person1->name[j] = user.ut_name[j];
		}
		person1->name[11] = NULL;
		person1->tty[11] = NULL;
		person1->loginat = user.ut_time;
		person1->pwd = NILPWD;
		person1->loggedin = 1;
		numnames++;
		p = person1;
		while( read( uf, (char *) &user, usize ) == usize )  {
		    if( user.ut_name[0] == NULL )  continue;
#ifdef USG
			if(user.ut_type != USER_PROCESS ) continue;
#endif /* USG */
		    p->link = (struct person  *) malloc( persize );
		    p = p->link;
		    for( j = 0; j < 12; j++ )  {
			p->tty[j] = user.ut_line[j];
			p->name[j] = user.ut_name[j];
		    }
		    p->name[11] = NULL;
		    p->tty[11] = NULL;
		    p->loginat = user.ut_time;
		    p->pwd = NILPWD;
		    p->loggedin = 1;
		    numnames++;
		}
		p->link = NILPERS;
		close( uf );
	    }
	    else  {
		fprintf( stderr, "finger: error opening %s\n", USERLOG );
		exit( 2 );
	    }

		/*  if we are doing it, read /etc/passwd for the useful info */

	    if( unquick )  {
		setpwent();
		i = numnames;
		while(  ( (pw = getpwent()) != NILPWD )  &&  ( i > 0 )  )  {
		    p = person1;
		    do  {
			if( p->pwd == NILPWD )  {
			    if(  strcmp( p->name, pw->pw_name ) == 0  )  {
				p->pwd = (struct passwd  *) malloc( pwdsize );
				pwdcopy( p->pwd, pw );
				decode( p );
				i--;
			    }
			}
			p = p->link;
		    }  while( p != NILPERS );
		}
		endpwent();
	    }
	}

    /* get names from command line and check to see if they're  logged in */

	else  {
	    unshort = ( small == 1 ? 0 : 1 );
	    i++;
	    person1 = (struct person  *) malloc( persize );
	    strcpy(  person1->name, (argv++)[ 0 ]  );
	    person1->loggedin = 0;
	    person1->pwd = NILPWD;
	    numnames++;
	    p = person1;
	    while( i++ <= argc )  {
		p->link = (struct person  *) malloc( persize );
		p = p->link;
		strcpy(  p->name, (argv++)[ 0 ]  );
		p->loggedin = 0;
		p->pwd = NILPWD;
		numnames++;
	    }
	    p->link = NILPERS;
	    pend = p;

		/*  if we are doing it, read /etc/passwd for the useful info */

	    orgnumnames = numnames;
	    if( unquick )  {
		setpwent();
		while(  ( pw = getpwent() ) != NILPWD  )  {
		    p = person1;
		    i = 0;
		    do  {
			if( strcmp( p->name, pw->pw_name ) == 0    ||
			    matchcmp( pw->pw_gecos, pw->pw_name, p->name ) )  {
			    if( p->pwd == NILPWD )  {
				p->pwd = (struct passwd  *) malloc( pwdsize );
				pwdcopy( p->pwd, pw );
			    }
			    else  {	/* handle multiple logins -- append new
					   "duplicate" entry to end of list */
				pend->link = (struct person  *) malloc(persize);
				pend = pend->link;
				pend->link = NILPERS;
				strcpy( pend->name, p->name );
				pend->pwd = (struct passwd  *) malloc(pwdsize);
				pwdcopy( pend->pwd, pw );
				numnames++;
			    }
			}
			p = p->link;
		    }  while( ++i < orgnumnames );
		}
		endpwent();
	    }

		/*  Now get login information */

	    if(  ( uf = open(USERLOG, 0) ) >= 0  )  {
		while( read( uf, (char *) &user, usize ) == usize )  {
		    if( user.ut_name[0] == NULL )  continue;
		    p = person1;
		    do  {
			pw = p->pwd;
			if( pw == NILPWD )  {
			    i = ( strcmp( p->name, user.ut_name ) ? 0 : 11 );
			}
			else  {
			    i = 0;
			    while(  (i < 11)  &&
				    ( pw->pw_name[i] == user.ut_name[i])  )  {
				if( pw->pw_name[i] == NULL )  {
				    i = 11;
				    break;
				}
				i++;
			    }
			}
			if( i == 11 )  {
			    if( p->loggedin == 1 )  {
				pend->link = (struct person  *) malloc(persize);
				pend = pend->link;
				pend->link = NILPERS;
				strcpy( pend->name, p->name );
				for( j = 0; j < 12; j++ )  {
				    pend->tty[j] = user.ut_line[j];
				}
				pend->tty[ 11 ] = NULL;
				pend->loginat = user.ut_time;
				pend->loggedin = 2;
				if(  pw == NILPWD  )  {
				    pend ->pwd = NILPWD;
				}
				else  {
				    pend->pwd = (struct passwd  *) malloc(pwdsize);
				    pwdcopy( pend->pwd, pw );
				}
				numnames++;
			    }
			    else  {
				if( p->loggedin != 2 )  {
				    for( j = 0; j < 12; j++ )  {
					p->tty[j] = user.ut_line[j];
				    }
				    p->tty[ 11 ] = NULL;
				    p->loginat = user.ut_time;
				    p->loggedin = 1;
				}
			    }
			}
			p = p->link;
		    }  while( p != NILPERS );
		}
		p = person1;
		while( p != NILPERS )  {
		    if( p->loggedin == 2 )  {
			p->loggedin = 1;
		    }
		    decode( p );
		    p = p->link;
		}
		close( uf );
	    }
	    else  {
		fprintf( stderr, "finger: error opening %s\n", USERLOG );
		exit( 2 );
	    }
	}

    /* print out what we got */

	if( header )  {
	    if( unquick )  {
		if( !unshort )  {
		    if( wide )  {
			printf(
"Login       Name               TTY  Idle    When            Office\n" );
		    }
		    else  {
			printf(
"Login     TTY  Idle    When            Office\n" );
		    }
		}
	    }
	    else  {
		printf( "Login      TTY            When" );
		if( idle )  {
		    printf( "             Idle" );
		}
		printf( "\n" );
	    }
	}
	p = person1;
	do  {
	    if( unquick )  {
		if( unshort )  {
		    personprint( p );
		    if( p->pwd != NILPWD )  {
			if( hack )  {
			    s = malloc(strlen((p->pwd)->pw_dir) + PROJLEN + 1 );
			    strcpy(  s, (p->pwd)->pw_dir  );
			    strcat( s, PROJ );
			    if(  ( fp = fopen( s, "r") )  != NULL  )  {
				printf( "Project: " );
				while(  ( c = getc(fp) )  !=  EOF  )  {
				    if( c == LINEBREAK )  {
					break;
				    }
				    putc( c, stdout );
				}
				fclose( fp );
				printf( "\n" );
			    }
			}
			if( plan )  {
			    s = malloc( strlen( (p->pwd)->pw_dir ) + PLANLEN + 1 );
			    strcpy(  s, (p->pwd)->pw_dir  );
			    strcat( s, PLAN );
			    if(  ( fp = fopen( s, "r") )  == NULL  )  {
				printf( "No Plan.\n" );
			    }
			    else  {
				printf( "Plan:  " );
				while(  ( j = getc(fp) )  !=  EOF  )  {
				    putc( j, stdout );
				}
				fclose( fp );
			    }
			}
		    }
		    if( p->link != NILPERS )  {
			printf( "\n" );
		    }
		}
		else  {
		    shortprint( p );
		}
	    }
	    else  {
		quickprint( p );
	    }
	    p = p->link;
	}  while( p != NILPERS );
	exit (0);
}


/*  given a pointer to a pwd (pfrom) copy it to another one, allocating
 *  space for all the stuff in it.  Note: Only the useful (what the
 *  program currently uses) things are copied.
 */

pwdcopy( pto, pfrom )		/* copy relevant fields only */

    struct  passwd		*pto,  *pfrom;
{
	pto->pw_name = malloc(  strlen( pfrom->pw_name ) + 1  );
	strcpy( pto->pw_name, pfrom->pw_name );
	pto->pw_uid = pfrom->pw_uid;
	pto->pw_gecos = malloc(  strlen( pfrom->pw_gecos ) + 1  );
	strcpy( pto->pw_gecos, pfrom->pw_gecos );
	pto->pw_dir = malloc(  strlen( pfrom->pw_dir ) + 1  );
	strcpy( pto->pw_dir, pfrom->pw_dir );
	pto->pw_shell = malloc(  strlen( pfrom->pw_shell ) + 1  );
	strcpy( pto->pw_shell, pfrom->pw_shell );
}


/*  print out information on quick format giving just name, tty, login time
 *  and idle time if idle is set.
 */

quickprint( pers )

    register struct  person		*pers;
{
	int			idleprinted;
	register char *cp;

	if (pers->tty[3] == 'p' || pers->tty[3] == 'q')
		cp = &pers->tty[6];
	else cp = "me";
	printf( "%-8.8s", pers->name );
	printf( "  " );
	if( pers->loggedin )  {
	    if( idle )  {
		findidle( pers );
		if( pers->writeable )  {
		    printf(  " %-8.8s(%s) %-16.16s",
			pers->tty,cp, ctime( &pers->loginat )  );
		}
		else  {
		    printf(  "*%-8.8s(%s) %-16.16s",
			pers->tty,cp, ctime( &pers->loginat )  );
		}
		printf( "   " );
		idleprinted = ltimeprint( &pers->idletime );
	    }
	    else  {
		printf(  " %-8.8s(%s) %-16.16s",
		    pers->tty,cp, ctime( &pers->loginat )  );
	    }
	}
	else  {
	    printf( "          Not Logged In" );
	}
	printf( "\n" );
}


/*  print out information in short format, giving login name, full name,
 *  tty, idle time, login time, office location and phone.
 */

shortprint( pers )

    struct  person	*pers;

{
	struct  passwd		*pwdt = pers->pwd;
	char			buf[ 26 ];
	int			i,  len,  offset,  dialup;

	if( pwdt == NILPWD )  {
	    printf( "%-8.8s", pers->name );
	    printf( "       ???\n" );
	    return;
	}
	printf( "%-8.8s", pwdt->pw_name );
	dialup = 0;
	if( wide )  {
	    if(  strlen( pers->realname ) > 0  )  {
		printf( " %-20.20s", pers->realname );
	    }
	    else  {
		printf( "        ???          " );
	    }
	}
	if( pers->loggedin )  {
	    if( pers->writeable )  {
		printf( "  " );
	    }
	    else  {
		printf( " *" );
	    }
	}
	else  {
	    printf( "  " );
	}
	if(  strlen( pers->tty ) > 0  )  {
	    strcpy( buf, pers->tty );
	    if(pers->loggedin &&
		((buf[0]=='d') || (strncmp(buf,"ttyd")==0))) dialup = 1;
	    printf( "%-5.5s ", buf );
	}
	else  {
	    printf( "      " );
	}
	strcpy( buf, ctime( &pers->loginat ) );
	if( pers->loggedin )  {
	    stimeprint( &pers->idletime );
	    offset = 7;
	    for( i = 4; i < 19; i++ )  {
		buf[i] = buf[i + offset];
	    }
	    printf( " %-9.9s ", buf );
	}
	else  {
	    printf( " " );
	    offset = 4;
	    for( i = 0; i <22; i++ )  {
		buf[i] = buf[i + offset];
	    }
	    printf( "<%-12.12s>", buf );
	}
	len = strlen( pers->homephone );
	if(  dialup  &&  (len > 0)  )  {
	    if( len == 8 )  {
		printf( "             " );
	    }
	    else  {
		if( len == 12 )  {
		    printf( "         " );
		}
		else {
		    for( i = 1; i <= 21 - len; i++ )  {
			printf( " " );
		    }
		}
	    }
	    printf( "%s", pers->homephone );
	}
	else  {
	    if(  strlen( pers->office ) > 0  )  {
		printf( " %-11.11s", pers->office );
		if(  strlen( pers->officephone ) > 0  )  {
		    printf( " %8.8s", pers->officephone );
		}
		else  {
		    if( len == 8 )  {
			printf( " %8.8s", pers->homephone );
		    }
		}
	    }
	    else  {
		if(  strlen( pers->officephone ) > 0  )  {
		    printf( "             %8.8s", pers->officephone );
		}
		else  {
		    if( len == 8 )  {
			printf( "             %8.8s", pers->homephone );
		    }
		    else  {
			if( len == 12 )  {
			    printf( "         %12.12s", pers->homephone );
			}
		    }
		}
	    }
	}
	printf( "\n" );
}


/*  print out a person in long format giving all possible information.
 *  directory and shell are inhibited if unbrief is clear.
 */

personprint( pers )

    struct  person	*pers;
{
	struct  passwd		*pwdt = pers->pwd;
	int			idleprinted;

	if( pwdt == NILPWD )  {
	    printf( "Login name: %-10s", pers->name );
	    printf( "			" );
	    printf( "In real life: ???\n");
	    return;
	}
	printf( "Login name: %-10s", pwdt->pw_name );
	if( pers->loggedin )  {
	    if( pers->writeable )  {
		printf( "			" );
	    }
	    else  {
		printf( "	(messages off)	" );
	    }
	}
	else  {
	    printf( "			" );
	}
	if(  strlen( pers->realname ) > 0  )  {
	    printf( "In real life: %-s", pers->realname );
	}
	if(  strlen( pers->office ) > 0  )  {
	    printf( "\nOffice: %-.11s", pers->office );
	    if(  strlen( pers->officephone ) > 0  )  {
		printf( ", %s", pers->officephone );
		if(  strlen( pers->homephone ) > 0  )  {
		    printf( "		Home phone: %s", pers->homephone );
		}
		else  {
		    if(  strlen( pers->random ) > 0  )  {
			printf( "	%s", pers->random );
		    }
		}
	    }
	    else  {
		if(  strlen( pers->homephone ) > 0  )  {
		    printf("			Home phone: %s",pers->homephone);
		}
		if(  strlen( pers->random ) > 0  )  {
		    printf( "			%s", pers->random );
		}
	    }
	}
	else  {
	    if(  strlen( pers->officephone ) > 0  )  {
		printf( "\nPhone: %s", pers->officephone );
		if(  strlen( pers->homephone ) > 0  )  {
		    printf( "\n, %s", pers->homephone );
		    if(  strlen( pers->random ) > 0  )  {
			printf( ", %s", pers->random );
		    }
		}
		else  {
		    if(  strlen( pers->random ) > 0  )  {
			printf( "\n, %s", pers->random );
		    }
		}
	    }
	    else  {
		if(  strlen( pers->homephone ) > 0  )  {
		    printf( "\nPhone: %s", pers->homephone );
		    if(  strlen( pers->random ) > 0  )  {
			printf( "%s", pers->random );
		    }
		}
		else  {
		    if(  strlen( pers->random ) > 0  )  {
			printf( "\n%s", pers->random );
		    }
		}
	    }
	}
	if( unbrief )  {
	    printf( "\n" );
	    printf( "Directory: %-25s", pwdt->pw_dir );
	    if(  strlen( pwdt->pw_shell ) > 0  )  {
		printf( "	Shell: %-s", pwdt->pw_shell );
	    }
	}
	if( pers->loggedin )  {
	    register char *ep = ctime( &pers->loginat );
	    printf("\nOn since %15.15s on %-8.8s	", &ep[4], pers->tty );
	    idleprinted = ltimeprint( &pers->idletime );
	    if( idleprinted )  {
		printf( " Idle Time" );
	    }
	}
	printf( "\n" );
}


/*
 *  very hacky section of code to format phone numbers.  filled with
 *  magic constants like 4, 7 and 10.
 */

char  *phone( s, len )

    char		*s;
    int			len;
{
	char		*strsave();
	char		fonebuf[ 15 ];
	int		i;

	switch(  len  )  {

	    case  4:
		fonebuf[ 0 ] = ' ';
		fonebuf[ 1 ] = 'x';
		fonebuf[ 2 ] = '2';
		fonebuf[ 3 ] = '-';
		for( i = 0; i <= 3; i++ )  {
		    fonebuf[ 4 + i ] = *s++;
		}
		fonebuf[ 8 ] = NULL;
		return( strsave( &fonebuf[0] ) );
		break;

	    case  7:
		for( i = 0; i <= 2; i++ )  {
		    fonebuf[ i ] = *s++;
		}
		fonebuf[ 3 ] = '-';
		for( i = 0; i <= 3; i++ )  {
		    fonebuf[ 4 + i ] = *s++;
		}
		fonebuf[ 8 ] = NULL;
		return( strsave( &fonebuf[0] ) );
		break;

	    case 10:
		for( i = 0; i <= 2; i++ )  {
		    fonebuf[ i ] = *s++;
		}
		fonebuf[ 3 ] = '-';
		for( i = 0; i <= 2; i++ )  {
		    fonebuf[ 4 + i ] = *s++;
		}
		fonebuf[ 7 ] = '-';
		for( i = 0; i <= 3; i++ )  {
		    fonebuf[ 8 + i ] = *s++;
		}
		fonebuf[ 12 ] = NULL;
		return( strsave( &fonebuf[0] ) );
		break;

	    default:
		fprintf( stderr, "finger: error in phone numbering\n" );
		return( strsave(s) );
		break;
	}
}


/*  decode the information in the gecos field of /etc/passwd
 *  another hacky section of code, but given the format the stuff is in...
 */

decode( pers )

    struct  person	*pers;

{
	struct  passwd		*pwdt = pers->pwd;
	char			buffer[ 40 ],  *bp,  *gp,  *lp;
	char			*phone();
	int			alldigits;
	int			len;
	int			i;

	pers->realname = NULLSTR;
	pers->office = NULLSTR;
	pers->officephone = NULLSTR;
	pers->homephone = NULLSTR;
	pers->random = NULLSTR;
	if(  pwdt != NILPWD )  {
	    gp = pwdt->pw_gecos;
	    bp = &buffer[ 0 ];
	    if( *gp == ASTERISK )  {
		gp++;
	    }
	    while(  (*gp != NULL)  &&  (*gp != COMMA)  )  {	/* name */
		if( *gp == SAMENAME )  {
		    lp = pwdt->pw_name;
		    *bp++ = CAPITALIZE(*lp++);
		    while( *lp != NULL )  {
			*bp++ = *lp++;
		    }
		}
		else  {
		    if( *gp == '$' )  {
			while(  (*gp != NULL)  &&  (*gp != COMMA)  )  gp++;
			break;
		    }
		    else  {
			*bp++ = *gp;
		    }
		}
		gp++;
	    }
	    *bp = NULL;
	    pers->realname = malloc( strlen( &buffer[0] ) + 1 );
	    strcpy( pers->realname, &buffer[0] );
	    if( *gp++ == COMMA )  {			/* office, supposedly */
		alldigits = 1;
		bp = &buffer[ 0 ];
		while(  (*gp != NULL)  &&  (*gp != COMMA)  )  {
		    *bp = *gp++;
		    alldigits = alldigits && ('0' <= *bp) && (*bp <= '9');
		    bp++;
		}
		*bp = NULL;
		len = strlen( &buffer[0] );
		if( buffer[ len - 1 ]  ==  CORY )  {
		    strcpy( &buffer[ len - 1 ], " Cory" );
		    pers->office = malloc( len + 5 );
		    strcpy( pers->office, &buffer[0] );
		}
		else  {
		    if( buffer[ len - 1 ] == EVANS )  {
			strcpy( &buffer[ len - 1 ], " Evans" );
			pers->office = malloc( len + 6 );
			strcpy( pers->office, &buffer[0] );
		    }
		    else  {
			if( buffer[ len - 1 ] == 'L' )  {
			    strcpy( &buffer[ len - 3 ], " LBL" );
			    pers->office = malloc( len + 2 );
			    strcpy( pers->office, &buffer[0] );
			}
			else  {
			    if( alldigits )  {
				if( len == 4 )  {
				    pers->officephone = phone(&buffer[0], len);
				}
				else  {
				    if(  (len == 7) || (len == 10)  )  {
					pers->homephone = phone(&buffer[0],len);
				    }
				}
			    }
			    else  {
				pers->random = malloc( len + 1 );
				strcpy( pers->random, &buffer[0] );
			    }
			}
		    }
		}
		if( *gp++ == COMMA )  {	    /* office phone, theoretically */
		    bp = &buffer[ 0 ];
		    alldigits = 1;
		    while(  (*gp != NULL)  &&  (*gp != COMMA)  )  {
			*bp = *gp++;
			alldigits = alldigits && ('0' <= *bp) && (*bp <= '9');
			bp++;
		    }
		    *bp = NULL;
		    len = strlen( &buffer[0] );
		    if( alldigits )  {
			if(  len != 4  )  {
			    if(  (len == 7) || (len == 10)  )  {
				pers->homephone = phone( &buffer[0], len );
			    }
			    else  {
				pers->random = malloc( len + 1 );
				strcpy( pers->random, &buffer[0] );
			    }
			}
			else  {
				pers->officephone = phone( &buffer[0], len );
			}
		    }
		    else  {
			pers->random = malloc( len + 1 );
			strcpy( pers->random, &buffer[0] );
		    }
		    if( *gp++ == COMMA )  {		/* home phone?? */
			bp = &buffer[ 0 ];
			alldigits = 1;
			    while(  (*gp != NULL)  &&  (*gp != COMMA)  )  {
				*bp = *gp++;
				alldigits = alldigits && ('0' <= *bp) &&
							(*bp <= '9');
				bp++;
			    }
			*bp = NULL;
			len = strlen( &buffer[0] );
			if( alldigits  &&  ( (len == 7) || (len == 10) )  )  {
			    if( *pers->homephone != NULL )  {
				pers->officephone = pers->homephone;
			    }
			    pers->homephone = phone( &buffer[0], len );
			}
			else  {
			    pers->random = malloc( strlen( &buffer[0] ) + 1 );
			    strcpy( pers->random, &buffer[0] );
			}
		    }
		}
	    }
	    if( pers->loggedin != 0 )  {
		findidle( pers );
	    }
	}
}


/*  find the idle time of a user by doing a stat on /dev/histty,
 *  where histty has been gotten from USERLOG, supposedly.
 */

findidle( pers )

    struct  person	*pers;
{
	struct  stat		ttystatus;
	struct  passwd		*pwdt = pers->pwd;
	char			buffer[ 20 ];
	char			*TTY = "/dev/";
	int			TTYLEN = strlen( TTY );
	int			i;

	strcpy( &buffer[0], TTY );
	i = 0;
	do  {
	    buffer[ TTYLEN + i ] = pers->tty[ i ];
	}  while( ++i <= 11 );
	if(  stat( &buffer[0], &ttystatus ) >= 0  )  {
	    time( &tloc );
	    if( tloc < ttystatus.st_atime )  {
		pers->idletime = 0L;
	    }
	    else  {
		pers->idletime = tloc - ttystatus.st_atime;
	    }
	    if(  (ttystatus.st_mode & TALKABLE) == TALKABLE  )  {
		pers->writeable = 1;
	    }
	    else  {
		pers->writeable = 0;
	    }
	}
	else  {
	    fprintf( stderr, "finger: error STATing %s\n", &buffer[0] );
	    exit( 4 );
	}
}


/*  print idle time in short format; this program always prints 4 characters;
 *  if the idle time is zero, it prints 4 blanks.
 */

stimeprint( dt )

    long	*dt;
{
	struct  tm		*gmtime();
	struct  tm		*delta;

	delta = gmtime( dt );
	if( delta->tm_yday == 0 )  {
	    if( delta->tm_hour == 0 )  {
		if( delta->tm_min >= 10 )  {
		    printf( " %2.2d ", delta->tm_min );
		}
		else  {
		    if( delta->tm_min == 0 )  {
			printf( "    " );
		    }
		    else  {
			printf( "  %1.1d ", delta->tm_min );
		    }
		}
	    }
	    else  {
		if( delta->tm_hour >= 10 )  {
		    printf( "%3.3d:", delta->tm_hour );
		}
		else  {
		    printf( "%1.1d:%02.2d", delta->tm_hour, delta->tm_min );
		}
	    }
	}
	else  {
	    printf( "%3dd", delta->tm_yday );
	}
}


/*  print idle time in long format with care being taken not to pluralize
 *  1 minutes or 1 hours or 1 days.
 */

ltimeprint( dt )

    long	*dt;
{
	struct  tm		*gmtime();
	struct  tm		*delta;
	int			printed = 1;

	delta = gmtime( dt );
	if( delta->tm_yday == 0 )  {
	    if( delta->tm_hour == 0 )  {
		if( delta->tm_min >= 10 )  {
		    printf( "%2d minutes", delta->tm_min );
		}
		else  {
		    if( delta->tm_min == 0 )  {
			if( delta->tm_sec > 10 )  {
			    printf( "%2d seconds", delta->tm_sec );
			}
			else  {
			    printed = 0;
			}
		    }
		    else  {
			if( delta->tm_min == 1 )  {
			    if( delta->tm_sec == 1 )  {
				printf( "%1d minute %1d second",
				    delta->tm_min, delta->tm_sec );
			    }
			    else  {
				printf( "%1d minute %d seconds",
				    delta->tm_min, delta->tm_sec );
			    }
			}
			else  {
			    if( delta->tm_sec == 1 )  {
				printf( "%1d minutes %1d second",
				    delta->tm_min, delta->tm_sec );
			    }
			    else  {
				printf( "%1d minutes %d seconds",
				    delta->tm_min, delta->tm_sec );
			    }
			}
		    }
		}
	    }
	    else  {
		if( delta->tm_hour >= 10 )  {
		    printf( "%2d hours", delta->tm_hour );
		}
		else  {
		    if( delta->tm_hour == 1 )  {
			if( delta->tm_min == 1 )  {
			    printf( "%1d hour %1d minute",
				delta->tm_hour, delta->tm_min );
			}
			else  {
			    printf( "%1d hour %2d minutes",
				delta->tm_hour, delta->tm_min );
			}
		    }
		    else  {
			if( delta->tm_min == 1 )  {
			    printf( "%1d hours %1d minute",
				delta->tm_hour, delta->tm_min );
			}
			else  {
			    printf( "%1d hours %2d minutes",
				delta->tm_hour, delta->tm_min );
			}
		    }
		}
	    }
	}
	else  {
		if( delta->tm_yday >= 10 )  {
		    printf( "%2d days", delta->tm_yday );
		}
		else  {
		    if( delta->tm_yday == 1 )  {
			if( delta->tm_hour == 1 )  {
			    printf( "%1d day %1d hour",
				delta->tm_yday, delta->tm_hour );
			}
			else  {
			    printf( "%1d day %2d hours",
				delta->tm_yday, delta->tm_hour );
			}
		    }
		    else  {
			if( delta->tm_hour == 1 )  {
			    printf( "%1d days %1d hour",
				delta->tm_yday, delta->tm_hour );
			}
			else  {
			    printf( "%1d days %2d hours",
				delta->tm_yday, delta->tm_hour );
			}
		    }
		}
	}
	return( printed );
}


matchcmp( gname, login, given )

    char		*gname;
    char		*login;
    char		*given;
{
	char		buffer[ 80 ];
	char		c;
	int		flag,  i,  unfound;

	if( !match )  {
	    return( 0 );
	}
	else  {
	    if(  namecmp( login, given )  )  {
		return( 1 );
	    }
	    else  {
		if( *gname == ASTERISK )  {
		    gname++;
		}
		flag = 1;
		i = 0;
		unfound = 1;
		while(  unfound  )  {
		    if( flag )  {
			c = *gname++;
			if( c == SAMENAME )  {
			    flag = 0;
			    c = *login++;
			}
			else  {
			    unfound = (*gname != COMMA)  &&  (*gname != NULL);
			}
		    }
		    else {
			c = *login++;
			if( c == NULL )  {
			    if(  (*gname == COMMA)  ||  (*gname == NULL)  )  {
				break;
			    }
			    else  {
				flag = 1;
				continue;
			    }
			}
		    }
		    if( c == BLANK )  {
			buffer[i++] = NULL;
			if(  namecmp( buffer, given )  )  {
			    return( 1 );
			}
			i = 0;
			flag = 1;
		    }
		    else  {
			buffer[ i++ ] = c;
		    }
		}
		buffer[i++] = NULL;
		if(  namecmp( buffer, given )  )  {
		    return( 1 );
		}
		else  {
		    return( 0 );
		}
	    }
	}
}


namecmp( name1, name2 )

    char		*name1;
    char		*name2;
{
	char		c1,  c2;

	c1 = *name1;
	if( (('A' <= c1) && (c1 <= 'Z')) || (('a' <= c1) && (c1 <= 'z')) )  {
	    c1 = CAPITALIZE( c1 );
	}
	c2 = *name2;
	if( (('A' <= c2) && (c2 <= 'Z')) || (('a' <= c2) && (c2 <= 'z')) )  {
	    c2 = CAPITALIZE( c2 );
	}
	while( c1 == c2 )  {
	    if( c1 == NULL )  {
		return( 1 );
	    }
	    c1 = *++name1;
	    if( (('A'<=c1) && (c1<='Z')) || (('a'<=c1) && (c1<='z')) )  {
		c1 = CAPITALIZE( c1 );
	    }
	    c2 = *++name2;
	    if( (('A'<=c2) && (c2<='Z')) || (('a'<=c2) && (c2<='z')) )  {
		c2 = CAPITALIZE( c2 );
	    }
	}
	if( *name1 == NULL )  {
	    while(  ('0' <= *name2)  &&  (*name2 <= '9')  )  {
		name2++;
	    }
	    if( *name2 == NULL )  {
		return( 1 );
	    }
	}
	else  {
	    if( *name2 == NULL )  {
		while(  ('0' <= *name1)  &&  (*name1 <= '9')  )  {
		    name1++;
		}
		if( *name1 == NULL )  {
		    return( 1 );
		}
	    }
	}
	return( 0 );
}


char  *strsave( s )

    char		*s;
{
	char		*malloc();
	char		*p;

	p = malloc( strlen( s ) + 1 );
	strcpy( p, s );
}

/*
 * This version of printf is compatible with the Version 7 C
 * printf.  It is from ls.c and is included to get around a
 * bug in v7 doprnt.s which prints too many leading zeros.  V7
 * printf is more general (and is much larger) and includes
 * provisions for floating point.
 */

#define MAXOCT  11          /* Maximum octal digits in a long */
#define MAXINT  32767       /* largest normal length positive integer */
#define BIG     1000000000  /* largest power of 10 less than an unsigned long */
#define MAXDIGS 10          /* number of digits in BIG */

static int width, sign, fill;

#include <varargs.h>

char *b_dconv();

printf(va_alist)
        va_dcl
{
        va_list ap;
        register char *fmt;
        char fcode;
        int prec;
        int length,mask1,nbits,n;
        long int mask2, num;
        register char *bptr;
        char *ptr;
        char buf[134];

        va_start(ap);
        fmt = va_arg(ap,char *);
        for (;;) {
                /* process format string first */
                while ((fcode = *fmt++)!='%') {
                        /* ordinary (non-%) character */
                        if (fcode=='\0')
                                return;
                        putchar(fcode);
                }
                /* length modifier: -1 for h, 1 for l, 0 for none */
                length = 0;
                /* check for a leading - sign */
                sign = 0;
                if (*fmt == '-') {
                        sign++;
                        fmt++;
                }
                /* a '0' may follow the - sign */
                /* this is the requested fill character */
                fill = 1;
                if (*fmt == '0') {
                        fill--;
                        fmt++;
                }
                
                /* Now comes a digit string which may be a '*' */
                if (*fmt == '*') {
                        width = va_arg(ap, int);
                        if (width < 0) {
                                width = -width;
                                sign = !sign;
                        }
                        fmt++;
                }
                else {
                        width = 0;
                        while (*fmt>='0' && *fmt<='9')
                                width = width * 10 + (*fmt++ - '0');
                }
                
                /* maybe a decimal point followed by more digits (or '*') */
                if (*fmt=='.') {
                        if (*++fmt == '*') {
                                prec = va_arg(ap, int);
                                fmt++;
                        }
                        else {
                                prec = 0;
                                while (*fmt>='0' && *fmt<='9')
                                        prec = prec * 10 + (*fmt++ - '0');
                        }
                }
                else
                        prec = -1;
                
                /*
                 * At this point, "sign" is nonzero if there was
                 * a sign, "fill" is 0 if there was a leading
                 * zero and 1 otherwise, "width" and "prec"
                 * contain numbers corresponding to the digit
                 * strings before and after the decimal point,
                 * respectively, and "fmt" addresses the next
                 * character after the whole mess. If there was
                 * no decimal point, "prec" will be -1.
                 */
                switch (*fmt) {
                        case 'L':
                        case 'l':
                                length = 2;
                                /* no break!! */
                        case 'h':
                        case 'H':
                                length--;
                                fmt++;
                                break;
                }
                
                /*
                 * At exit from the following switch, we will
                 * emit the characters starting at "bptr" and
                 * ending at "ptr"-1, unless fcode is '\0'.
                 */
                switch (fcode = *fmt++) {
                        /* process characters and strings first */
                        case 'c':
                                buf[0] = va_arg(ap, int);
                                ptr = bptr = &buf[0];
                                if (buf[0] != '\0')
                                        ptr++;
                                break;
                        case 's':
                                bptr = va_arg(ap,char *);
                                if (bptr==0)
                                        bptr = "(null pointer)";
                                if (prec < 0)
                                        prec = MAXINT;
                                for (n=0; *bptr++ && n < prec; n++) ;
                                ptr = --bptr;
                                bptr -= n;
                                break;
                        case 'O':
                                length = 1;
                                fcode = 'o';
                                /* no break */
                        case 'o':
                        case 'X':
                        case 'x':
                                if (length > 0)
                                        num = va_arg(ap,long);
                                else
                                        num = (unsigned)va_arg(ap,int);
                                if (fcode=='o') {
                                        mask1 = 0x7;
                                        mask2 = 0x1fffffffL;
                                        nbits = 3;
                                }
                                else {
                                        mask1 = 0xf;
                                        mask2 = 0x0fffffffL;
                                        nbits = 4;
                                }
                                n = (num!=0);
                                bptr = buf + MAXOCT + 3;
                                /* shift and mask for speed */
                                do
                                    if (((int) num & mask1) < 10)
                                        *--bptr = ((int) num & mask1) + 060;
                                    else
                                        *--bptr = ((int) num & mask1) + 0127;
                                while (num = (num >> nbits) & mask2);
                                
                                if (fcode=='o') {
                                        if (n)
                                                *--bptr = '0';
                                }
                                else
                                        if (!sign && fill <= 0) {
                                                putchar('0');
                                                putchar(fcode);
                                                width -= 2;
                                        }
                                        else {
                                                *--bptr = fcode;
                                                *--bptr = '0';
                                        }
                                ptr = buf + MAXOCT + 3;
                                break;
                        case 'D':
                        case 'U':
                        case 'I':
                                length = 1;
          
                      fcode = fcode + 'a' - 'A';
                                /* no break */
                        case 'd':
                        case 'i':
                        case 'u':
                                if (length > 0)
                                        num = va_arg(ap,long);
                                else {
                                        n = va_arg(ap,int);
                                        if (fcode=='u')
                                                num = (unsigned) n;
                                        else
                                                num = (long) n;
                                }
                                if (n = (fcode != 'u' && num < 0))
                                        num = -num;
                                /* now convert to digits */
                                bptr = b_dconv(num, buf);
                                if (n)
                                        *--bptr = '-';
                                if (fill == 0)
                                        fill = -1;
                                ptr = buf + MAXDIGS + 1;
                                break;
                        default:
                                /* not a control character, 
                                 * print it.
                                 */
                                ptr = bptr = &fcode;
                                ptr++;
                                break;
                        }
                        if (fcode != '\0')
                                b_emit(bptr,ptr);
        }
        va_end(ap);
}

/* b_dconv converts the unsigned long integer "value" to
 * printable decimal and places it in "buffer", right-justified.
 * The value returned is the address of the first non-zero character,
 * or the address of the last character if all are zero.
 * The result is NOT null terminated, and is MAXDIGS characters long,
 * starting at buffer[1] (to allow for insertion of a sign).
 *
 * This program assumes it is running on 2's complement machine
 * with reasonable overflow treatment.
 */
char *
b_dconv(value, buffer)
        long value;
        char *buffer;
{
        register char *bp;
        register int svalue;
        int n;
        long lval;
        
        bp = buffer;
        
        /* zero is a special case */
        if (value == 0) {
                bp += MAXDIGS;
                *bp = '0';
                return(bp);
        }
        
        /* develop the leading digit of the value in "n" */
        n = 0;
        while (value < 0) {
                value -= BIG;   /* will eventually underflow */
                n++;
        }
        while ((lval = value - BIG) >= 0) {
                value = lval;
                n++;
        }
        
        /* stash it in buffer[1] to allow for a sign */
        bp[1] = n + '0';
        /*
         * Now develop the rest of the digits. Since speed counts here,
         * we do it in two loops. The first gets "value" down until it
         * is no larger than MAXINT. The second one uses integer divides
         * rather than long divides to speed it up.
         */
        bp += MAXDIGS + 1;
        while (value > MAXINT) {
                *--bp = (int)(value % 10) + '0';
                value /= 10;
        }
        
        /* cannot lose precision */
        svalue = value;
        while (svalue > 0) {
                *--bp = (svalue % 10) + '0';
                svalue /= 10;
        }
        
        /* fill in intermediate zeroes if needed */
        if (buffer[1] != '0') {
                while (bp > buffer + 2)
                        *--bp = '0';
                --bp;
        }
        return(bp);
}

/*
 * This program sends string "s" to putchar. The character after
 * the end of "s" is given by "send". This allows the size of the
 * field to be computed; it is stored in "alen". "width" contains the
 * user specified length. If width<alen, the width will be taken to
 * be alen. "sign" is zero if the string is to be right-justified
 * in the field, nonzero if it is to be left-justified. "fill" is
 * 0 if the string is to be padded with '0', positive if it is to be
 * padded with ' ', and negative if an initial '-' should appear before
 * any padding in right-justification (to avoid printing "-3" as
 * "000-3" where "-0003" was intended).
 */
b_emit(s, send)
        register char *s;
        char *send;
{
        char cfill;
        register int alen;
        int npad;
        
        alen = send - s;
        if (alen > width)
                width = alen;
        cfill = fill>0? ' ': '0';
        
        /* we may want to print a leading '-' before anything */
        if (*s == '-' && fill < 0) {
                putchar(*s++);
                alen--;
                width--;
        }
        npad = width - alen;
        
        /* emit any leading pad characters */
        if (!sign)
                while (--npad >= 0)
                        putchar(cfill);
                        
        /* emit the string itself */
        while (--alen >= 0)
                putchar(*s++);
                
        /* emit trailing pad characters */
        if (sign)
                while (--npad >= 0)
                        putchar(cfill);
}
