#include <sys/types.h>
#include <stdio.h>
#include <errno.h>
#include <netdb.h>
#include <sys/socket.h>

extern struct hostent *gethostbyaddr();

/*
 * This program accepts, as an argument, a string of hexadecimal digits
 * representing the IP address of the desired host, and returns the name 
 * of the corresponding host.
 */

main(argc,argv)
char **argv;
{
	int l, addr;
	struct hostent *host;

	if (argc == 3) {
		if (strcmp(argv[2], "tcp") != 0)
			usage();
	}
	else if (argc != 2)
		usage();
	argv++;
	if ((l=strlen(argv[0])) < 8)
		usage();
	addr = strtol(&argv[0][l-8], (char **)&l, 16);
	if (l == (int)&argv[0][l-8]) {
		printf("NDbyaddr: need hex string instead of %s\n", argv[1]);
		exit(1);
	}
	if ( !(host = gethostbyaddr(&addr, 4, AF_INET)) ) {
		printf("NDbyaddr: gethostbyaddr failed errno %d\n", errno);
		exit(1);
	}
	printf("%s\n", host->h_name);
}

usage()
{
	printf("usage: NDbyaddr <address> [ tcp ]\n");
	exit(1);
}
