/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)uds_tli.c (TWG)       1.5     89/09/18 "

#include <sys/param.h>
#include <sys/types.h>

#ifndef XENIX
#include <sys/inline.h>
#include <sys/immu.h>
#include <sys/fs/s5dir.h>
#include <sys/region.h>
#ifdef u3b2
#include <sys/psw.h>
#include <sys/pcb.h>
#endif
#else /* XENIX */
#include <sys/seg.h>
#include <sys/page.h>
#include <sys/dir.h>
#include <sys/assert.h>
#endif
#include <sys/errno.h>
#include <sys/stream.h>
#include <sys/proc.h>
#include <sys/signal.h>
#include <sys/user.h>
#include <sys/file.h>
#include <sys/stropts.h>
#include <sys/tihdr.h>
#include <sys/tiuser.h>
#include <sys/strlog.h>
#include <sys/debug.h>

#include "sys/inet.h"
#include "sys/un.h"
#include "sys/unpcb.h"
#include "sys/in.h"
#include "sys/socket.h"

#define	z	UNREACH

unsigned char udsfsm_tbl[TE_NOEVENTS][TS_NOSTATES] = {

/* 0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 */
/* U  W  W  I  W  W  W  W  W  D  W  W  W  W  W  W  W */
/* N  A  A  D  A  A  C  R  A  A  I  R  A  A  A  A  A */
/* B  C  C  L  C  C  O  E  C  T  N  E  C  C  C  C  C */
/* N  K  K  E  K  K  N  S  K  A  D  Q  K  K  K  K  K */
/* D  :  :     :  :  :  :  :  :  :  :  :  :  :  :  : */
/*    B  U     O  C  C  C  C  X  O  O  D  D  D  D  D */
/*    R  R     P  R  R  I  R  F  R  R  R  R  R  R  R */
/*    E  E     T  E  E  N  E  E  D  D  E  E  E  E  E */
/*    Q  Q     R  Q  Q  D  S  R  R  R  Q  Q  Q  Q  Q */
/*             E                 E  E  6  7  9  1  1 */
/*             Q                 L  L           0  1 */

  {5, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z}, /* BIND_REQ	0 */
  {z, z, z, 6, z, z, z, z, z, z, z, z, z, z, z, z, z}, /* UNBIND_REQ	1 */
  {z, z, z, 7, z, z, z, z, z, z, z, z, z, z, z, z, z}, /* OPTMGMT_REQ	2 */
  {z, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z}, /* BIND_ACK	3 */
  {z, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z}, /* OPTMGMT_ACK	4 */
  {z, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z}, /* ERROR_ACK	5 */
  {z, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z}, /* OK_ACK1	6 */
  {z, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z}, /* OK_ACK2	7 */
  {z, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z}, /* OK_ACK3	8 */
  {z, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z, z}, /* OK_ACK4	9 */
  {1, z, z, 1, z, z, z, z, z, z, z, z, z, z, z, z, z}, /* TE_CONN_REQ	10 */
  {z, z, z, z, z, z, z, 2, z, z, z, z, z, z, z, z, z}, /* CONN_RES	11 */
  {z, z, z, z, z, z, 3, 3, z, 3, 3, 3, z, z, z, z, z}, /* DISCON_REQ	12 */
  {z, z, z, z, z, z, z, z, z, 4, z, 4, z, z, z, z, z}, /* DATA_REQ	13 */
  {z, z, z, z, z, z, z, z, z, 9, z, 9, z, z, z, z, z}, /* EXDATA_REQ	14 */
  {z, z, z, z, z, z, z, z, z, 8, z, 8, z, z, z, z, z}, /* ORDREL_REQ	15 */
};

#undef z

unsigned char uds_nonfatal(), uds_connreq(), uds_connres(), uds_disconreq();
unsigned char uds_unbind(), uds_ordrel(), uds_fatal(), uds_bind();
struct unpcb *uds_findinlistenq();

unsigned char (*udsfsm_action[])() = {
	uds_nonfatal,		/* 0 */
	uds_connreq,		/* 1 */
	uds_connres,		/* 2 */
	uds_disconreq,		/* 3 */
	uds_nonfatal,		/* 4, uds_data */
	uds_bind,		/* 5 */
	uds_unbind,		/* 6 */
	uds_nonfatal,		/* 7, uds_optmgmt */
	uds_ordrel,		/* 8 */
	uds_nonfatal,		/* 9, uds_exdata */
	uds_fatal,		/* 10 */
};

/* from T_primitives to the events of the fsm */

#define NUPRIM	T_ORDREL_REQ+1	/* # of primitives from user */
static unsigned char prim_to_event[NUPRIM] = {
	TE_CONN_REQ,		/* 0. T_CONN_REQ	*/
	TE_CONN_RES,		/* 1. T_CONN_RES	*/
	TE_DISCON_REQ,		/* 2. T_DISCON_REQ	*/
	TE_DATA_REQ,		/* 3. T_DATA_REQ	*/
	TE_EXDATA_REQ,		/* 4. T_EXDATA_REQ	*/
	UNREACH,		/* 5. T_INFO_REQ	*/
	TE_BIND_REQ,		/* 6. T_BIND_REQ	*/
	TE_UNBIND_REQ,		/* 7. T_UNBIND_REQ	*/
	UNREACH,		/* 8. T_UNINTDATA_REQ	*/
	TE_OPTMGMT_REQ,		/* 9. T_OPTMGMT_REQ	*/
	TE_ORDREL_REQ,		/* 10. T_ORDREL_REQ	*/
};

struct unpcb *uds_findaddr();

extern struct unpcb Uds[];
extern int Udscount;
extern int Udsmaxconn;

int
uds_fsm(queue, bp)
queue_t *queue;
register mblk_t *bp;
{
	register struct unpcb *unp;
	register unsigned char Ttype, actindex;
	register union T_primitives *tp;

	unp = (struct unpcb *)queue->q_ptr;
	tp = (union T_primitives *)bp->b_rptr;
	Ttype = (unsigned char)TTYPE(tp);
	actindex = udsfsm_tbl[prim_to_event[Ttype]][unp->ud_tstate];
	if (actindex == UNREACH)
		goto fsmerr;

	if ((*udsfsm_action[actindex])(queue, bp) == UNREACH)
		goto fsmerr;
	
	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE, "uds_fsm: action ok\n");
	return(0);

fsmerr:
	if (uds_error_ack(queue, Ttype, TOUTSTATE) < 0) {
		uds_fatal(unp);		/* don't know what else to do */
	} else {
		uds_cleansock(unp);
		unp->ud_tstate = TS_UNBND;
	}
	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE, "uds_fsm: unknown error\n");
	return(-1);
}

unsigned char
uds_nonfatal(queue, bp)
register queue_t *queue;
register mblk_t *bp;
{
	STRLOG(UDS_ID, UDSCHAN((struct unpcb *)queue->q_ptr), DPRI_LO, SL_TRACE,
		"uds_nonfatal: queue <0x%x>, bp <0x%x>\n", queue, bp);
	freemsg(bp);
	return(0);
}

unsigned char
uds_unbind(queue, bp)
register queue_t *queue;
register mblk_t *bp;
{
	register struct unpcb *unp;

	ASSERT(bp && queue);
	unp = (struct unpcb *)queue->q_ptr;

	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,"uds_unbind: entered\n");
	uds_cleansock(unp);
	unp->ud_flags = 0;	/* User can't rebind to priv port */

	/* send M_FLUSH upstream */

	if (uds_rdflush(queue) == -1)
		goto error;

	freemsg(bp);
	if ( !uds_ok_ack(queue, T_UNBIND_REQ) ) {
		unp->ud_tstate = TS_UNBND;
		STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_unbind: action ok\n");
		return(TE_OK_ACK1);
	}
error:
	/* fatal error: caller will freemsg(bp) and do "strlog" */

	strlog(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_unbind: fatal, return UNREACH\n");
	return(UNREACH);
}

unsigned char
uds_bind(queue, bp)
queue_t *queue;
mblk_t *bp;
{
	struct unpcb *unp;
	struct T_bind_req *tp;
	struct T_bind_ack *tp1;
	mblk_t *bp1 = NULL;
	long retcode;
	struct sockaddr_un *soun;

	ASSERT(bp && queue);
	unp = (struct unpcb *)queue->q_ptr;

	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE, "uds_bind: entered\n");

	tp = (struct T_bind_req *)bp->b_rptr;

	/* assume primitive and ADDR in one block */

	if (tp->ADDR_length != AFUADDRLEN ||
		(bp->b_wptr - bp->b_rptr) < (tp->ADDR_offset +tp->ADDR_length)){
		retcode = TBADADDR;
		strlog(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"uds_bind: TBADADDR\n");
		goto nonfatal;
	}

	/* is it already bound */

	if (unp->ud_ino || unp->ud_addr) {
		retcode = TNOADDR;
		strlog(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"uds_bind: TNOADDR\n");
		goto nonfatal;
	}

	soun = (struct sockaddr_un *) (tp + tp->ADDR_offset);
	{
		int ii;
		char *sounaddr;
		STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_bind: soun->sun_family <0x%x> name - <", (short) soun->sun_family);
		sounaddr = soun->sun_path;
		for (ii = 0; ii < 32 ; ii++)
			STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"%x", *sounaddr++);
		STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		">\n", (char) *sounaddr++);
	}

		

	/* now commit to success, return T_bind_ack */

	if (!(bp1 = allocb(AFUADDRLEN, BPRI_MED)))
		goto fatal;

	bcopy((char *)(tp + tp->ADDR_offset), (char *)bp1->b_wptr, AFUADDRLEN);
	bp1->b_wptr += AFUADDRLEN;
	unp->ud_addr = bp1;
	unp->ud_maxconn = min(Udsmaxconn, tp->CONIND_number);
	unp->ud_tstate = TS_IDLE;

	/* construct ACK message */

	if (!REUSEABLE(bp, sizeof(struct T_bind_ack) + AFUADDRLEN)) {
		freemsg(bp);
		if ( !(bp = allocb(sizeof(struct T_bind_ack) + AFUADDRLEN, 
			BPRI_LO)) )
			goto fatal;
	}

	tp1 = (struct T_bind_ack *)bp->b_rptr;

	tp1->PRIM_type = T_BIND_ACK;
	tp1->ADDR_length = AFUADDRLEN;
	tp1->ADDR_offset = sizeof(struct T_bind_ack);
	tp1->CONIND_number = unp->ud_maxconn;
	bcopy(unp->ud_addr, tp1 + tp1->ADDR_offset, AFUADDRLEN);
	MTYPE(bp1) = M_PCPROTO;
	bp->b_wptr = bp->b_rptr + AFUADDRLEN;
	
	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_bind: OK - queue <0x%x>\n", queue);

	qreply(queue, bp);
	return(TE_BIND_ACK);

nonfatal:
	freemsg(bp);
	if (uds_error_ack(queue, T_BIND_REQ, retcode))
		goto fatal;
	if (unp->ud_addr) {
		freeb(unp->ud_addr);
		unp->ud_addr = NULL;
	}
	strlog(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_bind: nonfatal error\n");
	return(TE_ERROR_ACK);

fatal:
	strlog(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_bind: Fatal Error\n");
	return(UNREACH);
}

unsigned char
uds_disconreq(queue, bp)
queue_t *queue;
mblk_t *bp;
{
	register struct unpcb *unp1, *unp2;
	int flush = 0;
	int to_idle = 1;
	long seq;

	ASSERT(bp && queue);
	unp1 = (struct unpcb *)queue->q_ptr;

	STRLOG(UDS_ID, UDSCHAN(unp1), DPRI_LO, SL_TRACE,
		"uds_disconreq: entered\n");

	unp2 = unp1->ud_conq;
	seq = ((struct T_discon_req *)bp->b_rptr)->SEQ_number;

	switch(unp1->ud_tstate) {

	case TS_DATA_XFER:
	case TS_WREQ_ORDREL:
	case TS_WIND_ORDREL:
		STRLOG(UDS_ID, UDSCHAN(unp1), DPRI_LO, SL_TRACE,
			"uds_disconreq: in data xfer/ord release\n");
		flush = 1;

	/* fall thru */

	case TS_WCON_CREQ:

		/* disconnecting existing connection */

		if (seq != -1)
			goto nonfatal;		/* can't match seq# */

		/* Clean up the two pmod structures and return. */

		uds_cleansock(unp1);
		unp1->ud_tstate = TS_UNBND;

		unp2->ud_tstate = TS_WREQ_ORDREL;
		uds_cleansock(unp2);
		uds_snddiscon(unp2->ud_rdq);

		break;

	case TS_WRES_CIND:

		/* rejecting a pending request from remote */

		to_idle = 0;
		if (unp2 = uds_findinlistenq(unp1, seq)) {

				uds_snddiscon(unp2->ud_rdq);
				uds_cleansock(unp2);
				unp2->ud_tstate = TS_WRES_CIND;
				goto ok;
		}
		goto nonfatal;

	default:			/* out of sync */
		goto fatal;
	}

ok:
	freemsg(bp);
	if (!uds_ok_ack(queue, T_DISCON_REQ)) {

		STRLOG(UDS_ID, UDSCHAN(unp1), DPRI_LO, SL_TRACE,
			"uds_disconreq: flushing streams\n");
		if (flush && upflush(queue) == -1)
			goto fatal;
		if (to_idle)
			unp1->ud_tstate = TS_IDLE;
		return(TE_OK_ACK1);
	}

fatal:
	strlog(UDS_ID, UDSCHAN(unp1), DPRI_LO, SL_TRACE,
		"uds_disconreq: fatal error\n");
	return(UNREACH);

nonfatal:
	if (uds_error_ack(queue, T_DISCON_REQ, TBADSEQ))
		goto fatal;
	strlog(UDS_ID, UDSCHAN(unp1), DPRI_LO, SL_TRACE,
		"uds_disconreq: nonfatal bad Seq number\n");
	return(TE_ERROR_ACK);
}

unsigned char
uds_connreq(queue, bp)
queue_t	*queue;
mblk_t *bp;
{
	register struct unpcb *unp, *unpsrv, *unptmp;
	register struct T_conn_req *tp;
	register long retcode;
	mblk_t *bp1;
	struct T_conn_ind *Tp;

	ASSERT(bp && queue);
	unp = (struct unpcb *)queue->q_ptr;
	tp = (struct T_conn_req *)bp->b_rptr;

	STRLOG(UDS_ID,UDSCHAN(unp), DPRI_LO, SL_TRACE, "uds_connreq: entered\n");

	if (unp->ud_type != SOCK_STREAM) {
		STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"uds_connreq: cannot connect non stream types\n");
		retcode = TBADADDR;
		goto nonfatal;
	}

	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_connreq: address size tp->DEST_length <%d>\n",
		tp->DEST_length);

	if ((bp->b_wptr - bp->b_rptr) < sizeof(struct T_conn_req) ||
		(tp->DEST_length != AFUADDRLEN )) {

		strlog(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"uds_connreq: bad address size tp->DEST_length <%d>\n",
			tp->DEST_length);
		retcode = TBADADDR;
		goto nonfatal;
	}

	if (!(unpsrv = uds_findaddr((unsigned char *)(tp + tp->DEST_offset)))) {
		STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"uds_connreq: cannot find dest addr\n");
		retcode = TBADADDR;
		goto nonfatal;
	}

	if (unp->ud_type != unpsrv->ud_type) {
		STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"uds_connreq: incorrect source/dest types\n");
		retcode = TBADADDR;
		goto nonfatal;
	}

	if (unpsrv->ud_numconn < unpsrv->ud_maxconn ) {
		unpsrv->ud_numconn++;

		if (unpsrv->ud_ref == NULL) {
			unp->ud_seqnum = 1;
			unpsrv->ud_ref = unp;
			unp->ud_seqnum = 1;
		} else {
			unptmp = unpsrv->ud_ref;
			while (unptmp->ud_nextref != NULL) 
				unptmp = unptmp->ud_nextref;
			unptmp->ud_nextref = unp;
			unp->ud_seqnum = unptmp->ud_seqnum + 1;
		}
		STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"uds_connreq: seq number <%d>\n", unp->ud_seqnum);
	} else {
		
		strlog(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"uds_connreq: too many connection requests\n");
		retcode = TBADADDR;
		goto nonfatal;
	}

	unp->ud_nextref = NULL;

	/* tell server process that a connection is available */

	if (!(bp1 = allocb(sizeof(struct T_conn_ind) + AFUADDRLEN, BPRI_MED))){
		
		strlog(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"uds_connreq: cannot allocate block for conn ind\n");
		goto nonfatal;
	}

	MTYPE(bp1) = M_PROTO;
	Tp = (struct T_conn_ind *)bp1->b_wptr;
	Tp->PRIM_type = T_CONN_IND;
	Tp->SRC_length = AFUADDRLEN;
	Tp->SRC_offset = sizeof(struct T_conn_ind);
	Tp->SEQ_number = unp->ud_seqnum;
	Tp->OPT_length = 0;
	bcopy((char *)unp->ud_addr, (char *) (Tp + Tp->SRC_offset), AFUADDRLEN);
	bp1->b_wptr += (sizeof(struct T_conn_ind) + AFUADDRLEN);
	putnext(unpsrv->ud_rdq, bp1);
	unpsrv->ud_tstate = TS_WRES_CIND;

	if ( !uds_ok_ack(queue, T_CONN_REQ) ) {
		unp->ud_ref = unpsrv;
		unp->ud_tstate = TS_WCON_CREQ;
		STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"uds_connreq: ALL is well\n");
		return(TE_OK_ACK1);
	}

nonfatal:
	if (uds_error_ack(queue, T_CONN_REQ, retcode))
		goto fatal;
	strlog(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_connreq: nonfatal return\n");
	return TE_ERROR_ACK;
fatal:
	strlog(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_connreq: fatal error\n");
	return(UNREACH);
}

unsigned char
uds_connres(queue, bp)
queue_t *queue;
mblk_t *bp;
{
	struct unpcb *unp, *unp2, *unp3;
	queue_t *coq1;
	long seq, retcode;
	struct T_conn_res *tp;
	struct T_conn_con *Tp;
	mblk_t *bp1;

	ASSERT(bp && queue);
	unp = (struct unpcb *)queue->q_ptr;

	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,"uds_connres: entered\n");

	tp = (struct T_conn_res *)bp->b_rptr;
	if (tp->OPT_length) {
		retcode = TBADOPT;
		goto nonfatal;
	}
	/*
	 * coq1 should have been opened and should not have any connection
	 * waiting or connect active.
	 */

	if (!(coq1 = tp->QUEUE_ptr) || !(unp2 = (struct unpcb *)coq1->q_ptr)
		|| unp2->ud_ref || unp2->ud_conq) {
		retcode = TBADF;
		goto nonfatal;
	}

	/* now find the sequence number */

	seq = tp->SEQ_number;
	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_connres: looking for seq number <%d>\n", seq);

	if ( !(unp3 =  uds_findinlistenq(unp, seq)) ) { 
		retcode = TBADSEQ;
		strlog(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"uds_connres: cannot find seq number <%d>\n", seq);
		goto nonfatal;
	}
	unp->ud_numconn -= 1;

	/* send a connection confirmation to the client */

	if (!(bp1 = (mblk_t *) allocb( sizeof(struct T_conn_con) + AFUADDRLEN,
			BPRI_MED))) {
		STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"uds_connres: cannot allocate block\n");
		goto fatal;
	}

	MTYPE(bp1) = M_PROTO;
	Tp = (struct T_conn_con *)bp1->b_wptr;
	Tp->PRIM_type = T_CONN_CON;
	Tp->OPT_length = 0;
	Tp->OPT_offset = sizeof(struct T_conn_con);
	Tp->RES_length = AFUADDRLEN;
	Tp->RES_offset = sizeof(struct T_conn_con);
	bcopy((char *)unp->ud_addr, (char *)(Tp + Tp->RES_offset), AFUADDRLEN);
	bp1->b_wptr += (sizeof(struct T_conn_con) + AFUADDRLEN);
	putnext(unp3->ud_rdq, bp1);

	if (uds_ok_ack(queue, T_CONN_RES))
		goto fatal;

	/* may want to allow to accept on listening channel later */

	unp3->ud_conq = unp2;
	unp2->ud_conq = unp3;
	unp3->ud_tstate = unp2->ud_tstate = TS_DATA_XFER;

	retcode = TE_OK_ACK4;

	if (unp->ud_numconn == 0) {
		retcode = TE_OK_ACK3;
	}

	freemsg(bp);
	return(retcode);

nonfatal:
	if (uds_error_ack(queue, T_CONN_RES, retcode))
		goto fatal;

	strlog(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_connres: nonfatal return\n");
	freemsg(bp);
	return(TE_ERROR_ACK);

fatal:
	strlog(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_connres: fatal return\n");
	freemsg(bp);
	return(UNREACH);
}

unsigned char
uds_ordrel(queue, bp)
register queue_t *queue;
register mblk_t *bp;
{
	register struct unpcb *unp, *unp2;
	register queue_t *queue2;

	ASSERT(bp && queue);

	unp = (struct unpcb *)queue->q_ptr;
	unp2 = unp->ud_conq;
	queue2 = unp2->ud_rdq;

	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE, "uds_ordrel: entered\n");

	if (bp)
		freemsg(bp);

	uds_sndordrel(queue2);

	switch (unp->ud_tstate) {

	case TS_DATA_XFER:
		unp->ud_tstate = TS_WIND_ORDREL;
		break;

	case TS_WREQ_ORDREL:
		unp->ud_tstate = TS_IDLE;
		break;

	default:
		STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"uds_ordrel: unknown state\n");
		return(UNREACH);
	}

	return TE_OK_ACK1;
}

struct unpcb *
uds_findinlistenq(unp, seq)
struct unpcb *unp;
long seq;
{
	struct unpcb *unptmp, *unp1;

	for (unptmp = unp1 = unp->ud_ref; unp1 != NULL;
			unptmp = unp1, unp1 = unp1->ud_nextref) {

		if (unp1->ud_seqnum == seq) {
			if (unptmp == unp1) 
				unp->ud_ref = unp1->ud_nextref;
			else 
				unptmp->ud_ref = unp->ud_nextref;
			unp1->ud_nextref = NULL;
			return(unp1);
		}
	}
	return(NULL);
}

int
uds_cleansock(unp)
struct unpcb	*unp;
{
	struct unpcb	*unp1, *unp2;

	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_cleansock: entered\n");

	/* we have people on out listen q ? */
	for (unp1 = unp->ud_ref; unp1; ) {

		uds_snddiscon(unp1->ud_rdq);
		unp2 = unp1;
		unp1 = unp1->ud_nextref;
		unp2->ud_nextref = NULL;
		unp2->ud_seqnum = 0;
	}
	unp->ud_ref = NULL;

	/* are we successfully connected ? */

	if (unp->ud_conq) {
		uds_snddiscon(unp->ud_conq->ud_rdq);
		unp->ud_conq->ud_conq = NULL;
		unp->ud_conq = NULL;
	}

	/* are we in anybody's connect list */

	if (unp->ud_seqnum)
		uds_rmlistenq(unp);

	if (unp->ud_addr) {
		freeb(unp->ud_addr);
		unp->ud_addr = NULL;
	}
	return(0);
}


uds_snddiscon(queue)
queue_t *queue;
{
	register mblk_t *bp;
	register struct T_discon_ind *tp;
	register struct unpcb *unp;

	unp = (struct unpcb *) queue->q_ptr;

	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_snddiscon: entered\n");

	switch (unp->ud_tstate) {

	case TS_IDLE:
	case TS_WREQ_ORDREL:
	case TS_WIND_ORDREL:
	case TS_DATA_XFER:
		break;
	default:
		return ;
	}

	if (! (bp = allocb(sizeof(struct T_discon_ind), BPRI_MED))) {

		strlog(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"uds_snddiscon: cannot allocate buffer\n");
		if ( bufcall(sizeof(struct T_discon_ind), BPRI_MED, 
			uds_snddiscon, queue )) 
			return ;
	} else {

		MTYPE(bp) = M_PROTO;
		tp = (struct T_discon_ind *) bp->b_wptr;

		tp->PRIM_type = T_DISCON_IND;
		tp->SEQ_number = -1;
		bp->b_wptr += sizeof(struct T_discon_ind);
		putq(queue, bp);
	}
	/* lets call this a orderly release */

	unp->ud_tstate = TS_WIND_ORDREL;

	return;
}


int
uds_rdflush(queue)
register queue_t *queue;
{
	struct unpcb *unp;

	ASSERT(queue);

	unp = (struct unpcb *) queue->q_ptr;

	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_rdflush: entered\n");
	queue = RD(queue);
	flushq(queue, FLUSHALL);
	if (putctl1(queue->q_next, M_FLUSH, FLUSHRW) == 0)
		return(-1);
	return(0);

}

int
uds_ok_ack(queue, prim)
register queue_t *queue;
register long prim;
{
	register struct T_ok_ack *tp;
	mblk_t *bp;

	if ((bp = allocb(sizeof(struct T_ok_ack), BPRI_MED)) == NULL)
			return(-1);

	MTYPE(bp) = M_PCPROTO;
	tp = (struct T_ok_ack *)bp->b_rptr;
	tp->PRIM_type = T_OK_ACK;
	tp->CORRECT_prim = prim;
	bp->b_wptr += sizeof(struct T_ok_ack);
	qreply(queue, bp);

	return(0);
}

int
uds_error_ack(queue, prim, code)
register queue_t *queue;
register long prim;
register long code;
{
	register struct T_error_ack *tp;
	mblk_t *bp;

	if ((bp = allocb(sizeof(struct T_error_ack), BPRI_MED)) == NULL)
			return(-1);

	MTYPE(bp) = M_PCPROTO;
	tp = (struct T_error_ack *)bp->b_rptr;
	tp->PRIM_type = T_ERROR_ACK;
	tp->ERROR_prim = prim;
	tp->TLI_error = code;
	bp->b_wptr += sizeof(struct T_error_ack);
	qreply(queue, bp);

	return(0);
}

uds_sndordrel(queue)
queue_t *queue;
{
	struct unpcb *unp;
	register struct T_ordrel_ind *tp;
	register mblk_t *bp;

	unp = (struct unpcb *) queue->q_ptr;
/*
 * IF the user has already initated a close, then
 * there is no need to send any message upstream.
 * Just set the TIME_WAIT timer to expire so that
 * the PCB will bet deleted next time.
 */

	/* send T_ordrel_ind upstream */

	if (!(bp = allocb(sizeof(struct T_ordrel_ind), BPRI_MED)))
		goto fatal;

	tp = (struct T_ordrel_ind *)bp->b_rptr;

	tp->PRIM_type = T_ORDREL_IND;
	bp->b_wptr += sizeof(struct T_ordrel_ind);
	MTYPE(bp) = M_PROTO;

	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_sndordrel: incoming state <0x%x>\n", unp->ud_tstate);

	switch(unp->ud_tstate) {

	case TS_DATA_XFER:
		unp->ud_tstate = TS_WREQ_ORDREL;
		break;

	case TS_WIND_ORDREL:
		unp->ud_tstate = TS_IDLE;
		break;
	default:
		goto fatal;
	}

	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_sndordrel: outgoing state <0x%x>\n", unp->ud_tstate);

	putq(queue, bp);
	return;

fatal:
	uds_fatal(unp);
	return;
}

unsigned char
uds_fatal(unp)
register struct unpcb *unp;
{
	register queue_t *queue;

	queue = unp->ud_rdq;
	unp->ud_flags |= TD_ERROR;

	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_fatal: entered\n");

	/* tell user: expect user to close the stream */

	if (putctl1(queue->q_next, M_ERROR, EPROTO) == 0)
		return(UNREACH);

	/* abort all connections or half connections */

	uds_cleansock(unp);
	unp->ud_tstate = TS_UNBND;
	return(UNREACH);
}

uds_rmlistenq(unp)
struct unpcb *unp;
{

	struct unpcb *unp1;

	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"uds_rmlistenq: entered\n");

	if (!unp->ud_seqnum || !(unp1 = unp->ud_ref))
		return;

	if (unp1->ud_ref == unp) {
		unp1->ud_ref = unp->ud_nextref;
	} else {
		for (; unp1->ud_nextref; ) {

			if (unp1->ud_nextref == unp) {
				unp1->ud_nextref = unp->ud_nextref;
				break;
			}
		}
	}
	unp->ud_nextref = unp->ud_ref = NULL;
	unp->ud_seqnum = 0;
}

struct unpcb *
uds_findaddr(addr)
struct sockaddr_un *addr;
{
	int index;
	struct unpcb *unp;
	struct sockaddr_un *addr2;
	char	*ccc;
	int alen = blen(addr->sun_path);

	for (index = 0; index < Udscount; index++ ) {

		unp = &Uds[index];
		addr2 = (struct sockaddr_un *) unp->ud_addr;
		if ( alen == blen(addr2->sun_path) &&
				!bcmp(addr->sun_path, addr2->sun_path, alen) ) {
			ccc = addr->sun_path;
			printf("uds_findaddr -> ");
			while (*ccc)
				printf("%x", (char) *ccc++);
			printf(">\n");
			return(unp);
		}
	}
	return(NULL);
}
