/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)uds_main.c (TWG)       1.3     89/09/18 "

#include <sys/param.h>
#include <sys/types.h>

#ifndef XENIX
#include <sys/inline.h>
#include <sys/immu.h>
#include <sys/fs/s5dir.h>
#include <sys/region.h>
#ifdef u3b2
#include <sys/psw.h>
#include <sys/pcb.h>
#endif
#else /* XENIX */
#include <sys/seg.h>
#include <sys/page.h>
#include <sys/dir.h>
#include <sys/assert.h>
#endif
#include <sys/errno.h>
#include <sys/stream.h>
#include <sys/proc.h>
#include <sys/signal.h>
#include <sys/user.h>
#include <sys/file.h>
#include <sys/stropts.h>
#include <sys/tihdr.h>
#include <sys/tiuser.h>
#include <sys/strlog.h>
#include <sys/debug.h>

#include "sys/inet.h"
#include "sys/inetioctl.h"
#include "sys/socket.h"
#include "sys/un.h"
#include "sys/unpcb.h"

extern struct unpcb Uds[];
extern int Udscount;
extern int Udsmaxconn;

void	udsinit();
int	udsopen(), udsclose(), udsput();

static struct module_info uds_info = {
	UDS_ID, "uds", 0, INFPSZ, 65535, 65535
};

static struct qinit udsrinit = {
	NULL, NULL, udsopen, udsclose, NULL, &uds_info, NULL 
};

static struct qinit udswinit = {
	udsput, NULL, NULL, NULL, NULL, &uds_info, NULL 
};

struct streamtab udsinfo = {
	&udsrinit, &udswinit, NULL, NULL
};

void
udsinit()
{
	extern void udtimeout();

#ifdef DEBUG
	printf("udsinit: initializing ...");
#endif

	/* udtimeout(); */

	return;
}

int
udsopen(queue, dev, flag, sflag)
register queue_t *queue;
register dev_t dev;
int flag, sflag;
{
	register struct unpcb *unp;

	dev = minor(dev);

	if (sflag == CLONEOPEN) {

		/*  Look for first available minor device */

		for (dev = 0; dev < Udscount; dev++) {

			if (Uds[dev].ud_rdq == (queue_t *)NULL)
				break;
		}

		/*  Set and test validity of selected minor device */

		if (dev >= Udscount) {

			STRLOG(UDS_ID, 0, DPRI_LO, SL_TRACE,
				"udsopen: OPENFAIL, No device available\n");

			u.u_error = ENODEV;
			return OPENFAIL;
		} else {

			unp = &Uds[dev];
		}

	} else if (unp = (struct unpcb *)queue->q_ptr) {

		/* Requested minor dev already open */

		STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"udsopen: OPENFAIL, Device already open\n");
		unp->ud_rdq = queue;
		return dev;

	} else {

		if (dev < 0 || dev >= Udscount) {

			STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
				"udsopen: OPENFAIL, Device out of range\n");
			u.u_error = ENODEV;
			return OPENFAIL;
		}
		unp = &Uds[dev];
	}

	unp->ud_rdq = queue;
	unp->ud_flags = u.u_uid ? 0 : TD_SUPERUSER;
	unp->ud_tstate = TS_UNBND;
	unp->ud_type = SOCK_STREAM;
	unp->ud_ref = NULL;
	unp->ud_maxconn = Udsmaxconn;
	unp->ud_numconn = 0;
	unp->ud_conq = NULL;
	unp->ud_nextref = NULL;

	queue->q_ptr = (caddr_t) unp;
	WR(queue)->q_ptr = (caddr_t) unp;
	/*
	noenable(WR(queue));
	*/

	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"udsopen: OPENFAIL, Successful open\n");
	return dev;
}

/*
 * 1) tell everyone on the conn queue that we are closing.
 * 2) send message to "co-queue" that we are closing.
 * 3) there is no use in lingering so clean up and return.
 */
int
udsclose(queue)
queue_t *queue;
{
	register struct unpcb *unp;

	unp = (struct unpcb *)queue->q_ptr;

	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"udsclose: Will clean sock and return\n");
	uds_cleansock(unp);

/* we will not linger any more */

	flushq(queue, FLUSHALL);
	flushq(WR(queue), FLUSHALL);
	unp->ud_rdq = NULL;
	unp->ud_flags = 0;
	return 0;
}

static struct T_info_ack UND_info_ack =
{
	T_INFO_ACK,		/* type */
	INFPSZ,			/* TSDU size */
	1024,			/* ETSDU size */
	0,			/* connect data size */
	0,			/* disconnect data size */
	AFUADDRLEN,		/* proto address size */
	0,			/* option size */
	65535,			/* TIDU size */
	T_CLTS,			/* */
	TS_IDLE,		/* default state */
};

udsput(queue, bp)
register queue_t *queue;
register mblk_t *bp;
{
	register union T_primitives *tp;
	register struct unpcb *unp, *conqp;
	struct T_info_ack *ib;
	register unchar Ttype;
	register mblk_t *bp1;
	struct iocblk *ip;
	extern void uds_ioctl();


	unp = (struct unpcb *)queue->q_ptr;
	if (!unp || unp->ud_rdq == NULL)
		/* Probably already aborted.  Just dump the message */
		goto Out;

	STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
		"udsput: entered, queue <0x%x>, bp <0x%x>\n", queue, bp);

	switch(MTYPE(bp)) {

	case M_DATA:
send_data:
		if (!unp->ud_conq) {

			STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
				"udsput: unconnected socket\n");
			freemsg(bp);
			putctl1(queue, M_ERROR, EPROTO);

		} else {
			conqp = unp->ud_conq;

			/* we must build the first block */
			if (unp->ud_type != SOCK_PAIR) {

			if (!(bp1 = allocb(sizeof(struct T_data_ind), BPRI_MED))) {
				strlog(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
				"udsput: Cannot allocate msg block\n");
				freemsg(bp);
				/* XXX */
			} else {

				register struct T_data_ind *tp1;
				STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
					"udsput: info request\n");

				MTYPE(bp1) = M_PROTO;
				tp1 = (struct T_data_ind *) bp1->b_wptr;
				tp1->PRIM_type = T_DATA_IND;
				tp1->MORE_flag = 0;
				bp1->b_wptr += sizeof(struct T_data_ind);
				bp1->b_cont = bp;
				putnext(conqp->ud_rdq, bp1);
			}

			} else {	/* SOCK_PAIR */
				STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
					"udsput: info request SOCK_PAIR\n");
				putnext(conqp->ud_rdq, bp);
			}
		}
		break;

	case M_PROTO:
	case M_PCPROTO:
		tp = (union T_primitives *)bp->b_rptr;
		Ttype = (unchar)TTYPE(tp);

		switch(Ttype) {

		case T_INFO_REQ:
			freemsg(bp);
			STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
				"udsput: info request\n");
			if (!(bp = allocb(sizeof(struct T_info_ack), BPRI_MED)))
				break;
			else {
				MTYPE(bp) = M_PCPROTO;
				ib = (struct T_info_ack *) bp->b_wptr;
				*ib = UND_info_ack;
				ib->SERV_type = unp->ud_type;
				bp->b_wptr += sizeof (struct T_info_ack);
				qreply(queue, bp);
			}
			break;

		case T_DATA_REQ:
		case T_EXDATA_REQ:

			/*  free M_PROTO, we can't support MORE_flag */

			bp1 = bp->b_cont;
			bp->b_cont = NULL;
			freeb(bp);
			bp = bp1;
			goto send_data;

		default:
			(void) uds_fsm(queue, bp);
		}
		break;

	case M_IOCTL:
	{
		struct iocblk *ip;

		STRLOG(UDS_ID, UDSCHAN(unp),DPRI_LO, SL_TRACE, "udsput: ioctl");
		ip = (struct iocblk *)bp->b_rptr;

		switch(ip->ioc_cmd) {

		case UDSIOC_PAIR:
		{
			int to;	/* minor device we're trying to connect to */

			if (ip->ioc_count != sizeof(int)) {
				STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
					"udsput: Bad size");
				ip->ioc_error = EINVAL;
				goto nackioc;
			}

			to = *(int *)bp->b_cont->b_rptr;

			/*
			 * The minor must be in range and open already.  Also,
			 * this device and the other one must be disconnected.
			 */
			if(to >= Udscount ||to < 0 || !Uds[to].ud_rdq) {
				STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
					"udsput: to out of range");
				ip->ioc_error = ENXIO;
				goto nackioc;
			}

			/* Don't allow cross connection to oneself */
			if (Uds[to].ud_rdq == queue) {
				STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
					"udsput: cannot loopback");
				ip->ioc_error = EINVAL;
				goto nackioc;
			}

			if (unp->ud_conq || Uds[to].ud_conq) {
				STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
					"udsput: queue is busy");
				ip->ioc_error = EBUSY;
				goto nackioc;
			}

			/* Cross connect streams */
			unp->ud_conq = &Uds[to];
			Uds[to].ud_conq = unp;
			ip->ioc_count = 0;
			unp->ud_type = Uds[to].ud_type = SOCK_PAIR;

ackioc:
			ip->ioc_error = 0;
			ip->ioc_count = 0;
			bp->b_datap->db_type = M_IOCACK;
			qreply(queue, bp);
			return;
		} 

		case UDSIOC_GETSOCKNAME:
		{
			if (((bp1 = bp->b_cont) == (mblk_t *)NULL) ||
			    (ip->ioc_count < AFUADDRLEN))  {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			if (!unp->ud_addr) {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			bcopy(unp->ud_addr->b_rptr, bp1->b_rptr, AFUADDRLEN);
			bp1->b_wptr = bp1->b_rptr + AFUADDRLEN;
			ip->ioc_count = AFUADDRLEN;
			goto ackioc;
		}
		case UDSIOC_GETPEERNAME:
		{
			if (( (bp1 = bp->b_cont) == (mblk_t *)NULL) ||
			    (ip->ioc_count < AFUADDRLEN))  {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			if (!unp->ud_ref || !unp->ud_ref->ud_addr) {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			bcopy(unp->ud_ref->ud_addr->b_rptr, bp1->b_rptr,
				AFUADDRLEN);
			bp1->b_wptr = bp1->b_rptr + AFUADDRLEN;
			ip->ioc_count = AFUADDRLEN;
			goto ackioc;
		}

		case UDSIOC_GETINODE:
		{
			if ((bp->b_cont == (mblk_t *)NULL) ||
					(ip->ioc_count < sizeof(int))) {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			if (!unp->ud_addr) {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			bp1 = bp->b_cont;

			bp1->b_wptr = bp->b_rptr + sizeof (int);
			*( (int *) bp1->b_rptr) = unp->ud_ino;
			goto ackioc;
		}
		case UDSIOC_SETINODE:
		{
			if ((bp->b_cont == (mblk_t *)NULL) ||
					(ip->ioc_count < sizeof(int))) {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			if (!unp->ud_addr) {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			bp1 = bp->b_cont;

			unp->ud_ino = *( (int *) bp1->b_rptr);
			goto ackioc;
		}
		default:
			ip->ioc_error = EINVAL;
			STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
				"udsput: unknown IOCTL");
nackioc:
			ip->ioc_count = 0;
			bp->b_datap->db_type = M_IOCNAK;
			qreply(queue, bp);
			return;
		}
	}

 	case M_FLUSH:
		STRLOG(UDS_ID, UDSCHAN(unp), DPRI_LO, SL_TRACE,
			"udsput: flush request\n");
		if (!queue->q_next) {
			*bp->b_rptr &= ~FLUSHW;
			if (*bp->b_rptr & FLUSHR) qreply(queue, bp);
			return;
		}
		switch (*bp->b_rptr) {
		case FLUSHR:
			*bp->b_rptr = FLUSHW;
			break;
		case FLUSHW:
			*bp->b_rptr = FLUSHR;
			break;
		}
		putnext(queue, bp);
		return;

	default:
Out:
		freemsg(bp);
		break;
	}
	return 0;
}
