/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)udd.c (TWG)       1.5     89/09/18 "

#include <sys/param.h>
#include <sys/types.h>

#ifndef XENIX
#include "sys/inline.h"
#include "sys/immu.h"
#include "sys/fs/s5dir.h"
#include "sys/region.h"
#ifdef u3b2
#include "sys/psw.h"
#include "sys/pcb.h"
#endif
#else /* XENIX */
#include "sys/seg.h"
#include "sys/page.h"
#include "sys/dir.h"
#include "sys/assert.h"
#endif
#include "sys/errno.h"
#include "sys/stream.h"
#include "sys/proc.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/file.h"
#include "sys/stropts.h"
#include "sys/tihdr.h"
#include "sys/tiuser.h"
#include "sys/strlog.h"
#include "sys/debug.h"

#include "sys/inet.h"
#include "sys/inetioctl.h"
#include "sys/socket.h"
#include "sys/un.h"
#include "sys/unpcb.h"

extern struct unpcb Udd[];
extern int Uddcount;

#define	UDD_ID	5432

void	uddinit();
int	uddopen(), uddclose(), uddput();
struct unpcb * udd_findaddr();

static struct module_info udd_info = {
	UDD_ID, "udd", 0, INFPSZ, 65535, 65535
};

static struct qinit uddrinit = {
	NULL, NULL, uddopen, uddclose, NULL, &udd_info, NULL 
};

static struct qinit uddwinit = {
	uddput, NULL, NULL, NULL, NULL, &udd_info, NULL 
};

struct streamtab uddinfo = {
	&uddrinit, &uddwinit, NULL, NULL
};

int
uddopen(queue, dev, flag, sflag)
register queue_t *queue;
register dev_t dev;
int flag, sflag;
{
	register struct unpcb *unp;

	dev = minor(dev);

	if (sflag == CLONEOPEN) {

		/*  Look for first available minor device */

		for (dev = 0; dev < Uddcount; dev++) {

			if (Udd[dev].ud_rdq == (queue_t *)NULL)
				break;
		}

		/*  Set and test validity of selected minor device */

		if (dev >= Uddcount) {

			STRLOG(UDD_ID, 0, DPRI_LO, SL_TRACE,
				"uddopen: OPENFAIL, No device available");

			u.u_error = ENODEV;
			return OPENFAIL;
		} else {

			unp = &Udd[dev];
		}

	} else if (unp = (struct unpcb *)queue->q_ptr) {

		/* Requested minor dev already open */

		STRLOG(UDD_ID, UDDCHAN(unp), DPRI_LO, SL_TRACE,
			"uddopen: OPENFAIL, Device already open");
		unp->ud_rdq = queue;
		return dev;

	} else {

		if (dev < 0 || dev >= Uddcount) {

			STRLOG(UDD_ID, UDDCHAN(unp), DPRI_LO, SL_TRACE,
				"uddopen: OPENFAIL, Device out of range");
			u.u_error = ENODEV;
			return OPENFAIL;
		}
		unp = &Udd[dev];
	}

	unp->ud_rdq = queue;
	unp->ud_flags = u.u_uid ? 0 : TD_SUPERUSER;
	unp->ud_tstate = TS_UNBND;
	unp->ud_type = SOCK_DGRAM;
	unp->ud_ref = NULL;
	unp->ud_addr = NULL;
	unp->ud_conq = NULL;
	unp->ud_nextref = NULL;

	queue->q_ptr = (caddr_t) unp;
	WR(queue)->q_ptr = (caddr_t) unp;

	STRLOG(UDD_ID, UDDCHAN(unp), DPRI_LO, SL_TRACE,
		"uddopen: Successful open");
	return dev;
}

int
uddclose(queue)
queue_t *queue;
{
	register struct unpcb *udd, *udd1, *uddtmp;

	udd = (struct unpcb *)queue->q_ptr;

	STRLOG(UDD_ID, UDDCHAN(udd), DPRI_LO, SL_TRACE,
		"uddclose: Will clean sock and return");

	/* if bound free the block */

	if (udd->ud_addr) {
		freeb(udd->ud_addr);
	}

	/* if connected remove from lists */

	if (udd->ud_conq) 
		udd_rmfromlist(udd, udd->ud_conq);

	/* if people connected to us, remove them from lists */

	if (udd->ud_ref) {

		for (udd1 = udd->ud_ref; udd1; ) {
			uddtmp = udd1->ud_nextref;
			udd1->ud_conq = NULL;
			udd1->ud_nextref = NULL;
			udd1 = uddtmp;
		}
	}

	/* we will not linger any more */

	flushq(queue, FLUSHALL);
	flushq(WR(queue), FLUSHALL);
	bzero(udd, sizeof(struct unpcb));
	return 0;
}

static struct T_info_ack UDD_info_ack =
{
	T_INFO_ACK,		/* type */
	INFPSZ,			/* TSDU size */
	1024,			/* ETSDU size */
	0,			/* connect data size */
	0,			/* disconnect data size */
	AFUADDRLEN,		/* proto address size */
	0,			/* option size */
	65535,			/* TIDU size */
	T_CLTS,			/* */
	TS_IDLE,		/* default state */
};

int
uddput(queue, bp)
register queue_t *queue;
register mblk_t *bp;
{
	register union T_primitives *tp;
	register struct unpcb *unp, *unp2;
	struct sockaddr_un *sun;
	register unchar Ttype;
	register mblk_t *bp1;

	unp = (struct unpcb *)queue->q_ptr;

	if (!unp || unp->ud_rdq == NULL)	/* just checking */
		goto Out;

	STRLOG(UDD_ID, UDDCHAN(unp), DPRI_LO, SL_TRACE,
		"uddput: entered, queue <0x%x>, bp <0x%x>", queue, bp);

	switch(MTYPE(bp)) {

	case M_DATA:
	{
		register struct T_data_ind *tp1;
send_data:
		if (!unp->ud_conq) {

			STRLOG(UDD_ID, UDDCHAN(unp), DPRI_LO, SL_TRACE,
				"uddput: unconnected socket");
			freemsg(bp);
			putctl1(queue, M_ERROR, EPROTO);
			break;
		}

		unp2 = unp->ud_conq;

		/* we must build the first block */

		if (!(bp1 = allocb(sizeof(struct T_data_ind), BPRI_MED))) {
			strlog(UDD_ID, UDDCHAN(unp), DPRI_LO, SL_TRACE,
			"uddput: Cannot allocate msg block");
			freemsg(bp);
			break;
		}

		STRLOG(UDD_ID, UDDCHAN(unp), DPRI_LO, SL_TRACE,
			"uddput: building M_PROTO");

		MTYPE(bp1) = M_PROTO;
		tp1 = (struct T_data_ind *) bp1->b_wptr;
		tp1->PRIM_type = T_DATA_IND;
		tp1->MORE_flag = 0;
		bp1->b_wptr += sizeof(struct T_data_ind);
		bp1->b_cont = bp;
		putnext(unp2->ud_rdq, bp1);
		break;
	}

	case M_PROTO:
	case M_PCPROTO:
	{
		tp = (union T_primitives *)bp->b_rptr;
		Ttype = (unchar)TTYPE(tp);

		switch(Ttype) {

		case T_DATA_REQ:
		case T_EXDATA_REQ:

			/*  free M_PROTO, we can't support MORE_flag */

			bp1 = bp->b_cont;
			bp->b_cont = NULL;
			freeb(bp);
			bp = bp1;
			goto send_data;

		case T_UNITDATA_REQ:
		{
			register struct T_unitdata_req *Tp;
			register struct T_unitdata_ind *Ti;
			int retcode;
			mblk_t	*bpc;

			STRLOG(UDD_ID, UDDCHAN(unp), DPRI_LO, SL_TRACE,
				"uddput: T_UNITDATA_REQ");

			Tp = (struct T_unitdata_req *)bp->b_rptr;

			if ((BLEN(bp) < (Tp->DEST_offset + Tp->DEST_length))
			    || (Tp->DEST_length != AFUADDRLEN)) {
				retcode = TBADADDR;
				strlog(UDD_ID, UDDCHAN(unp), DPRI_MED,
					SL_te,"uddput: Bad addr length");
				goto badudr;
			}

			if ( (bpc = bp->b_cont) == NULL) {
				retcode = TNODATA;
				strlog(UDD_ID, UDDCHAN(unp), DPRI_MED,
					SL_te,"uddput: No Data");
				goto badudr;
			}

			if ( !(unp2 = 
			udd_findaddr((struct sockaddr_un *)(bp->b_rptr + Tp->DEST_offset)))) {
				retcode = TBADADDR;
				strlog(UDD_ID, UDDCHAN(unp), DPRI_MED,
					SL_te, "uddput: cannot find dest");
				goto badudr;
			}

			if (!(bp1 = 
			allocb(sizeof(struct T_unitdata_ind) + AFUADDRLEN,
					BPRI_MED))) {
				retcode = TSYSERR;
				strlog(UDD_ID, UDDCHAN(unp), DPRI_LO, SL_TRACE,
				"uddput: Cannot allocate msg block");
				goto badudr;
			}

			STRLOG(UDD_ID, UDDCHAN(unp), DPRI_LO, SL_TRACE,
				"uddput: building T_UNITDATA_IND");

			MTYPE(bp1) = M_PROTO;
			Ti = (struct T_unitdata_ind *)bp1->b_wptr;
			Ti->PRIM_type = T_UNITDATA_IND;
			Ti->SRC_length = AFUADDRLEN;
			Ti->SRC_offset = sizeof(struct T_unitdata_ind);
			Ti->OPT_length = 0;
			Ti->OPT_offset = sizeof(struct T_unitdata_ind);

			bcopy((char *)unp->ud_addr->b_rptr,
			(char *)(bp1->b_wptr + sizeof(struct T_unitdata_ind)),
				AFUADDRLEN);
			bp1->b_wptr += (sizeof(struct T_unitdata_ind)
				 + AFUADDRLEN);
			bp1->b_cont = bpc;
			STRLOG(UDD_ID, UDDCHAN(unp), DPRI_LO, SL_TRACE,
			"uddput: putnext to queue <0x%x>", unp2->ud_rdq);
			putnext(unp2->ud_rdq, bp1);

			bp->b_cont = NULL;
			freemsg(bp);
			break;
badudr:
			if(bp1 = allocb(sizeof(struct T_uderror_ind), BPRI_HI)){
				struct T_uderror_ind *Tp1;

				Tp1 = (struct T_uderror_ind *)bp1->b_wptr;
				Tp1->PRIM_type = T_UDERROR_IND;
				Tp1->DEST_length = Tp->DEST_length;
				Tp1->DEST_offset = Tp->DEST_offset;
				Tp1->OPT_length = Tp->OPT_length;
				Tp1->OPT_offset = Tp->OPT_offset;
				Tp1->ERROR_type = retcode;
				bp1->b_wptr += sizeof(struct T_uderror_ind);
				strlog(UDP_ID, UDDCHAN(unp), DPRI_MED, SL_te,
				"udd_output: Non fatal error %d\n", retcode);
				qreply(queue, bp1);
			}
			if(bp)
				freemsg(bp);
			break;
		}
		case T_INFO_REQ:
		{
			register struct T_info_ack *ib;
			freemsg(bp);
			STRLOG(UDD_ID, UDDCHAN(unp), DPRI_LO, SL_TRACE,
				"uddput: info request");
			if (!(bp = allocb(sizeof(struct T_info_ack), BPRI_MED)))
				return;
			else {
				MTYPE(bp) = M_PCPROTO;
				ib = (struct T_info_ack *) bp->b_wptr;
				*ib = UDD_info_ack;
				bp->b_wptr += sizeof (struct T_info_ack);
				qreply(queue, bp);
			}
			return;
		}
		case T_BIND_REQ:
		{
			udd_bind(queue, bp);
			return;
		}
		case T_UNBIND_REQ:
		{
			STRLOG(UDD_ID, UDDCHAN(unp), DPRI_MED, SL_TRACE,
				"udd unbind");
			if (upflush(queue) == -1 || unp->ud_tstate != TS_IDLE) {
				if (bp1 = allocb(1, BPRI_HI)) {
					MTYPE(bp1) = M_ERROR;
					*bp1->b_wptr++ = EPROTO;
					putnext(queue, bp1);
				}
			} else {
				unp->ud_tstate = TS_UNBND;
				unp->ud_flags = 0;
				if (unp->ud_addr) {
					freemsg(unp->ud_addr);
					unp->ud_addr = NULL;
				}
				udd_ok_ack(queue, T_UNBIND_REQ);
			}

			freemsg(bp);
			break;
		}
		default:
			strlog(UDD_ID, UDDCHAN(unp), DPRI_MED, SL_TRACE,
			 "uddput: unknown M_PROTO type %x", Ttype);
			 break;
		}
		break;
	}
	case M_IOCTL:
	{
		struct iocblk *ip;

		STRLOG(UDD_ID, UDDCHAN(unp),DPRI_LO, SL_TRACE, "uddput: ioctl");
		ip = (struct iocblk *)bp->b_rptr;

		switch(ip->ioc_cmd) {

		case UDDIOC_CONNECT:
		{
			if (bp->b_cont == (mblk_t *)NULL ||
				ip->ioc_count < AFUADDRLEN) 
				goto nackioc;
			bp1 = bp->b_cont;
			sun = (struct sockaddr_un *)bp1->b_rptr;
	
			if (unp->ud_ref) {
				udd_rmfromlist(unp, unp->ud_ref);
				if ( !Strlen(sun->sun_path) ) { /* disconnect */ 
					ip->ioc_count = 0;
					goto ackioc;
				}
			}
			if ( !Strlen(sun->sun_path) ||
					!(unp2 = udd_findaddr(sun))) {
				ip->ioc_error = TBADADDR;
				goto nackioc;
			}

			udd_addtolist(unp, unp2);

			ip->ioc_count = 0;
ackioc:
			ip->ioc_error = 0;
			bp->b_datap->db_type = M_IOCACK;
			qreply(queue, bp);
			return;
		}

		case UDDIOC_GETSOCKNAME:
		{
			if (((bp1 = bp->b_cont) == (mblk_t *)NULL) ||
			    (ip->ioc_count < AFUADDRLEN))  {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			if (!unp->ud_addr) {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			bcopy(unp->ud_addr->b_rptr, bp1->b_rptr, AFUADDRLEN);
			bp1->b_wptr = bp1->b_rptr + AFUADDRLEN;
			ip->ioc_count = AFUADDRLEN;
			goto ackioc;
		}
		case UDDIOC_GETPEERNAME:
		{
			if (( (bp1 = bp->b_cont) == (mblk_t *)NULL) ||
			    (ip->ioc_count < AFUADDRLEN))  {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			if (!unp->ud_ref || !unp->ud_ref->ud_addr) {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			bcopy(unp->ud_ref->ud_addr->b_rptr, bp1->b_rptr,
				AFUADDRLEN);
			bp1->b_wptr = bp1->b_rptr + AFUADDRLEN;
			ip->ioc_count = AFUADDRLEN;
			goto ackioc;
		}

		case UDDIOC_GETINODE:
		{
			if ((bp->b_cont == (mblk_t *)NULL) ||
					(ip->ioc_count < sizeof(int))) {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			if (!unp->ud_addr) {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			bp1 = bp->b_cont;

			bp1->b_wptr = bp->b_rptr + sizeof (int);
			*( (int *) bp1->b_rptr) = unp->ud_ino;
			goto ackioc;
		}
		case UDDIOC_SETINODE:
		{
			if ((bp->b_cont == (mblk_t *)NULL) ||
					(ip->ioc_count < sizeof(int))) {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			if (!unp->ud_addr) {
				ip->ioc_error = EINVAL;
				goto nackioc;
			}
			bp1 = bp->b_cont;

			unp->ud_ino = *( (int *) bp1->b_rptr);
			goto ackioc;
		}
		default:
			ip->ioc_error = EINVAL;
			STRLOG(UDD_ID, UDDCHAN(unp), DPRI_LO, SL_TRACE,
				"uddput: unknown IOCTL");
nackioc:
			ip->ioc_count = 0;
			bp->b_datap->db_type = M_IOCNAK;
			qreply(queue, bp);
			return;
		}
	}
	case M_FLUSH:
	{
		STRLOG(UDD_ID, UDDCHAN(unp), DPRI_LO, SL_TRACE,
			"uddput: flush request");
		if (!queue->q_next) {
			*bp->b_rptr &= ~FLUSHW;
			if (*bp->b_rptr & FLUSHR) qreply(queue, bp);
			return;
		}
		switch (*bp->b_rptr) {
		case FLUSHR:
			*bp->b_rptr = FLUSHW;
			break;
		case FLUSHW:
			*bp->b_rptr = FLUSHR;
			break;
		}
		putnext(queue, bp);
		return;
	}
	default:
Out:
		freemsg(bp);
		break;
	}
}

struct unpcb *
udd_findaddr(sun)
struct sockaddr_un *sun;
{
	int index;
	struct unpcb *unp;
	struct sockaddr_un *sun2;
	int slen = blen(sun->sun_path);

	for (index = 0; index < Uddcount; index++ ) {

		unp = &Udd[index];
		if (unp->ud_rdq && unp->ud_addr) {
			sun2 = (struct sockaddr_un *) unp->ud_addr->b_rptr;
		
			if ( slen == blen(sun2->sun_path) &&
				 !bcmp(sun->sun_path, sun2->sun_path,slen) ) {
				return(unp);
			}
		}
	}
	return(NULL);
}

udd_rmfromlist(unp, unps)
register struct unpcb *unp, *unps;
{
	register struct unpcb *unp1;

	if (unp = unps->ud_ref)
		unps->ud_ref = unp->ud_nextref;
	else
	for (unp1 = unps->ud_ref; unp1->ud_nextref; unp1 = unp1->ud_nextref)
		if (unp1->ud_nextref = unp)
			unp1->ud_nextref = unp->ud_nextref;

	unp->ud_conq = unp->ud_nextref = NULL;
}

udd_addtolist(udd, udds)
struct unpcb *udd, *udds;
{
	if (udds->ud_ref == NULL) {

		udds->ud_ref = udd;
	} else {

		for (udds = udds->ud_ref; udds->ud_nextref; udds = udds->ud_nextref);
		udds->ud_nextref = udd;
	}
	udd->ud_nextref = NULL;
	return;
}

int
udd_ok_ack(queue, prim)
register queue_t *queue;
register long prim;
{
	register struct T_ok_ack *tp;
	mblk_t *bp;

	if ((bp = allocb(sizeof(struct T_ok_ack), BPRI_MED)) == NULL)
			return(-1);

	MTYPE(bp) = M_PCPROTO;
	tp = (struct T_ok_ack *)bp->b_rptr;
	tp->PRIM_type = T_OK_ACK;
	tp->CORRECT_prim = prim;
	bp->b_wptr += sizeof(struct T_ok_ack);
	qreply(queue, bp);

	return(0);
}

int
udd_error_ack(queue, prim, code)
register queue_t *queue;
register long prim;
register long code;
{
	register struct T_error_ack *tp;
	mblk_t *bp;

	if ((bp = allocb(sizeof(struct T_error_ack), BPRI_MED)) == NULL)
			return(-1);

	MTYPE(bp) = M_PCPROTO;
	tp = (struct T_error_ack *)bp->b_rptr;
	tp->PRIM_type = T_ERROR_ACK;
	tp->ERROR_prim = prim;
	tp->TLI_error = code;
	bp->b_wptr += sizeof(struct T_error_ack);
	qreply(queue, bp);

	return(0);
}

udd_bind(q, bp)
register queue_t *q;
register mblk_t *bp;
{
	struct T_bind_req *Tr;
	struct T_bind_ack *Ta;
	struct unpcb *udd;
	mblk_t *bp2;
	long retcode;
	struct sockaddr_un *sun;

	ASSERT(bp && q);

	Tr = (struct T_bind_req *) bp->b_rptr;
	udd = (struct unpcb *)q->q_ptr;

	if ((bp->b_wptr - bp->b_rptr) < (sizeof(struct T_bind_req) + AFUADDRLEN)
		|| (Tr->ADDR_length != AFUADDRLEN )) {
		retcode = TBADADDR;
		strlog(UDD_ID, UDDCHAN(udd), DPRI_LO, SL_TRACE,
			"udd_bind: TBADADDR\n");
		goto nonfatal;
	}

	/* are we already bound */

	if (udd->ud_ino || udd->ud_addr) {
		retcode = TNOADDR;
		strlog(UDD_ID, UDDCHAN(udd), DPRI_LO, SL_TRACE,
			"udd_bind: TNOADDR\n");
		goto nonfatal;
	}

	sun = (struct sockaddr_un *) (bp->b_rptr + Tr->ADDR_offset);

	if (udd_findaddr(sun)) {
		strlog(UDD_ID, UDDCHAN(udd), DPRI_LO, SL_TRACE,
			"udd_bind: Address in use");
		retcode = TNOADDR;
		goto nonfatal;
	}

	if ((bp2 = allocb(AFUADDRLEN, BPRI_MED)) == NULL) {
		freemsg(bp);
		goto fatal;
	}

	bcopy((char *) sun, (char *)bp2->b_rptr, AFUADDRLEN);
	bp2->b_wptr += AFUADDRLEN;
	udd->ud_addr = bp2;

	/* success, return T_bind_ack */

	freemsg(bp);
	if (!(bp = allocb(sizeof(struct T_bind_ack) + AFUADDRLEN, BPRI_MED))) {
		freemsg(udd->ud_addr);
		udd->ud_addr = NULL;
		goto fatal;
	}

	MTYPE(bp) = M_PCPROTO;

	Ta = (struct T_bind_ack *)bp->b_rptr;
	Ta->PRIM_type = T_BIND_ACK;
	Ta->ADDR_length = AFUADDRLEN;
	Ta->ADDR_offset = sizeof(struct T_bind_ack);
	Ta->CONIND_number = 0;
	bcopy(udd->ud_addr->b_rptr, (char *)(bp->b_rptr + Ta->ADDR_offset),
		AFUADDRLEN);

	bp->b_wptr = bp->b_rptr + sizeof(struct T_bind_ack) + AFUADDRLEN;
	udd->ud_tstate = TS_IDLE;

	qreply(q, bp);
	return;

nonfatal:
	strlog(UDD_ID, UDDCHAN(udd), DPRI_MED, SL_TRACE,
		"udd_bind: nonfatal retcode 0x%x", retcode);
	freemsg(bp);
	if (udd_error_ack(q, T_BIND_REQ, retcode))
		goto fatal;
	return;

fatal:
	strlog(UDD_ID, UDDCHAN(udd), DPRI_LO, SL_TRACE,
		"udd_bind: Fatal Error");
	putctl1(q->q_next, M_ERROR, EPROTO);
}

static int
Strlen(ss)
register char *ss;
{
	register int ii = 0;
	while (*ss++)
		ii++;
	return (ii);
}
