
#include "sys/types.h"
#include "sys/stream.h"

extern ushort sum_block();

ushort
in_cksum(bp, len)
	register mblk_t * bp;
	register int      len;
{
	register uchar *  rptr;
	register ushort   sum    = 0;
	register int      blen   = 0;
	register ulong    offset = 0;

	while (bp && len){ 
		rptr = bp->b_rptr;
		blen = bp->b_wptr - rptr ;
		if (len < blen)
			blen = len;
		sum = sum_block( rptr, blen, sum, offset );
		len    -= blen;
		offset += blen;
		bp = bp->b_cont;	
	}
	/*
	 * This comment is to explain the seemingly obvious error in the 
	 * following line of code.  If, as is USUALLY the case, sum contains
	 * the value 0xFFFF, then the expression ~sum (an integer expression)
	 * evaluates to 0xFFFF0000.  Even though (or perhaps, because) this
	 * function is a ushort function, nonetheless, the c compiler does
	 * NOT make sure that the value returned in the D0 register is 0x0.
	 * If the caller failed to properly declare this function as a ushort
	 * function, then the caller will find that the result is non-zero,
	 * even if the 16 least-significant bits are zero.  
	 *
	 * By casting sum to be a (signed) short, the c compiler must "promote"
	 * it to a signed int before doing the ones-complement operation (~).
	 * This way, if sum == 0xFFFF, it will become 0xFFFFFFFF and the (~)
	 * operation will return zero.  This  is evidently a common problem
	 * among c compilers, because the (slow) code from TWG used this trick
	 * to solve the problem in their "portable" code.
	 */
	return ~(short)sum; 
}
