/* LINTLIBRARY */
/*
 * @(#) Copyright 1988.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)tcp_tn.c (TWG)  1.6     89/08/17 "

/*
 * network originated actions
 */

#include "sys/param.h"
#include "sys/types.h"
#ifndef XENIX
#include "sys/inline.h"
#endif
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/tihdr.h"
#include "sys/strlog.h"
#include "sys/debug.h"
#ifdef XENIX
#include "sys/assert.h"
#endif
#include "sys/inet.h"
#include "sys/socket.h"
#include "sys/if.h"
#include "sys/in.h"
#include "sys/in_var.h"
#include "sys/ip.h"
#include "sys/tcp.h"

static tcp_connid = 0;


/***********************
 *  Table of Contents  *
 **********************/

void		tn_connected();
struct tcpcb	*tn_connreq();
void		tn_disconnected();
void		tn_data();
void		tn_exdata();
void		tn_exdata1();
void		tn_orddisconn();
void		tn_usrmsg();

/***** End of TOC *****/

/*
 * send bp upstream, change state, and log activity
 * may be subroutine
 */
#define	tnfsm(TDP, BP, STATE, CALLER)	{ \
	TDP->td_tstate = STATE; \
	putnext(TDP->td_rdq, BP);	/* need canput?? */ \
	STRLOG(TCP_ID, TCPCHAN(TDP), DPRI_LO, SL_TRACE,\
		"Change to state = %x\n", STATE); \
	}

/*
 * the tcp fsm acknowledges a previous outgoing connect request
 * fport and faddr are foreign port and address connected to us
 * currently no user data is provided
 */
void
tn_connected(tdp, faddr, fport)
     register struct tcpd *tdp;
     ulong faddr; 
     ushort fport;
{
    register struct T_conn_con *Tp;
    struct tsap *ap;
    register mblk_t *bp, *bpo;
    struct stroptions *optp;
    extern unchar tu_fatal();

    ASSERT(tdp && tdp->td_tcpcb);

    if (tdp->td_tstate != TS_WCON_CREQ)
	goto fatal;
    if ((bp = allocb(TCP_CONNCONLEN, BPRI_MED)) == NULL)
	goto fatal;
    if ((bpo = allocb(sizeof(struct stroptions), BPRI_MED))==NULL)
	goto fatal;

    MTYPE(bp) = M_PROTO;
    Tp = (struct T_conn_con *)bp->b_wptr;
    Tp->PRIM_type = T_CONN_CON;
    Tp->RES_length = TCP_CONNCONRESLEN;
    Tp->RES_offset = TCP_CONNCONRESOFFSET;
    Tp->OPT_length = 0;			/* not supported */
    Tp->OPT_offset = TCP_CONNCONRESOFFSET;
    ap = (struct tsap *)(bp->b_rptr + TCP_CONNCONRESOFFSET);
    ap->ta_addr = faddr;
    ap->ta_port = fport;
    bp->b_wptr += TCP_CONNCONLEN;
    tnfsm(tdp, bp, TS_DATA_XFER, "tn_connected");
    TRACE(1<<30,"tn_connected: Told User that we are connected\n",0);

    optp = (struct stroptions *)bpo->b_wptr;
    bpo->b_wptr += sizeof(struct stroptions);
    bpo->b_datap->db_type = M_SETOPTS;
    optp->so_flags = SO_LOWAT;
    optp->so_lowat = STRLOW;
    putnext(tdp->td_rdq, bpo);
    return;

fatal:
    TRACE(1<<15,"tn_connected: FataL error to User(LISTEN)\n",0);
    if (bp)
	freeb(bp);
    tu_fatal(tdp);
    return;

}	/*  End of tn_connected();  */

/*
 * the tcp fsm indicates an incoming call request
 * tdp is the listening stream
 * ti is the incoming tcpip segment
 * we now create a tcpcb and attach it to listener's t_conq
 * currently no user data is provided
 * return the floating tcpcb pointer if o.k. NULL if failed
 */
struct tcpcb *
tn_connreq(tdp, ti, iss)
     register struct tcpd *tdp;
     register struct tcpiphdr *ti;
     register int iss;
{
    struct T_conn_ind *Tp;
    struct tsap *ap;
    register struct tcpcb *tp, *rtp;
    register mblk_t *bp1 , *bp = NULL, *bpo = NULL, *zp = NULL;
	struct stroptions *optp;

    ASSERT(tdp && tdp->td_tcpcb);
    
    tp = (struct tcpcb *)tdp->td_tcpcb->b_rptr;

    if (tdp->td_tstate != TS_IDLE && tdp->td_tstate != TS_WRES_CIND)
	goto fatal;
    /*
     * check if we can have more connections pending
     */
    if (tp->t_cqlen >= tp->t_maxcon) {
	STRlog(TCP_ID, TCPCHAN(tdp), DPRI_LO, SL_te,
	       "tn_connreq: drop %x.%d",ntohl(ti->ti_src),ntohs(ti->ti_sport));
	goto nonfatal;
	}

    if ((bp = tv_popen(tdp)) == NULL)
	goto nonfatal;

    if ((bpo = allocb(sizeof(struct stroptions), BPRI_MED)) == NULL) 
	goto nonfatal;

    if ((zp = allocb(4, BPRI_MED)) == NULL) 
	goto nonfatal;

    rtp = (struct tcpcb *)bp->b_rptr;
    if (!(bp1 = allocb(TCP_CONNINDLEN, BPRI_MED))) {
	bzero((caddr_t)rtp, sizeof(struct tcpcb));
	goto nonfatal;
	}
    /*
     * Set up template.
     */
    rtp->t_laddr = ti->ti_dst;
    rtp->t_lport = ti->ti_dport;
    rtp->t_faddr =  ti->ti_src;
    rtp->t_fport = ti->ti_sport;
	
		
    if (tv_template(rtp)) {
	bzero((caddr_t)rtp, sizeof(struct tcpcb));
	goto nonfatal;
	}
	
    if (iss)
	rtp->iss = iss;
    else
	tp->iss = tcp_iss;
    tcp_iss += TCP_ISSINCR/2;
    rtp->irs = ti->ti_seq;
    tcp_sendseqinit(rtp);
    tcp_rcvseqinit(rtp);
    rtp->t_timer[TCPT_KEEP] = TCPTV_KEEP_INIT;
    rtp->t_state = TV_SYN_RCVD;

    MTYPE(bp1) = M_PROTO;
    Tp = (struct T_conn_ind *)bp1->b_wptr;
    Tp->PRIM_type = T_CONN_IND;
    Tp->SRC_length = TCP_CONNINDSRCLEN;
    Tp->SRC_offset = TCP_CONNINDSRCOFFSET;
    Tp->OPT_length = 0;
    Tp->OPT_offset = TCP_CONNINDSRCOFFSET;
    Tp->SEQ_number = rtp->t_conid = ++tcp_connid;
    ap = (struct tsap *)(bp1->b_rptr + TCP_CONNINDSRCOFFSET);
    ap->ta_addr = ti->ti_src;
    ap->ta_port = ti->ti_sport;
    ap->ta_family = AF_INET;
    bp1->b_wptr += TCP_CONNINDLEN;
    bp1->b_cont = zp;		/* used by somod, nop for timod */
    /*
     * Start up the timer (TO BE CONTINUED)
     */
    tp->t_cqlen++;			/* tp is for listener's */
    c_enq(bp, (mblk_t *)&tp->t_conq);

    /*
     * change state and send T_conn_ind up
     */
    optp = (struct stroptions *)bpo->b_wptr;
    bpo->b_wptr += sizeof(struct stroptions);
    bpo->b_datap->db_type = M_SETOPTS;
    optp->so_flags = SO_LOWAT;
    optp->so_lowat = STRLOW;
    putnext(tdp->td_rdq, bpo);

    tnfsm(tdp, bp1, TS_WRES_CIND, "tn_connreq");
    return(rtp);

fatal:
    tu_fatal(tdp);
nonfatal:
    if (bp)
	freeb(bp);
    if (bpo)
	freeb(bpo);
    if (zp)
	freeb(zp);
    return(NULL);

}	/*  End of tn_connreq()  */

/*
 * the tcp fsm indicates a connection is dropped (from tcp_input.c)
 * if tp is floating, i.e. td_tstate is TS_WRES_CIND
 * delete it from listener's conq (tp->t_tdp is the listener)
 * currently no user data is provided
 */
void
tn_disconnected(tp)

	register struct tcpcb *tp;
{
	register struct T_discon_ind *Tp;
	register struct tcpd *tdp;
	register mblk_t *bp, *head;
	queue_t *q;
	struct tcpcb *ltp;		/* listener's tcpcb, may be == tp */
	long seq;
	unchar state = TS_IDLE;

	if ((tdp = tp->t_tdp) == NULL)
		return;
	if ((tp->t_state != TV_CLOSED) && (tdp->td_flags & TD_CLOSING)) {
		/*
		 * User has already stared a close.
		 * Don't bother to send any messages
		 * upstream. Just set the TIME_WAIT timer
		 * so that this PCB will get delted.
		 */
		tp->t_timer[TCPT_2MSL] = 1;
		return;
	}
	q = tdp->td_rdq;
	ASSERT(q);

	STRLOG(TCP_ID, -1, DPRI_LO, SL_TRACE,
		"tn_disconnected: incoming state = %x", tdp->td_tstate);

	switch(tdp->td_tstate) {

	case TS_IDLE:
		return;

	case TS_WCON_CREQ:
	case TS_DATA_XFER:
	case TS_WIND_ORDREL:
	case TS_WREQ_ORDREL:
		seq = -1;
		break;

	case TS_WRES_CIND:
		seq = tp->t_conid;	/* from the floating tcpcb */
		/*
		 * remove floating tcpcb from listener's t_conq
		 * if the conq still not empty, stay in this state
		 * otherwise, go back to TS_IDLE state
		 */
		ltp = (struct tcpcb *)tdp->td_tcpcb->b_rptr;
		head = (mblk_t *)&ltp->t_conq;
		for (bp = head->b_next; bp != head; bp = bp->b_next)
			if (tp == (struct tcpcb *)bp->b_rptr)
				goto found;

		/* disconnect something not there */
		goto err;
found:
		c_deq(bp);
		if (--ltp->t_cqlen > 0)
			state = TS_WRES_CIND;
		break;
		
	default:
		goto err;
	}

	/*
	 * the network is dropping the connection
	 * send T_discon_ind to user
	 */
	if (!(bp = allocb(sizeof(struct T_discon_ind), BPRI_MED)))
		goto err;
	MTYPE(bp) = M_PROTO;
	Tp = (struct T_discon_ind *)bp->b_wptr;
	Tp->PRIM_type = T_DISCON_IND;
	Tp->DISCON_reason = 0;		/* TO BE CONTINUED */
	Tp->SEQ_number = seq;
	bp->b_wptr += sizeof(struct T_discon_ind);

	/*
	 * We should really present this after the
	 * any other messages that might be on the queue.
	 * There is no session protocol for TCP.
	 */
	tdp->td_tstate = state;
	putq (tdp->td_rdq, bp);
	return;

err:
	STRlog(TCP_ID, TCPCHAN(tdp), DPRI_LO, SL_te,
		"tn_disconnected: state = %x", tdp->td_tstate);
	return;

}	/*  End of tn_disconnected()  */

/*
 * normal data is available
 * makeup M_PROTO and followed by M_DATAs
 */
void
tn_data(tdp, bp)

	register struct tcpd *tdp;
	register mblk_t *bp;
{
	register mblk_t *bp1 = (mblk_t *)NULL;
	register struct T_data_ind *Tp;
	register int size;
	extern unchar tu_fatal();

	ASSERT(tdp && tdp->td_tcpcb && bp);
	if (MTYPE(bp) != M_DATA) {
		STRlog(TCP_ID, TCPCHAN(tdp), DPRI_MED, SL_te,
			"tn_data: Not Data(%x)", MTYPE(bp));
		freemsg(bp);
		return;
	}

	if (tdp->td_tstate != TS_DATA_XFER && tdp->td_tstate != TS_WIND_ORDREL)
		goto fatal;
	/*
	 * If the User is just going to do
	 * Read and writes only then there is
	 * no need for tirdwr.
	 */
	if (tdp->td_flags & TD_RDWR){
		bp1 = bp;
		goto Putit;
	}
	if (!(bp1 = allocb(sizeof(struct T_data_ind), BPRI_LO)))
		goto fatal;

	MTYPE(bp1) = M_PROTO;
	Tp = (struct T_data_ind *)bp1->b_wptr;
	Tp->PRIM_type = T_DATA_IND;
	Tp->MORE_flag = 0;
	bp1->b_wptr += sizeof(struct T_data_ind);
	bp1->b_cont = bp;
Putit:
	size = msgdsize(bp);
	tdp->td_rcount += size;
	STRlog(TCP_ID, TCPCHAN(tdp), DPRI_LO, SL_te,
	  "tn_data: rdq adr %x",tdp->td_rdq);
	putq(tdp->td_rdq, bp1);
	return;

fatal:
	if (bp)
		freemsg(bp);
	tu_fatal(tdp);
	return;

}	/*  End of tn_data()  */

/*
 * expedited data is available
 */
void
tn_exdata1(tdp,bp)

	register struct tcpd *tdp;
	register mblk_t *bp;
{
	register mblk_t *bp1;
	register struct T_exdata_ind *Tp;
	register int size;
	extern unchar tu_fatal();


	ASSERT(tdp && tdp->td_tcpcb && bp );

	if (MTYPE(bp) != M_DATA) {
		STRlog(TCP_ID, TCPCHAN(tdp), DPRI_MED, SL_te,
			"tn_data: Not Data(%x)", MTYPE(bp));
		freemsg(bp);
		return;
	}
	if (tdp->td_tstate != TS_DATA_XFER && tdp->td_tstate != TS_WIND_ORDREL)
		goto fatal;

	/**
	 **/

	if (!(bp1 = allocb(sizeof(struct T_exdata_ind), BPRI_LO)))
		goto fatal;

	MTYPE(bp1) = M_PROTO;
	Tp = (struct T_exdata_ind *)bp1->b_wptr;
	Tp->PRIM_type = T_EXDATA_IND;
	/* Tp->MORE_flag = 0; Someone screwed up tihdr.h */
	Tp->MORE_type = 0;
	bp1->b_wptr += sizeof(struct T_exdata_ind);
	bp1->b_cont = bp;
	size = msgdsize(bp);
	tdp->td_rcount += size;

	/*
	 * Should do a putnext() because this is
	 * Expedited data indication.
	 */
	STRlog(TCP_ID, TCPCHAN(tdp), DPRI_LO, SL_te,
	  "tn_exdata: rdq adr %x",tdp->td_rdq);
	putq(tdp->td_rdq,bp1);
	return;

fatal:
	if (bp1)
		freeb(bp1);
	tu_fatal(tdp);	/* Is this necessary */
	return;

}	/*  End of tn_exdata()  */
void
tn_exdata(tdp)

	register struct tcpd *tdp;
{
	register mblk_t *bp1;
	register struct T_exdata_ind *Tp;
	extern unchar tu_fatal();


	ASSERT(tdp && tdp->td_tcpcb );

	if (tdp->td_tstate != TS_DATA_XFER && tdp->td_tstate != TS_WIND_ORDREL)
		goto fatal;

	/**
	 ** Allocate a medium priority message block for sending
	 ** T_EXDATA_IND- this makes sure that the message block
	 ** gets to the stream head before the expedited data arrives
	 ** No data is sent here but just an indication that we got
	 ** expedited data further down in the byte stream
	 ** the expedited data is sent along with normal data in the
	 ** data stream
	 **/

	if (!(bp1 = allocb(sizeof(struct T_exdata_ind), BPRI_MED)))
		goto fatal;

	MTYPE(bp1) = M_PROTO;
	Tp = (struct T_exdata_ind *)bp1->b_wptr;
	Tp->PRIM_type = T_EXDATA_IND;
	/* Tp->MORE_flag = 0; Someone screwed up tihdr.h */
	Tp->MORE_type = 0;
	bp1->b_wptr += sizeof(struct T_exdata_ind);

	/*
	 * Should do a putnext() because this is
	 * Expedited data indication.
	 */
	STRlog(TCP_ID, TCPCHAN(tdp), DPRI_LO, SL_te,
	  "tn_exdata: rdq adr %x",tdp->td_rdq);
	putnext(tdp->td_rdq,bp1);
	return;

fatal:
	if (bp1)
		freeb(bp1);
	tu_fatal(tdp);	/* Is this necessary */
	return;

}	/*  End of tn_exdata()  */

/*
 * orderly disconnecting
 *	ignore all user data, if any
 */
void
tn_orddisconn(tdp, bp)

	struct tcpd *tdp;
	mblk_t *bp;
{
	register unsigned int state;
	register struct tcpcb *tp;
	extern unchar tu_fatal();

	ASSERT(tdp && tdp->td_tcpcb);
	if (bp) {		/* user data: implementation error */
		freemsg(bp);
		STRlog(TCP_ID, TCPCHAN(tdp), DPRI_LO, SL_te,
		  "tn_orddisconn: User data not allowed\n");
	}
	/*
	 * IF the user has already initated a close, then
	 * there is no need to send any message upstream.
	 * Just set the TIME_WAIT timer to expire so that
	 * the PCB will bet deleted next time.
	 */
	if (tdp->td_flags & TD_CLOSING) {
		tp = mtod ((tdp->td_tcpcb), struct tcpcb *);
		                            /* The damn compiler produces */
		                            /* bad code if not broken up  */
		tp->t_timer[TCPT_2MSL] = 1;
		return;
	}
	/*
	 * send T_ordrel_ind upstream
	 */
	if (!(bp = allocb(sizeof(struct T_ordrel_ind), BPRI_MED)))
		goto fatal;
	((struct T_ordrel_ind *)(bp->b_rptr))->PRIM_type = T_ORDREL_IND;
	bp->b_wptr += sizeof(struct T_ordrel_ind);
	MTYPE(bp) = M_PROTO;

	STRLOG(TCP_ID, -1, DPRI_LO, SL_TRACE,
		"tn_orddisconn: incoming state = %x", tdp->td_tstate);

	switch(tdp->td_tstate) {

	case TS_DATA_XFER:
		state = TS_WREQ_ORDREL;
		break;

	case TS_WIND_ORDREL:
		state = TS_IDLE;
		break;
	default:
		freeb(bp);
		goto fatal;
	}
	tdp->td_tstate = state;

	STRLOG(TCP_ID, -1, DPRI_LO, SL_TRACE,
		"tn_orddisconn: outgoing state = %x", tdp->td_tstate);

	putq(tdp->td_rdq, bp);
	return;

fatal:
	tu_fatal(tdp);
	return;

}	/*  End of tn_orddisconn()  */

/*
 * Send a message up to user
 */
void
tn_usrmsg(tp, error)

	register struct tcpcb *tp;
{
	register struct tcpd *tdp;
	register queue_t *q;

	if ((tdp = tp->t_tdp) == NULL || (q = tdp->td_rdq) == NULL
		|| (tdp->td_flags & TD_CLOSING))
		return;

	tdp->td_flags  |= TD_ERROR;

	/*
	 * tell user: expect user to close the stream
	 */
	(void) putctl1(q->q_next, M_ERROR, error);

	return;

}	/*  End of tn_usrmsg()  */
