/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)so_subr.c        1.1      12:32:43 - 89/06/19 "

#include "sys/types.h"
#include "sys/param.h"
#include "sys/stream.h"
#include "sys/inet.h"
#include "sys/inetioctl.h"
#include "sys/socket.h"
#include "sys/in.h"
#include "sys/stropts.h"
#include "sys/tihdr.h"
#include "sys/tiuser.h"
#include "sys/strlog.h"
#include "sys/debug.h"
#include "sys/errno.h"
#include "sys/somod.h"
mblk_t		*so_allocb();
void		so_ack();

mblk_t *
so_allocb(mp, size)
	mblk_t *mp;	
	unsigned size;
{
	mblk_t *bp;

	if (OKTOUSE(mp, size)) 
		bp = dupb(mp);
	else 
		bp = allocb(size, BPRI_MED);
	return bp;
}


/* 
 * so_ack - send up an M_IOCACK with ioc_rval 
 * holding errno (and t_errno if any) values.
 */
void
so_ack(q, error)
	queue_t * q;
{
	register struct so_socket *so;
	register mblk_t *bp;
	register struct iocblk *ip;

	ASSERT(q);

	so = (struct so_socket *)q->q_ptr;
	bp = so->so_iocsave;
	ip = (struct iocblk *)bp->b_rptr;

	MTYPE(bp) = M_IOCACK;
	ip->ioc_error = 0;

	if (error) {
		ip->ioc_rval = error;
		ip->ioc_count = 0;
	} else 
		ip->ioc_rval = 0;

	so->so_prim = 0;
	so->so_iocsave = NULL;
	so->so_flags &= ~WAITIOCACK;
	putnext(q, bp);
	return;
}

void
so_enq(head, p)
	register mblk_t **head, *p;
{
	register mblk_t *tmp;

	if (*head == NULL) {
		*head = p;
		return;
	}

	tmp = *head;
	while (tmp->b_next != NULL)
		tmp = tmp->b_next;

	tmp->b_next = p;
}


void
so_deq(head, p)
	register mblk_t **head, *p;
{
	register mblk_t *tmp;

	if (*head == p) {
		*head = p->b_next;
		freemsg(p);
		return;
	}

	tmp = *head;
	while(tmp->b_next && (tmp->b_next != p))
		tmp = tmp->b_next;

	if (tmp->b_next) {
		tmp->b_next = p->b_next;
		freemsg(p);
	}
}

int
so_qsize(head)
	register mblk_t *head;
{
	register mblk_t *bp;
	register count = 0;

	for (bp = head ; bp ; bp = bp->b_next)
		count++;
	
	return (count);
}

/*
 * so_sync_addr - synchronize the number of 
 * address message blocks on this read queue with 
 * data message blocks at the stream head read queue.
 * q is the somod read queue
 */
void
so_sync_addr(q)
	queue_t *q;
{
	register struct so_socket *so;
	register mblk_t *bp;
	register int i;

	ASSERT (q && q->q_ptr);
	so = (struct so_socket *)q->q_ptr;

#ifdef notdef
	STRlog(SOMOD_ID, SOCHAN(so), DPRI_LO, SL_TRACE, 
		"so_sync_addr: so_qs=%d strhd_qs=%d", 
		qsize(q), qsize(q->q_next));
#endif

	for (i = 0; i < qsize(q) - qsize(q->q_next); i++) {
		bp = getq(q);
		if (!bp) {
			STRlog(SOMOD_ID, SOCHAN(so), DPRI_LO, SL_TRACE, 
				"so_sync_addr: WARNING: getq returned NULL"); 
			break;
		}
		freemsg(bp);
	}
}
		
/*
 * so_clean - free all the message blocks 
 * on the link list pointed to by head
 */
void
so_clean(head)
	mblk_t **head;
{
	register mblk_t *bp, *tmp;

	bp = *head;
	while (bp) {
		tmp = bp->b_next;
		bp->b_next = NULL;
		freemsg(bp);
		bp = tmp;
	}
	*head = NULL;
}

/*
 * returns resonable errno based on t_errno
 * the lower module has not set the 
 * error_ack.UNIX_error properly.
 * q pointer may be used to look at so_socket.
 */
int
so_errset(q, t_err)
queue_t *q;
{
	int error;

	switch(t_err) {

	case TBADADDR:
		error = EADDRNOTAVAIL;
		break;

	case TBADOPT:
		error = EINVAL;
		break;

	case TACCES:
		error = EACCES;
		break;

	case TBADF:
		error = ENOTSOCK;
		break;

	case TNOADDR:
		error = EADDRNOTAVAIL;
		break;

	case TOUTSTATE:
		error = EINVAL;
		break;

	case TSYSERR:
		/* errno should have been set !!! leave it alone*/
		break;

	case TBADDATA:
		error = EINVAL;
		break;

	case TBUFOVFLW:
		error = EINVAL;
		break;

	case TFLOW:
		error = EWOULDBLOCK;
		break;

	case TNODATA:
		error = EWOULDBLOCK;
		break;

	case TNOTSUPPORT:
		error = EOPNOTSUPP;
		break;

	case TSTATECHNG:
		error = EINPROGRESS;
		break;
	default:
		error = EIO;	
	}

	return (error);
}
	
