/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)so_sockt2.c        1.1      12:32:36 - 89/06/19 "

#include "sys/types.h"
#include "sys/param.h"
#include "sys/stream.h"
#include "sys/inet.h"
#include "sys/inetioctl.h"
#include "sys/socket.h"
#include "sys/in.h"
#include "sys/stropts.h"
#include "sys/tihdr.h"
#include "sys/strlog.h"
#include "sys/debug.h"
#include "sys/errno.h"
#include "sys/somod.h"

extern mblk_t *so_allocb();

so_send(q, mp)
	queue_t *q;
	mblk_t *mp;
{
	register struct so_socket *so;
	register struct iocblk *ip;
	register mblk_t *bp;
	register struct S_snd_req *Sp;
	int cmd, flags;

	ASSERT(q && mp);
	so = (struct so_socket *)q->q_ptr;
	ip = (struct iocblk *)mp->b_rptr;
	cmd = ip->ioc_cmd;

	/*
	 * for "large" buffers check for sending all at once 
	 */
	if ((cmd == SIOC_SEND_L) || (cmd == SIOC_SEND_LF)) {
	    if (sosendallatonce(so))
			return (EMSGSIZE);
	}

	if ((so->so_state & SS_ISCONNECTED) == 0) {
		if (so->so_type == SOCK_STREAM)
			return (ENOTCONN);
		else
			return (EDESTADDRREQ);
	}

	if (so->so_state & SS_CANTSENDMORE) 
		return (EPIPE);

	if ((cmd == SIOC_SEND_S) || (cmd == SIOC_SEND_L)) {
		/*
		 * no flags.  (UDP/RAW accept M_DATA now)
		 */
		bp = dupmsg(mp->b_cont);
		if (!bp) {
			STRlog(SOMOD_ID, SOCHAN(so), DPRI_LO, SL_TRACE,
				"so_send: 1st dupmsg failed");
			return(ENOBUFS);
		}
		putnext(q, bp);
		return 0;
	}

	/*
	 * cmd is one of SIOC_SEND_SF or SIOC_SEND_LF
	 * flags is non_zero 
	 */
	Sp = (struct S_snd_req *)mp->b_cont->b_rptr;
	flags = Sp->flags;

	if (flags & MSG_OOB) {
		/* send down T_exdata_req */
		register struct T_exdata_req *Tp;
		register mblk_t *bp1;
	
		if (so->so_type != SOCK_STREAM)
			return (EOPNOTSUPP); 
	
		if ((bp = so_allocb(so->so_ctlbuf, sizeof(*Tp))) == NULL)
			return (ENOBUFS); 

		Tp = (struct T_exdata_req *)bp->b_wptr;
		Tp->PRIM_type = T_EXDATA_REQ;
		Tp->MORE_flag = 0;
		bp->b_wptr += sizeof(*Tp);
		MTYPE(bp) = M_PROTO;

		bp1 = dupmsg(mp->b_cont);
		if (!bp1) {
			STRlog(SOMOD_ID, SOCHAN(so), DPRI_LO, SL_TRACE,
				"so_send: 2nd dupmsg failed");
			return (ENOBUFS);
		}
		/*  set the bp->b_rptr to the begining of data */
		bp1->b_rptr += Sp->DATA_offset;

		bp->b_cont = bp1;
		putnext(q, bp);
		return 0;
	} else
		return (EINVAL);	/* for now only MSG_OOB */
}

so_sendto(q, mp)
	queue_t *q;
	mblk_t *mp;
{
	register struct so_socket *so;
	
	ASSERT(q && mp);
	so = (struct so_socket *)q->q_ptr;

	so->so_iocsave = mp;
	so->so_flags |= WAITIOCACK;

	if (!(so->so_state & SS_ISBOUND))
		return (so_bind(q, 0));

	return (so_sendingto(q, mp));
}

	
so_sendingto(q, mp)
	queue_t *q;
	mblk_t *mp;
{
	register struct so_socket *so;
	register struct iocblk *ip;
	register struct S_sndto_req *Sp;
	mblk_t *bp, *bp1;
	struct T_unitdata_req *Tp;
	unsigned size;
	
	ASSERT(q && mp);
	so = (struct so_socket *)q->q_ptr;
	ip = (struct iocblk *)mp->b_rptr;

	if (ip->ioc_cmd == SIOC_SENDTO) {
		/* to and tolen parameters were not given */
		if ((so->so_state & SS_ISCONNECTED) == 0) {
			if (so->so_type == SOCK_STREAM)
				return (ENOTCONN);
			else
				return (EDESTADDRREQ);
		}
		bp = dupmsg(mp->b_cont);    /* UDP/RAW now accept M_DATA */
		if (!bp) {
			STRlog(SOMOD_ID, SOCHAN(so), DPRI_LO, SL_TRACE,
				"so_sendingto: 1st dupmsg failed");
			return (ENOBUFS);
		}
		putnext(q, bp);
		so_ack(RD(q), 0);
		return 0;
	}

	/*
	 * SIOC_SENDTO2 
	 */
	if (ip->ioc_cmd != SIOC_SENDTO2 ||
	    *(int *)mp->b_cont->b_rptr != SIOC_SENDTO2) 
			return (EINVAL);

	Sp = (struct S_sndto_req *)mp->b_cont->b_rptr;

	/* no support for flags */
	if (Sp->flags)
		return (EINVAL);
	
	if (Sp->DEST_length) {
		if (so->so_state & SS_ISCONNECTED)
			return (EISCONN);
	} else if ((so->so_state & SS_ISCONNECTED) == 0) {
		if (so->so_type == SOCK_STREAM)
			return (ENOTCONN);
		else
			return (EDESTADDRREQ);
	}

	size = sizeof(struct T_unitdata_req) + Sp->DEST_length;
	if ((bp = allocb(size, BPRI_LO)) == NULL) {
		STRlog(SOMOD_ID, SOCHAN(so), DPRI_LO, SL_TRACE,
			"so_sendingto: allocb failed");
		return (ENOBUFS);
	}
	Tp = (struct T_unitdata_req *)bp->b_wptr;
	Tp->PRIM_type = T_UNITDATA_REQ;
	Tp->DEST_length = Sp->DEST_length;
	Tp->DEST_offset = sizeof(struct T_unitdata_req);
	bcopy((caddr_t)Sp + Sp->DEST_offset,
	      (caddr_t)Tp + Tp->DEST_offset, Sp->DEST_length);	
	Tp->OPT_length = 0;
	bp->b_wptr += size;
	MTYPE(bp) = M_PROTO;

	bp1 = dupmsg(mp->b_cont);
	if (!bp1) {
		STRlog(SOMOD_ID, SOCHAN(so), DPRI_LO, SL_TRACE,
			"so_sendingto: 2nd dupmsg failed");
		freeb(bp);
		return (ENOBUFS);
	}
	/* Set the rptr to the begining of data */
	bp1->b_rptr += Sp->DATA_offset;
	bp->b_cont = bp1;
	putnext(q, bp);
	so_ack(RD(q), 0);
	return 0;
}


so_recvfrom(q, mp)
	queue_t *q;
	mblk_t *mp;
{
	register struct so_socket *so;
	
	ASSERT(q && mp);
	so = (struct so_socket *)q->q_ptr;

	if ((so->so_state & SS_NBIO) && qsize(RD(q)->q_next) == 0) 
		return (EWOULDBLOCK);

	so->so_iocsave = mp;
	so->so_flags |= WAITIOCACK;

	return (so_recvit(RD(q), mp));
}

/*
 * Returns the source address of the incoming 
 * packet in m. q is the read queue.
 */
		
so_recvit(q, mp)
	queue_t *q;
	mblk_t *mp;
{
	register struct so_socket *so;
	register struct iocblk *ip;
	register struct T_unitdata_ind *Tp;

	ASSERT(q && mp);
	so = (struct so_socket *)q->q_ptr;
	ip = (struct iocblk *)mp->b_rptr;
	
	if (qsize(q->q_next) == 0)
		return 0;

	if (so->so_state & SS_CANTRCVMORE) {
		ip->ioc_count = 0;
		so_ack(q, 0);
		return 0;
	}

	/*
	 * return the source address in the ack
	 */
	so_sync_addr(q);
	Tp = (struct T_unitdata_ind *)q->q_first->b_rptr;
	if (Tp->SRC_length > ip->ioc_count) 
		return (EFAULT);

	bcopy((char *)Tp + Tp->SRC_offset, 
	      mp->b_cont->b_rptr, Tp->SRC_length);
	if (Tp->SRC_length < ip->ioc_count)
		mp->b_cont->b_wptr = mp->b_cont->b_rptr + Tp->SRC_length;
	ip->ioc_count = Tp->SRC_length;	
	so_ack(q, 0);
	return 0;
}

/*
 * so_oob - handles SIOC_ATMARK and SIOC_PEEKOOB ioctls
 */
so_oob(q, mp)
	queue_t *q;
	mblk_t *mp;
{
	register struct so_socket *so;
	register struct iocblk *ip;
	register mblk_t *bp;
	int cmd;

	ASSERT(q && q->q_ptr && mp);
	ip = (struct iocblk *)mp->b_rptr;
	cmd = ip->ioc_cmd;

	if (cmd != SIOC_ATMARK && cmd != SIOC_PEEKOOB) 
		return (EINVAL);

	if (mp->b_cont == NULL) 
		return (EINVAL);

	if (cmd == SIOC_ATMARK) {
		if (ip->ioc_count < sizeof(int)) 
			return (EINVAL);
		*(int *)mp->b_cont->b_rptr = 
			(so->so_state & SS_RCVATMARK) ? 1 : 0;
		mp->b_cont->b_wptr = mp->b_cont->b_rptr + sizeof(int);
		ip->ioc_count = sizeof(int);
/* LABEL(oob1) */
		return 0;
	}

	/* peek at oob data - SIOC_PEEKOOB cmd */
	if (ip->ioc_count < 1) 
		return (EINVAL);
	so = (struct so_socket *)q->q_ptr;
	if (so->so_type != SOCK_STREAM)
		return (EOPNOTSUPP);
	
	if ((so->so_flags & OOB) == 0)
		return (EINVAL);

	if ((so->so_state & SS_RCVATMARK) == 0)
		return (EWOULDBLOCK);

	*mp->b_cont->b_rptr = *so->so_oob->b_rptr;
	mp->b_cont->b_wptr = mp->b_cont->b_rptr + 1;
	ip->ioc_count = 1;
	return 0;
}
	   

/*
 * Read out-of-band data, q is the read queue
 */
so_readoob(q, mp)
	queue_t *q;
	mblk_t *mp;
{
	register struct so_socket *so;
	register struct iocblk *ip;
	register mblk_t *bp;

	ASSERT(q && mp);
	so = (struct so_socket *)q->q_ptr;
	ip = (struct iocblk *)mp->b_rptr;

	if (so->so_type != SOCK_STREAM)
		return (EOPNOTSUPP);
	
	if ((so->so_flags & OOB) == 0)
		return (EINVAL);

	if ((so->so_state & SS_RCVATMARK) == 0)
		return (EWOULDBLOCK);

	if (mp->b_cont == NULL)
		return 0;	/* no user buffer to recv data*/
	
	/*
	 * pass up the urgent data byte
	 * and unblock upward data flow
	 */
	/* change this to an ASSERT later */
	if (BLEN(so->so_oob) != 1)
		printf("so_readoob: length of the 1st msg on q is %d\n", 
			BLEN(bp->b_cont));

	*mp->b_cont->b_rptr = *so->so_oob->b_rptr;
	mp->b_cont->b_wptr = mp->b_cont->b_rptr + 1;
	ip->ioc_count = 1;
	freemsg(so->so_oob);
	so->so_oob = NULL;
	so->so_flags &= ~OOB;
	so->so_state &= ~SS_RCVATMARK;
	STRlog(SOMOD_ID, SOCHAN(so), DPRI_LO, SL_TRACE,
	"so_read_oob: send up the urgent byte %c", *mp->b_cont->b_rptr);
	return 0;
}
