/*
 * @(#) Copyright 1989, The Wollongong Group, All rights reserved
 */

#ident "@(#)slip.c ()      1.4      05:20:24 - 89/09/18"

#include <sys/types.h>
#include <sys/param.h>
#include <sys/errno.h>
#ifdef u3b2
#include <sys/psw.h>
#include <sys/pcb.h>
#endif
#include <sys/signal.h>
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/strlog.h>
#include <sys/log.h>
#ifndef	XENIX
#include <sys/fs/s5dir.h>
#else
#include <sys/dir.h>
#endif
#include <sys/user.h>
#include <sys/debug.h>
#include <sys/lihdr.h>
#include <sys/sysmacros.h>

#define	SLIP_ID	0x2569		/* random */

#ifndef DPRI_LO
#define DPRI_LO 40
#endif

#ifndef DL_PTOP
#define DL_PTOP 8
#endif

#ifndef MTYPE
#define MTYPE(bp)	(bp)->b_datap->db_type
#endif

#ifndef REUSABLE
#define	REUSEABLE(BP, SIZE) \
 (((BP->b_datap->db_ref == 1) && \
 (BP->b_datap->db_lim - BP->b_datap->db_base >= SIZE)) ? \
 freemsg(BP->b_cont), BP->b_cont = NULL,	/* XXX */ \
 BP->b_rptr = BP->b_wptr = BP->b_datap->db_base, 1 : 0)
#endif

struct slip_slip {
	queue_t *sl_rdq;
	queue_t *sl_cordq;
};

extern int slip_cnt;
extern struct slip_slip slip_slip[];

int	slipopen();
int	slipclose();
int	slipput();

static struct module_info slip_info = {
	SLIP_ID, "slip", 0, 1024, 1024, 256
};

static struct qinit sliprinit = {
	NULL, NULL, slipopen, slipclose, NULL, &slip_info, NULL 
};

static struct qinit slipwinit = {
	slipput, NULL, NULL, NULL, NULL, &slip_info, NULL 
};

struct streamtab slipinfo = {
	&sliprinit, &slipwinit, NULL, NULL
};

slipopen(q, dev, flag,sflag)
	register queue_t *q;
	dev_t	dev;
{
	register struct slip_slip *slp;

	STRLOG(SLIP_ID, 0, DPRI_LO, SL_TRACE, "slipopen()");
	dev = minor(dev);

	if (sflag == CLONEOPEN) {
		strlog(SLIP_ID, 0, DPRI_LO, SL_TRACE,
			"slipopen: clone open not allowed");
		return OPENFAIL;

	} else if (slp = (struct slip_slip *)q->q_ptr) {
		strlog(SLIP_ID, 0, DPRI_LO, SL_TRACE, "slipopen: already open");
		return dev;

	} else { 	
		if (dev < 0 || dev >= slip_cnt) {
		strlog(SLIP_ID, 0, DPRI_LO, SL_TRACE,
			"slipopen: dev <0x%x> already open", dev);
			u.u_error = ENODEV;
			return OPENFAIL;
		}
	}

	slp = &slip_slip[dev];

	if ( dev % 2 ) {	/* is it user process open ? */
		if ( ! (slp->sl_cordq = slip_slip[dev - 1].sl_rdq) ) {
			strlog(SLIP_ID, 0, DPRI_LO, SL_TRACE,
			"slipopen: must open even # device first");
			return OPENFAIL;
		}
		slip_slip[dev - 1].sl_cordq = q;
	} else {
	
		slp->sl_cordq = NULL;
	}

	slp->sl_rdq = q;
	q->q_ptr = WR(q)->q_ptr = (caddr_t)slp;

	STRLOG(SLIP_ID, 0, DPRI_LO, SL_TRACE, "slipopen: OK");
	return dev;

}

int
slipclose(q)
	register queue_t          *q;
{
	register struct slip_slip *slp;
	register struct slip_slip *coslp;
	register queue_t          *cordq;

	ASSERT(q && q->q_ptr);

	STRLOG(SLIP_ID, 0, DPRI_LO, SL_TRACE, "slipclose: entered");
	slp = (struct slip_slip *)q->q_ptr;
	cordq = slp->sl_cordq;
	q->q_ptr = WR(q)->q_ptr = NULL;
	slp->sl_rdq = slp->sl_cordq = NULL;
	
	if (cordq) {
		coslp = (struct slip_slip *)cordq->q_ptr;
		if (coslp)
			coslp->sl_cordq = NULL;
	}
	
	flushq(q, FLUSHALL);
	flushq(WR(q), FLUSHALL);
}


static struct DL_info_ack SL_info_ack =
{
	DL_INFO_ACK,		/* type */
	1006,			/* max lsdu size */
	0,			/* min lsdu size */
	0,			/* LSAP address length */
	DL_PTOP,		/* point to point */
	DL_NOSERV,		/* no service class */
	DL_IDLE,		/* default state */
	0,0,			/* GROWTH fields */
};	

int
slipput(q, bp)
	register queue_t *q;
	register mblk_t *bp;
{
	register struct slip_slip *slp;
	register union DL_primitives *p;

	ASSERT(q && q->q_ptr && bp);
	slp = (struct slip_slip *)q->q_ptr;
	ASSERT(slp->sl_rdq);

	switch(MTYPE(bp)) {

	case M_DATA:
PutData:
		STRLOG(SLIP_ID, 0, DPRI_LO, SL_TRACE, "slipput: M_DATA");
		if (slp->sl_cordq) {

			putnext(slp->sl_cordq, bp);

		} else {
			strlog(SLIP_ID, 0, DPRI_LO, SL_TRACE,
				"slipput: no cordq");
			freemsg(bp);
		}
		break;

	case M_IOCTL:

		/* no ioctl for us sir. */
		strlog(SLIP_ID, 0, DPRI_LO, SL_TRACE, "slipput: M_IOCTL");
		bp->b_datap->db_type = M_IOCNAK;
		qreply(q, bp);
		break;

 	case M_FLUSH:

		/* No buffer so no flush.  */
		strlog(SLIP_ID, 0, DPRI_LO, SL_TRACE, "slipopen: M_FLUSH");
		freemsg(bp);
		break;

	case M_PROTO:
	case M_PCPROTO:
		p = (union DL_primitives *)bp->b_rptr;

		switch (p->prim_type) {

		case DL_INFO_REQ:
		{
			struct DL_info_ack *Ip;

			if (!REUSEABLE(bp, sizeof(struct DL_info_ack))) {
				freemsg(bp);
				if (!(bp = allocb(sizeof(struct DL_info_ack),
					 BPRI_MED))) {
					return;
				}
			}

			bp->b_datap->db_type = M_PCPROTO;
			Ip = (struct DL_info_ack *)bp->b_rptr;
			*Ip = SL_info_ack;
			bp->b_wptr = bp->b_rptr + sizeof(struct DL_info_ack);
			putnext(slp->sl_rdq, bp);
			return;
		}

		case DL_BIND_REQ:
		{
			struct DL_bind_ack *ackp;
			ulong sap;

			sap = p->bind_req.LLC_sap;

			if (!REUSEABLE(bp, sizeof(*ackp))) {
				freemsg(bp);
				if (!(bp = allocb(sizeof(*ackp), BPRI_MED))) {
					return;
				}
			}

			bp->b_datap->db_type = M_PCPROTO;
			ackp = (struct DL_bind_ack *)bp->b_rptr;
			ackp->PRIM_type = DL_BIND_ACK;
			ackp->ADDR_length = 0;
			ackp->ADDR_offset = sizeof(*ackp);
			ackp->LLC_sap = sap;	/* Just for kicks */
			bp->b_wptr = bp->b_rptr + sizeof(*ackp);
			putnext(slp->sl_rdq, bp);
			return ;
		}

		case DL_UNBIND_REQ:
	
			/* unbind o.k., return DL_ok_ack */

			if (!REUSEABLE(bp, sizeof(struct DL_ok_ack))) {
				freemsg(bp);
				if (!(bp = allocb(sizeof(struct DL_ok_ack),
					BPRI_MED))) {
					return ;
				}
			}

			p = (union DL_primitives *)bp->b_rptr;
			bp->b_datap->db_type = M_PCPROTO;
			p->ok_ack.PRIM_type = DL_OK_ACK;;
			p->ok_ack.CORRECT_prim = DL_UNBIND_REQ;
			bp->b_wptr = bp->b_rptr + sizeof(struct DL_ok_ack);

			if(!slp->sl_rdq)
				return;
			putnext(slp->sl_rdq, bp);
			return;

		case DL_UNITDATA_REQ: 
		{
			struct DL_unitdata_ind *up;

			up = (struct DL_unitdata_ind *)bp->b_rptr;
			up->PRIM_type = DL_UNITDATA_IND;
			bp->b_wptr = bp->b_rptr + sizeof(*up);
			goto PutData;
		}

		default:
			strlog(SLIP_ID, 0, DPRI_LO, SL_TRACE,
			"slipput: unknown PROTO msg 0x%x", p->prim_type);
			freemsg(bp);
			break;
		}

	case M_CTL:
		strlog(SLIP_ID, 0, DPRI_LO, SL_TRACE, "slipput: M_CTL");
		freemsg(bp);
		break;
		
	default:
		strlog(SLIP_ID, 0, DPRI_LO, SL_TRACE,
			"slipput: unknown bp type 0x%x", MTYPE(bp));
		freemsg(bp);
		break;
	}
	return;
}

