/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)ip_subr.c (TWG)  1.2     89/07/10 "

#include "sys/param.h"
#include "sys/types.h"
#ifndef XENIX
#include "sys/inline.h"
#endif
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/debug.h"
#ifdef XENIX
#include "sys/assert.h"
#endif
#include "sys/strlog.h"
#include "sys/lihdr.h"

#include "sys/inet.h"
#include "sys/socket.h"
#include "sys/if.h"
#include "sys/in.h"
#include "sys/in_var.h"
#include "sys/ip.h"
#include "sys/ip_var.h"

#if !(vax || i386)
#define ALIGNMENT
#endif /* vax */

#ifndef DL_X25
#define DL_X25	9
#endif

/***********************
 *  Table of Contents  *
 **********************/

void		headflush();
int		dl_bind();
int		dl_unbind();
int		dl_inforeq();
int		ipdl_send();
void		ip_setname();
struct ifnet   *ip_getif();
struct ifnet   *ip_findemd();
int		Strlen();
int		Strncmp();
/* void		bzero();	*/

/***** End of TOC *****/


/*
 * stream head receives a M_FLUSH, q is the read q
 */

void
headflush(q, bp)

	queue_t *q;
	register mblk_t *bp;
{
	ASSERT(q && bp && MTYPE(bp) == M_FLUSH);

	if (*bp->b_rptr & FLUSHR)
		flushq(q, FLUSHALL);

	if (*bp->b_rptr & FLUSHW) {
		flushq(OTHERQ(q), FLUSHDATA);
		*bp->b_rptr &= ~FLUSHR;
		qreply(q, bp);
	} else
		freemsg(bp);

}	/*  End of headflush()  */

/*
 * LLC interface routine
 */
/*
 * bind a lsap # to the 802.2, 'q' is write q
 * return 0 if o.k., -1 if failure
 */

int
dl_bind(q, sap)

	queue_t *q;
	long sap;
{
	register mblk_t *bp;
	register struct DL_bind_req *dp;

	if ((bp = allocb(sizeof(*dp), BPRI_MED)) == NULL)
		return(-1);

	MTYPE(bp) = M_PROTO;
	dp = (struct DL_bind_req *)bp->b_wptr;
	dp->PRIM_type = DL_BIND_REQ;
	dp->LLC_sap = sap;
	bp->b_wptr += sizeof(*dp);
	putnext(q, bp);
	return(0);

}	/*  End of dl_bind()  */

/*
 * unbind a lsap # to the 802.2, 'q' is write q
 * return 0 if o.k., -1 if failure
 */

int
dl_unbind(q)

	queue_t *q;
{
	register mblk_t *bp;
	register struct DL_unbind_req *dp;

	if ((bp = allocb(sizeof(*dp), BPRI_MED)) == NULL)
		return(-1);

	MTYPE(bp) = M_PROTO;
	dp = (struct DL_unbind_req *)bp->b_wptr;
	dp->PRIM_type = DL_UNBIND_REQ;
	bp->b_wptr += sizeof(*dp);
	putnext(q, bp);
	return(0);

}	/*  End of dl_unbind()  */

/*
 * send info_req to 802.2, 'q' is write q
 * return 0 if o.k., -1 if failure
 */

int
dl_inforeq(q)

	queue_t *q;
{
	register mblk_t *bp;
	register struct DL_info_req *dp;

	if ((bp = allocb(sizeof(*dp), BPRI_MED)) == NULL)
		return(-1);

	MTYPE(bp) = M_PCPROTO;
	dp = (struct DL_info_req *)bp->b_wptr;
	dp->PRIM_type = DL_INFO_REQ;
	bp->b_wptr += sizeof(*dp);
LABEL(dlinfo);
	putnext(q, bp);
	return(0);

}	/*  End of dl_inforeq()  */

/*
 * send unitdata to the 802.2 or ethernet, 'q' is write q
 * sap is my lsap #, ipaddr is the remote address (4 octets)
 * 'data' is the real user data
 * return 0 if o.k., -1 if failure
 */
ipdl_send(q, type, ipaddr, data, ifflags)
	register queue_t *q;
	unchar type;		/* subnet type */
	ulong ipaddr;
	mblk_t *data;
	int ifflags;
{
	register struct llc_ip *ap;
	register struct DL_unitdata_req *dp;
	register mblk_t *bp;

	ASSERT(q && data);

	/* If can't put, just return error.  ipsend will record it */
	if (!canput(q->q_next))
		return (-1);

	/* Need to allocate a LLI header */
	if ((bp = allocb(LC_REQSIZE, BPRI_MED)) == NULL)
		return (-1);
	ASSERT(data != bp);
	bp->b_datap->db_type = M_PROTO;
	dp = (struct DL_unitdata_req *)bp->b_rptr;
	dp->PRIM_type = DL_UNITDATA_REQ;
	dp->RA_offset = DL_UNITDATA_REQ_SIZE;
	dp->SERV_class = DL_NOSERV;

	switch(type) {

	case DL_CSMACD:
	case DL_ETHER:
	{
		ap = (struct llc_ip *)((char *)dp + dp->RA_offset);
		ap->l_addr = ipaddr;
		ap->l_type = type;
		ap->l_flag = ifflags;
		dp->RA_length = (type == DL_ETHER) ? EMDSAP_SIZE : LSAP_SIZE;
		break;
	}

	case DL_X25:
	case DL_IPX25:
	{
		ap = (struct llc_ip *)((char *)dp + dp->RA_offset);
		ap->l_addr = ipaddr;
		dp->RA_length = sizeof(long);
		break;
	}

	case DL_PTOP:
		dp->RA_length = 0;
		break;

	default:
		STRlog(-1, -1, DPRI_LO, SL_te,
		  "ipdl_send: unsupport type %x", type, 0);
		freeb(bp);
		return (-1);
	}

	/* add data buffers to LLI header and send it down */
	bp->b_wptr += LC_REQSIZE;
	bp->b_cont = data;
	putnext(q, bp);
	return (0);
}

/*
 * Set the name in the bottom structure.
 */
void
ip_setname(ifp, name)
	struct ifnet *ifp;
	register char *name;
{
	register char *cp1;
	register int namelen;

	for (namelen = 0, cp1 = ifp->if_name;
		*name && (namelen < IFNAMESIZ-1) ; namelen++)
		*cp1++ = *name++;
	*cp1 = 0;
}

/*
 * Given a name return the ifnet structure
 */
struct ifnet *
ip_getif(name)
	register char *name;
{
	register struct ifnet *ifp = ipbnext;

	for (; ifp ; ifp = ifp->if_next)
		if (!Strncmp(name, ifp->if_name, IFNAMESIZ))
			break;
	return (ifp);
}

/*
 * Find the companion device for the ARP device.
 */
struct ifnet *
ip_findemd(ifp)
	register struct ifnet *ifp;
{
	register struct ifnet *p;
	register int namelen;

	namelen = Strlen(ifp->if_name);
	for (p = ipbnext; p; p = p->if_next) {
		if (p == ifp)
			continue;
		if (bcmp(ifp->if_name, p->if_name, namelen - 1) == 0)
			break;
	}
	return (p);
}

int
Strlen(cp)
	register char *cp;
{
	register int i;

	for (i = 0; *cp ; i++)
		cp++;
	return i;

}	/*  End of Strlen()  */

/*
 * Compare strings (at most n bytes): return *s1-*s2 for the last
 * characters in s1 and s2 which were compared.
 */

int
Strncmp(s1, s2, n)

	register char *s1, *s2;
	register n;
{
	if (s1 == s2)
		return(0);
	while (--n >= 0 && *s1 == *s2++)
		if (*s1++ == '\0')
			return(0);
	return((n < 0)? 0: *s1 - *--s2);

}	/*  End of Strncmp()  */

/*
 * Overlapping bcopy (HACK for now!)
 */
ovbcopy(d, s, len)
{
	return bcopy(d, s, len);
}

/*
 * Trim bytes from message
 *  len > 0, trim from head
 *  len < 0, trim from tail
 * Returns 1 on success, 0 on failure
 */
int
ipadjmsg(mp, len)
mblk_t *mp;
register int len;
{
	register mblk_t *bp;
	register n;
	int fromhead;

	ASSERT(mp != NULL);

	fromhead = 1;
	if (len < 0) {
		fromhead = 0;
		len = -len;
	}
	if (xmsgsize(mp) < len)
		return(0);

	if (fromhead) {
		bp = mp;
		while (len) {
			ASSERT(bp->b_wptr >= bp->b_rptr);
			n = min(bp->b_wptr - bp->b_rptr, len);
			bp->b_rptr += n;
			len -= n;
			bp = bp->b_cont;
		}
	} else {
		register mblk_t *save_bp;
		register unsigned char type;

		type = mp->b_datap->db_type;
		while (len) {
			bp = mp;
			while (bp && bp->b_datap->db_type == type) {
				ASSERT(bp->b_wptr >= bp->b_rptr);
				if (bp->b_wptr - bp->b_rptr > 0)
					save_bp = bp;
				bp = bp->b_cont;
			}
			if (!save_bp)
				break;
			n = min(save_bp->b_wptr - save_bp->b_rptr, len);
			save_bp->b_wptr -= n;
			len -= n;
		}
	}
	return(1);
}

#ifdef u3b2
/*
 * use own version of bzero since bzero cannot be called at interrupt
 * level on the paging versions of 3B's due to a bug in bzero.
 */

void
bzero(s, len)

	register caddr_t s;
	register int len;
{
	register int *i;

	/* do character at a time till we are aligned to a word boundary */
	while(((int)s & 0x3) && (len-- > 0))
		*s++ = 0;
	/* now we are word aligned; do word at a time */
	i = (int *)s;
	while(len >= 4) {
		*i++ = 0;
		len -= 4;
	}
	/* do remaining bytes (at most 3) character at a time */
	s = (caddr_t)i;
	while(len-- > 0)
		*s++ = 0;

}	/*  End of bzero()  */
#endif /* u3b2 */
