/*
 * @(#) Copyright 1989.  The Wollongong Group, Inc.  All Rights Reserved.
 */

#ident "@(#)if.c (TWG)  1.4     89/07/31 "

#include "sys/param.h"
#include "sys/types.h"
#ifndef XENIX
#include "sys/inline.h"
#endif
#include "sys/stream.h"
#include "sys/debug.h"
#include "sys/strlog.h"

#include "sys/inet.h"
#include "sys/socket.h"
#include "sys/if.h"
#include "sys/in.h"
#include "sys/in_var.h"
#include "sys/ip.h"
#include "sys/ip_var.h"
#include "sys/inetioctl.h"
#include "sys/route.h"
#include "sys/errno.h"

#ifdef NCR
#include "sys/ndir.h"
#include "sys/signal.h"
#include "sys/user.h"
#endif /* NCR */

#define satosin(sa)	((struct sockaddr_in *)(sa))
extern struct in_ifaddr *ifptoia();

/*
 * Initialize an interface's routing
 * table entry according to the network.
 * INTERNET SPECIFIC.
 */
if_rtinit(ifp, flags)
	register struct ifnet *ifp;
	int flags;
{
	struct in_ifaddr *ia;

	/*
	 * Assume that interface has only one 
	 * (internet) address associated with it. 
	 */
	if (ifp->if_flags & IFF_ROUTE)
		return;
	ia = ifptoia(ifp);

	ip_rtinit(&ia->ia_broadaddr, &ia->ia_addr, (int)IPIOC_ADDROUTE,
		flags, RTR_OTHER, 0); 
}

/*
 * Locate an interface based on a complete address.
 */
static char zeroaddr[14];

/*ARGSUSED*/
struct ifaddr *
ifa_ifwithaddr(addr)
	struct sockaddr *addr;
{
	register struct ifnet *ifp;
	register struct ifaddr *ifa;

#define	equal(a1, a2) \
	(bcmp((caddr_t)((a1)->sa_data), (caddr_t)((a2)->sa_data), 14) == 0)

	if (bcmp(zeroaddr, (caddr_t)addr->sa_data, 14) == 0)
		return ((struct ifaddr *)0);

	for (ifp = ipbnext; ifp; ifp = ifp->if_next)
	    for (ifa = ifp->if_addrlist; ifa; ifa = ifa->ifa_next) {
		if (ifa->ifa_addr.sa_family != addr->sa_family)
			continue;
		if (equal(&ifa->ifa_addr, addr))
			return (ifa);
		if ((ifp->if_flags & IFF_BROADCAST) &&
		    equal(&ifa->ifa_broadaddr, addr))
			return (ifa);
	    }

	return ((struct ifaddr *)0);
}


/*
 * Locate the point to point interface with a given destination address.
 */
/*ARGSUSED*/
struct ifaddr *
ifa_ifwithdstaddr(addr)
	struct sockaddr *addr;
{
	register struct ifnet *ifp;
	register struct ifaddr *ifa;

	for (ifp = ipbnext; ifp; ifp = ifp->if_next)
	    if (ifp->if_flags & IFF_POINTOPOINT)
		for (ifa = ifp->if_addrlist; ifa; ifa = ifa->ifa_next) {
			if (ifa->ifa_addr.sa_family != addr->sa_family)
				continue;
			if (equal(&ifa->ifa_dstaddr, addr))
				return (ifa);
	}
	return ((struct ifaddr *)0);
}

/*
 * Find an interface on a specific network.  If many, choice
 * is first found.
 */
struct ifaddr *
ifa_ifwithnet(addr)
	register struct sockaddr *addr;
{
	register struct ifnet *ifp;
	register struct ifaddr *ifa;
	register u_int af = addr->sa_family;
	register int (*netmatch)();
	extern int inet_netmatch();

	if (af >= AF_MAX)
		return (0);

	/* internet only for now */
	netmatch = inet_netmatch;

	for (ifp = ipbnext; ifp; ifp = ifp->if_next) {
	    if (ifp->if_flags & IFF_POINTOPOINT) 
		continue;
	    for (ifa = ifp->if_addrlist; ifa; ifa = ifa->ifa_next) {
		if (ifa->ifa_addr.sa_family != addr->sa_family)
			continue;
		if ((*netmatch)(&ifa->ifa_addr, addr))
			return (ifa);
	    }
	}
	return ((struct ifaddr *)0);
}


/*
 * Return interface configuration
 * of system.  List may be used
 * in later ioctl's (above) to get
 * other information.
 */
/*ARGSUSED*/
int
ifconf(bp)
	register mblk_t *bp;
{
	register struct ifnet *ifp = ipbnext;
	register struct ifaddr *ifa;
	struct ifreq ifr;
	int space;
	register mblk_t *bp1;
	register struct iocblk *ip;
	struct ifconf *ifc;

	ip = (struct iocblk *)bp->b_rptr;

	for (bp1 = bp->b_cont; bp1 ; bp1 = bp1->b_cont) 
		bp1->b_wptr = bp1->b_rptr;

	bp1 = bp->b_cont;
	bp1->b_wptr = bp1->b_rptr + sizeof(int);
	space = ip->ioc_count - sizeof(int);
	 
	for (; space > sizeof (ifr) && ifp; ifp = ifp->if_next) {
		bzero(ifr.ifr_name, sizeof (ifr.ifr_name));
		bcopy(ifp->if_name, ifr.ifr_name, sizeof (ifr.ifr_name) - 2);

		if ((ifa = ifp->if_addrlist) == 0) {
			bzero((caddr_t)&ifr.ifr_addr, sizeof(ifr.ifr_addr));
			if (fill_iocmsg(bp, (caddr_t)&ifr, sizeof(ifr)) < 0)
				return -1;
			space -= sizeof (ifr);
		} else {
		    for ( ; space > sizeof (ifr) && ifa; ifa = ifa->ifa_next) {
			ifr.ifr_addr = ifa->ifa_addr;
			if (fill_iocmsg(bp, (caddr_t)&ifr, sizeof(ifr)) < 0)
				return -1;
			space -= sizeof (ifr);
		    }
		}
	}
	ip->ioc_count -= space;
	ifc = (struct ifconf *)bp->b_cont->b_rptr;
	ifc->ifc_len = ip->ioc_count - sizeof(int);
	return 0;
}

int 
fill_iocmsg(bp, cp, len)
mblk_t *bp;
caddr_t cp;
int len;
{
	mblk_t *mp = bp->b_cont;
	register struct iocblk *ip;
	int n;
#define DSIZE(mp)	((mp)->b_datap->db_lim - (mp)->b_datap->db_base)

	ip = (struct iocblk *)bp->b_rptr;

	/* scan the full msg blocks */
	while (mp && ((mp->b_wptr - mp->b_rptr) >= DSIZE(mp)))
		mp = bp->b_cont;
	if (!mp) {
		ip->ioc_error = EFAULT;
		return -1;
	}
	
	/* now copy the data into msg blocks */
	while (mp && len) {
		n = min(len, ((mp->b_rptr + DSIZE(mp)) - mp->b_wptr));
		bcopy(cp, mp->b_wptr, n);
		mp->b_wptr += n;
		mp = mp->b_cont;
		len -= n;
		cp += n;
	}
	if (len != 0) {
		ip->ioc_error = EFAULT;
		return -1;
	}
	return 0;
}

#ifdef notdef
/*
 * Find an interface using a specific address family
 */
struct ifaddr *
ifa_ifwithaf(af)
	register int af;
{
	register struct ifnet *ipbnext;
	register struct ifaddr *ifa;

	for (ifp = ifnet; ifp; ifp = ifp->if_next)
	    for (ifa = ifp->if_addrlist; ifa; ifa = ifa->ifa_next)
		if (ifa->ifa_addr.sa_family == af)
			return (ifa);
	return ((struct ifaddr *)0);
}

/*
 * Mark an interface down and notify protocols of
 * the transition.
 * NOTE: must be called at splnet or eqivalent.
 */
if_down(ifp)
	register struct ipb *ifp;
{
	register struct ifaddr *ifa;

	ifp->if_flags &= ~IFF_UP;
/*
	for (ifa = ifp->if_addrlist; ifa; ifa = ifa->ifa_next)
		pfctlinput(PRC_IFDOWN, &ifa->ifa_addr);
*/

}

/*
 * Map interface name to
 * interface structure pointer.
 */
struct ifnet *
ifunit(name)
	register char *name;
{
	register char *cp;
	register struct ifnet *ifp;
	int unit;

	for (cp = name; cp < name + IFNAMSIZ && *cp; cp++)
		if (*cp >= '0' && *cp <= '9')
			break;
	if (*cp == '\0' || cp == name + IFNAMSIZ)
		return ((struct ifnet *)0);
	unit = *cp - '0';
	for (ifp = ipbnext; ifp; ifp = ifp->if_next) {
		if (bcmp(ifp->if_name, name, (unsigned)(cp - name)))
			continue;
		if (unit == ifp->if_unit)
			break;
	}
	return (ifp);
}
#endif
