#ident "@(#)inet_net.c        1.4      12:49:51 - 89/06/14 "

/*
 * @(#) Copyright 1987.  The Wollongong Group, Inc.  All Rights Reserved.
 */

/* Fix log
 *
 *	TWU	06/20/91	Add include file <sys/stream.h>
 */

#include <sys/types.h>
#include <sys/inet.h>
#include <sys/socket.h>
#include <sys/stream.h>
#include <sys/if.h>
#include <sys/in.h>
#include <sys/in_var.h>

#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <netdb.h>

#define C(x)	((x) & 0xff)

main(argc, argv)
    char *argv[];
{
    unsigned int netaddr, ipaddr, subnet;

    /* Usage */
    if (argc < 2)
	exit(-1);

    /* Convert two addresses */
    if ((ipaddr = inet_addr(argv[1])) == 0xffffffff)
	exit(-2);
    ipaddr = ntohl(ipaddr);
    if (argc > 2)
    {
	if (argv[2][0] == 'f')
	{
	    if (sscanf(argv[2], "%x", &subnet) < 0)
	    {
		fprintf(stderr, "bad subnet mask %s\n", argv[2]);
		exit(-3);
	    }
	}
	else
	{
	    if ((subnet = inet_addr(argv[2])) == 0xffffffff)
	    {
		fprintf(stderr, "bad subnet mask %s\n", argv[2]);
		exit(-3);
	    }
	    subnet = ntohl(subnet);
	}
    }
    else
    {
	/* Generate default subnet mask */
	switch ((ipaddr >> 30) & 3)
	{
	    case 0:
	    case 1:
		subnet = 0xFF000000;
		break;
	    case 2:
		subnet = 0xFFFF0000;
		break;
	    case 3:
		subnet = 0xFFFFFF00;
		break;
	    default:
		exit(-4);
	}

	/* Generate subnet mask string */
	if (strcmp(argv[0], "inet_mask") == 0)
	{
	    printf("%u.%u.%u.%u\n", C(subnet >> 24), C(subnet >> 16),
		C(subnet >> 8), C(subnet));
	    exit(0);
	}

	/* Generate address format confirm */
	if (strcmp(argv[0], "inet_addr") == 0)
	{
	    printf("%u.%u.%u.%u\n", C(ipaddr >> 24), C(ipaddr >> 16),
		C(ipaddr >> 8), C(ipaddr));
	    exit(0);
	}
    }

    /* Construct network address */
    netaddr = ipaddr & subnet;

    /* Normalize network address */
    if (strcmp(argv[0], "inet_net") == 0)
    {
	if ((netaddr & IN_CLASSA_HOST) == 0)
	    printf("%u\n", C(netaddr >> 24));
	else if ((netaddr & IN_CLASSB_HOST) == 0)
	    printf("%u.%u\n", C(netaddr >> 24), C(netaddr >> 16));
	else if ((netaddr & IN_CLASSC_HOST) == 0)
	    printf("%u.%u.%u\n", C(netaddr >> 24), C(netaddr >> 16),
		C(netaddr >> 8));
	else
	    printf("%u.%u.%u.%u\n", C(netaddr >> 24), C(netaddr >> 16),
		C(netaddr >> 8), C(netaddr));
    }
    else
    {
	printf("%u.%u.%u.%u\n", C(netaddr >> 24), C(netaddr >> 16),
	    C(netaddr >> 8), C(netaddr));
    }
    exit(0);
}
