
#include <sys/param.h>
#include <sys/types.h>
#include <sys/sysmacros.h>
#include "sainode.h"
#include "mt.h"
#include "dk.h"
#include "icb.h"
#include "icbcmd.h"
#include "vreg.h"
#include "cpu.h"
#include "sysconf.h"
#include "saio.h"
#include "data_struct.h"

#define FWRITE  2			/*write flag is set*/


static char *emsg[] = { "system sector bad",
			"illegal disk/tape command",
			"invalid sector number",
			"disk not formatted",
			"invalid system sector information",
			"drive not ready",
			"physical drive not mounted",
			"no such logical drive",
			"phy/log drive out of range",
			"invalid data in request",
			"no partial block r/w",
			"cartridge not in place",
			"drive not ready",
			"write protected",
			"end of media",
			"data error",
			"file mark detected",
			"no data detected",
			"retry count exceeded",
			"beginning of media",
			"tape drive hung during r/w",
			"tape drive was reset",
			"",
			"",
			"",
			"illegal command",

};


int cltype;

short already;
int drive;
int dev;
int blkno;
int w9flag = 0;
unsigned int nine_trk = 0;
unsigned short mmuslots[0x44];

extern struct slot_info *dev_slot[4];
struct slot_info *tm_slot;
extern devreq();

int mtbcount;			/* number of bytes in blk */
int mtdma;			/* value returned by rtbcom */
int lockflg = 0;

struct devq treq = 0;


/* 
   This function gets the io structure information from the open
   module in SYS.c. It then uses the functions in the prom code
   to perform the actual tape operations
*/

mtopen(io) struct iob *io; {
	int ret;

	dev = io->i_unit;
	if((dev & 7) > 7){
		printf("Invalid unit number %x\n",dev);
		return(-1);
	}
	if(lockflg & (1<<dev)) {
		printf("Device locked - lockflg = %x\n", lockflg);
		return(-1);
	}

	already = 0;
	mtbcount = 0;
	nine_trk = 0;

	if((ret = mtcommand(TAPESTAT,dev)) != 0) return(-1);

/* If the tape is write protected and we open for writing, return an error */
	if((w9flag ) && (io->i_flgs & FWRITE)){
		printf("open tape error:  %s\n",emsg[WRPROT - MSGSTRT]);
		w9flag = 0;
		return;
	}
	if((ret = mtcommand(REWIND,dev)) != 0) return(-1);


	lockflg |= (1<<dev);
	return(0);

}

mtclose(io) struct iob *io; {
	int dev;
	dev = io->i_unit;
	if(cltype == WRITE){
		mtcommand(WEOF,dev);
		mtcommand(WEOF,dev);
	}
	mtcommand(REWIND,dev);
	lockflg &= ~(1<<dev);
}

mtcommand(command,dev)
register int command;
register int dev;
{
	int rcode;
	struct iob mtbuf;

	mtbuf.i_unit = dev;
	mtbuf.i_cc = BSIZE;
	mtbuf.i_bn = command;
	mtbuf.i_ma = mtbuf.i_buf;
	rcode = mtstrategy(&mtbuf,command);

	return(rcode);
}

/*
    This function takes the read or write operation along with the
    information in the io structure and passes them on to the
    rtbcom module which keeps track of any errors, location on the
    tape, block count, and performs the necessary operation.
*/

mtstart(io,func) register struct iob *io; int func; {


	cltype = func;
	if (func == READ) {
		if(already){
			already = 0;
			return(0);
		}
		if((mtdma = calltape(io,func)) != 0 )
			return(-1);
		
		return(treq.q_count);
	}
	else if (func == WRITE) {
		if((mtdma = calltape(io,func)) != 0){
			return(-1);
		}
		return(treq.q_count);
	}
	else
		mtdma = calltape(io,func);

	return(0);
}

/* If an error occurs during a read or write, it will be printed out here */

mtdone(retcode)
unsigned short retcode;
{
	char *rc;
	short i;

	if((cltype == TAPESTAT) && (treq.q_count == TRACK9OL))
		nine_trk++;
	if (retcode){
		for(i=0,rc=(char *)&retcode;i<2;i++,rc++){
			if(*rc == 0) continue;
			switch(cltype){
				case READ:
					if(*rc == FMARK){
						mtbcount = treq.q_count;
						already++;
						return;
					}
					mtbcount = -1;
					break;
					
				case WRITE:
					if(*rc == BOM) continue;
					if(*rc)
						mtbcount = -1;
					break;
	
				case WEOF:
					mtbcount = 0;
					return;
					break;

				case REOF:
					if(*rc == FMARK || *rc == WRPROT){
						*rc = 0;
						mtbcount = 0;
					}
					break;
	
				case REWIND:
					if(*rc == BOM || *rc == WRPROT ||
						*rc == FMARK || *rc == DRVE ||
						*rc == OLDBOM){
						*rc = 0;
						mtbcount = 0;
						return;
					}
					break;
	
				case TAPESTAT:
					if(!(*rc==DRVE || *rc==CART || *rc==EOM || *rc==WRPROT))
						*rc = 0;
					if(*rc == WRPROT){
						w9flag++;
						*rc = 0;
					}
					if(*rc) mtbcount = -1;
					break;


				case TENSION:
					break;

				default:
					printf("No such command\n");
					mtbcount = -1;
					break;
			}
			if(*rc){
				if(*rc <= GEN_MSGSTRT)
					printf("tape error: %s\n",emsg[*rc-1]);
				else if((*rc < TMSGSTRT) || (*rc > NONINE))
					printf("tape error: rc(%x)\n",*rc);
				else
					printf("tape error:  %s\n",emsg[*rc - MSGSTRT]);
			}
		}
	}
}

mtstrategy(io,func) register struct iob *io; int func; {
	blkno = io->i_bn + 1; 	/*io starts its blocks at 0, tape drive at 1 */
	mtdma = 0;


	mtbcount = mtstart(io,func);
	
	mtdone(mtdma);

	return(mtbcount);
	
}

calltape(io,op)
register struct iob *io;
register char op;
{
	register unsigned int board;
	register i;
	register char *cptr;
	register unsigned int mem_addr;
	register unsigned short *mmu_ptr;
	short n;
	short retcode;

	struct devq *taperq;
	
	board = (io->i_unit >> 4) & 3;
	if((tm_slot = dev_slot[board]) == (struct slot_info *)0) {
		printf("Device not ready - board %d\n", board);
		return(DRVE);
	}

	for(i=0,cptr = (char *)&treq;i<sizeof treq;i++,cptr++)
		*cptr = 0;

	taperq = &treq;

	taperq->q_devtype = (nine_trk) ? TAPE9 : TAPE;
	taperq->q_cmd = op;
	taperq->q_flag = 0;
	taperq->q_devnum = io->i_unit & 0xf;	/* cjk 880603 */
	taperq->q_devun.block = 0;
	taperq->q_count = io->i_cc;
	taperq->q_mem = (char *)conl2p(io->i_ma);

/* load the mmu table */

	if((op == READ) || (op == WRITE)){
		mem_addr = (((unsigned) taperq->q_mem) >> 12);
		for(i=0,mmu_ptr=mmuslots;i<0x42;i++,mmu_ptr++,mem_addr++)
			*mmu_ptr = mem_addr & 0xffff;
		taperq->q_mmu = (struct mmutbl *)mmuslots;
		taperq->local_mem = (struct free_mem *)((int)taperq->q_mem & 0xfff);
	}
	
	n = 0;

#ifdef _DEBUG
	{
	register int i;

	printf("calltape() from here ----------------\n");
	printf("     cmd: %x\n", taperq->q_cmd);
	printf(" devtype: %d\n", taperq->q_devtype);
	printf("  devnum: %x\n", taperq->q_devnum);
	printf("priority: %d\n", taperq->q_priority);
	printf("mem (%d):  ", taperq->q_count);
        for (i = 0; i < taperq->q_count; i++)
		printf("%02x  ", taperq->q_mem[i]);
	printf("\n     key: %x\n", taperq->q_key);
	printf("    flag: %x\n", taperq->q_flag);
	printf("    scnt: %d\n", taperq->scnt);
	printf("   retry: %d\n", taperq->retry);
	printf("totsleft: %d\n", taperq->totsleft);
	printf("sectleft: %d\n", taperq->sectleft);
	}
#endif

	n = devreq(tm_slot,taperq);

	if(n || *(short *)&(taperq->rc1)){
		retcode = (n) ? n & 0xffff : *(short *)&(taperq->rc1);
		return(retcode);
	}

	return(0);
}



mtioctl(pdrive,cmd,addr)
register int pdrive,cmd;
register unsigned int addr;
{

	unsigned int retcode;
	int i;
	char *cptr;
	struct devq *tqptr;

	for(i=0,cptr=(char *)&treq;i<sizeof treq;i++,cptr++)
		*cptr = 0;

	tqptr = &treq;

	tqptr->q_devtype = TAPE;

	switch(cmd){
		case REOF:
			tqptr->q_cmd = cmd;
			tqptr->q_devnum = pdrive;
			tqptr->q_mem = (char *)conl2p(addr);
			retcode = mtcommand(cmd,pdrive);
			break;
		case TAPESTAT:
			tqptr->q_cmd = cmd;
			tqptr->q_devnum = pdrive;
			tqptr->q_mem = (char *)conl2p(addr);
			retcode = mtcommand(cmd,pdrive);
			break;
		default:
			printf("invalid command\n");
			return(-1);
	
	}
	if(retcode) return(-1);
	return(0);
}
