

	/*
		convert list of media defects from raw format
		into cyl/head/sector list
	*/

#include "disksect.h"

conv_defects (sechead, bitsec, Lbitsec, fmt, def_ptr, def_cnt, dest_ptr)
unsigned bitsec, Lbitsec, fmt;
struct medf *def_ptr;
unsigned def_cnt;
struct sectid *dest_ptr;
{
	unsigned i, ret_cnt, bit_p_trk;
	unsigned strt_def, end_def;
	char last_sec, sec;
	bit_p_trk =  ((sechead -1)) * bitsec + Lbitsec;
	ret_cnt = 0;
	while (def_cnt-- > 0) {
		if ((def_ptr->cyl & 0x8000) != 0) {
				/* spare entire track */
			for (sec = 0; sec < sechead; sec++) {
				spare (dest_ptr, def_ptr, sechead, fmt, sec);
				dest_ptr++;
				ret_cnt++;
			}
		}
		else {
				/* spare up to four sectors */
			last_sec = -1;
			for (i=0; i<4; i++) {
				if (strt_def = def_ptr->defpos[i].pos * 8)
					strt_def -= 8;
				if (((end_def = def_ptr->defpos[i].len) == 0) ||
						(strt_def > bit_p_trk)) {
					continue;
				}
				end_def += strt_def + 2*8;
				if (end_def > bit_p_trk) end_def = bit_p_trk;
				do {
					sec = strt_def/bitsec;
					if (sec >= sechead) break;
	    /*NOTE: if wrap around errors can happen, change break to sec = 0 */
					if (sec != last_sec) {
						spare (dest_ptr, def_ptr,
							    sechead ,fmt, sec);
						dest_ptr++;
						ret_cnt++;
						last_sec = sec;
					}
				    /* mov strt_def to start of next sect */
					strt_def = (sec+1)*bitsec;
				} while (strt_def <= end_def);
			}
		}
		def_ptr++;
	}
	return (ret_cnt);
}

unsigned char
secmap (sechead, ftype, head, sec)
short ftype;
unsigned char head, sec;
{
	unsigned char ret_sec;
	switch (ftype) {
	case 0:
		return (sec);
	case 1:
		ret_sec = sec+head;
		if (ret_sec >= sechead) {
			ret_sec -= sechead;
		}
		return (ret_sec);
	default:
		return (0xff);
	}
}

spare (dest_ptr, def_ptr, sechead, fmt, sec)
struct medf *def_ptr;
struct sectid * dest_ptr;
short fmt;
char sec;
{
	dest_ptr->cyl = def_ptr->cyl & 0x7fff;	/* mask off track defect bit */
	dest_ptr->head = def_ptr->head;
	dest_ptr->sector = secmap (sechead, fmt, dest_ptr->head, sec);
}

