#include <sys/param.h>
#include <sys/types.h>
#include <sys/sysmacros.h>
#include "sainode.h"
#include "saio.h"

devread(io)
register struct iob *io;
{

	return( (*devsw[io->i_ino.i_dev].dv_strategy)(io,READ) );
}

devwrite(io)
register struct iob *io;
{
	return( (*devsw[io->i_ino.i_dev].dv_strategy)(io, WRITE) );
}

devopen(io)
register struct iob *io;
{
	return( (*devsw[io->i_ino.i_dev].dv_open)(io) );
}

devclose(io)
register struct iob *io;
{
	(*devsw[io->i_ino.i_dev].dv_close)(io);
}

nullsys()
{ return(0); }

int	nullsys();
int rpopen();
int	rpstrategy();
int	mtstrategy();
int	mtopen();
int	mtclose();
int rvopen();
int	rvstrategy();
struct devsw devsw[] =  {
	"rp",	rpstrategy,	rpopen,	nullsys,
	"mt",	mtstrategy,	mtopen,		mtclose,
	"rv",	rvstrategy,	rvopen,	nullsys,
	0,0,0,0
};

devioctl(io,cmd,addr)
register struct iob *io;
char *addr;
{
	/* kluge */
	if (devsw[io->i_ino.i_dev].dv_strategy == rpstrategy)
		return(rpioctl(io->i_unit >> 4, cmd, addr));
	else if (devsw[io->i_ino.i_dev].dv_strategy == rvstrategy) {
		return(rpioctl(io->i_unit, cmd, addr));	/* cjk 880603 */
	}
	else if (devsw[io->i_ino.i_dev].dv_strategy == mtstrategy)
		return(mtioctl(io->i_unit, cmd, addr));
	else
		return(-1);
}
