/******************************************************************************
 *
 * various character functions
 *
 ******************************************************************************/

#define _U  01          /* Upper case */
#define _L  02          /* Lower case */
#define _N  04          /* Numeral (digit) */
#define _S  010         /* Spacing character */
#define _P  020         /* Punctuation */
#define _C  040         /* Control character */
#define _B  0100        /* Blank */
#define _X  0200        /* heXadecimal digit */

#define SZ		514


static char _ctype[SZ] = {                                         0,
    _C,     _C,     _C,     _C,     _C,     _C,     _C,     _C,
    _C,     _S|_C,  _S|_C,  _S|_C,  _S|_C,  _S|_C,  _C,     _C,
    _C,     _C,     _C,     _C,     _C,     _C,     _C,     _C,
    _C,     _C,     _C,     _C,     _C,     _C,     _C,     _C,
    _S|_B,  _P,     _P,     _P,     _P,     _P,     _P,     _P,
    _P,     _P,     _P,     _P,     _P,     _P,     _P,     _P,
    _N|_X,  _N|_X,  _N|_X,  _N|_X,  _N|_X,  _N|_X,  _N|_X,  _N|_X,
    _N|_X,  _N|_X,  _P,     _P,     _P,     _P,     _P,     _P,
    _P,     _U|_X,  _U|_X,  _U|_X,  _U|_X,  _U|_X,  _U|_X,  _U,
    _U,     _U,     _U,     _U,     _U,     _U,     _U,     _U,
    _U,     _U,     _U,     _U,     _U,     _U,     _U,     _U,
    _U,     _U,     _U,     _P,     _P,     _P,     _P,     _P,
    _P,     _L|_X,  _L|_X,  _L|_X,  _L|_X,  _L|_X,  _L|_X,  _L,
    _L,     _L,     _L,     _L,     _L,     _L,     _L,     _L,
    _L,     _L,     _L,     _L,     _L,     _L,     _L,     _L,
    _L,     _L,     _L,     _P,     _P,     _P,     _P,     _C,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,

    /* tolower()  and toupper() conversion table */         0,

    0,      1,      2,      3,      4,      5,      6,      7,
    8,      9,      10,     11,     12,     13,     14,     15,
    16,     17,     18,     19,     20,     21,     22,     23,
    24,     25,     26,     27,     28,     29,     30,     31,
    32,     33,     34,     35,     36,     37,     38,     39,
    40,     41,     42,     43,     44,     45,     46,     47,
    48,     49,     50,     51,     52,     53,     54,     55,
    56,     57,     58,     59,     60,     61,     62,     63,
    64,     97,     98,     99,     100,    101,    102,    103,
    104,    105,    106,    107,    108,    109,    110,    111,
    112,    113,    114,    115,    116,    117,    118,    119,
    120,    121,    122,    91,     92,     93,     94,     95,
    96,     65,     66,     67,     68,     69,     70,     71,
    72,     73,     74,     75,     76,     77,     78,     79,
    80,     81,     82,     83,     84,     85,     86,     87,
    88,     89,     90,     123,    124,    125,    126,    127,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0,
    0,      0,      0,      0,      0,      0,      0,      0
};

isdelimit(c)
register char c;
{
	switch (c) {
		case ' ':
		case ';':
        case   0:
            return(1);
        default:
            return(0);
	}
}

ishexnum(c)
register int c;
{
    return (isxdigit(c));
}

isalpha(c)
register int c;
{
    return ((_ctype + 1)[c] & (_U | _L));
}

isupper(c)
register int c;
{
    return ((_ctype + 1)[c] & _U);
}

islower(c)
register int c;
{
    return ((_ctype + 1)[c] & _L);
}

isdigit(c)
register int c;
{
    return ((_ctype + 1)[c] & _N);
}

isxdigit(c)
register int c;
{
    return ((_ctype + 1)[c] & _X);
}

isalnum(c)
register int c;
{
    return ((_ctype + 1)[c] & (_U | _L | _N));
}

isspace(c)
register int c;
{
    return ((_ctype + 1)[c] & _S);
}

ispunct(c)
register int c;
{
    return ((_ctype + 1)[c] & _P);
}

isprint(c)
register int c;
{
    return ((_ctype + 1)[c] & (_P | _U | _L | _N | _B));
}

isgraph(c)
register int c;
{
    return ((_ctype + 1)[c] & (_P | _U | _L | _N));
}

iscntrl(c)
register int c;
{
    return ((_ctype + 1)[c] & _C);
}

isascii(c)
register int c;
{
    return (!((c) & ~0177));
}

_toupper(c)
register int c;
{
    return ((_ctype + 258)[c]);
}

_tolower(c)
register int c;
{
    return ((_ctype + 258)[c]);
}

toascii(c)
register int c;
{
    return ((c) & 0177);
}

asc_to_hex(c)
register char c;
{
    if (isdigit(c))
        return (c - '0');
    if (c >= 'A' && c <= 'F')
        return (c + (10 - 'A'));
    if (c >= 'a' && c <= 'f')
        return (c + (10 - 'a'));
    return (-1);
}

#ifdef TESTING

char cs[80];

main()
{
        register char *c;

        printf("String: ");
        gets(cs);
        for (c = cs; *c; c++) {
            printf("%c is ", *c);
            if (isupper(*c))
                printf("Upper ");
            if (islower(*c))
                printf("Lower ");
            if (isalpha(*c))
                printf("Alpha ");
            if (isxdigit(*c))
                if (isdigit(*c))
                    printf("Digit ");
                else
                    printf("Hex digit ");
            if (isalnum(*c))
                printf("Alnum ");
            if (isspace(*c))
                printf("Space ");
            if (ispunct(*c))
                printf("Punctuation ");
            if (isprint(*c))
                printf("Printable ");
            if (isgraph(*c))
                printf("Graph ");
            if (iscntrl(*c))
                printf("Control ");
            if (isascii(*c))
                printf("Ascii ");
            printf("\n");
        }
}
#endif
