	global	bzero
#------------------------------------------------------------------
#
#	B Z E R O
#
#	bzero(address, count)
#
#------------------------------------------------------------------

bzero:
	mov.l	4(%sp),%d1		# address
	mov.l	8(%sp),%d0		# count
	add.l	%d0,%d1
	mov.l	%d1,%a0
	mov.l	&0,%a1
bz010%:
	mov.l	%a0,%d1
	and.l	&1,%d1
	beq.b	bz020%			# word boundary
	clr.b	-(%a0)
	sub.l	&1,%d0
	bne.b	bz020%
	rts
bz020%:
	mov.l	%d0,%d1
	lsr.l	&5,%d1			# see if 32 bytes left
	beq.b	bz023%			# no
	sub.l	&1,%d1			# don't do last 32 bytes of a page
	beq.b	bz023%
	lsl.l	&5,%d1
	sub.l	%d1,%d0			# adjust # of bytes left
	lsr.l	&5,%d1
	sub.l	&1,%d1
	movm.l	&0xbf00,-(%sp)		# save d0,d2-d7 registers
	clr.l	%d0
	clr.l	%d2
	clr.l	%d3
	clr.l	%d4
	clr.l	%d5
	clr.l	%d6
	clr.l	%d7
bz022%:
	movm.l	&0xbf40,-(%a0)		# use a1,d0,d2-d7
	dbvs	%d1,bz022%
	movm.l	(%sp)+,&0x00fd		# restore regs
bz023%:
	mov.l	%d0,%d1			# check if any long words 
	lsr.l	&2,%d1
	beq.b	bz025%
	sub.l	&1,%d1
bz024%:
	mov.l	%a1,-(%a0)			# clear long words
	dbvs	%d1,bz024%
bz025%:
	and.l	&3,%d0
	beq.b	bz090%			# check if 1 to 3 bytes left
bz030%:
	clr.b	-(%a0)
	sub.l	&1,%d0
	bra.b	bz025%
bz090%:
	rts

#	.end
