
/* iop's with a console device should support the following virtual uart */

struct virt_uart {
	unsigned short vu_status;
	unsigned short vu_control;
	char vu_cmd;
	char vu_rdata; /* receiver data */
	char vu_rstat; /* receiver status */
	char vu_tdata; /* transmitter data */
	char vu_tstat; /* transmitter status */
};

/* defines for vu_status */
#define VUIA   0 /* input active */
#define VUOA   1 /* output active */

/* defines for vu_control */
#define VUCBAUD  0x000f /* baud rate bit mask */
#define VUB0     0      /* hang up */
#define VUB50    1      /* 50 baud */
#define VUB75    2      /* 75 baud */
#define VUB110   3      /* 110 baud */
#define VUB134   4      /* 134.5 baud */
#define VUB150   5      /* 150 baud */
#define VUB200   6      /* 200 baud */
#define VUB300   7      /* 300 baud */
#define VUB600   8      /* 600 baud */
#define VUB1200  9      /* 1200 baud */
#define VUB2400  10     /* 2400 baud */
#define VUB4800  11     /* 4800 baud */
#define VUB9600  12     /* 9600 baud */
#define VUB19K   13     /* 19200 baud */
#define VUB38K   14     /* 38400 baud */
#define VUCSIZE  0x0030 /* character size bit mask */
#define VUCS5    0      /* 5 bits per character */
#define VUCS6    0x0010 /* 6 bits per character */
#define VUCS7    0x0020 /* 7 bits per character */
#define VUCS8    0x0030 /* 8 bits per character */
#define VUCSTOPB 0x0040 /* send two stop bits else one */
#define VUASDTR  0x0080 /* assert dtr */
#define VUPARENA 0x0100 /* parity enable */
#define VUPARODD 0x0200 /* parity odd else even */
#define VUENRI   0x0400 /* enable receiver interrupts */
#define VUENTI   0x0800 /* enable transmitter interrupts */

/* defines for vu_cmd */
#define VUPGCH   1 /* program channel */
#define VUACTI   2 /* activate input */
#define VUACTO   3 /* activate output */
