h56299
s 00177/00000/00000
d D 1.1 91/03/26 10:57:53 root 1 0
c date and time created 91/03/26 10:57:53 by root
e
u
U
t
T
I 1

typedef unsigned char uchar;
#include <sys/types.h>

#include <pdf.h>
#include "simple_mem.h"
#include "setjmp.h"

/* level 0 dsetup has possible bad spare tables */
#define LEVEL_1_DSETUP 1
#define CURRENT_DSETUP_LEVEL LEVEL_1_DSETUP

#define MIN_LD_SIZE 1024 /* 1 meg byte disk is the min */
#define RV_LOGDR -1  /* must be -1, check position in struct setup */
#define SIZE_RV 0x500
#define SIZE_SMALL_RV 0x300
#define MAX_SIZE_RV 0x800

#define BOOT_SECTOR 8
#define BOOT_START 0x100

/* is this setup for the system primary disk */
#define IS_SYS0(s) ((s)->dev.dev_num == 0)

#define INODEFACT 64 /* mkfs value for 1k file systems */
#define NBINODE 16 /* mkfs as above */
#define MKFS_MAGIC 65500

/*
 *	percentbad could be made a variable.
 *	If the disk types are weighted then the expected number of
 *	badies might be less.
 */
/* the FRACTIONBAD could probably be set to .002 (or less) for most config */
/* might want to put it into the default config stuff */
#define FRACTIONBAD 272 /* divide by this instead of mult by .0035 */

/* how to scan contiguous logical disks, used in writelasti */
#define NOPASS_EMPTY 1
#define PASS_EMPTY 0
#define EMPTY_OK 2
#define NOEMPTY_OK 0
#define FREEZE_OK 4
#define NOFREEZE_OK 0

#ifdef STANDALONE
struct icbdev {
    struct bd_desc *iop;
    ushort dev_type;
    ushort dev_num;
};
#else
struct icbdev {
    char *iop; /* just so the sizes are the same */
    ushort dev_type;
    ushort dev_num;
};
#endif

struct cbad {
    ushort cHole;
    ushort cSpare;
    ushort cTrack;
    ushort cSkip;
};

/* confld.flag bit definitions */
#define CFLD_PROTECT 1
#define CFLD_FREEZE 2
#define CFLD_OLD 4
#define CFLD_KEEPSIZE 8 /* not used */
struct confld {
    uchar type; /* logical disk type */
    uchar flag; /* protect, ... */
    uint cSect; /* number of logical disk sectors requested */
    uint cSpareLim; /* how many no hole sectors (inode or all) */
    /* the following are only meaningful if the disk is figured */
    uint start; /* starting phys disk address, sector number */
    uint cAssignSect; /* final number of sectors */
    struct cbad cBad; 
    /* if protected */
    int logdriveindex;
};

/* setup.flag definitions */
#define SET_USED 1
#define SET_WRIT 2
#define SET_FIG 4
#define SET_NEW 8

/* is the following used */
#define SET_CLEAR 0x10 /* spare and skip memory has been allocated */

#define SET_OLD 0x20
#define SET_MOD 0x40
#define SET_WBADS 0x80	/* need to write the bad block list */

struct setup {
    int flag; /* applied, figured, ... */
    int defaultldtype;
    int cSpareGuess; /* estimated number of sectors for bad */
    int cTotalSect; /* number of sectors on the disk */
    int cAvail; /* number of available sectors, after various reserved */
    int cSpareSectors; /* actual number of spares set aside */
    struct cbad cDiskBad;
    struct icbdev dev;
    struct pdstat pdstat;
    int fd;
    struct memuse *memPhysdisk;
    int cMemBad;  /* actual number of elements in memBad */
    struct memuse *memBad; /* too get to bad block list */
    int cMemSpare;  /* actual number of elements in memSpare */
    struct memuse *memSpare;
    int cMemSkip;
    struct memuse *memSkip;
    struct sprs *spares; /* constructed spare list */
    struct sprs *oldspares; /* current spare list */
    /* the relation of the following two cannot be changed */
    /* confRsv is logical disk -1 in a very few instances */
    struct confld confRsv;
    struct confld confld[LOGDR];
};

/*
 *	the bad sector list from the manufacturers defective media
 *	and the disktest results
 */
/* physbadsector.flag and sparedata.flag*/
#define BS_HOLE 1
#define BS_SPARE 2
#define BS_UNSPARE 4
#define BS_PROTECT 0x10
struct physbadsector {
    ushort flag;
    short index;
    ushort cyl;
    uchar head;
    uchar sector;
};

struct sparedata {
    ushort flag; /* protect, */
    ushort cyl;
    uchar head;
    uchar sector;
    ushort altcyl;
    uchar althead;
    uchar altsector;
};

/*
 *	maybee add to the default configs:
 *	  - what to use for fraction bad
 *	  - a confld.flag field to allow CFLD_FREEZE
 */
struct defconf {
    int cRsv;
    int normal; /* if this is -1 the remainder (after define) is one disk */
    int normaltype;
    int definedcount;
    int defined[2]; /* dynamic based on defcount, two ints: size,type */
};

struct conftable {
    char name[20];
    struct defconf *pconf;
};

extern jmp_buf errorbuf;
extern struct conftable gConf[];
extern char *ascldtype[];

#define SETCHS(p,v) (*(long *)(&(p)) = v)
#define VALCHS(p) (*(long *)(&(p)))
#define VALCH(p) (*(long *)(&(p)) & ~0xff)

#define PD0(s) ((struct sector0 *)((s)->memPhysdisk->p))
E 1
