/******************************************************************************
 *
 * miscellaneous defines 
 *
 ******************************************************************************/
#define NOP 0x4e71	/* 68000 nop instruction */
#define FALSE 0
#define TRUE 1
#define NULL 0
#define ESCAPE 0x1b  /* ascii ESCAPE character */
#define CONSOLE 0xff
#define STDOUT 0
#define STDERR 1
#define LOWORD(x) (((unsigned short *)&x)[1])
#define HIWORD(x) (((unsigned short *)&x)[0])
#define LWSHIFT(x) (x >> 2)
#define LWBOUND(x) ((x & 0x3) == 0)
#define SCTRSIZ 0x400
#define CQSIZ 16   /* queue size for i/o characters */
#define CBUFSIZ 80
#define DISINTS asm("	or.w	&0x0700,%sr")  /* interrupt mode 7 */
#define ENAINTS asm("	and.w	&0xf8ff,%sr")  /* interrupt mode 0 */
#define DMARESET(ch) (*DMCINTREG = GVP->SoftIReg | (1 << ch))
#define CONSPORT 0	/* The two consoles on the CPU */
#define DIAGPORT 1

/*
 * baud rate table for cpu monitor console baud rate
 */
struct baud {
	int bdrate;
	unsigned char bdmsb;
	unsigned char bdlsb;
};

typedef unsigned char boolean;
