/******************************************************************************
 *
 * defines for the arete memory board
 *
 ******************************************************************************/

/******************************************************************************
 *
 * the int register is the same address as an IOP's (ICBINTREG)
 *
 ******************************************************************************/
/*
     X X X X   X X X X   X X X X   X X X X b    (as written by the icb master)
     | | | |   | | | |   | | | |   | | | |
     | | | |   | | | |   | | base address (which megabyte)
     | | | |   | | | |   not used
     | | | |   | | | enable memory board
     | | | |   | | green led
     | | | |   | yellow led
     | | | |   red led
     | not used
     reset


     X X X X   X X X X   X X X X   X X X X b    (as read by the icb master)
     | | | |   | | | |   | | | |   | | | |
     | | | |   | | | |   | | base address (which megabyte)
     | | | |   | | | |   memory size information (see below)
     ---------not used

	size information:
		00 = 1 megabyte
		01 = 2 megabyte
		10 = 4 megabyte
		11 = 8 megabyte

 */
#define BSADDMSK   0x003f /* base address mask */
#define MSIZMSK    0x00c0 /* memory size mask */
#define MSIZSH     6      /* memory size shift */
#define MREDLED    0x0800 /* memory red led */
#define MYELLED    0x0400 /* memory yellow led */
#define MGRNLED    0x0200 /* memory green led */
#define MENBL      0x0100 /* memory board enable */
#define MRESET     0x8000 /* memory board reset (idle state) */
#define MBASSHFT   20     /* memory base shift (megabyte) */
#define MEMSIZ(x)  (1 << (x)) /* interpret size information (megabytes) */

/******************************************************************************
 *
 * the stat register is the same address as an IOP's (ICBSTATREG) - read only
 *
 ******************************************************************************/
/*

     X X X X   X X X X   X X X X   X X X X b    (as read by the icb master)
     | | | |   | | | |   | | | |   | | | |
     | | | |   | | | |   ---------not used
     | | | board type
     not used

 * use BDTYPMSK and BDTYPSH
 */
