/*****************************************************************************
 *
 * DMC
 *
 * the following is a port and bit description of the dmc board
 *
 *****************************************************************************/
#include "iospace.h"

/*****************************************************************************
 *
 * dtb arbiter ram
 *
 *****************************************************************************/
#define DMCARB ((unsigned short *)(0x260000 + IOSPACE))  /* arbiter ram */
#define DMCARB0 ((unsigned short *)(0x660000))  /* arbiter ram0 for DMC4 */
#define DMCARB1 ((unsigned short *)(0x660200))  /* arbiter ram1 for DMC4 */
#define DMCARB2 ((unsigned short *)(0x660400))  /* arbiter ram2 for DMC4 */
#define DMCARB3 ((unsigned short *)(0x660600))  /* arbiter ram3 for DMC4 */
#define DMCARBSZ 0x100   /* number of entries in each arbiter ram */
/* dmc arbiter word:					(read/write)
	X X X X  X X X X  X X X X  X X X X b
	| | | |  | | | |  | | | |  | | | |
	| | | |  | | | |  | | | |  dtb arbiter data
	unused   unused   unused
 */
#define DMCARBMSK 0x000f

/*****************************************************************************
 *
 * dma channels
 *
 *****************************************************************************/
/* below is a definition of the dma registers   (all read/write) */
struct dma_chan {
	unsigned short cntrl_wrd; /* description below */
	unsigned short lword_cnt; /* number of longwords to transfer */
	unsigned short hi_addr;
	unsigned short lo_addr; /* complete address must be on longword boundary (>> 2) */
};
#define DMC0DMA ((struct dma_chan *)(0x26ffc0 + IOSPACE))
#define DMC1DMA ((struct dma_chan *)(0x26ffc8 + IOSPACE))
#define MAXDMAB 0x20000 /* maximum dma tramsfer is 128k bytes */
/* dma control word:
	X X X X  X X X X  X X X X  X X X X b
	| | | |  | | | |  | | | |  | | | |
	| | | |  | | | |  unused   unused
	| | | |  dtb slave address (0-fh)
	| | | from/to* memory
	| | byte count 0 (read only)
	| dma transfer enable
	master mode enable
 */
#define DMASLVMSK 0x0f00 /* slave's dtb address mask (only master needs this) */
#define DMASHFTSL 8 /* slave dtb shift value */
#define DMAFROM   0x1000 /* if set dma from memory else to */
#define DMABCZERO 0x2000 /* byte count zero */
#define DMAXFRENA 0x4000 /* transfer enable */
#define DMAMMENA  0x8000 /* master mode enable */

/*****************************************************************************
 *
 * dmc interrupt register
 *
 *****************************************************************************/
#define DMCINTREG ((unsigned short *)(0x26fffe + IOSPACE))
/* dmc interrupt register:			(write only)
	X X X X  X X X X  X X X X  X X X X b
	| | | |  | | | |  | | | |  | | | |
	| | | |  | | | |  | | | |  | | | dma channel 0 reset
	| | | |  | | | |  | | | |  | | dma channel 1 reset
	| | | |  | | | |  | | | |  unused
	| | | |  | | | |  | | | dma channel 0 interrupt enable
	| | | |  | | | |  | | dma channel 1 interrupt enable
	| | | |  | | | |  | unused
	| | | |  | | | |  yellow led off
	| | | |  | | arbiter index (binary coded 0-3)
	| | | |  | green led on
	| | | |  red led on
	| | | edac enable
	| | diagnostic mode enable
	| memory error interrupt enable
	dmc master reset
 */
#define DMA0RST   0x0001 /* dma channel 0 reset */
#define DMA1RST   0x0002 /* dma channel 1 reset */
#define DMA0IENA  0x0010 /* dma channel 0 interrupt enable */
#define DMA1IENA  0x0020 /* dma channel 1 interrupt enable */
#define DMCYELOFF 0x0080 /* dmc yellow led off */
#define ARBINDMSK 0x0300 /* dtb arbiter index mask */
#define ARBINDSH  8      /* dtb arbiter index shift value */
#define DMCGRNL   0x0400 /* dmc's green led */
#define DMCREDL   0x0800 /* dmc's red led */
#define EDACENA   0x1000 /* edac enable */
#define DIAGMDENA 0x2000 /* diagnostic mode enable */
#define MERRIENA  0x4000 /* memory error interrupt enable */
#define DMCMRST   0x8000 /* dmc master reset */

/*****************************************************************************
 *
 * dmc status register
 *
 *****************************************************************************/
#define DMCSTATREG ((unsigned short *)(0x26fffc + IOSPACE))
/* dmc status register:				(read only)
	X X X X  X X X X  X X X X  X X X X b
	| | | |  | | | |  | | | |  | | | |
	| | | |  | | | |  | | | |  | | | dma channel 0 service request
	| | | |  | | | |  | | | |  | | dma channel 1 service request
	| | | |  | | | |  | | | |  | memory read error
	| | | |  | | | |  | | | |  memory error interrupt enabled
	| | | |  | | | |  | | | dma channel 0 interrupt enabled
	| | | |  | | | |  | | dma channel 1 interrupt enabled
	| | | |  | | | |  | edac enabled
	| | | |  | | | |  unused
	| | | board type bits (the dmc is board type 2)
	| | diagnostic mode enabled
	| dmc interrupt pending
	unused (always 0)
 */
#define DMA0SRQ   0x0001 /* dma channel 0 service request */
#define DMA1SRQ   0x0002 /* dma channel 1 service request */
#define MEMRDERR  0x0004 /* memory read error */
#define MERRIED   0x0008 /* memory error interrupt enabled */
#define DMA0IED   0x0010 /* dma channel 0 interrupt enabled */
#define DMA1IED   0x0020 /* dma channel 1 interrupt enabled */
#define EDACED    0x0040 /* edac enabled */
#define DIAGMED   0x2000 /* diagnostic mode enabled */
#define DMCINTP   0x4000 /* dmc interrupt pending */

/*****************************************************************************
 *
 * dmc faulty memory address registers
 *
 *****************************************************************************/
#define DMCHFMAREG ((unsigned short *)(0x26fff0 + IOSPACE)) /* dmc high faulty memory address register (read only << 16) */
#define DMCLFMAREG ((unsigned short *)(0x26fff2 + IOSPACE)) /* see below */
/* dmc low faulty memory address register:				(read only)
	X X X X  X X X X  X X X X  X X X X b
	| | | |  | | | |  | | | |  | | | |
	| | | |  | | | |  | | | |  | | | code/data* access
	| | | |  | | | |  | | | |  | | user/system* access
	low portion of longword address
 */

/*****************************************************************************
 *
 * dmc read check bit register
 *
 *****************************************************************************/
#define DMCRDCHKBITREG ((unsigned short *)(0x26fff4 + IOSPACE))
/* generated (real) check bit register:				(read only)
	X X X X  X X X X  X X X X  X X X X b
	| | | |  | | | |  | | | |  | | | |
	| | | |  | | | |  | check bits
	unused   unused   unused
 */
#define CHBITMSK  0x007f  /* edac check bit mask */

/*****************************************************************************
 *
 * dmc memory error status register
 *
 *****************************************************************************/
#define MEMERRSTATREG ((unsigned short *)(0x26fff6 + IOSPACE))
/* memory error status register:				(read only)
	X X X X  X X X X  X X X X  X X X X b
	| | | |  | | | |  | | | |  | | | |
	| | | |  | | | |  | syndrome bits
	| | | |  | | | |  uncorrectable memory error
	| | | |  byte select at time of memory error (not binary coded)
	| | | read* or read mod write at time of memory error 
	pmb grant status (binary coded)
 */
#define SYNDBMSK   0x007f /* syndrome bit mask */
#define UCMEMERR   0x0080 /* uncorrectable memory error */
#define ERRBSMSK   0x0f00 /* byte select at time of memory error */
#define RMWMERR    0x1000 /* if set read mod write mem err else read */
#define ERRPGMSK   0xe000 /* pmb grant at time of memory error */

/*****************************************************************************
 *
 * dmc diagnostic check bit register
 *
 *****************************************************************************/
#define DMCDIAGCHKBITREG ((unsigned short *)(0x26fffa + IOSPACE))
/* dmc diagnostic check bit register:				(read/write)
	X X X X  X X X X  X X X X  X X X X b
	| | | |  | | | |  | | | |  | | | |
	| | | |  | | | |  | check bits
	unused   unused   unused
 */


