/*	Layout of b.out file :
 *
 *	header of 8 longs	magic number 405, 407, 410, 411
 *				text size		)
 *				data size		) in bytes
 *				bss size		)
 *				symbol table size	)
 *				relocation size		)
 *				entry point
 *
 *
 *	header:		0
 *	text:		32
 *	data:		32+textsize
 *	symbol table:	32+textsize+datasize
 *	relocation:	32+textsize+datasize+symsize
 *
 */

/* various parameters */
#define SYMLENGTH	50		/* maximum length of a symbol */
#define SYMNMLEN	8

/* types of files */
#define	ARCMAGIC 0177545
#define OMAGIC	0405
#define	AOUT2MAGIC	0407
#define	AOUT1MAGIC	0410
#define	IMAGIC	0411
#define COFMAGIC 0570		/*common obj file format regular file*/
#define COF1MAGIC 0575		/*common obj file format pure file*/


/* symbol types */
#define	EXTERN	040
#define	UNDEF	00
#define	ABS	01
#define	TEXT	02
#define	DATA	03
#define	BSS	04
#define	COMM	05	/* internal use only */
#define REG	06

/* relocation regions */
#define	RTEXT	00
#define	RDATA	01
#define	RBSS	02
#define	REXT	03

/* relocation sizes */
#define RBYTE	00
#define RWORD	01
#define RLONG	02

/* macros which define various positions in file based on a bhdr, filhdr */
#define TEXTPOS		sizeof(filhdr)
#define DATAPOS 	TEXTPOS + filhdr.tsize
#define SYMPOS		DATAPOS + filhdr.dsize
#define RTEXTPOS	SYMPOS + filhdr.ssize
#define RDATAPOS	RTEXTPOS + filhdr.rtsize
#define ENDPOS		RDATAPOS + filhdr.rdsize
/* header of b.out files */
struct bhdr {
	long	fmagic;
	long	tsize;
	long	dsize;
	long	bsize;
	long	ssize;
	long	rtsize;
	long	rdsize;
	long	entry;
};

/* symbol management */
struct sym {
	char	stype;
	long	svalue;
};


struct naout{
	short	magic;
	short	vstamp;
	long	tsize;
	long	dsize;
	long	bsize;
	long	entry;
	long	text_start;
	long	data_start;
};
