
/*******************************************************************
 *
 *   A C I A   motorola 6850
 *   asynchronous communications interface adapter
 *
 *******************************************************************/

struct acia_reg {
	unsigned char filler;
	unsigned char reg;
};

struct acia {
	struct acia_reg csreg;		/* control/status register */
	struct acia_reg datreg;		/* data register */
};

/*******************************************************************
 *
 * 	C O N T R O L   R E G I S T E R
 *
 *******************************************************************/
#define AC_CD1    0x00  /* counter divide 1 */
#define AC_CD16   0x01  /* counter divide 16 */
#define AC_CD64   0x02  /* counter divide 64 */
#define AC_RESET  0x03  /* master reset */
#define AC_7BE2S  0x00  /* 7 bit data, even parity, 2 stop bits */
#define AC_7BO2S  0x04  /* 7 bit data, odd parity, 2 stop bits */
#define AC_7BE1S  0x08  /* 7 bit data, even parity, 1 stop bit */
#define AC_7BO1S  0x0c  /* 7 bit data, odd parity, 1 stop bit */
#define AC_8B2S   0x10  /* 8 bit data, 2 stop bits */
#define AC_8B1S   0x14  /* 8 bit data, 1 stop bit */
#define AC_8BE1S  0x18  /* 8 bit data, even parity, 1 stop bit */
#define AC_8BO1S  0x1c  /* 8 bit data, odd parity, 1 stop bit */
#define AC_RL     0x00  /* RTS low, no Tx interrupt */
#define AC_RLTXI  0x20  /* RTS low, Tx interrupt enabled */
#define AC_RH     0x40  /* RTS high, no Tx interrupt */
#define AC_RLTB   0x60  /* RTS low, transmit a break, no Tx interrupt */
#define AC_RXI    0x80  /* Rx interrupt enabled */

/*******************************************************************
 *
 *   S T A T U S   R E G I S T E R
 *
 *******************************************************************/
#define AS_RX     0x01	/* receiver full */
#define AS_TX     0x02	/* transmitter empty */
#define AS_DCD    0x04	/* data carrier detect */
#define AS_CTS    0x08	/* clear to send */
#define AS_FRM    0x10	/* framing error */
#define AS_RXO    0x20	/* receiver overrun */
#define AS_PE     0x40	/* parity error */
#define AS_IRQ    0x80	/* interrupt request */
