#include "scsi_ccpu.h"
#include "scsi.h"
#include "disk_struct.h"
#include "scsitape.h"
#include "scsi_dtc.h"
#include "scsidata.h"
#include "scsi_ptm.h"
#include "scsi_error.h"
#include "scsiextrn.h"
#include "vreg.h"
#include "data_struct.h"

char *tbl0[] = {
	"t0:",
	"notape,",
	"not online,",
	"wrprot,",
	"eot,",
	"unrecov dataerr,",
	"noBIE,",
	"fm detect,",
};
char *tbl1[] = {
	"t1:",
	"illegal cmd,",
	"nodata detect,",
	"8 read retries,",
	"bot,",
	"resv,",
	"resv,",
	"reset/powerup,",
};

char err0[] = {
	0,TP_NOTAPE, TP_NRDY, TP_WPROT, TP_EOM, TP_DATER, TP_DATER, TP_FMD,
};
char err1[] = {
	0,TP_ILLCMD, TP_NDATA, TP_8RETRY, TP_BOM, 0,0,0,
};

ptapstat(dev)
register struct devq *dev;
{
	register char *ptr;

	ptr = (char *)tapdr[dev->q_devnum].tp_stat;
	printf ("ts=%x ",(*(short *)ptr) & 0xffff);

	/* print the tape status message */
	prtbl (*ptr++, tbl0);
	prtbl (*ptr, tbl1);
}


setrc ( dev, mask0, mask1 )
register struct devq *dev; register char mask0, mask1;
{
	register num; register char *ptr;

	ptr = (char *)tapdr[dev->q_devnum].tp_stat;
	*(short *)&dev->rc1 = 0;

	*ptr  = *ptr & mask0;
	*(ptr+1) = *(ptr+1) & mask1;

	num = 0;

	if ( (num = ckbyte (dev, *ptr++, num, err0)) == 2 )
		return;			/* error byte full */

	ckbyte (dev, *ptr, num, err1);
}
