h64367
s 00142/00000/00000
d D 1.1 91/03/26 07:49:30 root 1 0
c date and time created 91/03/26 07:49:30 by root
e
u
U
t
T
I 1

#	@(#)scsi.mk	6/30/88


include $(IROOT)/macdefs

SGS_ROOT	=	$(SGS_68000)

VERS	=	vers
VER	=	0x520
NAME	=	scsicode
SINC	=	.

#	special	rule for prom code, force .data become .text
NODATA	=	-Wa,-r 

# force no stack probe
NOSPRB	=	-W0,-sp
SHTWRD  =	-wnewfile

CFLAG	=	$(NOSPRB) $(NODATA) $(CFLAGS)

.SUFFIXES: .s .o .t .d .f .x 


COBJS	=	cmd.o  		disk.o 		disk_rw.o	seek.o	\
		initbd.o	message.o	pgchar.o	printf.o \
		interrupt.o	timer.o		menu.o \
		send_cmd.o	finreq.o


all install: $(NAME)

clean:

clobber: clean
	rm -f *.o $(NAME) *.map *.f *.t *.d

.c.o:
	$(CC) -c -I$(SINC)   $(CFLAG) $<

.s.o:
	$(AS) -r $(ASFLAGS) -o $@ $*.s

.x.s:
	$(CPP) -P -I. $< > $*.s

.x.o:
	$(CPP) -P -I. $< > $*.i
	$(AS) -r $(ASFLAGS)  -o $@ $*.i
	rm $*.i

# rule for bssdata.c (bss data)
.c.t:
	$(CC) -O -I$(SINC) $(NOSPRB) -c $*.c
	-ln -f $*.o $*.t

.c.d:
	$(CC) -DDOWN -I$(SINC) -c $(CFLAG) $*.c
	-ln -f $*.o $*.d

# ------------------------------------
# compile for archive tape & 9 track 
# ------------------------------------
.c.f:
	$(CC) -DARCH -DTRACK9 -I$(SINC) -c $(CFLAG) $*.c
	-ln -f $*.o $*.f



$(NAME):	int_vectors.o int_hndlrs.o printf.o main.o pgchar.o \
		console.o bssdata.t cmd.o interrupt.o message.o \
		disk_rw.o timer.o initbd.o misc.o math.o send_cmd.o \
		finreq.o disk_parse.o dkparse2.o tapeio.o  \
		tapesub.o raw_proc.o tape_parse.o ckreq.o  icbparse.o \
		disk_open.o
	$(LD) -o scsicode -m ld.file int_vectors.o int_hndlrs.o misc.o \
		main.o initbd.o disk_open.o printf.o pgchar.o console.o \
	        cmd.o interrupt.o message.o disk_rw.o timer.o \
	        send_cmd.o finreq.o math.o disk_parse.o dkparse2.o \
	        tapeio.o tapesub.o raw_proc.o tape_parse.o ckreq.o \
	        icbparse.o bssdata.t>scsicode.map
		date >> scsicode.map
		nm -xev scsicode >>scsicode.map
		strip scsicode
		size -x scsicode
	-../sapatch/sapatch -hv $(VER) $(NAME)

bssdata.t: \
		scsi.h \
		data_struct.h \
		vreg.h 

console.d:	scsi_ccpu.h \
		scsiextrn.h

disk.o: \
		scsi.h \
		scsi_ccpu.h \
		scsi_dtc.h \
		scsiextrn.h \
		data_struct.h 

int_vectors.o:	scsi.h \
		scsi_error.h \
		icbcmd.h

main.o: \
		scsi.h \
		scsi_ccpu.h \
		scsi_dtc.h \
		scsiextrn.h \
		data_struct.h  \
		vreg.h

initbd.o: 	scsi.h \
		scsi_ccpu.h \
		scsi_dtc.h \
		scsiextrn.h \
		icbcmd.h \
		data_struct.h \
		vreg.h

initdata.o:	hsdt.h \
		hsdtdisksect.h

interrupt.f: \
		devcmd.h \
		scsi.h \
		scsi_ccpu.h \
		scsi_dtc.h \
		scsierror.h \
		scsiextrn.h \
		data_struct.h 

timer.o: \
		scsi.h \
		scsi_ccpu.h \
		scsi_ptm.h 

int_vectors.o:	scsi_cpu.h

E 1
