#include "vreg.h"
#include "data_struct.h"
#include "scsi.h"
#include "disk_struct.h"
#include "scsiextrn.h"
#include "devcmd.h"
#include "commands.h"


/* Every element of the interim_processing_que enters this routine.

    Input: dev  -  pointer to the original request

    Output:  1 if no free requests are available
	     0 if everything is OK

    Purpose:  This routine gets a free request pointer and then decides
	whether the request can be handled as one chained request or
	must be broken into several smaller requests to the dtb.

*/


raw_proc(ip)
register struct interim_processing_que *ip;
{
	register struct devq *dev;
	register struct devq *dq;
	register struct mmutbl *m;
	static struct dkinf *dkptr;
	register unsigned short count;
	register unsigned short oldpri;


/* Check to see if the entire transfer is complete.  If it is, send the
   request back to the master cpu and clear the interim processing
   structure.
*/

	if(((ip->i_p_count) && (ip->i_p_count >= ip->i_p_first->q_count))||
	    ((ip->i_p_first->q_devtype & TAPE) && (ip->i_p_block == FINISHED)) 
	    || ((ip->i_p_first->q_devtype != TAPE) && 
	    *(short *)&ip->i_p_first->rc1)){
	        oldpri = spl6();
		dev = ip->i_p_first ;
		dev->q_count = (ip->i_p_count > dev->q_count) ? dev->q_count :
			ip->i_p_count;
		if((ip->i_p_first = dev->q_next) == (struct devq *)0)
			ip->i_p_last = (struct devq *)0;
		send_back(dev,1);
		ip->i_p_active = 0;
		ip->i_p_proc_count = -1;
		ip->i_p_count = 0;
		splx(oldpri);
		return;
	}

    /* get a free request */
	if(ip->i_p_proc_count != ip->i_p_first->q_count){

		oldpri = spl6();
		if((ip->i_p_first->q_devtype == TAPE) && (ip->freemem_first == (struct free_mem *)0)){
			splx(oldpri);
			return;
		}
		if((dev = ip->i_p_dqfirst) == (struct devq *)0){
			splx(oldpri);
			return;
		}
		ip->i_p_dqfirst = dev->q_next;
		splx(oldpri);
		bcopy(ip->i_p_first,dev,sizeof(struct devq));
		dev->q_next = (struct devq *)0;
		dev->q_mmu = (struct mmutbl *)0;
		dev->q_mem = (char *)0;
		dev->q_flag |= FREE_REQ;
		dev->q_devun.block = ip->i_p_block;
		dev->q_count = ip->i_p_first->q_count - ip->i_p_proc_count;


		if(chain_multiple(dev)){
			oldpri = spl6();
			if(ip->i_p_dqfirst)
				ip->i_p_dqlast->q_next = dev;
			else
				ip->i_p_dqfirst = dev;
			ip->i_p_dqlast = dev;
			dev->q_next = (struct devq *)0;
			splx(oldpri);
		}

	}


	return;

}

load_mmu(ip)
register struct interim_processing_que *ip;
{

	register struct devq *dev;
	register struct devq *fq;
	register struct dtb_que *dptr;
	register unsigned short oldpri;

	dev = ip->i_p_first;
	oldpri = spl6();
	if((fq = ip->i_p_dqfirst) == (struct devq *)0){
		splx(oldpri);
		return(1);
	}
	ip->i_p_dqfirst = fq->q_next;
	fq->q_next = (struct devq *)0;
	splx(oldpri);
	setbuf (fq, (sizeof(struct devq)) >>1, 0 );


	fq->q_flag = FREE_REQ|MAIN_TO_LOC;

#ifndef S90
	if((int)(dev->q_mmu)&3){
		fq->q_mem =  (char *)((int)(dev->q_mmu) & ~3);
		ip->i_p_mmutable->mmu1index = 1;
	}
	else{
		fq->q_mem = (char *)((int)dev->q_mmu-4);
		ip->i_p_mmutable->mmu1index = 2;
	}
#else

	fq->q_mem = (char *)((int)dev->q_mmu);
	ip->i_p_mmutable->mmu1index = 1;

#endif

	fq->local_mem = (struct free_mem *)&(ip->i_p_mmutable->mmu2index);
	fq->q_cmd = MWRITE;

	/* Figure out the number of pages that need to be transferred*/

#ifndef S90
 	fq->q_count = (((dev->q_count&~0xfff)>>11) +
     	    ((dev->q_count&0xfff) ? 2:0) +
	    (((int)dev->q_mmu & 3) ? 2:4) + ((dev->local_mem)?2:0));
	if(fq->q_count&2)
		fq->q_count +=2;	
#else
 	fq->q_count = (((dev->q_count&~0xfff)>>10) +
     	    ((dev->q_count&0xfff) ? 4:0) + (((int)(dev->local_mem)+((dev->q_count&0xfff) >= PAGESIZE))?4:0));
#endif


	fq->q_devtype = DTLBUF;
	fq->q_key = dev->q_key;

	dptr = &dtbque;

	oldpri = spl6();
	ip->i_p_mmutable->length1 = dev->q_count;
#ifndef S90
	ip->i_p_mmutable->length2 = (int)ip->i_p_mmutable+16;
#else
	ip->i_p_mmutable->length2 = (int)ip->i_p_mmutable+20;
#endif
	ip->i_p_mmutable->offset1 = (unsigned short)dev->local_mem;
	if(dptr->d_first)
		dptr->d_last->q_next = fq;
	else
		dptr->d_first = fq;

	dptr->d_last = fq;
	fq->q_next = (struct devq *)0;
	splx(oldpri);
}

/* 
   The maximum transfer count for the scsi chip is 0xffff bytes.
   This routine determines the number of sectors that can be transferred in
   a single request.
   For each of these requests, a free request is obtained, filled
   in with the proper infomation and placed on the peripheral device queue. 
   The amount processed is updated.  Only one set of requests is processed 
   on each cycle so that large raw requests do not monopolize the disk.
*/

chain_multiple(free_q)
register struct devq *free_q;
{
	register struct interim_processing_que *iptr;
	register struct mmutbl *mmu = ipque.i_p_mmutable;
	register int *update_counter;
	register int i;
	register unsigned short oldpri;
	struct dkinf *dkptr;

	iptr = &ipque;

	free_q->opr = iptr->i_p_first->opr;
	if(mmu->length1 > 0){
		free_q->q_mmu = (struct mmutbl *)(mmu->mmu1index);
		free_q->q_mem = (char *)(mmu->offset1);
		update_counter = &(mmu->length1);
	}
	else
		return(1);

	if(free_q->q_devtype == DISK){
		dkptr = drive_pointer_array[free_q->q_devnum];
		if(free_q->q_count > MAXIMUM_SINGLE_TRANSFER)
			free_q->q_count = MAXIMUM_SINGLE_TRANSFER;
		free_q->scnt = free_q->q_count>>10;
		free_q->totsleft = free_q->scnt;
		free_q->sectleft = free_q->scnt;
		free_q->q_flag |= (free_q->opr == READ) ? DK_TO_MAIN : MAIN_TO_DK;
		iptr->i_p_proc_count += free_q->q_count;

		bump_sector_mmu(iptr->i_p_first,free_q->scnt,dkptr);
		iptr->i_p_block = iptr->i_p_first->q_devun.block;
		*update_counter -= free_q->q_count;

		send_out_the_request(free_q);
		
	}
	else if(free_q->q_devtype & TAPE){
		if((free_q->q_count > BLKSIZE) && (free_q->q_devtype == TAPE))
			free_q->q_count = BLKSIZE;
		free_q->q_flag |= (free_q->q_cmd == LREAD) ? 
			NO_WAIT|TAPE_TO_LOC : NO_WAIT|MAIN_TO_LOC;
		
		adjmmu(free_q->q_count>>10,&(iptr->i_p_mmutable->mmu1index),
			&(iptr->i_p_mmutable->offset1));
		iptr->i_p_proc_count += free_q->q_count;
		*update_counter -= free_q->q_count;
		oldpri = spl6();
		if(*(short *)&iptr->i_p_first->rc1){
			splx(oldpri);
			return(1);
		}
		if(free_q->q_devtype == TAPE){
			if((free_q->local_mem=iptr->freemem_first)==(struct free_mem *)0){
				splx(oldpri);
				return(1);
			}
			iptr->freemem_first=iptr->freemem_first->fm_next;
			free_q->local_mem->fm_next = (struct free_mem *)0;
		}

/* If we are writing to the tape then first we must transfer data from main
   memory to our local buffer
*/
		if(free_q->q_cmd == LWRITE){
			if(dtbque.d_first)
				dtbque.d_last->q_next = free_q;
			else
				dtbque.d_first = free_q;
			dtbque.d_last = free_q;
		}
/* otherwise put the request on the tape que to extract data from the tape*/
		else{
			if(tapeque.t_first)
				tapeque.t_last->q_next = free_q;
			else
				tapeque.t_first = free_q;
			tapeque.t_last = free_q;
		}
		free_q->q_next = (struct devq *)0;
		splx(oldpri);
		
	}
	return(0);

	
}

bump_sector_mmu(dev,count,dkptr)
register struct devq *dev;
register unsigned short count;
register struct dkinf *dkptr;
{

	register unsigned char logdr;
	register struct ld *ldkptr;

	adjmmu(count,&(ipque.i_p_mmutable->mmu1index),&(ipque.i_p_mmutable->offset1));

	dev->q_devun.block += count;
		
}

