
/* The following are the one byte messages used to communicate between the
   initiator and the target.
*/

#define COMMAND_COMPLETE	0x0
#define SYNC_DATA_XFER		0x1
#define EXTENDED_MSG		0x1
#define SAVE_DATA_PTR		0x2
#define RESTORE_POINTERS	0x3
#define DISCONNECT_MSG		0x4
#define INITIATOR_DETECTED_ERROR 0x5
#define ABORT			0x6
#define MESSAGE_REJECT		0x7
#define NO_OP			0x8
#define MESSAGE_PARITY_ERR	0x9
#define BUS_RESET		0xc

/*
IDENTIFY BYTE has the following format (value 0x80 - 0xff)

-----------------------------------------------------------------
|       |       |       |       |       |       |       |       |
| 	|	|	|	|	|	|	|	|
-----------------------------------------------------------------
    |       |   |              		|_______________________|
    |       |   |			|	    |
    |	    |	|			| Logical unit number
    |	    |	|_______________________|
    |	    |	            |
    |	    |	         reserved
    |	    |
    |	0 - target should not disconnect
    |	1 - initiator can accomodate disconnection and reconnection
    |
 always set to indicate an identify byte

*/


#define IDENTIFY      0xc0
#define IDENTIFY_MSG  0x80




/* the following are the values found in the one byte status message returned by the drive */

#define GOOD_STATUS  	0
#define CHECK_COND	2	/*error, send a request sense to get details*/
#define BUSY_STAT	8	/*unit busy, reissue the command */
#define RESERV_CONFLICT  0x18	/*access already reserved by another SCSI 
				  device*/
