# ldiv  - long signed division
# lrem  - long signed remainder

# uldiv - long unsigned division
# ulrem - long unsigned remainder

# enter with d0 == dividend; 4(sp) == divisor

# return with result in d0.
# d1, a0 & a1 are blasted.

	text

ldiv%%:	global	ldiv%%		# quotient is negative if input signs differ
uldiv%%: global uldiv%%

				# dividend in d0
	mov.l	4(%sp),%d1	# get divisor in d1
	bsr.b	L%divide
	rts			# quoteint in d0

lrem%%:	global	lrem%%
ulrem%%: global	ulrem%%

	mov.l	4(%sp),%d1	# get divisor in d1
	bsr.b	L%divide
	mov.l	%d1, %d0
	rts			# remainder in d0

L%divide:

# ----------------------------------------------
# input:	d0 - dividend	d1 - divisor
#
# output:	d0 - quoteint	d1  -  remainder
# ----------------------------------------------

	movm.l	&0x3800,-(%sp)		# save d2,d3,d4
	clr.l	%d2			# clear remainder
	mov.l	&33,%d3			# bit count
	clr.l	%d4			# bit toggle no.

div10%:
	roxl.l	&1,%d0
	bchg	%d4,%d0
	roxl.l	&1,%d2
	bcs.b	div20%
	sub.l	&1,%d3
	beq.b	div90%
	sub.l	%d1,%d2
	bcc.b	div10%
	add.l	%d1,%d2
	bra.b	div10%
div20%:
	sub.l	&1,%d3
	beq.b	div90%
	sub.l	%d1,%d2
	or.l	%d2,%d2
	bra.b	div10%

div90%:
	roxr.l	&1,%d2
	mov.l	%d2,%d1
	movm.l	(%sp)+,&0x001c
	rts

	global	ldivrem
# ldivrem(dividend, divisor, &quotient, &remainder)
ldivrem:
	mov.l	4(%sp),%d0	# dividend
	mov.l	8(%sp),%d1	# divisor
	divu	%d1,%d0

	mov.l	12(%sp),%a0	# pointer to quoteint
	clr.l	%d1
	mov.w	%d0,%d1
	mov.l	%d1,(%a0)
	swap	%d0
	mov.w	%d0,%d1
	mov.l	16(%sp),%a0	# pointer to remainder
	mov.l	%d1,(%a0)
	rts	


# "@(#)lmul.s	2.1	";
# long multiply

	global	lmul%%

lmul%%:
	link	%fp,&0
	mov.l	%d2,%a0
	mov.l	%d3,%a1
	mov.w	%d0,%d2
	mov.w	%d0,%d1
	ext.l	%d1
	swap.w	%d1
	swap.w	%d0
	sub.w	%d0,%d1
	mov.w	10(%fp),%d0
	mov.w	%d0,%d3
	ext.l	%d3
	swap.w	%d3
	sub.w	8(%fp),%d3
	muls.w	%d0,%d1
	muls.w	%d2,%d3
	add.w	%d1,%d3
	muls.w	%d2,%d0
	swap.w	%d0
	sub.w	%d3,%d0
	swap.w	%d0
	mov.l	%a0,%d2
	mov.l	%a1,%d3
	unlk	%fp
	rts
