
#include "scsi_ccpu.h"
#include "scsi.h"
#include "devcmd.h"
#include "scsi_dtc.h"
#include "scsi_error.h"
#include "scsi_ptm.h"
#include "scsiextrn.h"
#include "vreg.h"
#include "data_struct.h"
#include "disksect.h"
#include "disk_struct.h"
#include "scsitape.h"
#include "scsi_mem_map.h"
#include "registers.h"
#include "commands.h"
#include "message.h"
#include "command_blk.h"
#include "scsidata.h"

#define NOCHAIN 	0
/* bit 27 of the IOA DTB channel status register, set if channel has data in
   the fifo, reset to zero if fifo is empty
 */
#define IOA_DTB_FIFO	0x08000000	


unsigned char cmd_buffer[] = {INQUIRY,0,0,0,0,0};

extern unsigned short burstid;
extern struct devq *getptr();
extern struct free_mem *getmem();

#define DTB_MASK (DTB_INT + CHNDMA_INT + DTBDMA_INT)

/* ************************************** */
/* icb interrupt service routine  LEVEL 1 */
/* ************************************** */

icbint() {
	/* insure it is icb interrupt from main cpu */
	if ( ICB_IBUSY == 0 )	 {
		printf ("i1");
		return;
	}

	icbdata = *ICB_IR;

	status_change |= ICB;
}


/* ************************************** */
/* tape interrupt service routine LEVEL 2 */
/* ************************************** */

tapeint() {
	register unsigned short stat;
	register struct devq *dev;

	stat = *TP_SR;
	enter_short_cr;

	if(tapeque.t_active == 0){
		dtc_ctl &= ~TAPEINT_EN;
		*DTC_CRL = dtc_ctl;
		exit_short_cr2;
		return;
	}



	if ( (stat &(TP_EXCPT | TP_READY))== 0 ) {
		exit_short_cr2;
		return;
	}

	/* READY may be true for the archive tape drive between 512 byte 
		blocks */

	if((dev = tapeque.t_first) == (struct devq *)0)
		return;

	if ( (tapdr[dev->q_devnum].tp_type & TP_ARCH) 
		&& ( stat & TP_READY ) && ((interrupt & TAPEDMA_INT)==0) ) {
		exit_short_cr2;
		return;
	}

	interrupt |= TAPE_INT;
	close_out_tape(dev);

	exit_short_cr2;
	return;
}



/* ******************************************* */
/* dtb & dma interrupt service routine LEVEL 4 */
/* ******************************************* */

dtbdmaint() {
	register struct dtb_que *dptr;
	register unsigned char status;
	register unsigned char value;
	register unsigned short oldpri;
	struct peripheral_que *pq_ptr;

	dptr=&dtbque;
	oldpri = spl6();;

if(PRINT3)
	printf("dma interrupt\n");
	if ( status=(*DTB_SR & (DTBRDSTAT|DTBSNDINT|DTBWRLAST|DTBRDLAST)) ) {

		*DTB_CR = (status << 8) | dtb_cr;
	/* check to see if the entire transfer has been completed */
		interrupt |= DTB_INT;

		if((dptr->dtb_active) && ((dptr->dtb_active & DISK)==0)){
			check_tape_completion(dptr->dtb_active&0xf);
			splx(oldpri);
			return;
		}

		else{
		    if(dptr->dtb_active){
		    	dptr->dtb_active |= DMA_DONE;
		    	cancel_dma(DK_TO_MAIN);
		    }
		}
		
		splx(oldpri);
		return;

	}
	status = *DBC_SR;	

	if((value = ((dbc_cr&CR_MASK) & status)) == 0){
		splx(oldpri);
		return;
	}

	if(value == DDC_EN){
		dptr->dtb_active |= DMA_DONE;
		cancel_dma(DK_TO_LOC);
	}
	else{

		dbc_cr &= ~value;
		*DBC_CR = dbc_cr;
		interrupt |= (value&CR_MASK);
		if((value & 0xf0) && dptr->dtb_active)
			check_tape_completion(dptr->dtb_active&0xf);
	}

	splx(oldpri);

}

/* ************************************** */
/* scsi 1 interrupt service routine LEVEL 6 */
/* ************************************** */

scsi_int()
{

	register struct scsiwr *wr;
	register struct dtb_que *dptr;
	register struct peripheral_que *pq_ptr;
	struct scsird *rd;
	unsigned char drive;


	rd = (struct scsird *)SCSI_1;
	wr = (struct scsiwr *)SCSI_1;
	dptr = &dtbque;
	pq_ptr = &periph_que;
	drive = last_drive;

	scsi_handler(rd,wr,dptr,pq_ptr,drive);


}

/* ************************************** */
/* scsi 2 interrupt service routine LEVEL 5 */
/* ************************************** */

scsi1_int()
{

	register struct scsiwr *wr;
	register struct dtb_que *dptr;
	register struct peripheral_que *pq_ptr;
	unsigned char drive;
	unsigned short oldpri;
	struct scsird *rd;


	oldpri = spl6();

	rd = (struct scsird *)SCSI_2;
	wr = (struct scsiwr *)SCSI_2;
	dptr = &dtbque;
	pq_ptr = &periph1_que;
	drive = last_drive1;

	scsi_handler(rd,wr,dptr,pq_ptr,drive);

	splx(oldpri);

}

scsi_handler(rd,wr,dptr,pq_ptr,last_drive_used)
struct scsird *rd;
register struct scsiwr *wr;
register struct dtb_que *dptr;
register struct peripheral_que *pq_ptr;
unsigned char last_drive_used;
{

	register struct periph_table *p_ptr;
	register unsigned char status,int_status,sequence;
	register unsigned char unit_stat;
	unsigned char message_byte;
	unsigned char throw_away;
	struct devq *dev;
	char *mem;

	unsigned char cmd_reg;
	unsigned char fifo_flags;
	unsigned char discon;
	unsigned int i,amount_left;
	static unsigned char first;
	unsigned char *cptr;
	int timeout;


	/*first read the status register*/

	status = rd->status;

	/* then read the sequence step register to be used later to get more
	   details if there are problems
	*/


	sequence = rd->seq_step;
	fifo_flags = rd->fifo_flag;

	cmd_reg = rd->command;

	/* then read/clear the interrupt status register */

	int_status = rd->interrupt;

if (PRINT3)
	printf("status %x int status %x seq %x command reg %x fifo flags %x\n",status,int_status,sequence,cmd_reg,fifo_flags);


	/* get the request that has the bus now */

	p_ptr = &pq_ptr->pt[pq_ptr->bus_id];


/* First check for errors from the chip */

	if(status&(GROSS_ERR|PARITY)){
	    if(status&GROSS_ERR){
		wr->command = SET_ATN;
		next_message = ABORT;
	    }
	    else printf("parity error\n");
/*
	    else {
	      wr->command = SET_ATN;
	      if(cmd_reg == XFER_INFO_D){
		if(dptr->d_first->retry++ >= RETRY){
		    dptr->d_first->rc1=DER_BAD_PARITY;
		   if((dptr->d_first = dptr->d_first->q_next) == 0)
			dptr->d_last = 0;
		    dptr->d_first->q_next = p_ptr->p_first;
		    dptr->dtb_active|=TRANSFER_DONE;
		    p_ptr->p_first = dev;
		    cancel_dma(dptr->d_first->q_flag);
		    canceldmc();
		    next_message = ABORT;
		}
		else{
			p_ptr->p_first->rc1 = DER_PARITY;
			next_message = INITIATOR_DET_ERROR;
		}
	      }
	      else{
		    next_message = MESSAGE_PARITY_ERR;
	      }
	    }
*/
	    return;
	}

	if((int_status == FUNCTION_COMPLETE) || (int_status&BUS_SERVICE)){
		/* send out the next command */
		switch(status&BUS_PHASE){
			case MESSAGE_IN:
			    if(cmd_reg == XFER_INFO_D ){
				dev = dptr->d_first;

				if((dptr->d_first = dev->q_next)==0)
					dptr->d_last = 0;
				if((dev->q_next = p_ptr->p_first) == 0)
					p_ptr->p_last = dev;
				p_ptr->p_first=dev;
				dptr->request_removed = dev;

				amount_left=((rd->xferhi<<8)|rd->xferlo);
				if(fifo_flags){
				    wr->command = FLUSH_FIFO;
			    	    dt_control |= READ_REMAINDER;
			    	    *(DT_CTRL_REG) = dt_control;
				    amount_left += fifo_flags;
				    fifo_flags = 0;
				}
				if(dev->q_mmu){
					last_mmu = dev->q_mmu;
					last_mem = dev->q_mem;
					i = (unsigned int)(dev->q_mem);
					i += (p_ptr->next_byte_count - amount_left);
					dev->q_mem = (char *)(i&0xfff);
					if ( i >= PAGESIZE ) 
						dev->q_mmu = (struct mmutbl *)((i >> 12 ) + (int)dev->q_mmu);
				}
				else{
				    last_mem = dev->q_mem;
#ifndef S90
				    p_ptr->next_mem_ptr = (char *)((int)dev->q_mem + (dev->q_count - amount_left));
#else
				    i = ((dev->q_count - amount_left)>>4)&0xff;
				    p_ptr->next_mem_ptr += i;
#endif
				}
				last_count = p_ptr->next_byte_count;
		    		p_ptr->next_byte_count = amount_left;
				if(amount_left){
#ifdef S90
			       /*check bit 27 to flush fifo data,for read only*/
				  if (dev->q_flag & DK_TO_MAIN) {
				    timeout = TIMEOUT;
				    for (i = 0 ; i < 0x10 ; i++){
				      if((check_dtb_status() & IOA_DTB_FIFO)==0){
						timeout = 0;
						break;
				      }
				    }
				    if (timeout) printf("flush ioa time out\n");
				  }
#endif
				  canceldmc();
				  dptr->dtb_active|=TRANSFER_DONE;
				}
				else
				    dptr->dtb_active |= SCSI_DONE;
				cancel_dma(dev->q_flag);

			    }
			    if(cmd_reg == I_CMD_CMPLT){
			     /*read the status byte */
			        unit_stat = rd->fifo;
			        message_byte = rd->fifo;
if(PRINT3)
				printf("us %x mb %x\n",unit_stat,message_byte);
			        if(message_byte == COMMAND_COMPLETE){
				    p_ptr->p_first->rc2 = unit_stat;
				    p_ptr->p_first->q_message = message_byte;
				}
				else if(unit_stat == SAVE_DATA_PTR){
				    p_ptr->p_first->q_message=message_byte;
				}
			        wr->command = MSG_ACCEPTED;
			    	return;
			    }
			   
/* This is just a kludge for now to take care of setting up sync/async transfers
   Some drives will give an error if all of the bytes in an extended message
   are not in the chip fifo and sent with one transfer information command. 
   Other drives do not support extended messages and therefore, will send a
   message reject after receiving the first message byte, leaving the rest of
   the bytes in the fifo. 
*/
			   if(fifo_flags > 2){
				wr->command = FLUSH_FIFO;
				fifo_flags = 0;
			   }
			    
			    if(fifo_flags){
				message_byte = rd->fifo;
				p_ptr->p_first->q_message = message_byte;
if(PRINT3)
				printf("message %x\n",message_byte);
					
			        switch(message_byte){
				    case COMMAND_COMPLETE:
					if(rd->fifo_flag)
					    unit_stat = rd->fifo;
					wr->command = MSG_ACCEPTED;
					break;
				    case EXTENDED_MSG:
/* first check to see if this message is in response to something that we have
   sent out or if the target is sending us this on its own 
*/
				        if(p_ptr->p_first->q_cmd!=SET_HOST_XFER){					
			/*if it's not ours, get in the four bytes and reject the
			negotiation
			*/
					    next_message = MESSAGE_REJECT;
					    wr->command = SET_ATN;
					}
					else{
					    first = 1;
			    		    wr->command = MSG_ACCEPTED;
					    cur_command=(unsigned int *)cmd_buffer;
					}
				        dptr->d_first = dptr->d_last = p_ptr->p_first;
				        if((p_ptr->p_first = p_ptr->p_first->q_next)==0)
					    p_ptr->p_last = 0;

				        dptr->d_last->q_next = 0;
					dptr->dtb_active = DISK;
					*setup_buf = message_byte;

			        	set_local_dma(dptr->d_first,4,SCSI_TO_MEM);
					wr->command = NOP;
					wr->command = XFER_INFO_D;
					break;
				    case SAVE_DATA_PTR:
					wr->command = MSG_ACCEPTED;
					break;
				    case RESTORE_POINTERS:
			    		wr->command = MSG_ACCEPTED;
		    			if(p_ptr->next_byte_count == p_ptr->p_first->q_count){
					    first = 1;
					}
					else{
					    if(p_ptr->p_first->q_mmu){
						p_ptr->p_first->q_mmu=last_mmu;
						p_ptr->p_first->q_mem=last_mem;
					    }
					    else
						p_ptr->next_mem_ptr = last_mem;
					    p_ptr->next_byte_count=last_count;
					}
					break;
				    case DISCONNECT_MSG:
			    		wr->command = MSG_ACCEPTED;
					p_ptr->p_first->q_message = message_byte;
					break;
				    case ABORT:
			    		wr->command = MSG_ACCEPTED;
					break;
				    case MESSAGE_REJECT:
					first = 1;
					cur_command=(unsigned int *)cmd_buffer;
					p_ptr->p_first->rc2 = message_byte;
					p_ptr->p_first->q_message = 0;
					p_ptr->next_byte_count = 0;
			    		wr->command = MSG_ACCEPTED;
					next_message = NO_OP;
					break;
				    default:
					printf("invalid message byte %x\n",message_byte);
					break;
			        }
			    }
			    else{
				if(cmd_reg == XFER_INFO_D){
				    if(p_ptr->p_first->q_cmd == SET_HOST_XFER){
					wr->command = MSG_ACCEPTED;
				    }
				    else if(p_ptr->p_first->q_cmd == SET_TGT_XFER){
					wr->command = SET_ATN;
					next_message = MESSAGE_REJECT;
					return_mem(p_ptr->p_first->local_mem);
					p_ptr->p_first = p_ptr->p_first->q_next;
					p_ptr->next_byte_count = p_ptr->p_first->q_count;
					return_ptr(p_ptr->p_first);
					
				    }
				    else
					wr->command = I_CMD_CMPLT;
				}
				else{
					wr->command = NOP;
			        	wr->command = XFER_INFO;
				}
			    }
			    break;
			case STATUS:
			     /*send a request for command complete
				and check the information */
			    if(cmd_reg == XFER_INFO_D ){
if(PRINT2)
			    	printf("transfer count %x\n",(rd->xferhi<<8)|rd->xferlo);
				dev = dptr->d_first;

			    	if(dev->q_count&3){
if(PRINT3)
					printf("read_remainder\n");

			    		dt_control |= READ_REMAINDER;
			    		*(DT_CTRL_REG) = dt_control;
			    		dt_control &= ~READ_REMAINDER;
			    		*(DT_CTRL_REG) = dt_control;
			    	}


				if((dptr->d_first = dev->q_next)==0)
					dptr->d_last = 0;
				if((dev->q_next = p_ptr->p_first) == 0)
					p_ptr->p_last = dev;
				p_ptr->p_first=dev;
				dptr->request_removed = dev;


				amount_left=((rd->xferhi<<8)|rd->xferlo);
				if(dev->q_mmu){
					i = (unsigned int)(dev->q_mem);
					i += (p_ptr->next_byte_count - amount_left);
					dev->q_mem = (char *)(i&0xfff);
					if ( i >= PAGESIZE ) 
						dev->q_mmu = (struct mmutbl *)((i >> 12 ) + (int)dev->q_mmu);
				}
				else{
#ifndef S90
				    p_ptr->next_mem_ptr = (char *)((int)dev->q_mem + (dev->q_count - amount_left));
#else
				    i = ((dev->q_count - amount_left)>>4)&0xff;
				    p_ptr->next_mem_ptr += i;
#endif
				}
		    		if((p_ptr->next_byte_count = amount_left) !=0){
#ifdef S90
			       /*check bit 27 to flush fifo data,for read only*/
				  if (dev->q_flag & DK_TO_MAIN) {
				    timeout = TIMEOUT;
				    for (i = 0 ; i < 0x10 ; i++){
				      if((check_dtb_status() & IOA_DTB_FIFO)==0){
						timeout = 0;
						break;
				      }
				    }
				    if (timeout) printf("flush ioa time out\n");
				  }
#endif
				  canceldmc();
				  dptr->dtb_active |= TRANSFER_DONE;
				}
				else
					dptr->dtb_active |= SCSI_DONE;
				cancel_dma(dev->q_flag);


			    }
			    wr->command = I_CMD_CMPLT;
			    break;
			case DATA_OUT:
			    if(p_ptr->next_byte_count == 0){
				dev = p_ptr->p_first;
				if(++dev->retry >= RETRY){
				    dev->rc1 = DER_TIMEOUT;
				    dev->q_count = 0;
				    clear_periph_que(dev,p_ptr);
				    send_back(dev,1);
				    last_ditch_recovery(dev);
				}
				else{
				    last_ditch_recovery(dev);
			            break;
			        }
			    }
			    else if(p_ptr->p_first->rc2){
			        printf("status error %x\n",p_ptr->p_first->rc2);
			        break;
			    }
			    else {

				if(dptr->d_first){
				    dptr->d_last->q_next = p_ptr->p_first;
				    dptr->d_last = p_ptr->p_first;
			        }
			        else
				    dptr->d_first = dptr->d_last = p_ptr->p_first;
				if((p_ptr->p_first = p_ptr->p_first->q_next)==0)
					p_ptr->p_last = 0;

				dptr->d_last->q_next = 0;

				if(dptr->dtb_active  == 0){
				    if(dptr->d_first->q_devtype == DISK)
				        dptr->dtb_active = (dptr->d_first->q_devtype|((dptr->d_first->q_devnum<NUMBER_OF_DEVICES)?FIRST_QUE : SECOND_QUE));
				    else
					dptr->dtb_active = dptr->d_first->q_devtype;
			            dtb_proc(dptr->d_first);
				}
			    }
				
			    break;
			case DATA_IN:

				if(dptr->d_first){
				    dptr->d_last->q_next = p_ptr->p_first;
				    dptr->d_last = p_ptr->p_first;
			        }
			        else
				    dptr->d_first = dptr->d_last = p_ptr->p_first;
				if((p_ptr->p_first = p_ptr->p_first->q_next)==0)
					p_ptr->p_last = 0;
				dptr->d_last->q_next = 0;
				if(dptr->dtb_active  == 0){
				    if(dptr->d_first->q_devtype == DISK)
				        dptr->dtb_active = (dptr->d_first->q_devtype|((dptr->d_first->q_devnum<NUMBER_OF_DEVICES)?FIRST_QUE : SECOND_QUE));
				    else
					dptr->dtb_active = dptr->d_first->q_devtype;
			            dtb_proc(dptr->d_first);
				}

			    break;
			case MESSAGE_OUT:
			    if(next_message){
				if(next_message != NO_OP)
				    wr->fifo = IDENTIFY;
			    	wr->fifo = next_message;
			        next_message = 0;
			    }
			    wr->command = NOP;
        		    wr->command = XFER_INFO;
			    break;
			case COMMAND:
			    if(first){
			        wr->command = NOP;
				cptr = (unsigned char *)cur_command;
				if(*cptr&0xe0) 
				    first = TEN_BYTE_CDB_SIZE;
				else
				    first = SIX_BYTE_CDB_SIZE;
				for(i=0;i<first;i++,cptr++)
					wr->fifo = *cptr;
        		    	wr->command = XFER_INFO;
				first = 0;
			    }
			    break;
			default:
			    printf("not a valid bus phase\n",status&BUS_PHASE);

		}
	}
	else if (int_status&DISCONNECT){
if(PRINT3)
		printf("disconnect\n");

		if(cmd_reg == MSG_ACCEPTED){
		    if(p_ptr->p_first->q_message == COMMAND_COMPLETE){ 
			finreq(p_ptr->p_first);
	        	waiting = 1;
		    }
		}
		else{
if(PRINT2)
			printf("fifo_flag %x\n",fifo_flags);
			if(fifo_flags){
				while(fifo_flags--)
				    discon = rd->fifo;
			}
			if((sequence&7) == 0){
				p_ptr->p_first->rc1 = DER_NRDY;
				finreq(p_ptr->p_first);
			}
		}
		pq_ptr->bus_id = NO_ONE_ON_THE_BUS;
		wr->command = ENAB_SEL_RESEL;
		check_for_completion(dptr,pq_ptr);

		return;
	}
	else if(int_status&RESELECTED){
	       	unit_stat = rd->fifo;
		message_byte = rd->fifo;

		if(rd->fifo_flag){
			fifo_flags = rd->fifo_flag;
			for(i=0;i<fifo_flags;i++)
				throw_away = rd->fifo;
			pq_ptr->periph_active &= ~(U_L_BIT(last_drive_used));
		}
if(PRINT3)
		printf("reselect: bus id %x message %x\n",unit_stat,message_byte);
		i=0;
		while(i< NUMBER_OF_DEVICES){
			if(((unit_stat&0x7f)>>i) == 1)
				break;
			i++;
		}
		if(pq_ptr->bus_id != NO_ONE_ON_THE_BUS){
			pq_ptr->periph_active &= ~(U_L_BIT(pq_ptr->bus_id));
		}
		pq_ptr->bus_id = i;
			
	    	wr->command = MSG_ACCEPTED;
	}
	else if(int_status&SELECTED){
		printf("selected\n");
	}
	else if(int_status&SELECTED_ATN){
		printf("selected with attn\n");
	}
	else if(int_status&ILL_CMD){
		if(rd->fifo_flag){
			fifo_flags = rd->fifo_flag;
			for(i=0;i<fifo_flags;i++)
				throw_away = rd->fifo;
		}
		if(pq_ptr->periph_active & (BIT(last_drive_used))){
			pq_ptr->periph_active &= ~(U_L_BIT(last_drive_used));
			if(pq_ptr->scsi_periph_ptr == 0)
				pq_ptr->scsi_periph_ptr = &pq_ptr->pt[last_drive_used];
		}
	}
	else if(int_status&SCSI_RESET){
		printf("scsi reset\n");
	}
	else
		printf("invalid interrupt status %x\n",int_status);
}
				    

close_out_tape(dev)
register struct devq *dev;
{
	register struct tp *taptr;
	register struct dtb_que *dptr;
	register struct interim_processing_que *iptr;
	struct mmutbl * mmu;
	register short mmu_value;



	dtc_ctl &= ~TAPEINT_EN;
	*DTC_CRL = dtc_ctl;

	dbc_cr &= ~TP_EN;
	*DBC_CR = dbc_cr;

	taptr = &tapdr[dev->q_devnum];
	iptr = &ipque;

	tapeque.t_active = 0;

	/* *********************** */
	/* turn off TICK for tape */
	tapeque.t_tick = 0;
	/* *********************** */
	if ( dev->q_flag & NO_WAIT) {

		/* ************************************* */
		/* ************************************* */
		/* take care of archive tape and 9 track */
		/* ************************************* */
		/* ************************************* */
		if ( taptr->tp_type & TP_ARCH ) {
			ckarchtape(dev);
		/* ************************************************ */
		/* return tape status in dev->sectleft          */
		/* ************************************************ */
			if(ipque.i_p_first)
			    *((short *)&ipque.i_p_first->sectleft)= *((short *)taptr->tp_stat);
		}


		/* disable tape dma enable bit */
		interrupt &= ~(TAPEDMA_INT | TAPE_INT);

		/* ********************************** */
		/* we are finished with this tape operation */
		/* ********************************** */


		if ( (dev->q_cmd == TPREAD) && (int)dev->q_count>0 ) {
			/* put the request on the dtb queue to be transferred
			   to the master */
			if((dev->q_count&~3) == 0){

	/* If we are reading for a non long word count, and that count
	is less than one long word in length, we must put
	the address of the final bytes in the 'q_mem' slot of the
	response so that the master can transfer them. The actual bytes are
	placed in the 'q_mmu' slot of the response
	*/
			   	iptr->i_p_first->q_mem = (char *)
				    (((iptr->i_p_mmutable->mmuslots[(short)dev->q_mmu]
					<<12) | (int)(dev->q_mem)));

				
				iptr->i_p_first->local_mem = (struct free_mem *)
					(*(int *)(((int)dev->local_mem->fm)));
				if((tapeque.t_first = dev->q_next) == 
					(struct devq *)0)
					tapeque.t_last = (struct devq *)0;
				iptr->i_p_count += dev->q_count;
				iptr->i_p_block = FINISHED;
				*((short *)&iptr->i_p_first->sectleft)= *((short *)taptr->tp_stat);
				send_back(dev,1);
				return;
			}

			dev->q_flag &= ~TAPE_TO_LOC;
			dev->q_flag |= LOC_TO_MAIN;
			dptr = &dtbque;
			if((tapeque.t_first = dev->q_next) == (struct devq *)0)
				tapeque.t_last = (struct devq *)0;
			if(dev->rc1){
			    *(short *)&iptr->i_p_first->rc1= *(short *)&dev->rc1;
			    *((short *)&iptr->i_p_first->sectleft)= *((short *)taptr->tp_stat);
			    clean_up_que(dev,0);
			}

			if ( dptr->d_first ) 
				dptr->d_last->q_next = dev;
			else
				dptr->d_first = dev;
			dptr->d_last = dev;
			dev->q_next = 0;

			return;
		}
		else if((int)dev->q_count < 0)
			dev->q_count = 0;

		/* *************************** */
		/* 1 tape write                */
		/* 2 tape read with no data    */
		/* 3 tape position cmd         */
		/* send request back to the master cpu */
		/* *************************** */


		/* ********************************** */
		/* free up tape for next tape request */
		/* ********************************** */

		if(burstid){
			*(unsigned short *)&iptr->i_p_first->sectleft = burstid;
			burstid = 0;
		}
		if((dev->q_cmd == TPWRITE) || (dev->q_cmd == TPREAD)){
			iptr->i_p_count += dev->q_count;
			if(dev->rc1){
				clean_up_que(dev,0);
				iptr->i_p_block = FINISHED;
				*(short *)&iptr->i_p_first->rc1= *(short *)&dev->rc1;
				*((short *)&iptr->i_p_first->sectleft)= *((short *)taptr->tp_stat);
				return;
			}
			if(dev->q_devtype == TAPE)
				return_to_free(dev,iptr);
		}
		if((tapeque.t_first = dev->q_next) == (struct devq *)0)
			tapeque.t_last = (struct devq *)0;

		send_back (dev,1);

	}

}
/* This routine is called when we either have an error or hit a file mark
when reading the tape.  Since there are usually several requests for the
tape queued up, it is necessary to remove all of the requests for this
device from the queue, put them back on the free request queue and free
up the local memory that they are using.
After all of this is done, it is also possible that some requests for this
drive completed the tape requests properly and were place on the dtb queue
but the data has not yet been transferred to main memory.  In this situation,
we will assume that the dtb transfer will complete so we must get the
byte count from these requests to pass on up with the tape request to which
they belong.
*/

clean_up_que(dev,dtb_error)
register struct devq *dev;
register unsigned short dtb_error;
{
	register struct interim_processing_que *iptr;
	register struct devq *que_ptr,*prev,*next;
	register struct devq *last_que_ptr = (struct devq *)0;
	register struct tape_que *tape_ptr;
	unsigned char first_new_device = 1;

	tape_ptr = &tapeque;

	if(dev->q_devtype & TAPE){
		que_ptr = tape_ptr->t_first;
		iptr = &ipque;

		while(que_ptr){  
	    	    	if(que_ptr->q_devnum == dev->q_devnum){
				if(iptr->i_p_dqfirst)
					iptr->i_p_dqlast->q_next = que_ptr;
				else
					iptr->i_p_dqfirst = que_ptr;
				iptr->i_p_dqlast = que_ptr;
				if(que_ptr->q_devtype == TAPE)
					return_to_free(que_ptr,iptr);
		    	}
		    	else{ 
				if(first_new_device){
					first_new_device = 0;
					tape_ptr->t_first = que_ptr;
					last_que_ptr = que_ptr;
		        	}
				else{
					last_que_ptr->q_next = que_ptr;
					last_que_ptr = que_ptr;
				}

		    	}
		    	    que_ptr = que_ptr->q_next;
		    	    iptr->i_p_dqlast->q_next = (struct devq *)0;
		}
		if(tape_ptr->t_first->q_devnum == dev->q_devnum)
			tape_ptr->t_first = (struct devq *)0;
		tape_ptr->t_last = last_que_ptr;
		if(last_que_ptr)
			last_que_ptr->q_next = (struct devq *)0;
	}

	/* Now check the dtb queue */
	
	prev = dtbque.d_first;
	for((que_ptr = dtbque.d_first);que_ptr;que_ptr=next){
		next=que_ptr->q_next; /* keep place */
		if(que_ptr->q_key == dev->q_key){
		      if((dev->q_cmd == TPWRITE) || dtb_error) {
			    if((dtbque.d_first==que_ptr)&&(dtbque.dtb_active)){
				que_ptr->q_flag |= TAPE_CMPLT;
				prev = que_ptr;
				continue;
		            }
			    else {
			         if (prev != que_ptr){
			   	     if ((prev->q_next=que_ptr->q_next) ==
						(struct devq *)0)
					    dtbque.d_last = prev;
			         }
		                 else
				     if (que_ptr->q_next){
					dtbque.d_first = next;
					prev = next;
			             }
				     else
				        dtbque.d_first = dtbque.d_last =
							(struct devq *)0;
		           }
		     send_back(que_ptr,1);
		     return_to_free(que_ptr,iptr);
		     }
		     else
			prev = que_ptr;
		}
	        else
		    prev = que_ptr;
	}
}

return_to_free(dev,ip)
register struct devq *dev;
register struct interim_processing_que *ip;
{

       if(ip->freemem_first)
		ip->freemem_last->fm_next = dev->local_mem;
       else
	    	ip->freemem_first = dev->local_mem;

       ip->freemem_last = dev->local_mem;
       dev->local_mem->fm_next = (struct free_mem *)0;

}

check_for_completion(dptr,pq_ptr)
register struct dtb_que *dptr;
struct peripheral_que *pq_ptr;
{

	register struct periph_table *p_ptr;
	register struct devq *dev;


	struct scsird *rd;

	if((dptr->dtb_active == 0) &&  dptr->d_first) {
	    if(dptr->d_first->q_devtype == DISK)
	        dptr->dtb_active = (dptr->d_first->q_devtype|((dptr->d_first->q_devnum<NUMBER_OF_DEVICES)?FIRST_QUE : SECOND_QUE));
	    else
		dptr->dtb_active = dptr->d_first->q_devtype;
	    	dtb_proc(dptr->d_first);
	}

	pq_ptr = &periph1_que;
	if(pq_ptr->bus_id == NO_ONE_ON_THE_BUS)
		look_for_more_work(pq_ptr);
	pq_ptr = &periph_que;
	if(pq_ptr->bus_id == NO_ONE_ON_THE_BUS)
		look_for_more_work(pq_ptr);

}


check_tape_completion(type)
unsigned char type;
{
	
	register struct devq *dev;
	register struct dtb_que *dptr;
	register struct tp *taptr;
	register struct interim_processing_que *ip;

	dptr = &dtbque;
	ip = &ipque;
	dev = dptr->d_first;

	if (  (interrupt & DTB_MASK) == DTB_MASK ) {
	    dptr->dtb_active = 0;
	    dptr->d_tick = 0;

	    if(type & TAPE){
		/* interrupts are disabled, tape req is finished sending or 
			receiving data from main memory
		if tape read, then put req on the response que, inturpt 
			master cpu, then check for any pending disk io 
		if tape write, start the tprw, if error, then put
			req on the response que, interrupt the master cpu, 
			then check for any pending disk io */


		/* *************************** */
		/* take care of archive & 9 track */
		/* *************************** */

		taptr = &tapdr[dev->q_devnum];

		if ( dev->q_cmd == TPREAD ) {

if (PRINT4) printf("<<TAPE>>");

		    if(dev->q_devtype == TAPE){
			return_to_free(dev,ip);
			if(dev->rc1){
				ip->i_p_block = FINISHED;
				*(short *)&ip->i_p_first->rc1= *(short *)&dev->rc1;
			}
		    }
			
		    if((!(dev->rc1)) && (ip->i_p_first->q_devtype ==
			dev->q_devtype)){
			if(dev->q_devtype == TAPE9)
				ip->i_p_block = FINISHED;
		    }
		    ip->i_p_count += dev->q_count;
		    *((short *)&ip->i_p_first->sectleft)= *((short *)taptr->tp_stat);

#ifdef S90
	    	    if ((dev->rc1 == 0) && (dev->rc2 == 0))
	        		quickread(dev);
#endif
		    send_back (dev,0);
		}	
		else {

			dev->retry = 0;
			if(dev->q_flag & TAPE_CMPLT){
			    return_to_free(dev,ip);
			    send_back(dev,0);
			    return;
			}
				
			if((dptr->d_first = dev->q_next) == (struct devq *)0)
				dptr->d_last = (struct devq *)0;
			dev->q_flag &= ~MAIN_TO_LOC;
			dev->q_flag |= LOC_TO_TAPE;
			if(tapeque.t_first)
				tapeque.t_last->q_next = dev;
			else
				tapeque.t_first = dev;
			tapeque.t_last = dev;
			dev->q_next = 0;

		}
	    }
	    else if(type & DTLBUF){
		ipque.i_p_active |= MMUTABLE_IN;
		ipque.i_p_mmutable->length2 = -1;
		send_back(dev,0);
		
	    }
	}

}

blkyellow()
{	
	if ( (dtc_ctl & 0x03) != yellowlit )
		LIGHT (yellowlit);
	else
		LIGHT (ledoff);
}
 
look_for_more_work(pq_ptr)
register struct peripheral_que *pq_ptr;
{

	register struct periph_table *p_ptr;
	register i;
	register unsigned char drive;
	struct devq *dev;
	unsigned char sent_already = 0;


    	if(pq_ptr->scsi_periph_ptr){
		dev = pq_ptr->scsi_periph_ptr->p_first;
		drive = (pq_ptr == &periph_que) ? dev->q_devnum : dev->q_devnum-NUMBER_OF_DEVICES;
		if(pq_ptr->periph_active&BIT(drive)){
			pq_ptr->scsi_periph_ptr = 0;
			return;
		}
		if(diskrw(dev)){
			return;
		}
		p_ptr = &pq_ptr->pt[drive];
		sent_already = 1;
	}
	else{
		p_ptr = pq_ptr->pt;
	}

	for(i=0;i<NUMBER_OF_DEVICES;i++){
		p_ptr = p_ptr->next_periph_ptr;
		if(p_ptr->p_first){
		    drive = (pq_ptr == &periph_que) ? p_ptr->p_first->q_devnum : p_ptr->p_first->q_devnum-NUMBER_OF_DEVICES;
		    if((pq_ptr->periph_active&BIT(drive)) == 0){
    			pq_ptr->scsi_periph_ptr = p_ptr;
    			break;
		    }
		}
	}
	if(i == NUMBER_OF_DEVICES)
		pq_ptr->scsi_periph_ptr = 0;
	else{
	    if(!(sent_already) && !(pq_ptr->periph_active)){
		if(pq_ptr->scsi_periph_ptr)
	        	diskrw(pq_ptr->scsi_periph_ptr->p_first);
	    }
	}

}


ckarchtape(dev)
register struct devq *dev;
{
	register b0, b1;

	if ( (dev->opr == TREAD) || (dev->opr == TWRITE) ) {
		/*  assume that the tapedma is finished,followed by tapeint */
		/* check to see if the tape has any error, set the return code*/
		/* see if the tape drive timed out */
		if ( cktaperw(dev) ) {
			dev->q_count=dev->q_count-(*TP_DMAE+1- *TP_DMAS);
			if ( (dev->rc1 == TP_EOM) || (dev->rc2 == TP_EOM) )
				dev->q_count--;
			else if((dev->q_count & (TAPEBLK-1)) || ((dev->q_count == 0) && (dev->rc1 == 0)))
				dev->rc1=TP_ILLCMD;
			if ( PRINT1 )
				printf("RWEX(%x)",dev->q_count); 
		}
	}

	else {
		/* rewind, tension, erase, Q11/Q24 commands */
		/* read file mark, write file mark */

		if ( ckexcpt (dev) )
			return;		/* tape hung or power fail */

		if ( dev->opr == TRFM ) {
			b0 = TRFM_M0;
			b1 = TRFM_M1;
		}
		else if ( dev->opr == TWFM ) {
			b0 = TWFM_M0;
			b1 = TWFM_M1;
		}  
		else {
			b0 = T_M0;
			b1 = T_M1;
		}
		setrc ( dev, b0, b1 );
	}
	return;
}

