

#include "scsi_ccpu.h"
#include "scsi_dtc.h"
#include "command_blk.h"
#include "commands.h"
#include "mode_sns_pg.h"
#include "scsi_mem_map.h"
#include "scsi.h"
#include "message.h"
#include "scsiextrn.h"
#include "error.h"
#include "vreg.h"
#include "data_struct.h"
#include "scsi_error.h"
#include "scsi_ptm.h"
#include "disk_struct.h"


finreq(dev)
register struct devq *dev;
{

	register struct periph_table *p_ptr;
	register struct peripheral_que *pq_ptr;
	register struct devq *dev1;
	register unsigned char drive;
	register i;


	if(dev->q_devnum < NUMBER_OF_DEVICES){
		pq_ptr = &periph_que;
		drive = dev->q_devnum;
	}
	else{
		pq_ptr = &periph1_que;
		drive = dev->q_devnum - NUMBER_OF_DEVICES;
	}
		
	p_ptr = &pq_ptr->pt[drive];

	p_ptr->p_time = 0;

	if(PRINT3)
		printf("finreq: %x\n",dev);


	pq_ptr->periph_active &= ~(U_L_BIT(drive));

/* If the drive is busy try reissuing the command */

	if((*(short *)&dev->rc1) == BUSY_STAT) {
	    if(++dev->retry < RETRY){
		p_ptr->next_byte_count = dev->q_count;
		*(short *)&dev->rc1 = 0;
		if(pq_ptr->scsi_periph_ptr == 0)
			pq_ptr->scsi_periph_ptr = p_ptr;
		return;
	    }
	}

	/*if we received a check condition from the drive, send a request sense
	and when the response comes back put the error code in dev->rc1 */

	if((dev->rc2 == CHECK_COND) && (++dev->retry < RETRY)){
		get_sense(dev,dev->q_devnum,0);
		return;
	}


	if(p_ptr->next_byte_count && (dev->retry < RETRY)){

/* The following 'if' statement was added to handle the request sense for the 
Northern Telecom drive which returns only 8 bytes when 18 is requested.
Normally, if we have not transferred all of the bytes requested we will try
again but in this case we just move on.
*/
	   
	    if(dev->opr != REQ_SENSE){
	    	p_ptr->p_time = TICK_2SEC;
	    	p_ptr->next_mem_ptr = (dev->q_flag&(DK_TO_MAIN|MAIN_TO_DK)) ? 
			dev->q_mem : (char *)(dev->local_mem->fm);
	    	p_ptr->next_byte_count = dev->q_count;
	    	dev->retry++;
	    	if(pq_ptr->scsi_periph_ptr == 0)
			pq_ptr->scsi_periph_ptr = p_ptr;
	    	return;
	    }
	}
	else if(dev->retry >= RETRY){
	    if(*(short *)&dev->rc1 == 0)
	    	dev->rc1 = DER_TIMEOUT;
	    dev->q_count = p_ptr->next_byte_count;
	    if((p_ptr->p_first = dev->q_next) == 0)
		 p_ptr->p_last = 0;
	    p_ptr->next_mem_ptr = 0;
	    p_ptr->next_byte_count = 0;
	    if(dev->q_flag&(DK_TO_MAIN|MAIN_TO_DK)){
		if(dev->q_flag&FREE_REQ){
			clear_periph_que(dev,p_ptr);
		}
		send_back(dev,1);
	    }
	    else
		dev->q_priority = DONE;
	    return;
	}



	if((p_ptr->p_first = dev->q_next) == 0)
		 p_ptr->p_last = 0;
	else if(dev->opr == REQ_SENSE){
	    if(p_ptr->p_first->q_key == dev->q_key){
		p_ptr->p_first->rc2 = *(char *)((int)dev->local_mem->fm+SENSE_KEY);
		p_ptr->p_first->rc1 = req_sense_error_conversion[p_ptr->p_first->rc2];
		p_ptr->p_first->q_message = *(char *)((int)dev->local_mem->fm+ERROR_CODE);
		dev1 = p_ptr->p_first;

	/*If we had to reset the bus in order to get things going again, then
	the error from the request sense will be a unit attention and we should
	just try the request again 
	*/
		if((dev1->rc2 == UNIT_ATTENTION) && (++dev1->retry < RETRY)){
			return_ptr(dev);
			*(short *)&dev1->rc1 = 0;
	    		if(dev1->q_flag&WAIT)
				dev1->q_priority = DONE;
			return;
		}
		if((p_ptr->p_first = dev1->q_next) == 0)
			p_ptr->p_last = 0;
		if(PRINT1)
			printf("error return %x block %x\n",*(short *)&dev1->rc1,dev1->q_devun.block);
			
		if(dev1->q_flag & (DK_TO_MAIN|MAIN_TO_DK)){
		    if(dev1->rc1 == RECOVERED_ERR)
			*(short *)&dev1->rc1 = 0;
		    else if(*(short *)&dev1->rc1)
			dev1->q_count = 0;
			
		    if((dev1->q_flag & FREE_REQ) &&
		        (ipque.i_p_first->q_key == dev1->q_key))
			    ipque.i_p_count += dev1->q_count;
		    send_back(dev,1);
		    send_back(dev1,1);
		    return;
		}
		else
			dev1->q_priority = DONE;
	    }
	}
	p_ptr->next_mem_ptr = 0;
	p_ptr->next_byte_count = 0;

	if(pq_ptr->scsi_periph_ptr == 0){
	    for(i=0;i<NUMBER_OF_DEVICES;i++){
		p_ptr = p_ptr->next_periph_ptr;
		if(p_ptr->p_first) {
		    drive = (pq_ptr == &periph_que) ? p_ptr->p_first->q_devnum :
			(p_ptr->p_first->q_devnum - NUMBER_OF_DEVICES);
		    if((pq_ptr->periph_active&BIT(drive))==0){
    			pq_ptr->scsi_periph_ptr = p_ptr;
    			break;
		    }
		}
	    }
	    if(i == NUMBER_OF_DEVICES)
		pq_ptr->scsi_periph_ptr = 0;
	}

	if(dev->q_flag&(DK_TO_MAIN|MAIN_TO_DK)){
		if(dev->q_flag&FREE_REQ)
			ipque.i_p_count += dev->q_count;
		send_back(dev,1);
	}
	else{
	    if(dev->q_flag&WAIT)
		dev->q_priority = DONE;
	    if(dev->q_flag&BUS_RECOVERY)
		return_ptr(dev);
	}


}

last_ditch_recovery(dev)
register struct devq *dev;
{

	register struct periph_table *p_ptr;
	register struct dkinf *dkptr;
	register i;
	register unsigned char j;
	unsigned char bus;

if(PRINT3)
	printf("Performing our last ditch recovery scheme\n");

	if(dev->q_devnum < NUMBER_OF_DEVICES) {
		bus = 0;
		periph_que.periph_active = 0;
		periph_que.bus_id = NO_ONE_ON_THE_BUS;
		p_ptr = periph_que.pt;
		j = 0;
		dkptr = phydr;
	}
	else{
		bus = 1;
		periph1_que.periph_active = 0;
		periph1_que.bus_id = NO_ONE_ON_THE_BUS;
		p_ptr = periph1_que.pt;
		j = NUMBER_OF_DEVICES;
		dkptr = &phydr[NUMBER_OF_DEVICES];
	}

	reset_chip(bus);
	reset_bus(bus);

	for(i=0;i<NUMBER_OF_DEVICES;i++,j++,p_ptr=p_ptr->next_periph_ptr,dkptr++){
		
	    if ( dkptr->pd_ststat & DK_INIT ){
		p_ptr->p_time = 0;
		if(get_sense(dev,j,BUS_RECOVERY))
		    return(1);
	    }
	}

	data_transfer_mode = ASYNC;

	return(0);
}

