#include "disksect.h"
#include "scsi.h"
#include "disk_struct.h"
#include "scsi_dtc.h"
#include "scsi_error.h"
#include "scsiextrn.h"
#include "vreg.h"
#include "data_struct.h"
#include "commands.h"

#define S_TIMEOUT 0xfffff

/* A device structure, upon entry into this routine must have
	dev->q_devtype = DISK;
	dev->local_mem
	dev->q_devnum
*/
diskopen(dev, dkptr)
struct devq *dev; register struct dkinf *dkptr;
{
	register struct sector0 *sec0;
	register struct ld *ldkptr;
	register struct logtype *p;
	register ret;
	register unsigned int i;
	register unsigned short oldpri;
	struct peripheral_que *pq_ptr;
	struct periph_table *p_ptr;
	unsigned int *lptr;


	/* check to see if the physical drive is already open */

	if ( dkptr->pd_ststat & DK_INIT )
		return (0);

	if(dev->q_devnum < NUMBER_OF_DEVICES){
		pq_ptr =  &periph_que;
		p_ptr = &pq_ptr->pt[dev->q_devnum];
	}
	else{
		pq_ptr =  &periph1_que;
		p_ptr = &pq_ptr->pt[(dev->q_devnum-NUMBER_OF_DEVICES)];
	}
	sec0 = (struct sector0 *) dev->local_mem->fm;

	/* pointer to logical table for this physical drive */
	ldkptr = &log[(short)(dev->q_devnum<<4)];

	/* always wait if read system sector */
	dev->q_flag |= (DK_TO_LOC|OPEN_DISK|NO_DISCONNECT);

	/* first check by doing a read capacity to see whether the drive 
	has been formatted to 1024 bytes per sector
	*/

	dev->q_cmd = READ_CAPACITY;
	dev->opr = READ_CAPACITY;
	dev->q_count = sizeof(int) << 1;
	dev->q_priority = 0;

	read_cap(dev);
	i=0;
	while((dev->q_priority != DONE) && (i++ < S_TIMEOUT));
	if(i >= S_TIMEOUT){
		dev->rc1=DER_TIMEOUT;
		printf("timeout\n");
		return(1);
	}
	if(dev->rc1)
		return(1);
	lptr = (unsigned long *)dev->local_mem->fm;
	if(*(lptr+1) != BLKSIZE){
		async_set(dev->q_devnum);
		dev->rc1 = DER_UNFORM;
		printf("drive %x unformatted\n",dev->q_devnum);
		return(1);
	}


	dev->q_cmd = READ;
	dev->opr = READ;
	dev->q_count = BLKSIZE;
	dev->q_devun.block = SEC0;
	dev->q_priority = 0;
    	oldpri = spl6();
	p_ptr->p_first = dev;
	p_ptr->p_last = dev;
	p_ptr->next_mem_ptr = (char *)(dev->local_mem->fm);
	p_ptr->next_byte_count = dev->q_count;
	if(pq_ptr->periph_active == 0){
	    if(diskrw(dev)){
	        if(pq_ptr->scsi_periph_ptr == 0)
	            pq_ptr->scsi_periph_ptr = p_ptr;
	    }
	}
	else{
	    if(pq_ptr->scsi_periph_ptr == 0)
		        pq_ptr->scsi_periph_ptr = p_ptr;
	}
	splx(oldpri);

	i=0;
	while ((dev->q_priority != DONE) && (i++ < S_TIMEOUT));

	if(i >= S_TIMEOUT){
		printf("timeout reading drive %d\n",dev->q_devnum);
		return(1);
	}


	/* at least we are able to read a sector */
	dkptr->pd_ststat |= DK_READY;

	/* check ID name and the maximum number of logical drives allowed */
	if ( (*((int *)&sec0->id[0]) != (int)'INIT') ||
		(sec0->pd_ldmaxnum > LOGDR) ||
		(sec0->pd_ldnum > LOGDR) ) {
		dev->rc1 = DER_UNFORM;
		printf("drive %x not formatted\n",dev->q_devnum);
		async_set(dev->q_devnum);
		return(1);
	}

	*(int *)&dkptr->cyldisk = *(int *)&sec0->cyldisk;
	*(int *)&dkptr->seccyl = *(int *)&sec0->seccyl;

	dkptr->pd_ldmaxnum = sec0->pd_ldmaxnum;
	dkptr->pd_ldnum = sec0->pd_ldnum;
	dkptr->sync_drive = sec0->synchronous_drive;

	/* reserved size and skip track list */
	dkptr->rv_strt = sec0->rv_strt;
	dkptr->rv_size = sec0->rv_size;


	if ( dkptr->pd_ldnum == 0 ) {
		/* no need to read setup logical drive table */
		/* sector 0 read in*/
		dkptr->pd_ststat |= DK_INIT;
		return(0);
	}
	
	/* setup log drive table */
	dkptr->pd_ptr = ldkptr;
	p = &sec0->logdrive[0];

	for (i=0; i< dkptr->pd_ldnum; i++) {
		ldkptr->ld_strt = p->ld_strt;
		ldkptr->ld_size = p->ld_size;
		ldkptr->ld_type = p->ld_type;
		ldkptr++;
		p++;
	}


	/* sector 0 read and got timing register from sector 0 */
	dkptr->pd_ststat |= DK_INIT;
	return(0);
}


closephy (drive, dkptr)
register unsigned char drive;
register struct dkinf *dkptr;
{
	register struct dev_desc *devptr;

	devptr = devdesc;
	if(!(devptr->dd_type & DTDISK)) devptr++;
	devptr->dd_count--;

	setbuf ( dkptr, sizeof (struct dkinf) >> 1, 0);

}

