
/* ***************************************************** */
/* MEMORY device command for structure devq (devq.q_cmd) */
/* ***************************************************** */
#define MREAD		1
#define MWRITE		2



/******************************************************************************
 *
 * Tape drive commands for structure devq (devq.q_cmd)
 *
 ******************************************************************************/
/*	read/write data between main memory and tape
	Main memory can be either contiguous and non-contiguous.
	For contiguous physical memory, the address is specified in devq.q_mem 
	and devq.q_mmu = 0; maximum can handle 0x4000 bytes in devq.q_count
	(ALL version of HSDT download code support this feature)  
	For non-contiguous memory, devq.q_mmu is the pointer to a request
	block which contains a list of page number with an offset of long
	word boundary into the first page number. (see vreg.h for structure 
	definition) and devq.q_mem = 0; maximum can handle 0x4000 bytes
	in devq.q_count.
	(HSDT download code V2.8 supports this feature)
 */

#define TPREAD		1
#define TPWRITE		2

#define REWIND 		3
#define WEOF 		4		/* write single filemark */
#define REOF 		5		/* read single filemark */
#define TAPESTAT	6		/* get tape status */
#define TENSION 	7
#define ERASE   	8		/* erase to end of tape */

#define ERASEFIX	9		/* erase a fix length of tape */
#define FORRECORD	0xa		/* space record forward */
#define REVRECORD	0xb		/* space record reverse */
#define POS		0xc		/* position the tape */
					/* (not support yet) */
#define	ARCHQ11		0xd		/* archive tape Q11 format */
#define	ARCHQ24		0xe		/* archive tape Q24 format */

#define DENSITY		0xf		/* set the density on 9 track */
#define TAPESPEED	0x10		/* set the speed on 9 track */
#define TAPEMODE	0x11		/* set 9 track stream/start & stop */
#define REVSFM		0x12		/* reverse to last filemark */
#define RESET9		0x13		/* reset 9 track */

#define TOTPCMD		0x0f		/* total tape cmd for archive tape */
#define TOT9CMD		0x14		/* total tape cmd for 9 track */

/* ******************************************** */
/* definition for density and speed for 9 track */
/* ******************************************** */
#define DENS_1600	0x01		/* 1600 bpi density of the 9 track */
#define DENS_6250	0x02		/* 6250 bpi density of the 9 track */
#define DENS_800	0x4		/* 800 bpi density for the 9 track */

#define SPEED_HI	0x01		/* set high speed for 9 track */
#define SPEED_LOW	0x02		/* set low speed for 9 track */

#define MODE_STARTSTP	0x01		/* start & stop mode */
#define MODE_STREAM	0x02		/* stream mode */

/******************************************************************************
 *
 * Disk drive commands for structure devq (devq.q_cmd)
 *
 ******************************************************************************/

/*	read/write MULTIPLE logical sectors from logical drive for
	Main memory can be either contiguous and non-contiguous.
	For contiguous physical memory, the address is specified in devq.q_mem 
	and devq.q_mmu = 0; maximum request that we can handle 0x3fc00 bytes 
	in devq.q_count (255 logical sectors). 
	data is to be transferred. (see vreg.h for the structure definition)
	and devq.q_mem = 0; maximum request that we can handle 
	is 0x14000 bytes in devq.q_count (80 logical sectors).
 */

#define LREAD		1
#define LWRITE		2

/*	read/write multiple physical sectors from physical drive number
	This cmd is used by the standalone disktest program.

 */
#define PREADPS		3
#define PWRITPS		4

#define INIT		0xe		/* read sector 0 and build structure */
#define CLOSE		0xf		/* erase structure tbl for phy drive */

#define BADBLK		0x11		/* bad block within a physical drive */

#define NEXTRVSEC	0x12		/* next available log sector in reserved
					area for storing more information in
					spare list, media defect list,
					bad sector list */		

#define PHSPARE		0x13		/* spare physical sector */

#define BDBLKNUM	0x15		/* total bad blocks number */

#define HWSPARE		0x16		/* program bad sector id field */

#define ALTSECNUM	0x17		/* total number of alternate sectors in 
			   	   	the spare sectors */
#define ALTSEC		0x18		/* get all the alternate sectors
				   	(used/unused) of a physcial drive */

#define SWAPDEV		0x19		/* get the swap device log drive num */


#define PRSKALT		0x1a		/* phy drive, c,h,s, skip track,
					lookup spare */
#define PWSKALT		0x1b		/* phy drive, c,h,s, skip track,
					lookup spare */

#define WRITEID 	0x1c		/* write sector id (format) */

#define DSKCMPL		0x1d		/* wait until all disk io completed */

#define UNSPARE		0x1e		/* unspare a sector */

#define SETIME 		0x1f		/* set timing parameters */

#define PWRITS0		0x20		/* setup system sectors 0 */

#define SEEKCYL		0x21		/* seek cylinder */

#define	READID		0x22		/* read sector id */

#define	MEDEFTRK 	0x23		/* read initial media defect information
					 of a single track */
#define NEWSTAT		0x24		/* additional status necessary to
					distinguish between the Hitachi 172MB
					drive and the Fuji 168 MB drive. */

#define SPECIAL_SCSI_CMD 0x25		/*command used to pass scsi tool box 
					commands to the scsiedt */
