/* The following are the formats of the two command descriptor blocks */

struct six_byte_cdb{
	unsigned char op_code;
	unsigned char unit_block;	/*upper 3 bits - logical unit number
				  lower 5 bits - logical block address */
	unsigned char block_msb;
	unsigned char block_lsb;
	unsigned char length;
	unsigned char control;
};

struct ten_byte_cdb{
	unsigned char op_code;
	unsigned char logical_unit;	/*upper 3 bits - logical unit
				  next 4 bits  - reserved
				  1 bit	       - relative address */
	union{
		unsigned block;
		struct{
		    unsigned char block_msb1;
		    unsigned char block_msb2;
		    unsigned char block_msb3;
		    unsigned char block_lsb;
		}ten_b;
	}cb_blk;
	unsigned char reserved;
	unsigned char length_msb;
	unsigned char length_lsb;
	unsigned char control;
};

#define UPPER5(x) (x&0x00f80000)>>19
#define MIDDLE8(x)   (x&0000ff00) >> 8


/* Values to be placed in the page control field of the mode sense command */

#define CURRENT  00
#define CHANGEABLE 1<<6
#define DEFAULT  1<<7
#define SAVED  3<<6

#define TEN_BYTE_CDB_SIZE 10
#define SIX_BYTE_CDB_SIZE  6
