#include "scsi_ccpu.h"
#include "disksect.h"
#include "scsi.h"
#include "disk_struct.h"
#include "scsi_dtc.h"
#include "scsi_error.h"
#include "scsidata.h"
#include "vreg.h"
#include "data_struct.h"
#include "scsiextrn.h"
#include "scsi_ptm.h"
#include "devcmd.h"

ckreq()
{	register struct devq *dev;
	register struct interim_processing_que *iptr;
	register struct periph_table *p_ptr;
	register struct tape_que *tptr;
	register unsigned short oldpri;

		oldpri = spl6();
		locktas();
		if ( (int)bddesc.reqfst == 0 ) {
			/* clear TAS */
			*DTC_CRH = 1;
			splx(oldpri);
			return;
		}
	
		dev = bddesc.reqfst;

		if ( bddesc.reqlst == (struct devq *)dev )
			bddesc.reqlst = 0;
		
		bddesc.reqfst = (struct devq *)dev->q_next;

		/* clear TAS */
		*DTC_CRH = 1;
	
		LIGHT(greenlit);
		splx(oldpri);
	
	/* ****************************************** */
		if ( PRINT2 )  {
			printf("\n");
			prbuf ( dev, (sizeof (struct devq)) >> 1 );
		}
	
		/* only keep 2 bits */
		dev->q_flag &= (NO_RETRY + NOALT);
		dev->q_next = (struct devq *)0;
		*((short *)&dev->rc1) = 0;	/* zero return code */
	
		dev->retry = 0;
	
		/* check for valid device by parsing the request for
		   errors in the elements of the structure */
		if ( dev->q_devtype == DISK ) {
		    if(dkparse(dev)){
			oldpri = spl6();
			send_back(dev,1);
			splx(oldpri);
		    }
		    return;
		}
		else if(dev->q_devtype & TAPE ){
		    if(taparse(dev)){
			oldpri = spl6();
			send_back(dev,1);
			splx(oldpri);
		        return;
		    }
		}
/*
		else if (dev->q_devtype == PF_WAIT){
		    	dkcompl(dev);
			return;
		}
*/
	 	else {
			dev->rc1 =  DER_DTYPE;
			oldpri = spl6();
			send_back(dev,1);
			splx(oldpri);
			return;
		}
	

		/*If it is not contiguous memory, put it on the interim_
		  processing_queue */


		if(dev->q_mmu){
			iptr = &ipque;
			if(iptr->i_p_first)
				iptr->i_p_last->q_next = dev;
			else
				iptr->i_p_first = dev;
			iptr->i_p_last = dev;
		}


		/* A tape request should go on the tape queue */

		else if(dev->q_devtype & TAPE ){
			tptr = &tapeque;
			if(tptr->t_first)
				tptr->t_last->q_next = dev;
			else
				tptr->t_first = dev;
			tptr->t_last = dev;
		}

}

/* interrupts are disabled when we enter this routine */

send_back(ndevq,leave_dtb_alone)
register struct devq *ndevq;
unsigned int leave_dtb_alone;
{
	register struct devq *dq;
	register unsigned int *io_count;
	register struct dtb_que *dptr;

	if(!(leave_dtb_alone)){

		dptr = &dtbque;
		if((dptr->d_first = ndevq->q_next) == (struct devq *)0)
			dptr->d_last = (struct devq *)0;
	}

	if(ndevq->q_flag&FREE_REQ){
		if(ipque.i_p_dqfirst)
			ipque.i_p_dqlast->q_next = ndevq;
		else
			ipque.i_p_dqfirst = ndevq;
		ipque.i_p_dqlast = ndevq;
		if(ipque.i_p_first->q_key == ndevq->q_key)
		    *(short *)&ipque.i_p_first->rc1 = *(short *)&ndevq->rc1;

		ndevq->q_next = (struct devq *)0;
		ndevq->q_prev = (struct devq *)0;
		return;
	}
	
	
	ndevq->q_next = (struct devq *)0;
	ndevq->q_prev = (struct devq *)0;



/* If there is not a value in q_mmu, then we have completed a block io
   transfer and now must put in a count in the physical drive structure
   to increment the number of block io transfers and the total time for 
   those requests.
*/
	if(!(ndevq->q_mmu)) {
		io_count = io_counter_array[ndevq->q_devnum] ;
		*io_count += 1;
		*(io_count+1) += (clock_cnt - time_counter_array[ndevq->q_devnum]);
	}

	
	if ( PRINT2 )
		prbuf ( ndevq, (sizeof (struct devq)) >> 1 );
	
/*
	if ( PRINT1 && (*(short *)&ndevq->rc1) )
		printrc(ndevq);
*/

	/* put req on response que */
	locktas();
	if ( bddesc.rsfst == 0 ) {
		bddesc.rsfst = ndevq;
		bddesc.rslst = ndevq;

		/* clear TAS */
		*DTC_CRH = 1;
	/* interrupt the master cpu */
		intr_cpu (ICB_ACK);
	}
	else {
		/* put que at the end */
		dq = bddesc.rslst;
		dq->q_next = ndevq;
		ndevq->q_prev = dq;

		bddesc.rslst = ndevq;

		/* clear TAS */
		*DTC_CRH = 1;
	}

	LIGHT(ledoff);
	return;
}
locktas()
{	register first;
	first = 1;
	while ( ICB_TAS ){
		if ( first && PRINT2 )
			con_out ('*');
		first = 0;
	}
}


static short flag = 1;

quick_read(dev)
struct devq *dev;
{
	register timeout, i;
	register unsigned char *qrbuf;
	register unsigned char status;
	register *lpt;

	qrbuf = (unsigned char *)ALTBUF;

	if (flag){
		/* when power up, slice table will be read into local memory.
		   this operation will call cancel_dma, at the time
		   the q_mem is 0.
	 	*/
		   
		if ((dev->q_flag & DK_TO_MAIN) || (dev->q_flag & LOC_TO_MAIN))
			flag = 0;
		else 
			return; 	/* request from local disk transfer */

		*((int *)(ALTBUF + 0x10)) = 0;
		*((int *)(ALTBUF + 0x14)) = 0;

		/* for S90 find slot number which */
		if ( dev->q_mem == 0){
			*(qrbuf+1)=(unsigned char)(((int)ipque.i_p_mmutable->
			mmuslots[1]&0xf0000000)>>24);
		}
		else{
			*(qrbuf+1)=(unsigned char)(((int)dev->q_mem &
			   0xf0000000)>>24);
		}
		/* direction and io board ID */
		*qrbuf = (char )(RD_DTB | bddesc.bd_dtbid);

		/* set long word count */
		*(short *)(qrbuf+2) = 2;

		/* using address 0 of the memory slot as random address */
		*(int *)(qrbuf+4) = 100;
if (PRINT5)
      printf("QUICK_READ >> L0=%x, L1=%x \n", *(int *)qrbuf, *(int *)(qrbuf+4));
	}

	/* program the DTB DMA starting & ending address with the DTC local 
	   data buffer ALTBUF 0x10020*/
	*(short *)((int)DTB_DMAS) = (short)(ALTBUF+8);
	*(short *)((int)DTB_DMAE) = (short)(ALTBUF+12);

	/* program the CHAIN DMA starting & ending address with 
	   an 8 byte buffer containing DTB parameters */
	*(short *)((int)CHN_DMAS) = (short)ALTBUF;
	*(short *)((int)CHN_DMAE) = (short)(ALTBUF+4);

	/* program the DTB/DISK data path mode for local memory <->DTB */

	/* receive data from main memory */
	dtb_cr = FS_RDCHN;

	*DTB_CR = dtb_cr;

	/* DTB control register : DTB function code */
	dbc_cr = (dbc_cr & CR_MASK) | LOCMDTBX | RDDTB;
	*DBC_CR = dbc_cr;


	dbc_cr = dbc_cr | DTB_EN | CHN_EN;

	*DBC_CR = dbc_cr;

	/* ******************** */
	/* set a timer incase the DTB gets hung up */
	/* ******************** */
	timeout = TIMEOUT;
	for (i=0; i<0xf000; i++) {
		status = *DBC_SR;
		if ((status & 0x30) == (DTB_DONE + CHN_DONE)){
		     	timeout = 0;
			break;
		}
	}

	/* clear both the CHAIN DMA & DTB DMA done bit */

	dbc_cr &= ~(DTB_EN | CHN_EN);

	*DBC_CR = dbc_cr;

	return (timeout);
}



quickread(ndevq)
struct devq *ndevq;
{
if(PRINT4){
	*(int *)(ALTBUF +8) = 0x05555555; 
	printf(">> ALTBUF = %x\n",*(int *)(ALTBUF + 8));
	}

	if (quick_read(ndevq)){
	    	if(PRINT4)
			printf("@@ flush buffer time out @@\n");
		*((int *)(ALTBUF + 0x14)) += 1;
		if (*((int *)(ALTBUF+0x14)) == 0)
			*((int *)(ALTBUF +0x10)) += 1;
/*
		ndevq->rc1 = 0xdd ;
*/
		ndevq->rc1 = DER_TIMEOUT;
	}

if(PRINT4)
	printf(">> ALTBUF after = %x,error count=%x\n",*(int *)(ALTBUF + 8),
			*(int *)(ALTBUF + 0x14));

}
