/* ATON: ascii to numeric
 *	Takes a string representing a number in:
 * binary: +-^101
 * octal: +-017
 * decimal: +-12345
 * hex: +-0x123abc
 * and transforms it into a long integer value for return.
 * errflag is set if an illegal value is seen.
 */
#include "extern.h"
aton(s)
register char *s;
{
	register sign = 0;
	register retval=0, val = 0;
	register base = 0;
	register int c;
	atonerr = 0;
	switch (baseflag){
		case BIN: base = 2; break;
		case OCT: base = 8; break;
		case DEC: base =10; break;
		case HEX: base =16; break;
		default: atonerr++; return(1);
	}
	do{
		while ( *s == '+' || *s == '-'){
			if ( *s == '-' ) sign = !sign;
			s++;
		}
		c = *s;

		if( c >= '0' && c <= '9')
			val = (int)(c - '0');
		else if ( ((c & ~0x0010) >= 'a') &&((c & ~0x0010) <= 'f') )
				val = (int)((c & ~0x010) - 'a' + 10);
			else { return(atonerr++); }
		 if (val >= base){ return(atonerr++); }
		 retval = retval*base + val;
	}while(*++s != '\0');
	return(sign ? -retval : retval);
} /* end aton */

/* LTOBS:
 * Convert a number to a binary string.
 */

char * ltobs(val,bitlen,sbase)
register unsigned long val; 
register long bitlen;
register char * sbase;
{
	register unsigned long mask = 1;
	register char * s;
	s= &sbase[bitlen]; /* get to the end of string */
	*s-- = '\0';
	while(bitlen--) {
	/*
	printf("%2d %c\b\b\b\b",bitlen,inbuf[bitlen]);sleep(1);
	*/
		if(val&mask) *s-- = '1';
		else *s--='0';
		mask <<= 1;
		}
	return ( sbase );
} /* end ltobs */
