/* sw0 11/17/85 stone -- support logical sections > 9  */
/* sw1 11/17/85 stone -- deal properly with SKIP/SPARE devices  */
/* sw2 11/22/85 stone -- filesys/volume names were being improperly loaded  */
/* sw3 11/22/85 stone -- filesys/volume names were being improperly loaded  */
/* sw4 11/27/85 naw -- allocate bad block, spare buffers dynamically */
/* sw5 01/21/86 naw -- search skip track list as well as spare list */
/* 3/19/86 peter logan --- if the tape drive to be read from is a nine track,
	added code to wait until the rewind is complete before searching for
	the root file system to be loaded
*/

/*
	f_n can't be > MAXFN

	superblk resides in block 0
	first inode blk starts at 2

 * Stand-alone (system III) file system maker for X-1000
 *
 * This code bears but a loose relationship to the user-mode mkfs; it
 * expects to receive prototype text AND file content from the secondary
 * serial port in all but the simplest cases.  One enters down-line mode
 * by giving any non-numeric answer to the "file system size" prompt.
 *
 * note also: prototype format has been tinkered with; e.g. there is no
 * bootfile copy.
 *
 *
 *	readbinmux modified to
 *	make sure chars are loaded instead of ints (Z8000 ints are
 *	backwards from M68000 short ints!)
 *
 * changes made to support the logical disk information and
 * bad block list. 12/84
 *
 * changes made to use the pdf subroutines
 * and check the size for eagle interlace 02/85
 * remove downline load prompt
 */



#include <sys/types.h>
#include <sys/stat.h>
#include <sys/fs/s5param.h>
#include <sys/sysmacros.h>
#include <sys/ino.h>
#include "sainode.h"
#include <sys/fs/s5filsys.h>
#include <sys/fs/s5fblk.h>
#include <sys/fs/s5dir.h>

#include "ccpu.h"
#include "maps.h"
#include "saio.h"

#include "dklist.h"			/* new logical disk stuff */
#include "dk.h"
#include "disksect.h"
#include "pdf.h"


#include "misc.h"
#include "globlvars.h"
#include "icb.h"
#include "icbcmd.h"
#include "vreg.h"
#include "cpu.h"
#include "sysconf.h"
#include "mt.h"


/* for VAX, Interdata, ... */
#define MKSHORT(v,lv) {U.l=1L;if(U.c[0]) U.l=lv,v[0]=U.s[1],v[1]=U.s[0]; else U.l=lv,v[0]=U.s[0],v[1]=U.s[1];}

#define MAGIC	070707		/* cpio magic number */
#define IN	1		/* copy in */
#define OUT	2		/* copy out */
#define PASS	3		/* direct copy */
#define HDRSIZE	(Hdr.h_name - (char *)&Hdr)	/* header size minus filename field */
#define LINKS	1000		/* max no. of links allowed */
#define CHARS	76		/* ASCII header size minus filename field */
#define CPIOBSZ 4096		/* file read/write */
#define defblksiz 0x400
#define NINE_TRK_SZ  5120
#define ADDR100K		0x100000
#define MEG 0x100000
#define RD 1
#define WR 2
#define BNUM  0x40000
#define REMAINPG 0x45

#define STANDALONE 1
#define PGSIZE	4096
#define PGROUND(a) ((char *)(((unsigned)a+PGSIZE-1) & ~(PGSIZE-1)))

char *ascldtype[] = {
	"NULL", "FSYS", "SWAP", "PWRF",
	"HOLE", "SPARE", "SKIP", "SPLIT"
};

int	cyloff,			/* FS offset within cylinder */
	f_s,			/* file system size (blocks) */
	f_t,			/* sectors per track */
	fsorg;			/* FS origin on disk */
char	ans [128];
char *dataptr;
int	rcode, wcode;
int	i;
int pdrive,ldrive;
int popit = 0;				/*set if the directory entry should be 
					    written out*/
int process = 0;			/*file has been processed */
int nopro = 0;				/*missed processing a file or directory*/
struct iob *file;
int maxblksz = 0x40000;
int endit = 0;				/*last file on the tape has been read in */
ino_t cklink();
int verbose;				/*set if file names are to be printed as
					 they are loaded */

struct ml {
	short	m_dev;
	short	m_ino;
	ino_t   m_oldino;
} mlbuf[LINKS];

struct ml *ml[LINKS];

int mlinks = 0;


	/* Cpio header format */
struct header {
	short	h_magic,
		h_dev;
	ushort	h_ino,
		h_mode,
		h_uid,
		h_gid;
	short	h_nlink,
		h_rdev,
		h_mtime[2],
		h_namesize,
		h_filesize[2];
	char	h_name[256];
} Hdr;

unsigned	Bufsize = BNUM;		/* default record size */
short	Buf[CPIOBSZ/2], *Dbuf;
int	Wct, Wc;
short	*Wp;
char	*Cp;


short	Option,
	Dir,
	Toc,
	Verbose,
	Select,
	Mod_time,
	Acc_time;

int	Ifile,
	Ofile,
	Input = 0,
	Output = 1;
long	Blocks,
	Longfile,
	Longtime;

char	Fullname[256],
	Name[256];
int	Pathend;


char	*Pattern[100];
char	Strhdr[500];
char	*Chdr = Strhdr;
short	Dev,
	Uid,
	Gid,
	A_directory,
	A_special,
	Filetype = S_IFMT;

char 	*cd();
/*	char	*Cd_name;	*/

union { long l; short s[2]; char c[4]; } U;

/* for VAX, Interdata, ... */
long mklong(v)
short v[];
{
	U.l = 1;
	if(U.c[0])
		U.s[0] = v[1], U.s[1] = v[0];
	else
		U.s[0] = v[0], U.s[1] = v[1];
	return U.l;
}




#define NULL 0
#define DIR 1
#define FILE 2

/* LED light if error happened */

#define AWAIT	1
#define WTFS	2
#define RDFS	3
#define GETSTR	4
#define GMODE	5
#define GETNUM	6
#define READBIN	7
#define CFILE1	8
#define CFILE2	9
#define OPEN	10
#define BRATIO	11
#define NEWBLK	12
#define BFLIST	13
#define IPUT1	14
#define IPUT2	15
#define ALLOC	16
#define CKSUM	17

#define	NIPB	(BSIZE/sizeof(struct dinode))
#define	NDIRECT	(BSIZE/sizeof(struct direct))
#define	LADDR	10
#define	MAXFN	2000	



char	buf[BSIZE];

union {
	struct filsys fs;
	char pad2[BSIZE];
} filsys;



union {
	struct fblk fb;
	char pad1[BSIZE];
} fbuf;

daddr_t aux1[NINDIR],aux2[NINDIR];

time_t	utime = 0x999999;
int	fsi, fso;
char	*charp, *cp;
char	mxbuf[200],*mxp,mxeof;
char	string[60];
char	*fsys, *proto;
int	f_n, f_m;
int	error = 0;
int	downline = 0;
ino_t	ino;
long	getnum();
daddr_t	alloc();
unsigned char ledvalue = 0xff;
int	check = 0; unsigned char cksum;
char	rawbuf[2*PGSIZE] = {0};
char	*rwbuf;				/* will be set to page bound in rawbuf*/
int mflag;

char tape_buf[] = "c0d0";
extern unsigned int nine_trk;

main(argc, argv)
char *argv[];
{
	register int f, c;
	register long n; register char * xcp;
	static char protos[60];
	int i,j;
	char fsbuf[20];

	check = 0;
	*led_port = (char)0xff;
	rwbuf = (char *)PGROUND(rawbuf);

	printf("Standalone mkfs VER 6.00\n\r");
	printf("\nSelect one\n");

	/* printf("[d]ownline input:   or\n"); */
	printf("[m]ake a blank file system:   or\n");
	printf("[r]ecreate a file system from tape: ");
	gets(protos);

	/*

	    if (*protos == 'd')
		    downline = 1;
	 */

	if (*protos == 'r'){
		mflag++;
		cpio();
	}

	printf ("\r\n");
	

	if (downline) {
	/* from now on, can't talk to 68k any more */

		printf ("Ready in 15 seconds for connection !!\n");
		delay (4);

		/* send out some special character to start the
			the proto program on the external system
		*/
loopp:
/* all led on */
		*led_port = (char)0x00;
		aputch ('?');	/* start character */
		c = pgchar();

/* all led off */
		*led_port = (char)0xff;
		if (c != '?') goto loopp;

		aputch ('\n');
		awaitmuxline();

		getstr();	/* get file system name */
		cp = string;
		while (*cp > ' ') cp++;		/* put zero at the end */
		*cp = 0;
		fso = open(string,1);
		fsi = open(string,0);
		if (fso < 0 || fsi < 0) {
			flash (OPEN);
			exitsamkfs(1);
		}
	} else {
		/* make blank file system */

		printf ("file system size: ");
		gets(protos);
		proto = protos;

		do {
			printf("\r\nfile system: ");
			gets(fsbuf);
			fso = open(fsbuf, 1);
			fsi = open(fsbuf, 0);
			if(fsbuf[4] == 'r'){
				printf("You cannot make a file system on the reserved area of the disk\n");
				fso = -1;
			}

		} while (fso < 0 || fsi < 0);
	}
	/*check to see if file system is designated in old or new format */
	
	/* get disk hardware dependent data */
	gdkinfo(fsbuf, &f_m, &f_n, &f_s, &f_t, &fsorg, &cyloff);

	if(f_n > MAXFN) {
	    printf("%d sectors per cylinder, can't handle, sorry\n",f_n);
	    exit(1);
	}
	filsys.fs.s_fsize = f_s;


	if ( downline ) {
		filsys.fs.s_fsize = getnum();	/* total file size */
		filsys.fs.s_isize = getnum();	/* total inode block */
	} else {
		/* compute inode from file system size */
		n = 0;
		for(f=0; c=proto[f]; f++) {
			if(c<'0' || c>'9') {
				printf("%s: cannot open\r\n", proto);
				exitsamkfs(1);
			}
			n = n*10 + (c-'0');
		}
		if (n > filsys.fs.s_fsize)
			printf("requested size larger than logical disk\r\n");
		else if (n != 0 && n < filsys.fs.s_fsize) {
			printf("requested size smaller than logical disk\r\n");
			filsys.fs.s_fsize = n;
		}
		printf("fsize = %d\r\n", filsys.fs.s_fsize);
		n = filsys.fs.s_fsize / (NIPB*4);
		if(n <= 0)
			n = 1;
		if(n > 65500/NIPB)
			n = 65500/NIPB;
		filsys.fs.s_isize = n + 2;
		printf("isize = %d\r\n", n*NIPB);
		charp = "d--777 0 0 $ ";
	}

	filsys.fs.s_dinfo[0] = f_m;
	filsys.fs.s_dinfo[1] = f_n;

	if ( !downline )
		printf("interlace %d, sectors/cylinder %d\r\n", f_m, f_n);

	/* inode number can not > file system size */

	if(filsys.fs.s_isize >= filsys.fs.s_fsize) {
		if ( downline )
			flash (BRATIO);
		printf("%ld/%ld: bad ratio\n\r",filsys.fs.s_fsize,filsys.fs.s_isize-2);
		exitsamkfs(1);
	}

	filsys.fs.s_tfree = 0;		/* total free block */
	filsys.fs.s_tinode = 0;		/* total free inodes */

	if (badblk(0)) {
		printf("super block is bad--reformat the disk\n");
		exitsamkfs(1);
	}
	for(c=0; c<BSIZE; c++)
		buf[c] = 0;

	/* clear inode block on disk */
/* ??????????????????? */
	for(n=2; n!=filsys.fs.s_isize; n++) {
		if (badblk(n)) {
			printf("bad block %d in inode list--reformat the disk\r\n",n);
			exitsamkfs(1);
		}
		wtfs(n, buf);
		filsys.fs.s_tinode += NIPB;
	}

	ino = 0;
	bflist();

	if(mflag){
		printf("Verbose mode?  ");
		gets(ans);
		if(ans[0] == 'Y' || ans[0] == 'y')
			verbose++;
		gethdr();
		pushem(Hdr.h_name,Hdr.h_mode);
		c1file((struct inode *)0);
	}
	else
		cfile((struct inode *)0);

	filsys.fs.s_time = utime;
/* ****************************** */

	if ( !downline ) {
		printf ("\r\nfile system name: ");
		gets (protos);
		proto = protos;
		cp = &filsys.fs.s_fname[0];
		if ( *proto != 0 ) {
/* sw2 */
			for (n=0; n<6 && *proto != 0; n++)
				*cp++ = *proto++;
			if ( n < 6 )
				*cp = 0;
		}

		printf ("\r\nvolume name: ");
		gets (protos);
		proto = protos;
		cp = &filsys.fs.s_fpack[0];
		if ( *proto != 0 ) {
/* sw3 */
			for (n=0; n<6 && *proto != 0; n++)
				*cp++ = *proto++;
			if ( n < 6 )
				*cp = 0;
		}
	}

	/* write superblock to disk at second half of block 1 */

	filsys.fs.s_magic = FsMAGIC;
	filsys.fs.s_type  = Fs2b;

	cp = rwbuf;
	for (c = 0; c < 512; c++)
		*cp++ = 0;
	xcp = (char *)&filsys.fs;
	for (c=0; c < 512; c++)
		*cp++ = *xcp++;

/*   ??????????????????
	wtfs((long)1, (char *)rwbuf);
*/
	wtfs((long)0, (char *)rwbuf);

	if ( error && downline )
		flash (error);
	close(Input);
	exitsamkfs(error);
}

cfile(par)
struct inode *par;
{
	char	cfbuf[BSIZE+4];
	char	* cfbptr;
	struct inode in;
	int dbc, ibc;
	daddr_t ib[NINDIR*2];
	register int i, f, c;

	/*
	 * get mode, uid and gid
	 */

	cfbptr = cfbuf;	/* init cf buf pointer */
	while ((((int)cfbptr) & 0x0003) != 0) cfbptr++;	/* MOD 4 boundry */

	getstr();

	in.i_mode = gmode(string[0], "-bcd", IFREG, IFBLK, IFCHR, IFDIR);
	in.i_mode |= gmode(string[1], "-u", 0, ISUID, 0, 0);
	in.i_mode |= gmode(string[2], "-g", 0, ISGID, 0, 0);

	for(i=3; i<6; i++) {
		c = string[i];
		if(c<'0' || c>'7') {
			if ( downline )
				flash (CFILE1);
			printf("%c/%s: bad octal mode digit\r\n", c, string);
			error = 1;
			c = 0;
		}
		in.i_mode |= (c-'0')<<(15-3*i);
	}
	in.i_uid = getnum();
	in.i_gid = getnum();

	/*
	 * general initialization prior to
	 * switching on format
	 */

	ino++;
	in.i_number = ino;
	for(i=0; i<BSIZE; i++)
		cfbptr[i] = 0;
	for(i=0; i<NINDIR*2; i++)
		ib[i] = (daddr_t)0;
	in.i_nlink = 1;
	in.i_size = 0;
	for(i=0; i<NADDR; i++)
		in.i_addr[i] = (daddr_t)0;

	if(par == (struct inode *)0) {
		par = &in;
		in.i_nlink--;
	}
	dbc = 0;
	ibc = 0;
	switch(in.i_mode&IFMT) {

	case IFREG:
		/*
		 * regular file
		 * contents is a file name
		 */

		/* should get  "!\n"  */
		getstr();
		if (string[0] != '!') {
			if ( downline )
				flash (CFILE2);
			printf("file content expected here\r\n");
			exitsamkfs(1);
		}
		mxeof = 0;
		check = 1;
		while((i = readbinmux(cfbptr, BSIZE)) > 0) {
			in.i_size += i;
			newblk(&dbc, cfbptr, &ibc, ib);
		}

		check = 0;
		if ( !downline )
			printf("file copied, %x bytes\n\r",in.i_size);
		break;

	case IFBLK:
	case IFCHR:
		/*
		 * special file
		 * content is maj/min types
		 */

		i = getnum() & 0377;
		f = getnum() & 0377;

		in.i_addr[0] = (i<<8) | f;
		break;

	case IFDIR:
		/*
		 * directory
		 * put in extra links
		 * call recursively until
		 * name of "$" found
		 */

		par->i_nlink++;
		in.i_nlink++;
		entry(in.i_number, ".", &dbc, cfbptr, &ibc, ib);
		entry(par->i_number, "..", &dbc, cfbptr, &ibc, ib);
		in.i_size = 2*sizeof(struct direct);
		for(;;) {
			getstr();
			if(string[0]=='$' && string[1]=='\0') {
				break;
			}
			entry(ino+1, string, &dbc, cfbptr, &ibc, ib);
			in.i_size += sizeof(struct direct);
			cfile(&in);
		}
		break;
	}
	if(dbc != 0)
		newblk(&dbc, cfbptr, &ibc, ib);
	iput(&in, &ibc, ib);
}

gmode(c, s, m0, m1, m2, m3)
char c, *s; int m0, m1, m2, m3;
{
	register int i;

	for(i=0; s[i]; i++)
		if(c == s[i])
			return((&m0)[i]);
	if ( downline )
		flash (GMODE);
	printf("%c/%s: bad mode\r\n", c, string);
	error = 1;
	return(0);
}

/* call getstr(): get a string of input only upto a space
 * 		return character in string[]
 *		call getch(1) :grep a line of input if mxbuf is empty
 *		also echo first char
 *		
 * 	
 * and convert to a long number 
 * only call when it is downline
 */
long
getnum()
{
	register int i, c;
	register long n;

	getstr();
	n = 0;
	i = 0;
	for(i=0; c=string[i]; i++) {
		if(c<'0' || c>'9') {
			if ( downline )
				flash (GETNUM);
			printf("%s: bad number\r\n", string);
			error = 1;
			return((long)0);
		}
		n = n*10 + (c-'0');
	}
	return(n);
}

/* getstr call getch(1) which get the character from mxbuf[200] for 
 * downline, all characters are echo back 
 */
getstr() { 
register int i, c;

loop:
	c = getch(1);
	switch(c) {

	case ' ':
	case '\t':
	case '\n':
	case '\0':
		goto loop;

	case ':':
		while(getch(1) != '\n'); /* printf("X"); */
		goto loop;

	}
	i = 0;

	do {
		if( i > sizeof string ) {
			if ( downline )
				flash ( GETSTR );
			printf("use shorter lines or change me!!!\r\n");
			exitsamkfs(1);
		}
		string[i++] = c;
		c = getch(1);
	} while(c!=' '&&c!='\t'&&c!='\n'&&c!='\0');

	string[i] = '\0';
}

rdfs(bno, bf)
daddr_t bno; char *bf; { 
	register int n; register i;

	lseekck(fsi, bno*BSIZE, 0);
/*
	n = readck(fsi, bf, BSIZE);
*/
	n = readck (fsi, rwbuf, BSIZE);
	for (i=0; i<1024; i++)
		*bf++ = rwbuf[i];

	if(n != BSIZE) {
		if (downline)
			flash (RDFS);
		printf("read error: %ld\r\n", bno);
		exitsamkfs(1);
	}
}

/* write to disk block bno, with data pointed by bf
   always write BSIZE bytes 
 */

readck(fd,b,s) 
char *b;
{
    register int rc,i,totrc,bsize,count;

    totrc = 0;
    bsize = (s >= maxblksz) ? maxblksz : s;
    count = (s%bsize) ? ((s/bsize)+1) : s/bsize;
    for(i=0;i<count;i++,b+=rc){
    	if((rc=read(fd,b,bsize)) < 0){
		printf("read(0x%x, 0x%x, 0x%x) error 0x%x\n",fd,b,s,rc);
		return(rc);
	}
	if(rc == 0) break;
	totrc += rc;
    }
    return(totrc);
}
writeck(fd,b,s) {
    register int rc;
    if((rc=write(fd,b,s)) < 0)
	printf("write(0x%x, 0x%x, 0x%x) error 0x%x\n",fd,b,s,rc);
    return(rc);
}
lseekck(fd,p,h) {
    register int rc;
    if((rc=lseek(fd,p,h)) < 0)
	printf("lseek(0x%x, 0x%x, 0x%x) error 0x%x\n",fd,p,h,rc);
    return(rc);
}

wtfs(bno, bf)
daddr_t bno;
char *bf;
{
	int n;

	lseekck(fso, bno*BSIZE, 0);
	for (n = 0; n<1024; n++)
		rwbuf[n] = *bf++;
	n = writeck (fso, rwbuf, BSIZE);
/*
	n = writeck(fso, bf, BSIZE);
*/

	if(n != BSIZE) {
		if (downline) 
			flash (WTFS);
		printf("write error: %x\r\n", bno);
		exitsamkfs(1);
	}
}

daddr_t
alloc()
{
	int i;
	daddr_t bno;

	filsys.fs.s_tfree--;
	bno = filsys.fs.s_free[--filsys.fs.s_nfree];
	if(bno == 0) {
		if ( downline )
			flash ( ALLOC);
		printf("out of free space\r\n");
		exitsamkfs(1);
	}
	if(filsys.fs.s_nfree <= 0) {
		rdfs(bno, (char *)&fbuf);
		filsys.fs.s_nfree = fbuf.fb.df_nfree;
		for(i=0; i<NICFREE; i++)
			filsys.fs.s_free[i] = fbuf.fb.df_free[i];
	}
	return(bno);
}

bfree(bno)
daddr_t bno;
{
	int i;

	filsys.fs.s_tfree++;
	if(filsys.fs.s_nfree >= NICFREE) {

		fbuf.fb.df_nfree = filsys.fs.s_nfree;
		for(i=0; i<NICFREE; i++)
			fbuf.fb.df_free[i] = filsys.fs.s_free[i];

		wtfs(bno, (char *)&fbuf);
		filsys.fs.s_nfree = 0;
	}
	filsys.fs.s_free[filsys.fs.s_nfree++] = bno;
}

entry(inum, str, adbc, db, aibc, ib)
ino_t inum;
char *str;
int *adbc, *aibc;
char *db;
daddr_t *ib;
{
	struct direct *dp;
	int i;

	dp = (struct direct *)db;
	dp += *adbc;
	(*adbc)++;
	dp->d_ino = inum;
	for(i=0; i<DIRSIZ; i++)
		dp->d_name[i] = 0;
	for(i=0; i<DIRSIZ; i++)
		if((dp->d_name[i] = str[i]) == 0)
			break;
	if(*adbc >= NDIRECT)
		newblk(adbc, db, aibc, ib);
}

newblk(adbc, db, aibc, ib)
int *adbc, *aibc;
char *db;
daddr_t *ib;
{
	int i;
	daddr_t bno;

	bno = alloc();
	wtfs(bno, db);
	for(i=0; i<BSIZE; i++)
		db[i] = 0;
	*adbc = 0;
	ib[*aibc] = bno;
	(*aibc)++;
	if(*aibc >= NINDIR*2) {
		if ( downline )
			flash (NEWBLK);
		printf("indirect block full\r\n");
		error = 1;
		*aibc = 0;
	}
}


/* return byte count */
readbinmux(mbuf,maxct)
char	mbuf[];
int	maxct;
{
/*
modified Sept 9, 82 by Reid. mbuf is now chars instead of ints to
	improve compatiblity across systems.  proto data is still
	in same format (left four bits + ' ', middle six bits + ' ',
	right six bits + ' ').  left bits will go into mbuf[0, 2, 4...],
	right bits will got into mbuf[1, 3, 5...].  (backwards from
	z8000 style ints!!!)
*/
	int bl,bm,br,ct;
	register char val1, val2;

	if(mxeof) return(0);
	ct = 0;
	while (ct<maxct) {
		switch (bl = getch(0)) {
		case '\n':
			continue;
		case 01:	/* end of data */
			mxeof = 1;
			getch(0);	/* grep \n */
			return(ct);
		default  :
/*
			bm = getch(0);
			br = getch(0);
			if (bl < ' ' || bm < ' ' || br < ' ' || bl > ' ' + 15
					|| bm > ' ' + 63 || br > ' ' + 63) {
				if ( downline )
					flash ( READBIN);
			}
			mbuf[ct++] = (char) (((bl - ' ') << 4) |
					((bm - ' ') >> 2));
			mbuf[ct++] = (char) (((bm - ' ') << 6) | (br - ' '));
*/
			bm = getch(0);
			if ( bl > '9' )
				val1 = (char)(bl -'A' + 10);
			else
				val1 = (char)(bl -'0');
			if ( bm > '9')
				val2 = (char)(bm - 'A' + 10);
			else
				val2 = (char)(bm -'0');
			mbuf[ct++] = ((val1<<4)&0xf0) | val2;
		}
	}
	return(ct);
}

getch(echo)
int echo;
{
	register int rch;

	if (!downline )
		return(*charp++);
	
	/* check any more character in mxbuf[200] */

	if (!*mxp) {
		aputch('\n'); awaitmuxline();
	}
	rch = *mxp++;
	
	return(rch);
}

/* always put out a \n before calling awaitmuxline 
 * get a line of character from external system  into mxbuf[200]
 * if first character is \n, ignore it, ignore all \r,
 * stop until got \n, always put 0 at the end
 */

awaitmuxline() {
	register int rch;
	register char char1, char2;

	mxp = mxbuf;
	/* only stop when getting \n */
	do {
		rch = pgchar();
		if ((rch == '\n') && (mxp == mxbuf)) rch = '\0';
		if ((rch == '\0') || (rch == '\r')) continue;
		*mxp++ = rch;

	} while (rch != '\n');

	if( mxp > &mxbuf[sizeof mxbuf] ) {
		flash (AWAIT);
		exitsamkfs(1);
	}
	*mxp = 0;  mxp = mxbuf;
	
	*led_port = ledvalue;
	ledvalue = ledvalue >> 1;
	if ( ledvalue == 0 ) ledvalue = 0xff;
	if ( check == 0 ) return(0);
	
	cksum = 0;
	while ( (*mxp != '\n') && (*mxp != 01) ) {
		char1 = *mxp++;
		char2 = *mxp++;
		if ( char1 > '9' )
			char1 = (char)(char1 -'A' + 10);
		else if ( char1 >= '0' )
			char1 = (char)(char1 -'0');
		if ( char2 > '9' )
			char2 = (char)(char2 -'A' + 10);
		else if ( char2 >= '0' )
			char2 = (char)(char2 -'0');
		cksum += ((char1<<4)&0xf0) | char2 ;
	}

	if ( cksum != 0 )
		flash (CKSUM);

	if ( *mxp == 01 ) {
		mxp--; mxp--; *mxp++ = 01;
	}
	else {
		mxp--; mxp--;
	}
	*mxp++ = '\n'; *mxp = 0; mxp = mxbuf;
}

bflist()	/* build free list */
{
	struct inode in;
	daddr_t ib[NINDIR];	/* NINDIR=1024/4=256 */
	int ibc;
	char flg[MAXFN];
	int adr[MAXFN];
	int i, j;
	daddr_t f, d;

	/* fill adr[i] with interlace gap: 
	 * adr[0]=1 adr[1]=4 adr[2]=7
	 */

	for(i=0; i<f_n; i++)
		flg[i] = 0;
	i = 0;
	for(j=0; j<f_n; j++) {
		while(flg[i])
			i = (i+1)%f_n;
		adr[j] = i+1;
		flg[i]++;
		i = (i+f_m)%f_n;
	}

	/* setup inode 1 */

	ino++;
	in.i_number = ino;
	in.i_mode = IFREG;	/* regular file */
	in.i_uid = 0;
	in.i_gid = 0;
	in.i_nlink = 0;
	in.i_size = 0;

	for(i=0; i<NADDR; i++)
		in.i_addr[i] = (daddr_t)0;

	for(i=0; i<NINDIR; i++)
		ib[i] = (daddr_t)0;
	ibc = 0;

	/* free block 0 */
	bfree((daddr_t)0);

/* ****************************** */
	/* total free block decrement 1 */
	filsys.fs.s_tfree--;	

	d = filsys.fs.s_fsize-1;	/* total file system */
	while((d+cyloff)%f_n)
		d++;
	for(; (d+cyloff) > 0; d -= f_n)
	for(i=0; i<f_n; i++) {
		f = (d+cyloff) - adr[i];
		if(f < filsys.fs.s_fsize && f >= filsys.fs.s_isize)
			if(badblk(f)) {
				if(ibc >= NINDIR) {
					if ( downline )
						flash (BFLIST);
					printf("too many bad blocks\r\n");
					error = 1;
					ibc = 0;
				}
				ib[ibc] = f;
				ibc++;
			} else
				bfree(f);
	}
	if (ibc > 0)
		printf("%d bad blocks removed from freelist\n", ibc);
	in.i_size = ibc * BSIZE;
	iput(&in, &ibc, ib);
}

iput(ip, aibc, ib)
struct inode *ip;
int *aibc;
daddr_t *ib;
{
	struct dinode *dp;
	daddr_t d;
	int i;

	filsys.fs.s_tinode--;
	d = itod(ip->i_number);
	if(d >= filsys.fs.s_isize) {
		if(error == 0)
			if ( downline )
				flash (IPUT1);
			printf("ilist too small\r\n");
		error = 1;
		return;
	}
	rdfs(d, buf);
	dp = (struct dinode *)buf;
	dp += itoo(ip->i_number);

	dp->di_mode = ip->i_mode;
	dp->di_nlink = ip->i_nlink;
	dp->di_uid = ip->i_uid;
	dp->di_gid = ip->i_gid;
	dp->di_size = ip->i_size;
	dp->di_atime = utime;
	dp->di_mtime = utime;
	dp->di_ctime = utime;

	switch(ip->i_mode&IFMT) {

	case IFDIR:
	case IFREG:

		for (i = 0; i < NADDR; i++) ip->i_addr[i] = 0;
		for(i=0; i<*aibc; i++) {
			if(i >= LADDR)
				break;

			ip->i_addr[i] = ib[i];
		}
		if(*aibc > LADDR) {

			ip->i_addr[LADDR] = alloc();
			for (i=0; i<NINDIR; i++) aux1[i] = 0;
			for (i=LADDR;i<*aibc && i < LADDR+NINDIR;i++) {
				aux1[i-LADDR] = ib[i];
			}

			wtfs(ip->i_addr[LADDR], (char *)aux1);
		}
		if (*aibc > LADDR+NINDIR) {
			for (i=0;i<NINDIR;i++) {
				aux1[i]=0;
				aux2[i]=0;
			}
			aux1[0] = alloc();

			ip->i_addr[LADDR+1] = alloc();
			for (i = LADDR+NINDIR;i<*aibc&&i<NINDIR*2;i++) {
				aux2[i-LADDR-NINDIR] = ib[i];
			}
			wtfs(aux1[0],(char *)aux2);

			wtfs(ip->i_addr[LADDR+1],(char *)aux1);
		}

	case IFBLK:
	case IFCHR:

		ltol3(dp->di_addr, ip->i_addr, NADDR);
		break;

	default:
		if ( downline )
			flash (IPUT2);
		printf("bad mode %o\r\n", ip->i_mode);
		exitsamkfs(1);
	}
	wtfs(d, buf);
}

badblk(bno)
daddr_t bno;
{	struct bad_list b;
	extern struct bad_list *bsrch();

	bno += fsorg;
	b.cyl = bno / f_n;
	bno = bno % f_n;
	b.head = bno / f_t;
	b.sector = bno % f_t;
	if (bsrch(&b)) {
		return(1);
	}
	else
		return(0);
}

exitsamkfs(retcode) {
	if (downline) {  
		aputch('\n');
		*led_port = (char)0;	/* all led on */
		while ( pgchar() != 'Q' )
			rflash(0);	/* on then off */
	}
	exit(retcode);
}


rflash (led)
char led; {
	*led_port = (char)led;
	delay (1);
	*led_port = (char)0xff;
	delay(1);
}

flash(led)
char led; {
flashloop:
	rflash(led);
	goto flashloop;
	/* flash light with value led */
}

delay (n)
int n; {
	register int j,k;
	while (n--) {
		for (j=0; j<30000; j++) {
			for (k=0; k<8; k++);
		}
	}
}



c1file(par)
struct inode *par;
{
	char	cfbuf[BSIZE+4];
	char	* cfbptr;
	struct inode in;
	int dbc, ibc;
	daddr_t ib[NINDIR*2];
	register int i, f, c;
	int filesz,ct;
	static ino_t ival;
	static ino_t link;

	/*
	 * get mode, uid and gid
	 */

	cfbptr = cfbuf;	/* init cf buf pointer */
	while ((((int)cfbptr) & 0x0003) != 0) cfbptr++;	/* MOD 4 boundry */


	in.i_mode = Hdr.h_mode;
	in.i_uid = Hdr.h_uid;
	in.i_gid = Hdr.h_gid;

	/*
	 * general initialization prior to
	 * switching on format
	 */

	if(!(link))
		ino++;
	in.i_number = ino;
	for(i=0; i<BSIZE; i++)
		cfbptr[i] = 0;
	for(i=0; i<NINDIR*2; i++)
		ib[i] = (daddr_t)0;
	in.i_nlink = 1;
	in.i_size = 0;
	for(i=0; i<NADDR; i++)
		in.i_addr[i] = (daddr_t)0;

	if(par == (struct inode *)0){
		par = &in;
		in.i_nlink--;
	}

	dbc = 0;
	ibc = 0;
	switch(in.i_mode&IFMT) {

	case IFREG:
		/*
		 * regular file
		 * contents is a file name
		 */

		utime = *(time_t *)Hdr.h_mtime;
		mxeof = 0;
		check = 1;
		for(filesz=mklong(Hdr.h_filesize); filesz > 0;filesz -= BSIZE){
			ct = filesz>BSIZE? BSIZE : filesz;
			bread(cfbptr,ct);
			if(link == 0){
				in.i_size += ct;
				newblk(&dbc, cfbptr, &ibc, ib);
			}
		}

		in.i_nlink = Hdr.h_nlink;
		check = 0;
		if ( verbose )
			printf("file %s copied, %x bytes\n\r",Hdr.h_name,in.i_size);
		process++;
		break;

	case IFBLK:
	case IFCHR:
		/*
		 * special file
		 * content is maj/min types
		 */

		in.i_addr[0] = Hdr.h_rdev;
		in.i_nlink = Hdr.h_nlink;
		process++;
		break;

	case IFDIR:
		/*
		 * directory
		 * put in extra links
		 * call recursively 
		 */


		in.i_nlink++;
		par->i_nlink++;
		entry(in.i_number, ".", &dbc, cfbptr, &ibc, ib);
		entry(par->i_number, "..", &dbc, cfbptr, &ibc, ib);
		in.i_size = 2*sizeof(struct direct);
		for(;;){
			if(popit)
				break;
			if(nopro){
				nopro=0;
				ival = (link) ? link : ino+1;
				entry(ival, string, &dbc, cfbptr, &ibc, ib);
				in.i_size += sizeof(struct direct);
				c1file(&in);
			}
			else{
				if(endit) break;
				if(A_directory || process){
					process=0;
					if(!(gethdr())){
						endit++;
						break;
					}
					pushem(Hdr.h_name,Hdr.h_mode);
					if(A_directory)
						link = 0;
					else
						link = cklink();
					if(popit){
						nopro++;
						break;
					}
				}

				ival = (link) ? link : ino+1;
				entry(ival, string, &dbc, cfbptr, &ibc, ib);
				in.i_size += sizeof(struct direct);
				c1file(&in);
			}
		}
		break;
	}
	if(dbc != 0)
		newblk(&dbc, cfbptr, &ibc, ib);
	if(link == 0 || popit || endit){
		if(popit) popit--;
		iput(&in, &ibc, ib);
	}
}



/* Since we have to determine our location in the directory structure
   by reading the name of each file, it is necessary to parse each of 
   the names and push or pop the directories accordingly.  */

char pbuf[0x400];
char *cptr;
int count = 0;


pushem(name,pmode)
char * name;
ushort pmode;
{

	char *p,*r,*q,c;
	static char *t ;
	static char cbuf[0x100] = {0};
	char **pptr;
	int i,push(),pop();
	int type;
	static int oldtype;

	cptr = pbuf;
	p = name;
	type = FILE;
	t = cbuf;


	if((pmode & S_IFMT) == S_IFDIR)
		type = DIR;
	if(*t){
		q = p;
		r = t;
		while ((*q == *r)){
			r++;
			q++;
		}
		if(*r || ((oldtype == FILE) || (*q != '/')))
			while((r != t) && (*--r != '/'));
		if(*q || ((type == FILE) && (*q == '\0')))
			while((q != p) && (*--q != '/'));

		if(*r && *q){
			if(r == t)
				separate(r,pop,oldtype);
			else
				separate(++r,pop,oldtype);
			if(q == p)
				separate(q,push,type);
			else
				separate(++q,push,type);
		}
		else if(*r && !*q){
			if(r == t)
				separate(r,pop,oldtype);
			else
				separate(++r,pop,oldtype);
		}
		else{
			if(q == p)
				separate(q,push,type);
			else
				separate(++q,push,type);
		}
	}
	else 
		separate(p,push,type);
	cpy(p,cbuf);
	oldtype = type;


}


separate(par,func,type)
char *par;
int (*func) ();
int type;
{

	char *p,*q,c;
	int i;

	p = par;

		if(*p == '/' || (*p == '.' && *(p+1) == '\0') ){
			c = *(p+1);
			*(p+1) = '\0';
			(*func)(p);
			*(p+1) = c;
			p++;
		}
		
		q = p;

		while (*q){
			while(*++q != '/' && *q);

				if(*q){
					*q = '\0';
					(*func)(p);
					*q++ = '/';
					p = q;
				}
				else{
					if(type == FILE) {
						cpy(p,string);
						return;
					}
					cpy(p,string);
					(*func)(p);
				}
		}
}

push(val)
char *val;
{


		char *vptr;

		vptr = val;
		while(*vptr != '\0')
			*cptr++ = *vptr++;
		*cptr++ = '\0';

	count++;

}


pop(par)
char *par;
{

	count--;
	if(*par == '.' && *(par+1) == '\0')
		return;
	popit++;
}


cpio()
{
	register ct;
	register char *fullp;
	register i,j;
	int *addr1,*maploc;
	long filesz;
	int ret;
	int progpg;
	char dummy[10];


	addr1 = (int *)ADDR100K;

	maploc = (int *)(SMAP(addr1));

	progpg = 0x100;

/*
	Load the map addresses for one megabyte of storage on the first
   	auxiliary memory board
*/

	for(i=0;i<REMAINPG;i++){
		j = progpg++;
		*maploc++ = j << 16;
	}

	if(SYSCONF->bootdev == DTDISK){
		printf("Load the file system tape \n");
		printf("Enter the tape device number.  <CR> defaults to c0d0: ");
		gets(dummy);
		if(dummy[0] != '\0')
			strcpy(tape_buf,dummy);
	}
	else{
		printf("Load the file system tape and hit <CR>\n");
		tape_buf[1] = ((SYSCONF->bootunit>>4)&3) + 0x30;
		tape_buf[3] = ((SYSCONF->bootunit) & 7) + 0x30;
		gets(dummy);
	}

	Input = open(tape_buf,0);
#ifndef MFGSYS
	if(nine_trk){
		maxblksz = NINE_TRK_SZ;
		if((ret = ioctl(Input,TAPESTAT,dummy)) < 0){
			printf("cannot stat tape device\n");
			exit(1);
		}
	}
	printf("Does this tape contain both a Bootimage and a Root File System?\n");
	gets(dummy);
	if(dummy[0] == 'y' || dummy[0] == 'Y' || dummy[0] == 0){
		if((ret = ioctl(Input,REOF,dummy)) < 0){
			printf("cannot seek to file on tape\n");
			exit(1);
		}
	}
#else
	if(nine_trk){
		maxblksz = NINE_TRK_SZ;
		if((ret = ioctl(Input,TAPESTAT,dummy)) < 0){
			printf("cannot stat tape device\n");
			exit(1);
		}
	}
	if((ret = ioctl(Input,REOF,dummy)) < 0){
		printf("cannot seek to file on tape\n");
		exit(1);
	}
#endif


}

gethdr()		/* get file headers */
{
	register ushort ftype;
	register int i;
	register char *hptr;

	bread(&Hdr, HDRSIZE);

	if(Hdr.h_magic != MAGIC) {
		printf( "Out of phase--get help\n");
		exit(2);
	}
	bread(Hdr.h_name, Hdr.h_namesize);
	Hdr.h_name[Hdr.h_namesize] = '\0';

	if(equal(Hdr.h_name, "TRAILER!!!"))
		return (0);
	ftype = Hdr.h_mode & Filetype;
	A_directory = (ftype == S_IFDIR);
	A_special =(ftype == S_IFBLK)
		|| (ftype == S_IFCHR)
		|| (ftype == S_IFIFO);
	return (1);
}



bread(b, c)
register c;
register short *b;
{
	static nleft = 0;
	static short *ip;
	register int rv;
	register short *p = ip;

	c = (c+1)>>1;
	while(c--) {
		if(nleft == 0) {
			dataptr = (char *)ADDR100K;
			dataptr += (4 - (int)dataptr%4);
			if((rv=readck(Input, dataptr, BNUM)) != BNUM){
				if(rv < 0) {
					Input = chgreel(0, Input);
				}
			}
			nleft += (rv >> 1);
			p = (short *)dataptr;
			++Blocks;
		}
		*b++ = *p++;
		--nleft;
	}
	ip = p;
}




chgreel(x, fl)
{
	register f;
	char str[22];
	struct stat statb;

	printf( "Can't %s\n", x? "write output": "read input");
again:
	printf( "If you want to go on, type device/file name when ready\n");
	gets(str);
	if(!*str)
		exit(2);
}


equal(x,y)	
char *x,*y;
{

	while(*x) {
		if(*x++ != *y++)
			return(0);
	}
	return(1);
}

cpy(p,s)
char *s,*p;
{

	while(*p)
		*s++ = *p++;
	*s = '\0';
}

ino_t
cklink()		/* linking funtion */
{
	register i;
	struct ml *mlptr;

	if(Hdr.h_nlink == 1)  return((ino_t)0);


	for(i = 0; i < mlinks; ++i) {
		if(mlinks == LINKS) {
			printf("Too many links\n");
			break;
		}
		if(ml[i]->m_ino==Hdr.h_ino && ml[i]->m_dev==Hdr.h_dev) {
			if(verbose)
			  	printf("%s is linked \n", Hdr.h_name);
			return(ml[i]->m_oldino);
		}

	}

	mlptr = mlbuf;
	ml[mlinks] = mlptr + mlinks;
	ml[mlinks]->m_dev = Hdr.h_dev;
	ml[mlinks]->m_ino = Hdr.h_ino;
	ml[mlinks]->m_oldino = ino+1;
	++mlinks;
	return ((ino_t)0);
}

#ifdef STANDALONE

/* sw4 */
#define MAXBADBLKS	2048
struct bad_list	_badheap[3 * MAXBADBLKS];	/* space for bad, alt list */

#endif

struct bad_list *Bbp;
int		 Bbcnt;

struct bad_list *bsrch();


gdkinfo(fp, f_mp, f_np, f_sp, f_tp, fsorgp, cyloffp)
char *fp;
int  *f_mp, *f_np, *f_sp, *f_tp, *fsorgp, *cyloffp;
{	int ld,pd;
	char *ffp;
	struct sector0 sect0;
	int pdfd,i;
	char *pdstring;

	if(fp[0] == 'r'){
		for (ffp=fp; *ffp && *ffp != '('; )
			ffp++;
		if (*ffp++ != '(') {
			printf("bad file name %s\n", fp);
			exit(1);
		}
		ld = 0;
		while (*ffp >= '0' && *ffp <= '9')
			ld = ld*10 + *ffp++ - '0';
		pd = ld/16;
		ld = ld % 16;
		/* open up the reserved area */
		pdstring = "rv(0,0)";
		pdstring[3] = '0' + pd;
	}
	else{
		pdstring = "c0d0r";
		pdstring[1] = fp[1];
		pdstring[3] = fp[3];
/* sw0  */
		ld = atoi(fp+5);
	}
	if((pdfd=open(pdstring,0))<0) {
	    printf("cannot open physical disk %s\n",pdstring);
	    exit(1);
	}
	/* read sector 0 */
	if(pdfread(pdfd,0,&sect0) < 0) {
	    printf("cannot read sector 0 information on %s\n",pdstring);
	    exit(1);
	}

	*f_tp = sect0.sechead;
	*f_np = sect0.headcyl * f_t;
	*f_sp = sect0.logdrive[ld].ld_size;

	*f_mp = sect0.rec_interlace;		/* interlace factor */
	/* look at the standalone */
	if(sect0.FORMAT_LEVEL) printf("new format type, %d\n",sect0.FORMAT_LEVEL);

	if(*f_mp == 0){
		if(sect0.seccyl * sect0.cyldisk > 290000) *f_mp = 7;
		else *f_mp = 4;
	}

	*fsorgp = sect0.logdrive[ld].ld_strt;
	*cyloffp = *fsorgp % *f_tp;

/* sw1 */

	switch (sect0.logdrive[ld].ld_type ) {

	case LD_UNIXFS:
	case LD_USERSPLIT:
		gbadlist(pdfd);
		break;
	case LD_USERSPARE:
	case LD_USERSKIP:
		break;
	default:
		if(sect0.logdrive[ld].ld_type < 1 ||
		  sect0.logdrive[ld].ld_type > sizeof(ascldtype) /
		  sizeof(ascldtype[0]) )
			sect0.logdrive[ld].ld_type = 0;
		printf("invalid logical disk %d is type %s\n", ld,
		  ascldtype[sect0.logdrive[ld].ld_type]);
		exit(1);
	}
	close(pdfd);
}

gbadlist(fd)
int fd;
{	int abcnt, i;
	register struct bad_list *p, a;
	struct alt_list *abp, *ap;
	struct pdstat pdstat;
	struct badtrck *sp;
	extern int bcmp();

	if(pdfstat(fd,&pdstat)<0) {
	    printf("cannot stat physical disk\n");
	    exit(1);
	}
	/* get space for badblock and alternate lists */
	Bbcnt = pdstat.pd_bd_count;
#ifdef STANDALONE
	Bbp = _badheap;
#else
	Bbp = (struct bad_list *)malloc(Bbcnt * sizeof(struct bad_list));
#endif

	abcnt = pdstat.pd_sp_count;
#ifdef STANDALONE
	abp = (struct alt_list *)&_badheap[Bbcnt];
	i = abcnt * sizeof(struct alt_list);
	if (i < pdstat.pd_sk_count * sizeof(struct badtrck))
		i = pdstat.pd_sk_count * sizeof(struct badtrck);
	if (i > (3*MAXBADBLKS - Bbcnt) * sizeof(struct bad_list)) {
		printf("bad block/spare/skip list too long(%d/%d/%d)\n",
			Bbcnt, abcnt, pdstat.pd_sk_count);
		abp = (struct alt_list *)0;
	}
#else
	abp = (struct alt_list *)malloc(abcnt * sizeof(struct alt_list));
#endif
	if ( !Bbp || !abp ) {
		printf("cannot allocate 0x%x bytes for badblock list\nno checking will be performed\n",
			Bbcnt * sizeof(struct bad_list));
		Bbcnt = 0;
		return;
	}
	/* get the badblock list */
	if(pdfread(fd, RV_BAD_ID, Bbp) < 0) {
	    printf("cannot read bad block list\n");
	    exit(1);
	}
	qsort(Bbp, Bbp+Bbcnt, sizeof(*Bbp));

	/* get alternate list */
	if(pdfread(fd, RV_SPARE_ID, abp)<0) {
	    printf("cannot read spare table\n");
	    exit(1);
	}

	/* remove spared sectors from the list */
	for (ap=abp; abcnt--; ap++) {
		if ( ap->cyl == -1 )
			continue;
		a.cyl = ap->cyl;
		a.head = ap->head;
		a.sector = ap->sector;
		if ( (p=bsrch(&a)) )
			p->cyl = -1;
	}

	/* get skip track list */
	if(pdfread(fd, RV_SKIP_ID, abp)<0) {
		printf("cannot read skip table\n");
		exit(1);
	}
	/* remove skipped sectors */
	for (sp=(struct badtrck *)abp; i--; sp++) {
		a.cyl = sp->cyl;
		a.head = sp->head;
		a.sector = 0;
		if ( (p=bsrch(&a)) ) {
			while (p->cyl == a.cyl && p->head == a.head)
				p++->cyl = -1;
		}
	}
	p = &Bbp[Bbcnt];
	while ( --p > Bbp && p->cyl == -1 )
		Bbcnt--;
	for ( ; --p >= Bbp; ) {
		if (p->cyl == -1) {
			p->cyl = (p+1)->cyl;
			p->head = (p+1)->head;
			p->sector = (p+1)->sector;
		}
	}
#ifndef STANDALONE
	free(abp);
#endif
}

struct bad_list *
bsrch(ap)
struct bad_list *ap;
{	register struct bad_list *bp;
	register i,j,m;register short n;

	i=0;
	if ((j=Bbcnt) == 0)
		return (struct bad_list *)0;
	do	{
		m = (i+j) >> 1;
		bp = &Bbp[m];
		if (   (n=bp->cyl-ap->cyl) == 0
		    && (n=bp->head-ap->head) == 0
		    && (n=bp->sector-ap->sector) == 0 )
			return bp;
		if (n<0)
			i = m+1;
		else	j = m-1;
	} while (i<=j);
	return (struct bad_list *)0;
}

bcmp(p, q)
register struct bad_list *p, *q;
{
	int n;
	if ( (n=p->cyl-q->cyl) == 0 && (n=p->head-q->head) == 0 )
		n = p->sector - q->sector;
	return n;
}

#define NULL	0
static char *qsbuf = NULL;
int qses;

qsort(a, l, es)
char	*a, *l;
register int es;
{
	register char *i, *j;
	char	*lp, *hp;
	int c;
	void	qsexc(), qstexc();
	unsigned n;
	qses = es;

start:
	if((n=l-a) <= es)
		return;
	n = es * (n / (2*es));
	hp = lp = a+n;
	i = a;
	j = l-es;
	while(1) {
		if(i < lp) {
			if((c = bcmp(i, lp)) == 0) {
				qsexc(i, lp -= es);
				continue;
			}
			if(c < 0) {
				i += es;
				continue;
			}
		}

loop:
		if(j > hp) {
			if((c = bcmp(hp, j)) == 0) {
				qsexc(hp += es, j);
				goto loop;
			}
			if(c > 0) {
				if(i == lp) {
					qstexc(i, hp += es, j);
					i = lp += es;
					goto loop;
				}
				qsexc(i, j);
				j -= es;
				i += es;
				continue;
			}
			j -= es;
			goto loop;
		}

		if(i == lp) {
			if(lp-a >= l-hp) {
				qsort(hp+es, l, sizeof(struct bad_list));
				l = lp;
			} else {
				qsort(a, lp, sizeof(struct bad_list));
				a = hp+es;
			}
			goto start;
		}

		qstexc(j, lp -= es, i);
		j = hp -= es;
	}
}

static void
qsexc(ri, rj)
register char *ri, *rj;
{
	register int n = qses;

	do {
		register char c = *ri;
		*ri++ = *rj;
		*rj++ = c;
	} while(--n);
}

static void
qstexc(ri, rj, rk)
register char *ri, *rj, *rk;
{
	register int n = qses;

	do {
		register char c = *ri;
		*ri++ = *rk;
		*rk++ = *rj;
		*rj++ = c;
	} while(--n);
}

ioctlck(fd, n, p)
{	char *s;
	static char hexc[] = "0123456789abcdef";
	int i;

	if ((i=ioctl(fd, n, p)) == 0)
		return;
	switch (n) {
	    case INIT:
		s = "INIT";
		break;
	    case NEXTRVSEC:
		s = "NEXTRVSEC";
		break;
	    case SWAPDEV:
		s = "SWAPDEV";
		break;
	    case PHSPARE:
		s = "PHSPARE";
		break;
	    case HWSPARE:
		s = "HWSPARE";
		break;
	    case UNSPARE:
		s = "UNSPARE";
		break;
	    default:
		s = "UNKNOWN(00)";
		s[9] = hexc[n&0x0f];
		s[8] = hexc[(n>>4)&0x0f];
	}
	printf("ioctl(%s) == %d\n", s, i);
	/*exit(1);*/
}
pblist()
{	struct bad_list *p;
	printf("badblock count = %d\n", Bbcnt);
	for (p=Bbp; p < &Bbp[Bbcnt]; p++)
		printf("<%d, %d, %d> ", p->cyl, p->head, p->sector);
	printf("\r\n");
}
