#include "hsdtdtc.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevstr.h"
#include "hsdtdevdq.h"
#include "hsdttape.h"
#include "hsdterror.h"
#include "hsdtextrn.h"
#include "vreg.h"
#include "data_struct.h"


/*	return:	1 if seek error
		2 if read/write sector error
		0 if no error
 */

		

check_sort(dev,sptr)
register struct devq *dev;
register struct seek_per_disk *sptr;
{
	register struct devq *ap,*bp;


	/* sort the que */

	if((sptr->sort_count & 0xf) == 0)
		sptr->sort_ptr = sptr->s_last;
	if(!(sptr->sort_ptr)) sptr->sort_ptr = sptr->s_first;
	for (ap = sptr->sort_ptr; bp = ap->q_next;ap=bp){
		int s1, s2;
		if ((s1=ap->q_devun.pdisk.cyl-dev->q_devun.pdisk.cyl)<0)
				s1 = -s1;
		if ((s2=ap->q_devun.pdisk.cyl-bp->q_devun.pdisk.cyl)<0)
				s2 = -s2;
		if ( s1 < s2 ) 
			break;
	}
	ap->q_next = dev;
	dev->q_prev = ap;
	if((dev->q_next = bp) == (struct devq *)0)
		sptr->s_last = dev;
}
			
		



start_seek(sptr)
register struct seek_per_disk *sptr;
{

	register struct devq *dev;
	register struct dtb_que *dptr;
	register unsigned int retbyte;
	register unsigned short oldpri;

	if((dev = sptr->s_first) == (struct devq *)0)
		return(1);



	if ( sptr->current_cyl != dev->q_devun.pdisk.cyl ) {

	/* time stamp the request for system activity */
		time_counter_array[dev->q_devnum] = clock_cnt;

		retbyte =  aseek (dev, sptr);
		/* if aseek routine has problem before starting
			to seek, it will rezero drive, set rc1
		*/
		if ( retbyte ) {
			if((sptr->s_first = dev->q_next) == (struct devq *)0)
				sptr->s_last = (struct devq *)0;
			seekque.seek_active &= ~(U_L_BIT(dev->q_devnum));
			if((dev->q_flag&OPEN_DISK) == 0)
				finreq(dev,1);
		}


		return;
		
	}


	/* Since we are already on the cylinder that this request
	   needs, just put the request on the dtbque for the disk r/w 
	   and take it off of the seek queue */


	enter_short_cr;
	dptr = &dtbque;
	if((sptr->s_first = dev->q_next) == (struct devq *)0)
		sptr->s_last = (struct devq *)0;
	if(sptr->sort_ptr == dev)
		sptr->sort_ptr = dev->q_next;
	if(dptr->d_first)
		dptr->d_last->q_next = dev;
	else
		dptr->d_first = dev;
	dptr->d_last = dev;
	dev->q_next = (struct devq *)0;
	seekque.seek_active &= UNBIT(dev->q_devnum);
	exit_short_cr;
	


}
