#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdevstr.h"
#include "hsdterror.h"
#include "hsdtextrn.h"
#include "vreg.h"



/*	open physical drive if drive has not been opened
	output:	return 1 if we can't open the drive
 */

ckopdrive(dev, dkptr)
struct dkinf *dkptr;
register struct devq *dev;
{

	/* check to see if the drive has been opened */
	if ( dkptr->pd_ststat & DK_INIT )
		return (0);

	if(dkptr->pd_ststat & DK_READY)
		dev->rc1 = DER_UNFORM;
	else
		dev->rc1 = DER_NRDY;

	return(1);
}


getphptr(dev)
register struct devq *dev;
{
	if ( (dev->q_devnum) >= MAX_PDRIVE) {
		dev->rc1 = DER_DRLIMIT;
		printf ("D=%x invalid\n",dev->q_devnum);
		return (-1);
	}

	return ( (int)&phydr[dev->q_devnum] ) ;
}


convl2p (dev, dkptr)
register struct devq *dev;
register struct dkinf *dkptr;
{
	int remsec, cyl, headn, sect;

	/* ldivrem(dividend, divisor, quoteint, remainder) */
	/* ldivrem(logical sector #, #of sectors/cylinder,cylinder #,remainder */

	if ( dkptr->seccyl == 0 || dkptr->sechead == 0 ) {
		dev->rc1 = DER_ISEC;
		return (-1);
	}

	ldivrem ( dev->q_devun.block, dkptr->seccyl, &cyl, &remsec ); 
	ldivrem ( remsec, dkptr->sechead, &headn, &sect );

	if ( cyl >= dkptr->cyldisk ) {
		dev->rc1 = DER_ISEC;
		return (-1);
	}
	dev->q_devun.pdisk.cyl = cyl;
	dev->q_devun.pdisk.head = headn;
	dev->q_devun.pdisk.sector = sect;
	return (0);
}

