#include "hsdtccpu.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevstr.h"
#include "hsdtdevdq.h"
#include "hsdttape.h"
#include "hsdtdtc.h"
#include "hsdtdata.h"
#include "hsdtptm.h"
#include "hsdterror.h"
#include "hsdtextrn.h"
#include "vreg.h"
#include "data_struct.h"


extern struct tcmd {
	short opr; int (*io)();
};
extern struct tcmd taptbl[];
extern struct tcmd tap9tbl[];


/* take 0x00515fff to rewind the tape */
#define LOOPCNT2 0x00c0ffff		/* this will give 2 min */
#define LOOPCNT	0x19000

#define SEC5	0x00210000
#define SEC1	0x00002000		/* about 1ms */



/* state of online during sending tape command to archive drive */

/* tape r/w: dev->q_mem = local address, dev->q_count = # of bytes */

/* tape rewind, tension, erase, set Q11/Q24 format */
tapepos(dev)
struct devq *dev;
{
	return(tapeopr(dev, TP_NONLINE, T_M0, T_M1));

}

trwfm(dev)
struct devq *dev;
{
	register b0, b1;
	if ( dev->opr == TRFM ) {
		b0 = TRFM_M0;
		b1 = TRFM_M1;
	}
	else {
		b0 = TWFM_M0;
		b1 = TWFM_M1;
	}
	return(tapeopr (dev, TP_ONLINE, b0, b1));
}


tapeopr (dev, state, b0, b1)
register struct devq *dev; int state, b0, b1;
{
	register oldpri; register struct tape_que *taptr;
	register unsigned short status;

	/* if EXCPT on, read status, and READY must be true,
		and insure correct tape drive is selected */
	if ( ckexcpt(dev) == -1 ) 
		return(1);
    
	if ( tcmd (dev, state) )	/* we don't care about online */
		return(1);		/* tape hung, rc1=TP_HANG */

	taptr = &tapeque;

	oldpri = spl6();	

	/* allow tape interrupt */
	/* we don't use tape dma, so there is no setup to be done */

	/* ************************************ */
	/* program the clock                    */
	/* if it timesout, we need to reset the tape drive */
	taptr->t_tick = TICK_3MIN;

	if ( dev->opr == TRFM )		/* longer timeout for read filemark */
		taptr->t_tick = TICK_20MIN;
	if ( dev->opr == TENS )		/* longer timeout for tension */
		taptr->t_tick = TICK_5MIN;

	/* ************************************ */

	inturpt = (inturpt & ~TAPE_INT) | TAPEDMA_INT;
	dtc_ctl |= TAPEINT_EN;
	*DTC_CRL = dtc_ctl;

	if ( dev->q_flag & NO_WAIT ){
		splx(oldpri);
		return(0);			/* don't wait for completion */
	}
	splx(oldpri);
	printlf();
	prbuf ( dev, (sizeof (struct devq)) >> 1 );

	/* ************************************************************* */
	/* wait for READY or EXCPT to be true, always read status */
	/* timer will monitor the operation, and timout and set TAPE_INT */
	/* ************************************************************* */
	while ( (inturpt &  TAPE_INT) == 0 );

	oldpri = spl6();

	/* interrupts are disabled */
	inturpt &= ~(TAPE_INT+TAPEDMA_INT);

	/* *********************** */
	/* turn off timer for the tape */
	taptr->t_tick = 0;
	/* *********************** */

	splx(oldpri);

	/* get tape status */
	status = *TP_SR;
	if ( (status & (TP_EXCPT | TP_READY) ) == 0 ) {
		printf ("no ex/rdy ");
		blkyellow();
	}


	/* if power fail, dev->rc1 = TP_ABORT */
	if ( tstatus (dev) )
		return(1);

	/* reset dev->rc1 */
	/* mask out status byte and set dev->rc */ 
	setrc (dev, b0, b1);
}


/* **************************************************** */
/* always wait for this operation to be completed       */
/* no tape interrupts are involved, just poll the status */
/* register						 */

/* return	1 if the tape drive hangs up           	*/
/*		   if power fail occurs			*/

/* return 	0 if status is obtained  	        */
/* **************************************************** */
tstatus(dev)
register struct devq *dev;
{
	register count; register i; register oldpri;


	/* send tape status command twice, if there is no tape error */
	/* archive tape firmware problem */
	for (i=0; i<2; i++) {
		/* send status cmd to tape drive, we don't care about the
		   online bit */
		oldpri = spl6();
		if ( sendcmd (TSTATUS, TP_ONLINE, dev) ) {
			splx(oldpri);
			return(1);
		}
		splx(oldpri);
	
		/* if EXECPT is true, we may need to resend STATUS cmd	
			(incase it was in the middle of r/w) */
		/* WAIT for ready to be true */
	
	
		count = LOOPCNT2;
		while( ((*TP_SR & (TP_READY|TP_EXCPT)) == 0) && (--count) );
		if ( count == 0 ) {
			if ( (*TP_SR & (TP_READY| TP_EXCPT)) == 0 )  {
				dev->rc1 = TP_HANG;
				return (1);
			}
		}

		oldpri = spl6();
		/* if EXCEPT on, need to resend status cmd */
		if ( *TP_SR & TP_EXCPT )  {
			if ( sendcmd (TSTATUS, TP_ONLINE, dev) ) {
				splx(oldpri);
				return(1);
			}
		}

		if ( getsbyte(dev) ) {	/* get status byte & print */
			splx(oldpri);
			return(1);		/* return TIMEOUT */
		}

		splx(oldpri);
	
		/* print the tape status */
		if ( PRINT1 )
			ptapstat(dev);

		/* if no tape message shows up, send the status again */
		if ((tapdr[dev->q_devnum].tp_stat[0] & T_NOCART) == 0) {
			setrc ( dev, TST_M0, TST_M1 ); 
			return(0);
		}
		count = LOOPCNT2;
		while( ((*TP_SR & TP_READY) == 0) && (--count) );
		if ( count == 0 ) {
			dev->rc1 = TP_HANG;
			return (1);
		}
	}

	setrc ( dev, TST_M0, TST_M1 ); 
	return(0);
}
	

tprw(dev)
register struct devq *dev;
{
	register b0, b1, oldpri;
	register struct tape_que *taptr;
	unsigned int transfer_count;

	/* if EXCPT on, read status, and READY must be true
		and insure correct tape drive is selected */
	if ( ckexcpt(dev)  == -1)
		return(1);

	if ( dev->opr == TREAD ) {
		b0 = TRD_M0_B;
		b1 = TRD_M1_B;
	}
	else {
		b0 = TWR_M0_B;
		b1 = TWR_M1_B;
	}

	/* set appropriate error code before read/write */
	setrc ( dev, b0, b1 );

	if ( *(short *)&dev->rc1 ) {
		dev->q_count = 0;	/* zero bytes performed */
		printf ("p1");
		return(1); 
	}

	
	/* program TAPE DMA start & end address */
	if(dev->q_count&(TAPEBLK-1)) 
		transfer_count = (dev->q_count > TAPEBLK) ? BLKSIZE : TAPEBLK;
	else
		transfer_count = dev->q_count;

	dmaddr ( dev->local_mem->fm, transfer_count-1, TPDMA);

	if ( tcmd (dev, TP_ONLINE) )	/* online set to be true */ 
		return(1);		/* tape hang, rc1=TP_HANG */

	taptr = &tapeque;


	/* DBC control register: enable TAPE dma */
	enter_short_cr;

	/* ************************************ */
	/* set the tape timer to 3 minutes	*/
	/* if we timeout, then reset the tape drive */
	taptr->t_tick = TICK_3MIN;
	/* ************************************ */

	inturpt &= ~(TAPEDMA_INT + TAPE_INT);
	dbc_cr = dbc_cr | TP_EN;
	*DBC_CR = dbc_cr;

	/* allow tape to interrupt for either wait or no wait */
	dtc_ctl |= TAPEINT_EN;
	*DTC_CRL = dtc_ctl;
	if ( dev->q_flag & NO_WAIT ){
		exit_short_cr;
		return(0);
	}

	exit_short_cr;
	/* ************************************************************* */
	/* either wait for tape dma done or EXCEPT true */
	/* timer will monitor the operation, and timout and set TAPE_INT */
	/* ************************************************************* */
	while ( (inturpt & TAPE_INT) == 0 );

	oldpri = spl6();


	/* *********************** */
	/* turn off TICK for tape */
	taptr->t_tick = 0;
	/* *********************** */

	inturpt &= ~(TAPEDMA_INT + TAPE_INT);
	splx(oldpri);

	if ( (*TP_SR & TP_EXCPT) && PRINT1 )
		printf ("p2");

	if ( (b0= cktaperw(dev)) == 0 )
		return(0);
	
	else if ( b0 == TIMEOUT )
		return (TIMEOUT);


	/* compute how many bytes performed */
	dev->q_count =  dev->q_count - (*TP_DMAE + 1 - *TP_DMAS);

	/* disable tape dma incase never done */
	oldpri = spl6();
	dbc_cr &= ~TP_EN;
	*DBC_CR = dbc_cr;
	splx (oldpri);
	
	if ( PRINT1 )
		printf ("cnt=%x\n", dev->q_count);
	return (1);
}


/* ***************************************** */
/* return 	TIMEOUT if tape drive hangup */
/*		dev->rc1 = TP_HANG	     */
/*		dev->q_count = 0   	     */
/* return 	0 if READY on                */
/* return	-1 if EXCPT on, read status  */
/* ***************************************** */
cktaperw(dev)
register struct devq *dev;
{
	register int b0, b1;

	/* if EXCPT on, read status, and READY must be true */
	if ( (b0 = ckexcpt (dev)) == 0 )
		return (0);			/* no exception, everything 
						   is ok */

	if (b0 == -1 ) {
		dev->q_count = 0;		/* tape hung, power fail */
		return (b0);
	}

	/* except is set */

	/* problem with r/w, set appropriate error code, and set
		number of bytes performed */
	if ( dev->opr == TREAD ) {
		b0 = TRD_M0;
		b1 = TRD_M1;
	}
	else {
		b0 = TWR_M0;
		b1 = TWR_M1;
	}

	setrc ( dev, b0, b1);
	return (1);
}


/* 
	Insure correct tape drive is selected
	check tape status, if EXCEPT is true, read status
	and READY must be true when return
	(either EXCEPT or READY must be on)

	return 0 if READY TRUE
	return 1 if EXCEPT true and read tape status
	return -1 if tape drive hang or power fail occur
		dev->rc1 = error code
 */
ckexcpt(dev)
register struct devq *dev;
{
	register unsigned short status; register i;

	for (i=0; i< LOOPCNT; i++) {
		/* if EXCEPT on, send tape status command to clear it */
		if ( (status = *TP_SR) & TP_EXCPT ) {
			if(tstatus (dev)) return(-1);
			return (1);
		}
		else if ( status & TP_READY ) 
			return (0);

	}

	dev->rc1 = TP_HANG;
	return (1);
}

/*
	read in 6 bytes of status from archive tape drive 
	and print them out
	return 1 if tape drive hangs up
 */
getsbyte (dev)
register struct devq *dev;
{
	register i, j; register char *ptr;
	register unsigned short status;

	ptr = (char *)tapdr[dev->q_devnum].tp_stat;

	for (i=0; i<6; i++) {
		/* wait for ready to be true */
		j = 0;
		while ( ( (status = *TP_SR) & TP_READY ) == 0 ) {
			if ( j++ >= LOOPCNT ) {
				dev->rc1 = TP_HANG;
				return(1);
			}
		}

		*ptr++ = status & 0xff;		/* store status byte */

		/* set REQ to inform status byte is read */
		*TP_CR = tp_cr | TP_REQ;

		/* wait for > 20us before resetting REQ */
		j = 15;
		while (j--);
		*TP_CR = tp_cr & ~TP_REQ;
	}
if(PRINT1){
	printf("stat__");
	for(i=5;i>=0;i--)
	printf(" %x ",*(((char *)tapdr[dev->q_devnum].tp_stat)+i));
	printf("\n");
}
	return(0);
}


/* ***********************************
	return TIMEOUT if tape drive hangs up
	dev->rc1 = TP_HANG
 *********************************** */
tcmd (dev, state)
register struct devq *dev; int state;
{
	register oldpri, i;

	/* wait for READY to be true */
	i=0;
	while ( (*TP_SR & TP_READY) == 0 ) {
		if ( i++ >= LOOPCNT ) {
			dev->rc1 = TP_HANG;
			return (TIMEOUT);
		}
	}


	if ( (dev->opr == TWRITE) || (dev->opr == TREAD) ) {
		/* no need to send cmd if it is the same as previous */
		if ( lastpcmd == dev->opr )
			return (0);
	}

	oldpri = spl6();
	if ( sendcmd (dev->opr,state, dev) ) {
		splx(oldpri);
		return (1);
	}
	splx(oldpri);
	return (0);
}


/* *********************************************** 
interrupts are disabled before enterring this routine
output:
	return 0 if command accept
	return -1 if tape drive doesn't't communicate 
		or power fail occurs
		dev->rc1 = TP_HANG/TP_ABORT
 *********************************************** */
sendcmd(opr, state, dev)
register unsigned char opr;
int state; register struct devq *dev;
{
	register i,j;

	i = LOOPCNT;
	j = LOOPCNT;
	if ( state & TP_ONLINE )
		tp_cr |= TP_ONLINE; 

	/* send cmd and set/reset online */
	*TP_CR = tp_cr | opr;
	lastpcmd = opr;
	
	/* set REQUEST */
	*TP_CR = tp_cr | TP_REQ | opr;

	/* wait for READY to be true - command accpeted */
	/* ready reset < .25 us - acknowledge strobe */
	
	while ( ((*TP_SR & TP_READY) == 0) && (--i) );
	if ( i == 0 ) {
		dev->rc1 = TP_HANG;
		return (1);
	}

	/* reset REQUEST */
	*TP_CR = tp_cr  & ~TP_REQ;

	/* wait for READY false for command execution */
	/* READY false only last 20u sec */
	while ( (*TP_SR & TP_READY) && (--j) );

	if ( j==0 ) {
		dev->rc1 = TP_HANG;
		return (1);
	}

	return(0);
}

/* ????????????????????????????????????????????????? */
setape(drive)
char drive;
{
	struct devq dkreq; register struct devq *p;
	register unsigned short status;
	register struct tp *taptr;

	taptr = &tapdr[drive];
	tp_cr = 0;	/* keep track online bit */

	if ( (status = *TP_SR) & TP_READY ) {
		
		/* print out tape status */
		p = &dkreq;
		initdevq (p);
		p->q_devtype = TAPE;
		p->q_devnum = drive;

		/* will wait for it */
		if ( tstatus (p) )
			return (1);
		taptr->tp_type = TAPEON | TP_ARCH;
		return(0);
	}

	/* no ready, no except, try reset the drive */
	if ( (status & TP_EXCPT) == 0 ) {
		resetape();

		if ( (*TP_SR & (short)TP_EXCPT) == 0 ) {
			/* after reset, still no except, then no drive */
			taptr->tp_type = TP_ARCH;
			printf ("no tape\n");
			return(1);
		}
	}

	taptr->tp_type = TAPEON | TP_ARCH;

	/* print out tape status */
	p = &dkreq;
	initdevq (p);
	p->q_devtype = TAPE;
	p->q_devnum = drive;

	/* will wait for it , either return 0 or -1 */
	if ( tstatus (p) )
		return(1);		/* return TIMEOUT */
	return(0);
}
extern int start_up;
resetape()
{
	register count;
	*TP_CR = TP_RESET;
	/* wait min 25 us */
	count=40;
	while ( count--);
	*TP_CR = 0;
	/* wait about 5 seconds */
	if(start_up)
		count = SEC1; /* long enough for start up */
	else
		count = SEC5;
	while ( --count );
}
setup_tape(dev)
struct devq *dev;
{
	register struct tcmd *p;
	register struct tape_que *tape_ptr;

	if(tapdr[dev->q_devnum].tp_type & TP_ARCH)
		p = &taptbl[dev->q_cmd];
	else
		p = &tap9tbl[dev->q_cmd];
	if((p->io) (dev)){
		tape_ptr = &tapeque;
		enter_short_cr;
		if((tape_ptr->t_first = dev->q_next) == (struct devq *)0)
			tape_ptr->t_last = (struct devq *)0;
		finreq(dev,1);
		if(ipque.i_p_first->q_key == dev->q_key){
			*(short *)&ipque.i_p_first->rc1 = *(short *)&dev->rc1;
			*(short *)&ipque.i_p_first->sectleft = *(short *)&dev->sectleft;
			ipque.i_p_block = FINISHED;
		}
		tape_ptr->t_active = 0;
		exit_short_cr;
	}
}

