
#include "hsdtccpu.h"
#include "hsdtdtc.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdevstr.h"
#include "hsdtextrn.h"

/* power up , tape should have EXCEPTION on */
cktapeon(drive)
char drive;
{
	struct devq dkreq; register struct devq *p; register count;
	register struct tp *taptr;

	taptr = &tapdr[drive];
	tp_cr = 0;	/* keep track online bit */

	/* check if tape drive online */
	if ( (*TP_SR & (short)TP_EXCPT) == 0 ) {
	/* no except on reset, try to reset the drive, then EXCPT must be on */
		*TP_CR = TP_RESET;
		/* wait min 13 us */
		count=20;
		while ( count--);
		*TP_CR = 0;

		if ( (*TP_SR & (short)TP_EXCPT) == 0 ) {
			/* after reset, still no except, then no drive */
			taptr->tp_type = TP_ARCH;
			printf ("no tape\n");
			return(-1);
		}
	}

	taptr->tp_type = TAPEON | TP_ARCH;

	/* print out tape status */
	p = &dkreq;
	initdevq (p);
	p->q_devtype = TAPE;
	p->q_devnum = drive;

	/* will wait for it */
	if ( tstatus (p) )
		return (-1);
	return(0);
}
