/*----------------------------------------------------------------------------
/ scsivar.h - global variables used for scsi disktest
/
/ Craig J. Kim      June 1988
/ (c) Copyright 1988 ARIX Corp.
/---------------------------------------------------------------------------*/

#ifndef _DISKTEST_
#include "disktest.h"
#endif

#ifndef _SCSITEST_
#include "scsitest.h"
#endif

struct devq sc_devreq;                  /* device request thru CPU PROM */
int scsi_drvtype;                       /* subscript to scsi_drv[] */

struct _scsi_inquiry        inquiry;    /* INQUIRY command */
struct _scsi_mode_sense     msense;     /* MODE SELECT/SENSE */
struct _scsi_mode_error     merror;     /* MODE SELECT/SENSE */
struct _scsi_mode_conn      mconn;      /* MODE SELECT/SENSE */
struct _scsi_mode_format    mformat;    /* MODE SELECT/SENSE */
struct _scsi_mode_geo       mgeo;       /* MODE SELECT/SENSE */
struct _scsi_mode_flex      mflex;      /* MODE SELECT/SENSE */
struct _scsi_read_cap       capacity;   /* READ CAPACITY */
struct _scsi_xreq_sense     rerror;     /* REQUEST SENSE */

extern int fmt_cdc();                   /* CDC specific format parameters */

struct _scsi_drvparms       scsi_drv[SCSI_NUMDRVS] = {
/*      diskname,           nam,as,gp,mb,cyldk,hdcy,schd,bytsc,ft,c,c,a,s,s,*,fmtfunc   initfunc  */
        { "UNKNOWN $$$",    11, 0, 1, 0, 0,    0,   0,   1024, 0, 0,0,0,0,0,0,0,        0       },
        { "MICROP  157",    11, 0, 5, 0, 1224, 15,  18,  1024, 25,1,0,0,1,0,0,0,        0       },
        { "CDC     94171",  13, 0, 1, 0, 1549, 9,   24,  1024, 20,1,1,1,1,1,0,fmt_cdc,  0       },
        { "CDC     94161",  13, 0, 8, 0, 967,  9,   19,  1024, 15,1,0,1,1,0,0,0,        0       },
        { "PRIAM   717",    11, 0, 7, 0, 1225, 7,   19,  1024, 15,1,0,0,1,0,0,0,        0       },
        { "PRIAM   738",    11, 0, 7, 0, 1225, 15,  19,  1024, 25,1,0,0,1,0,0,0,        0       },
        { "NT      8508",   12, 0, 1, 0, 1494, 8,   41,  1024, 20,1,0,0,0,1,0,0,        0       },
        { "NT      8512",   12, 0, 1, 0, 1494, 12,  41,  1024, 25,1,0,0,0,1,0,0,        0       },
        { "NT      8514",   12, 0, 1, 0, 1581, 14,  41,  1024, 25,1,0,0,0,1,0,0,        0       },
        { "NT      9514",   12, 0, 1, 0, 2300, 14,  41,  1024, 25,1,0,0,0,1,0,0,        0       },
        { "NT      9516",   12, 0, 1, 0, 2300, 16,  41,  1024, 25,1,0,0,0,1,0,0,        0       }
};

/*--------------------------- End of scsivar.h -----------------------------*/
