/*----------------------------------------------------------------------------
/ get.c - input routines
/
/ (c) Copyright 1988 ARIX Corp. San Jose, CA
/---------------------------------------------------------------------------*/

#ifndef _DISKTEST_
#include "disktest.h"
#endif

/*---------------------------------------------------- gets() --------------*/
gets(buf_ptr,buf_size)
char *buf_ptr;
unsigned buf_size;
{
    register int c;
    register unsigned charnum = 0;

    while ((c = pgchar()) != '\r') {
        switch (c) {
            case '\b':
                if (charnum) {
                    printf("\b \b");
                    --charnum;
                    --buf_ptr;
                }
                break;
            default:
                ++charnum;
                putchar(c);
                *buf_ptr++ = c;
                break;
        }
        if (charnum == buf_size)
            return(-1);
    }
    *buf_ptr = 0;                       /* terminate the string */
    putchar('\n');
    return(charnum);
}

/*---------------------------------------------------- getlong() -----------*/
getlong(buf_vector, ret_val)
register char **buf_vector;
unsigned *ret_val;
{
    register char c, *ptr;
    register unsigned value = 0;        /* init */

    skipsp(buf_vector);                 /* skip over possible spaces */
    ptr = *buf_vector;
    while ((c = asc_to_hex(*ptr)) != -1) { /* convert all valid characters */
        value = (value << 4) + c;       /* add in value */
        ptr++;
    }

    if (!isdelimit(*ptr) || ptr == *buf_vector)
        return(-1);                     /* invalid character or no arg */
    *buf_vector = ptr;                  /* point where we left off */
    *ret_val = value;
    return(0);
}

/*---------------------------------------------------- getarg() ------------*/
getarg(buf_vector, ret_val, num_args)
char **buf_vector;
register unsigned *ret_val;
register unsigned num_args;
{
    while (num_args--) {
        if (getlong(buf_vector, ret_val++) < 0)
            return(-1);
    }
    return(0);
}

/*---------------------------------------------------- get_num() -----------*/
get_num(prompt)
char *prompt;
{
    unsigned int temp;
    char *p;

    while (1) {
        printf("%s--> ", prompt);
        p = buffer;
        if (gets(p, CBUFSIZ) < 0)
            prhuh();
        else if (usrabort())
            longjmp(MenuBuffer,1);
        else if (getlong(&p, &temp) < 0)
            prhuh();
        else
            return(temp);
    }
}

/*---------------------------------------------------- get_qnum() ----------*/
get_qnum(prompt)
char *prompt;
{
    unsigned int temp;
    char *p;

    while (1) {
        printf("%s--> ", prompt);
        p = buffer;
        if (gets(p, CBUFSIZ) < 0)
            prhuh();
        else if (*p == 'q')
            return(-1);
        else if (usrabort())
            longjmp(MenuBuffer,1);
        else if (getlong(&p, &temp) < 0)
            prhuh();
        else
            return(temp);
    }
}

/*---------------------------------------------------- get_qunum() ---------*/
get_qunum(unum, prompt)
uint *unum;
char *prompt;
{
    uint temp;
    char *p;

    while (1) {
        printf("%s--> ", prompt);
        p = buffer;
        if (gets(p, CBUFSIZ) < 0)
            prhuh();
        else if (*p == 'q')
            return(FALSE);
        else if (usrabort())
            longjmp(MenuBuffer,1);
        else if (getlong(&p, &temp) < 0)
            prhuh();
        else
            break;
    }
    *unum = temp;
    return(TRUE);
}

/*---------------------------------------------------- getyn() ---------------
/ returns TRUE if user enters 'y' or 'Y'
/ returns FALSE if user enters 'n' or 'N'
/---------------------------------------------------------------------------*/
int getyn(prompt)
char *prompt;
{
    register int c;

    while (1) {
        printf("%s? (y,n) ", prompt);
        if ((c = getreply()) < 0)       /* check for escape */
            longjmp(MenuBuffer, 1);
        if (c == 'y' || c == 'Y')       /* a positive user */
            return(TRUE);
        else if (c == 'n' || c == 'N')  /* a pessimistic user */
            return(FALSE);
        else
            printf("Please reply 'y' or 'n'.\n");
    }
}

/*---------------------------------------------------- getreply() ----------*/
getreply()
{
    register int c;

    while (1)
        if ((c = conin()) != -1 || usrabort()) {
            printf("%c\n", isprint(c) ? c : ' ');
            return(c);
        }
}

/*---------------------------------------------------- prhuh() -------------*/
prhuh()
{
    printf("\nHuh?\n");
}

/*---------------------------------------------------- pr_no_good() --------*/
pr_no_good()
{
    printf("Value out of range\n");
}

/*---------------------------------------------------- q_continue() --------*/
q_continue()
{
    printf("Press [Return] to continue -- [Esc] to exit--> ");
    if (getreply() < 0)
        return(FALSE);
    return(TRUE);
}

/*---------------------------------------------------- qc_continue() -------*/
qc_continue()
{
    register int c;

    while (1) {
        printf("More? (Y)es, N)o, [Esc]=exit)--> ");
        if ((c = getreply()) < 0)
            return(ESCAPE);
        if (c == 13 || c == ' ' || c == 'y' || c == 'Y' || c == 'n' || c == 'N')
            return(c);
    }
}

/*--------------------------------- End of get.c ---------------------------*/
