/*----------------------------------------------------------------------------
/ disk.c
/
/ (c) Copyright 1988 ARIX Corp.  San Jose, CA
/---------------------------------------------------------------------------*/

#include "disktest.h"

unsigned short CurCyl;

/********************************************************************!HDR!*****
 * test_drive()
 * 	
 * read/write the specified sectors
 *
 ********************************************************************!RDH!*****/
test_drive(start_sector,num_of_sectors,command)
	register unsigned start_sector,num_of_sectors;
	unsigned command;
{	register unsigned this_pack,end_sect;

	printf("\r%s pass %d pattern ",command == PREADPS ? "read" : "write",Pass);
	if(DBPat) printf("DEBUG\n");
	else {
		printf("%8x\n",Pattern);
		init_buffer(CompBuf,MthrBlk.sechead * MthrBlk.bytesec,0,1,Pattern);
	}
	end_sect = start_sector + num_of_sectors;
	/*
	 * break up into track or less operations
	*/
	while(start_sector < end_sect) { 
		this_pack = MthrBlk.sechead - (start_sector % MthrBlk.sechead);
		if (this_pack > num_of_sectors) this_pack = num_of_sectors;
		do_track(start_sector,this_pack,command,0);
		start_sector += this_pack;
		num_of_sectors -= this_pack;
	}
}

/********************************************************************!HDR!*****
 * do_track(lsect,nsect,cmd,retry)
 * 	
 *   perform READ/WRITE for a track
 *
 * input:
 *
 *   lsect      starting sector
 *   nsect	number of sectors
 *   cmd	command ( READ or WRITE )
 *   retry	number of retries
 *
 ********************************************************************!RDH!*****/
do_track(lsect,nsect,cmd,retry)
	register lsect, cmd;
{	struct sectid psect;
	struct devq devq;
	register x, xbc, bsect;
	register unsigned retcode;
	int bspot, bbyte;

	xbc = nsect * MthrBlk.bytesec; /* expected byte count */
	if(xbc == 0) return; /* nothing to read */
	if(DBPat) init_buffer(CompBuf,xbc,lsect,0,0);

	/* test to see if the user wishes to ESCAPE */
	if(conin() == 's') show_status();
	if(usrabort()) report_errs();

	log_to_phys(lsect, &psect);
	if(psect.cyl != CurCyl) {
#ifndef MFGSYS
		printf("\rcylinder 0x%x ",psect.cyl);
#endif
		CurCyl = psect.cyl;
	}

	/* program the disk parameter block */
	devq.q_devtype = DTDISK;
	devq.q_devnum = DriveNum;
	devq.q_cmd = cmd;
	devq.q_count = xbc;
	devq.q_devun.pdisk.cyl = psect.cyl;
	devq.q_devun.pdisk.head = psect.head;
	devq.q_devun.pdisk.sector = psect.sector;
	devq.q_extdtb = XDDFLT;
	if(cmd == PREADPS) {
		if(Compare) init_buffer(TrackBuffer,xbc,lsect,1,0);
		devq.q_mem = (char *)TrackBuffer;
	} else devq.q_mem = (char *)CompBuf;
	devq.q_priority = 0;
	devq.q_mmu = 0;
	devq.q_flag = 1; /* no automatic retries */
	devq.rc1 = 0;
	devq.rc2 = 0;
	x = devreq(SlotPtr,&devq);
	retcode = (devq.rc1 << 8) | devq.rc2;
	if(cmd == PREADPS && Compare) {
		bspot = comp_bufs(TrackBuffer,CompBuf,devq.q_count);
		if(bspot < devq.q_count) {
			bsect = lsect + (bspot / MthrBlk.bytesec); /* calculate logical bad sector */
			bbyte = bspot % MthrBlk.bytesec; /* get byte offset into sector */
			log_to_phys(bsect,&psect);
			printf("\rcompare error #%d location %x sh be %8x is %8x\n",
					++CompErr, bbyte, *(unsigned *)(bspot + CompBuf),
					*(unsigned *)(bspot + TrackBuffer));
			id_sect(&psect);
			file_error(0,&psect,bbyte, /* compare error = 0 */
					*(unsigned *)(bspot + TrackBuffer),
					*(unsigned *)(bspot + CompBuf),0); /* retry count of 0 */
			if(DumpIt) dumper(TrackBuffer + (bspot - bbyte)); /* dump read buffer */
		}
	}
	if(x < 0 || retcode) {
		bsect = lsect + (devq.q_count / MthrBlk.bytesec); /* compute bad sector */
		log_to_phys(bsect,&psect);
		if(retry < RETRYCOUNT) { /* soft disk error */
			x = ++SoftDiskErr;
			printf("\rsoft");
		} else {
			SoftDiskErr -= RETRYCOUNT; /* compensate for the hard error */
			x = ++HardDiskErr;
			printf("\rhard");
		}
		printf(" disk error #%d  retcode %4x\n", x, retcode);
		id_sect(&psect);
		file_error(1,&psect,0,retcode,Pattern,retry); /* 1 = disk error */
		if(retry < RETRYCOUNT) { /* soft disk error */
			do_track(bsect,1,cmd,retry+1); /* retry the bad sector */
			bsect++; /* bump to next (hopefully good) sector */
			if(retry == 0) do_track(bsect,nsect - (bsect - lsect),cmd,0); /* finish the track */
		}
	}
}


/* Initialize the specified buffer w/pattern */
init_buffer(address,size_bytes,sector,pat_flag,pattern)
	register unsigned pattern,*address,sector;
	unsigned pat_flag,size_bytes;
{	register unsigned count,size_lwrds,*k;

	size_lwrds = WrdsPerSect >> 1; /* sector size in long words */
	k = (address + (size_bytes >> 2));
	if (pat_flag)
		while (address < k) *address++ = pattern;
	else
		while (address < k) {
			for (count=0; count<size_lwrds;) {
				*address++ = (Pass << 16) | ((unsigned short)((sector << 8) | (count++)));
			}
			++sector;
		}
}

/*-------------------------------- End of disk.c ---------------------------*/
