/*----------------------------------------------------------------------------
/ disbad.c
/
/ (c) Copyright 1988 ARIX Corp.  San Jose, CA
/---------------------------------------------------------------------------*/

#include "disktest.h"

disbad()
{
	register i;
	register count = 0;
	register linecount = 0;
	register struct sectid *eptr;
	register lsect = 0x10; /* start of bad sector list */
	register struct badlist *bdptr = (struct badlist *)TrackBuffer;

	errnum = 1;
	while(lsect) {
		for(i=0; i<2; i++) {
			if(lsectop(PREADPS,lsect+i,bdptr+i,"display bad sector list") < 0)
				return;
		}
		if((i = comp_bufs(bdptr,bdptr+1,sectsiz)) < sectsiz) {
			printf("sectors 0x%x and 0x%x are not equal at byte 0x%x...abort\n",
				lsect,lsect+1,i);
			return;
		}
		if(wrdcmp(BadId,bdptr->id) != 0 || bdptr->idfield != BADSECID ||
			bdptr->seqnum != count++) {
				printf("bad sector block improperly initialized...abort\n");
				return;
		}
		eptr = bdptr->badsctrinfo; /* first entry of block */
		while(1) { /* display this block */
			if(bdptr->numofentries == 0) {
				if (errnum == 1)
					printf("no bad blocks in list\n");
				break;
			}
			if(++linecount > 22) {
				linecount = 0;
				if(!q_continue()) return;
			}
			printf("%d) ",errnum++);
			id_sect(eptr++);
			bdptr->numofentries--;
		}
		lsect = bdptr->nextsec;
	}
}

/*--------------------------------- End of disbad.c ------------------------*/
