
#include "disksect.h"
#include "pdf.h"
#include "setjmp.h"

#ifdef UNIXSTANDALONE
#include <termio.h>
#include <stdio.h>
#include <signal.h>

int UNIXfd, UNIXpdnext;
#endif

struct pdstat pdstat;

struct pdstat *statbuf;

#define BSIZE 0x400
#define DISK_INIT 'INIT'

#define devtype(s) (*(short *)s)

#define DEFAULT_DEST "00"
char dstname[200];

jmp_buf errorbuf;
int debugflag = 0; /* for the error module */

char secbuf[BSIZE];
struct sector0 *pd;


pversion(){
    printf("\nStandalone defectlist  (VER 4.03)\n\n");
}

#ifndef UNIXSTANDALONE
main() {
    int fd = 0;

    pversion();
    setjmp(errorbuf);
    if(fd) close(fd);
    fd = getdrive();
    defectenter(fd);
}
#endif

getdrive() {
    int rc;
    int dstfd;

    printf("Enter disk drive unit, <CR> defaults to %s: ",DEFAULT_DEST);
    gets(dstname);
    if(dstname[0] == 0) strcpy(dstname, DEFAULT_DEST);
    dstfd = opensa(dstname,"rv");
    return(dstfd);
}

opensa(icbchar,sachar) /* s is ascii of the ICB nibbles for controller:device */
register char *sachar; /* mt or rv */
register char *icbchar;
{
    int fd;
    register char *p = icbchar;
    char *sadevchar;

#define CCHAR 1
#define DCHAR 3
    sadevchar = "c?d?r";

    /* validate icbchar, turn into sa number */
    /* if mt then was forced in zero */

    if(!*p) error("missing device number");
    if(*p < '0' || *p > '9') error(" non numeric device entered");
    if(*(p+1)) { /* more than one, first times 4 disks per dt_board */
	if(*p > '3')error("bug, only controllers 0-3 supported");
	sadevchar[CCHAR] = *p++;
    } else {
	sadevchar[CCHAR] = '0';
    }
    if(*p < '0' || *p > '9') error(" non numeric device entered");
    if(*p > '3') error("only 4 disks per controller");

    sadevchar[DCHAR] = *p++;
    if(*p) error("too many characters entered");


    fd = openck(sadevchar,2);
    if(devtype(sachar) == 'rv') {
	if(pdfread(fd, PDF_SECT0, secbuf) < 0)
	    errxit("read error on sector 0\n");
	/* should be an ioctl/subroutine for valid sector 0, and boot start */
	pd = (struct sector0 *)secbuf;
	if(*(long *)pd->id != DISK_INIT)
	    error("disk not initialized");
	if(pd->pd_ldnum != 0) {
	    warn("disk is allready setup");
	    confirm();
	}
	if(pdfstat(fd,&pdstat) < 0) {
	    warn("defectlist: pdfstat failed, ignoring");
	    statbuf = 0;
	} else statbuf = &pdstat;
#ifdef UNIXSTANDALONE
	UNIXpdnext = pd->nextsec;
#endif
    } else
	error("Sorry, %s ??, cannot handle this type of device",sadevchar);
    return(fd);
}

openck(s,h) {
    int fd;

    if((fd=open(s,h)) < 0)
	error("open error on device %s",s);
    return(fd);
}

#ifdef UNIXSTANDALONE

static struct termio oldt,newt;

int catchit();

main(){
    int fd;
    setbuf(stdout,0);
    signal(SIGINT, catchit);
    signal(SIGBUS, catchit);
    signal(SIGSEGV, catchit);
    ioctl(0,TCGETA,&oldt);
    newt=oldt;

    /* make terminal look raw */
    newt.c_iflag = 0;
    newt.c_lflag &= ISIG; /* only leave signals on, ICANON off */
    newt.c_cc[VMIN] = 1;
    newt.c_cc[VTIME] = 0;
    /* ioctl(0,TCSETAW,&oldt); */

    pversion();

    fd = getdrive();
    UNIXfd = fd;
    while(1)
	defectenter(fd); /* loop for testing */

    ioctl(0,TCSETAW,&oldt);
}
catchit(trap) {
    ioctl(0,TCSETAW,&oldt);
    printf("trap %d\n",trap);
    exit(1);
}
devreq(){
    return -1; /* shouldn't be doing this */
}
format() {
}
static int abflag;
usrabort() {
    if(abflag)return(-1);
    else return(0);
}
conin() {
    if(abflag)return -1;
    return (pgchar());
}
pgchar() {
    unsigned char c;

gagain:
    ioctl(0,TCSETAW,&newt);
    read(0,&c,1);
    if( c == 0x1b ) {
	abflag++;
	goto gagain;
    }
    ioctl(0,TCSETAW,&oldt);
    return(c);
}
#endif
