
#	@(#)boot.mk	1.3
include $(IROOT)/macdefs
include ../../macdefs

NAME = boot
LIB = -L../../lib -lsc
LIB1= ../../lib/libsc.a
LDF = ../../lib/ld.boot
CRT0 = ../../lib/scrt0.o
INCDIR = ../../head

.SUFFIXES: .c .s .o

.s.o:
	$(AS) $(ASFLAGS) -o $@ $*.s

CFLAG = -DEBUG -I$(INCRT) -W0,-sp -DSTANDALONE  
DFLAG = -W0,-sp -DSTANDALONE

all install:	$(NAME)

$(NAME):	$(LIB1) $(LDF) $(CRT0) boothead.o boot.o
	$(LD) -o $(NAME) -N $(LDF) $(CRT0) boothead.o boot.o $(LIB) 
	nm -xv $(NAME) > $(NAME).nm
	strip $(NAME)
	../sapatch/sapatch -h $(NAME)

boot.o:	$(INCDIR)/b.out.h \
	$(INCDIR)/ccpu.h \
	$(INCRT)/a.out.h \
	$(INCRT)/sys/dk.h \
	$(INCRT)/sys/iop.h \
	$(INCDIR)/misc.h \
	$(INCDIR)/globlvars.h \
	$(INCDIR)/maps.h \
	$(INCDIR)/icb.h \
	$(INCDIR)/icbcmd.h \
	$(INCDIR)/vreg.h \
	$(INCDIR)/cpu.h \
	$(INCDIR)/sysconf.h
	$(CC) -I$(INCDIR) $(CFLAG) -c boot.c

clean:
	-rm -f boot.o boothead.o

clobber: clean
	-rm -f $(NAME) $(NAME).nm
