
	* * * * * * * * * * * * * * * * * * * * * * * * * *
	*                                                 *
	*       AMPRO SYSTEM CONFIGURATION UTILITY        *
	*                                                 *
	*  Copyright (C) 1984,85,86 AMPRO COMPUTERS, INC. *
	*		All rights reserved.              *
	*                                                 *
	* * * * * * * * * * * * * * * * * * * * * * * * * *

VER	EQU	26		; Version number prints in signon message.

;Vers 2.6  rbl	5 Feb 86	Show 1772 step rates in main display
;
;Version 2.5	28 Jun 85	Show options on 1770 and 1772 FDC chips.
;
;Version 2.4	18 Jun 85	Always show "4" drives if 3.0+ bios.
;
;Version 2.3	21 May 85	Duplicated step rate logic to support
;				four individual step rates.
;
;Version 2.2	27 Mar 85	Mods to LDTE routine
;
;Version 2.1    22 Feb 85	Added routine to show the floppy drive
;				assignments.
;
;Version 2.0    10 Dec 84	Expanded to allow operation with up to
;				16 Logical disk drives.
;
;				Added code in DSKIO routine to get the
;				data from Track 1 sector 5 for floppies,
;				or from Track 0 sector 45 for hard disk.
;
;				Added test during Get From Disk time to
;				insure that a System is on the target
;				disk.
;
;Version 1.4	7 May 84	: Cleaned up some of the responses, caused
;				   only the characters of interest to be
;				   acted upon eliminating action by control
;				   characters generated by the terminal.
;
;Version 1.3	3 May 84	: Modified to exit on ESC, answer Yes
;				   instead of CR.  Also add 10 ms delay
;				   after LF output to console.
;
;Version 1.2	6 April 84	: Modified CONOUT routine to call BDOS 
;                                  instead of BIOS   
;                                 Added disk written message   

; char equates
CTLC	EQU	3		; control c
ESC	EQU	27		; escape key
CR	EQU	13		; carriage return (^m)
LF	EQU	10		; line feed (^j)
UPCASE	EQU	01011111B	; upper case mask

; bdos equates
BDOS	EQU	5		; bdos entry
RDCON	EQU	10		; read console buffer
CONBUF	EQU	80H		; console buffer

; bios equates
CNIN	EQU	9		; console in
CNOT	EQU	12		; console out

HOM	EQU	24		; disk home
SLDSK	EQU	27		; select disk
STTRK	EQU	30		; set track
STSEC	EQU	33		; set sector
STDMA	EQU	36		; set dma address
READS	EQU	39		; read sector
WRITS	EQU	42		; write sector

IOINT	EQU	57		; initialize i/o

	ORG	100H

START:	LXI	SP,STACK
	MVI	A,0
	CALL	CGTTBL		;get table address vers 2.1 >
	sta	lb$vers
	INX	H
	MOV	A,H		;if < 2.1 then hl=ffff
	ORA	L
	MVI	A,16		;for 2.1 max 16 drives
	JNZ	STNEW
	LHLD	1		;get NDSKS parameter current
	MVI	L,5CH		;offset
	MOV	A,M
STNEW:	ADI	'@'		;set drive letters
	STA	GDSK1
	STA	PDSK1
	inr	a
	STA	DSK1		;and insert to utility
	STA	DSK2
	JMP	SIGNON

CGTTBL:	LHLD	1
	MVI	L,33H
	PCHL			;for <2.1 does Unlog 
;				 2.1 returns next table address < ffff

lb$get$ldte:
	push	psw
	lda	lb$vers		; If version 1.x bios
	cpi	20
	jp	lb$2x
	lxi	h,lb$d		; then point to a dummy floppy unit
	jmp	lb$ok
lb$1:	db	1
lb$d:	lxi	h,lb$1
	ret
lb$2x:	call	cgttbl		; otherwise (2.x) get unit from table
	lxi	d,9
	dad	d
lb$ok:	pop	psw
	pchl

DISPLAY$FDEV:
	call	clearscreen
	LXI	D,D$FDEV$HDR	; Print header
	mvi	c,9
	call	bdos

	mvi	a,0		; starting unit #
D$NEXT$FDEV:
	sta	unit
	call	lb$get$ldte	; Get address of unit id	
	MOV	A,M		; Get unit id
	CPI	01		; Floppy?
	JNZ	D$BUMP$PTR	; No -- go to the next device
	inx	h		; Get drive #
	mov	a,m		; .
	ani	03h		; mask out excess bits
	MOV	l,a		; update floppy device number
	mvi	h,0		; .
	dad	h		; x2
	xchg
	LXI	H,FNAMES	; .
	dad	d		; x2
	dad	d		; x4
	dad	d		; x6
	lxi	d,d$fname	;
	lxi	b,6		; 
	db	0edh,0b0h	; . (LDIR)
	lda	unit		;
	adi	'A'		;
	sta	d$current	;
	LXI	D,D$FDEV$LIN	; and output the line
	mvi	c,9
	call	bdos

D$BUMP$PTR:
	lda	unit
	inr	a		; Bump to next unit
	cpi	16		; Done yet?
	jm	D$NEXT$FDEV	; No -- go do the next one
	RET

unit:	db	0

D$FDEV$HDR:	DB	'FLOPPY DISK ASSIGNMENTS:',CR,LF
		DB	'CP/M drive   '
		DB	'Floppy disk',CR,LF
		DB	'------------------------',CR,LF,'$'

D$FDEV$LIN:
		DB	' '
D$CURRENT:	DB	'x  '
D$EDISK:	DB	'   '
D$EBLANK:	DB	'         '
D$FNAME:	DB	'        '
		DB	CR,LF,'$'
D$FDEV$HLEN	EQU	$-D$FDEV$LIN	; Line length

FNAMES:		DB	'First '
		DB	'Second'
		DB	'Third '
		DB	'Fourth'

LB$VERS		DB	0	; Bios version number

clearscreen:
	mvi	b,24		; clear screen
clsc2:
	MVI	A,0Dh		; Send carriage return
	CALL	CON$CHR		; .
	MVI	A,0Ah		; and line feed
	CALL	CON$CHR		; .
	CALL	WAIT		; wait for the s-l-o-w terminals
	dcr	b
	jnz	clsc2
	RET			; and return

CON$CHR:
	PUSH	B
	MVI	C,2
	MOV	E,A
	CALL	BDOS
	POP	B
	RET

SIGNON:
	call	clearscreen
	CALL	ILPRT
	DB	'           AMPRO System Configuration Utility',CR,LF
	DB	'     Copyright (c) 1984,85,86 - AMPRO Computers, Inc.',CR,LF
	DB	'                       Version '
	DB	VER/10+'0','.',VER MOD 10+'0',CR,LF,LF
	DB	'With this utility you may view and change the various',CR,LF
	DB	'parameters of your AMPRO system.  You will be asked to',CR,LF
	DB	'choose to view the current parameters now in memory or',CR,LF
	DB	'to view the parameters on a system disk.  You will be',CR,LF
	DB	'asked for any changes you might make.  After any changes',CR,LF
	DB	'you will be asked whether to install the new parameters',CR,LF
	DB	'in memory and/or on a system disk.',CR,LF,LF
	DB	'View parameters from Memory or from Disk? (M or D)',CR,LF,LF
	DB	'Press <ESC> to quit.  $'

ASK1:	CALL	CONIN		; get the response
	CPI	CTLC		; control c?
	JZ	EXIT		; quit
	CPI	ESC		; escape key?
	JZ	EXIT		; quit
	ANI	UPCASE		; force upper case
	CPI	'M'		; memory?
	JZ	XXX
	CPI	'D'		; disk?
	JNZ	ASK1		; try again

; say 'disk' and ask which
ASKG:	CALL	ILPRT
	DB	'Disk$'
ASK2:	lda	lb$vers
	cpi	20
	cp	display$fdev
ask222:	CALL	ILPRT
	DB	CR,LF,LF,'Which disk shall you read from? (A thru '
GDSK1:	DB	'P)  $'
ASK2A:	CALL	CONIN		; get response
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP		; start over
	ANI	UPCASE		; force upper case
	CPI	'A'
	JC	ASK2A		; bad selection, try again
DSK1:	EQU	$+1		;modified for max drive name
	CPI	'P'+1
	JNC	ASK2A		; bad selection
	MOV	C,A		; save for conout
	ANI	0FH		; strip ascii
	DCR	A		; adjust rel 0
	STA	DISK		; remember it
	CALL	CONOUT		; to console (echo)
	CALL	GETD		; read the disk

	JZ	DISP		; display parms if a good system disk
	CALL	ILPRT		;issue a message
	DB	CR,LF,'There is no system on this disk $'
	JMP	ASK222		;and get a new disk to try

XXX:	CALL	ILPRT
	DB	'Memory$'
	CALL	GETM		; get parameters from memory

; display the parameters in iobuf
DISP:	CALL	ILPRT
	DB	CR,LF,LF,LF,'Configuration Table:'
	DB	CR,LF,LF,'Parameter:              Currently:'
	DB	CR,LF,LF,'1. Terminal             $'
	LDA	IOBYT
	ANI	3
	LXI	H,SPA
	JNZ	DISP1
	LXI	H,SPB
DISP1:	CALL	PRINT
	CALL	ILPRT
	DB	CR,LF,'2. Printer              $'
	LDA	IOBYT
	ANI	0C0H		; isolate lst assignment
	CPI	0
	LXI	H,SPB
	JZ	DISP2
	CPI	40H
	LXI	H,SPA
	JZ	DISP2
	LXI	H,PP
DISP2:	CALL	PRINT
	CALL	ILPRT
	DB	CR,LF,'3. Max. Floppy Drives   $'
	LDA	LB$VERS
	CPI	30
	JC	DISP2X
	MVI	A,4
	JMP	DISP2Y
DISP2X:
	LDA	NDSKS
DISP2Y:
	ORI	30H
	MOV	C,A
	CALL	CONOUT
	CALL	ILPRT
	DB	CR,LF,'4. Step Rate            $'
	LDA	STPRAT
	CALL	DISP2Z
	CALL	ILPRT
	DB	', $'
	LDA	STPRAT+1
	CALL	DISP2Z
	CALL	ILPRT
	DB	', $'
	LDA	STPRAT+2
	CALL	DISP2Z
	CALL	ILPRT
	DB	', $'
	LDA	STPRAT+3
	CALL	DISP2Z
	CALL	ILPRT
	DB	' $'
	JMP	DISP6A
DISP2z:
	ORA	A
	JNZ	DISP3
	CALL	ILPRT
	DB	'6ms$'
	JMP	DISP6
DISP3:	DCR	A
	JNZ	DISP4
	CALL	ILPRT
	DB	'12ms$'
	JMP	DISP6
DISP4:	DCR	A
	JNZ	DISP5
	CALL	ILPRT
	DB	'2ms$'
	JMP	DISP6
DISP5:	CALL	ILPRT
	DB	'3ms$'
DISP6:	RET

DISP6a:
	LDA	LB$VERS
	CPI	30		; skip msg if bios 3.0
	JNC	DISP6b
	CALL	ILPRT
	DB	cr,lf,9,9,'Note: The first step rate is used for all drives'
	DB	cr,lf,9,9,'      when using bios 1.x or 2.x',CR,LF,'$'
DISP6b:
	CALL	ILPRT
	DB	CR,LF,'5. Autocommand          $'
	LXI	H,AUTOCMD+1
	CALL	PRINT

	CALL	ILPRT
	DB	CR,LF,LF,'6. $'
	LXI	H,SPA
	CALL	PRINT
	LXI	D,SIOA+3
	CALL	DISP16

	CALL	ILPRT
	DB	CR,LF,'                        baud rate       $'
	LXI	B,CT0
	LXI	D,SIOA+1
	CALL	PBAUD
	CALL	ILPRT
	DB	CR,LF,'                        hand shake      $'
	LDA	HSA
	ORA	A
	LXI	H,N
	JZ	DISP15
	LXI	H,Y
DISP15:	CALL	PRINT
	CALL	ILPRT
	DB	CR,LF,LF,'7. $'
	LXI	H,SPB
	CALL	PRINT
	LXI	D,SIOB+3
	CALL	DISP16
	CALL	ILPRT
	DB	CR,LF,'                        baud rate       $'
	LXI	B,CT1
	LXI	D,SIOB+1
	CALL	PBAUD
	CALL	ILPRT
	DB	CR,LF,'                        hand shake      $'
	LDA	HSB
	ORA	A
	LXI	H,N
	JZ	DISP17
	LXI	H,Y
DISP17:	CALL	PRINT
	CALL	ILPRT
	DB	CR,LF,LF,'Any (more) changes? (1 through 7 or No) $'
DSP17A:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	CPI	'N'
	JZ	FINI
	CPI	'n'
	JZ	FINI
	CPI	'1'
	JC	DSP17A
	CPI	'8'
	JNC	DSP17A
	CPI	'7'
	JZ	CH7
	CPI	'6'
	JZ	CH6
	CPI	'5'
	JZ	CH5
	CPI	'4'
	JZ	CH4
	CPI	'3'
	JZ	CH3
	CPI	'2'
	JZ	CH2
CH1:	CALL	ILPRT
	DB	CR,LF,LF,'1. Terminal, Serial port A or Serial port B. (A or B)$'
CH1A:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	ANI	UPCASE
	CPI	'C'
	JNC	CH1A
	CPI	'A'
	JC	CH1A
	MVI	C,1
	JZ	CH10
	DCR	C
CH10:	LDA	IOBYT
	ANI	0FCH
	ORA	C
	STA	IOBYT
	JMP	DISP

CH2:	CALL	ILPRT
	DB	CR,LF,LF,'2. Printer, Serial port A, Serial port B '
	DB	'or Parallel port. (A, B or P)$'
CH2A:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	ANI	UPCASE
	CPI	'A'
	JZ	CH20
	CPI	'B'
	JZ	CH20
	CPI	'P'
	JNZ	CH2A
CH20:	CPI	'B'
	MVI	C,0
	JZ	CH21
	CPI	'A'
	MVI	C,40H
	JZ	CH21
	MVI	C,80H
CH21:	LDA	IOBYT
	ANI	3FH
	ORA	C
	STA	IOBYT
	JMP	DISP

CH3:	LDA	LB$VERS
	CPI	30
	JC	CH3X
	CALL	ILPRT
	DB	CR,LF,LF,'3. The maximum number of floppy disk '
	DB	'drives is preset to four (4)',CR,LF
	DB	'in the Ampro BIOS version 3.0 or greater.',CR,LF,LF
	DB	'Press the RETURN key to continue - ','$'
CH3R:
	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	CPI	CR
	JZ	DISP
	JMP	CH3R

CH3X:
	CALL	ILPRT
	DB	CR,LF,LF,'3. Max. drives. (1, 2, 3 or 4)$'
CH3A:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	CPI	'1'
	JC	CH3A
	CPI	'5'
	JNC	CH3A
	ANI	0FH
	STA	NDSKS
	JMP	DISP

CH4:	CALL	ILPRT
        DB	CR,LF,LF,'4. Step rates for each floppy drive '
	DB	'(in milliseconds).',CR,LF,LF
	DB	'Choices:  1770  1772',CR,LF
	DB	'   1  --   6ms   6ms',CR,LF
	DB	'   2  --  12ms  12ms',CR,LF
	DB	'   3  --  20ms   2ms',CR,LF
	DB	'   4  --  30ms   3ms',CR,LF
	DB	'$'
	CALL	ILPRT
	DB	CR,LF,'First  floppy drive rate (1-4): $'
CH4A:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	CPI	CR
	JZ	CH42A
	CPI	'1'
	MVI	C,0
	JZ	CH41A
	CPI	'2'
	MVI     C,1
	JZ 	CH41A
	CPI	'3'
	MVI	C,2
	JZ	CH41A
	CPI	'4'
	MVI 	C,3
	JNZ 	CH4A
CH41A:
	PUSH	PSW
	MOV	A,C
	STA	STPRAT
	POP	PSW
	MOV	C,A
	CALL	CONOUT
CH42A:

	CALL	ILPRT
	DB	CR,LF,'Second floppy drive rate (1-4): $'
CH4B:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	CPI	CR
	JZ	CH42B
	CPI	'1'
	MVI	C,0
	JZ	CH41B
	CPI	'2'
	MVI     C,1
	JZ 	CH41B
	CPI	'3'
	MVI	C,2
	JZ	CH41B
	CPI	'4'
	MVI 	C,3
	JNZ 	CH4B
CH41B:
	PUSH	PSW
	MOV	A,C
	STA	STPRAT+1
	POP	PSW
	MOV	C,A
	CALL	CONOUT
CH42B:

	CALL	ILPRT
	DB	CR,LF,'Third  floppy drive rate (1-4): $'
CH4C:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	CPI	CR
	JZ	CH42C
	CPI	'1'
	MVI	C,0
	JZ	CH41C
	CPI	'2'
	MVI     C,1
	JZ 	CH41c
	CPI	'3'
	MVI	C,2
	JZ	CH41c
	CPI	'4'
	MVI 	C,3
	JNZ 	CH4c
CH41c:
	PUSH	PSW
	MOV	A,C
	STA	STPRAT+2
	POP	PSW
	MOV	C,A
	CALL	CONOUT
ch42c:

	CALL	ILPRT
	DB	CR,LF,'Foruth floppy drive rate (1-4): $'
CH4D:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	CPI	CR
	JZ	CH42d
	CPI	'1'
	MVI	C,0
	JZ	CH41D
	CPI	'2'
	MVI     C,1
	JZ 	CH41D
	CPI	'3'
	MVI	C,2
	JZ	CH41D
	CPI	'4'
	MVI 	C,3
	JNZ 	CH4D
CH41D:
	PUSH	PSW
	MOV	A,C
	STA	STPRAT+3
	POP	PSW
	MOV	C,A
	CALL	CONOUT
CH42D:
	JMP	DISP

CH5:	CALL	ILPRT
	DB	CR,LF,LF,'5. Autocommand.  Command file to be executed '
	DB	'on cold boot.  $'
	LXI	D,CONBUF
	MVI	A,8
	STAX	D
	MVI	C,RDCON
	CALL	BDOS
	LXI	H,CONBUF+1
	MOV	E,M
	MVI	D,0
	DAD	D
	INX	H
	MVI	M,0
	LXI	H,CONBUF+1
	LXI	D,AUTOCMD
	LXI	B,10
	CALL	LDIR
	JMP	DISP

CH6:	CALL	ILPRT
	DB	CR,LF,LF,'Serial port A configuration'
	DB	CR,LF,LF,'Data bits.  (5, 6, 7 or 8) $'
CH6A:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	CPI	CR
	JZ	CH6B		; next
	CPI	'5'
	JC	CH6A		; again
	CPI	'9'
	JNC	CH6A
	CPI	'8'
	MVI	C,60H
	JZ	CH60
	CPI	'7'
	MVI	C,20H
	JZ	CH60
	CPI	'6'
	MVI	C,40H
	JZ	CH60
	MVI	C,0		; 5 bits
CH60:	LXI	H,SIOA+3
	MOV	A,M		; wr5 info
	ANI	9FH		; mask
	ORA	C		; add selection
	MOV	M,A		; store it
	MOV	A,C
	RAL
	MOV	C,A		; shift selection left
	LXI	H,SIOA+5
	MOV	A,M		; wr3 info
	ANI	3FH		; mask
	ORA	C
	MOV	M,A		; store it
CH6B:	CALL	ILPRT
	DB	CR,LF,LF,'Stop bits.  A=1, B=1.5, C=2. (A, B or C)$'
CH6BA:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	CPI	CR
	JZ	CH6C
	ANI	UPCASE
	CPI	'A'
	JC	CH6BA
	CPI	'D'
	JNC	CH6BA
	CPI	'A'
	MVI	C,4
	JZ	CH6B1
	CPI	'B'
	MVI	C,8
	JZ	CH6B1
	MVI	C,0CH
CH6B1:	LXI	H,SIOA+1
	MOV	A,M		; wr4 info
	ANI	0F3H		; mask
	ORA	C
	MOV	M,A		; store new info

CH6C:	CALL	ILPRT
	DB	CR,LF,LF,'Parity.  Odd, Even or None.  (O, E or N) $'
CH6CA:	CALL	CONIN
	CPI	CR
	JZ	CH6D
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	ANI	UPCASE
	CPI	'O'
	MVI	C,1
	JZ	CH6C0
	CPI	'E'
	MVI	C,3
	JZ	CH6C0
	CPI	'N'
	MVI	C,0
	JNZ	CH6CA
CH6C0:	LXI	H,SIOA+1
	MOV	A,M		; wr4 info
	ANI	0FCH		; mask
	ORA	C
	MOV	M,A		; store it

CH6D:	CALL	ILPRT
	DB	CR,LF,LF,'Baud rates:'
	DB	CR,LF,'0. 110                  5. 2400'
	DB	CR,LF,'1. 300                  6. 4800'
	DB	CR,LF,'2. 450                  7. 9600'
	DB	CR,LF,'3. 600                  8. 19200'
	DB	CR,LF,'4. 1200                 9. 38400'
	DB	CR,LF,LF,'Choose one.  (0 through 9) $'

CH6DA:	CALL	CONIN
	CPI	CR
	JZ	CH6E
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	CPI	':'
	JNC	CH6DA
	CPI	'0'
	JC	CH6DA
	JZ	B110
	CPI	'1'
	JZ	B300
	CPI	'2'
	JZ	B450
	CPI	'3'
	JZ	B600
	CPI	'4'
	JZ	B1200
	CPI	'5'
	JZ	B2400
	CPI	'6'
	JZ	B4800
	CPI	'7'
	JZ	B9600
	CPI	'8'
	JZ	B19200
B38400:	LXI	H,CT0
	MVI	A,3
	MOV	M,A
	INX	H
	MOV	M,A
	LXI	H,SIOA+1
	MOV	A,M
	ANI	3FH
	ORI	40H
	MOV	M,A
	INX	H
	INX	H		; point to wr5
	MOV	A,M
	ANI	7FH		; turn dtr off
	MOV	M,A
	JMP	CH6E

B19200:	LXI	H,CT0
	MVI	A,3
	MOV	M,A
	INX	H
	MOV	M,A
	LXI	H,SIOA+1
	MOV	A,M
	ANI	3FH
	ORI	80H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ANI	7FH
	MOV	M,A
	JMP	CH6E

B9600:	LXI	H,CT0
	MVI	A,47H
	MOV	M,A
	INX	H
	MVI	A,13
	MOV	M,A
	LXI	H,SIOA+1
	MOV	A,M
	ANI	3FH
	ORI	40H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A
	JMP	CH6E

B4800:	LXI	H,CT0
	MVI	A,47H
	MOV	M,A
	INX	H
	MVI	A,26
	MOV	M,A
	LXI	H,SIOA+1
	MOV	A,M
	ANI	3FH
	ORI	40H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A
	JMP	CH6E

B2400:	LXI	H,CT0
	MVI	A,47H
	MOV	M,A
	INX	H
	MVI	A,52
	MOV	M,A
	LXI	H,SIOA+1
	MOV	A,M
	ANI	3FH
	ORI	40H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A
	JMP	CH6E

B1200:	LXI	H,CT0
	MVI	A,47H
	MOV	M,A
	INX	H
	MVI	A,104
	MOV	M,A
	LXI	H,SIOA+1
	MOV	A,M
	ANI	3FH
	ORI	40H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A
	JMP	CH6E

B600:	LXI	H,CT0
	MVI	A,47H
	MOV	M,A
	INX	H
	MVI	A,208
	MOV	M,A
	LXI	H,SIOA+1
	MOV	A,M
	ANI	3FH
	ORI	40H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A
	JMP	CH6E

B450:	LXI	H,CT0
	MVI	A,47H
	MOV	M,A
	INX	H
	MVI	A,139
	MOV	M,A
	LXI	H,SIOA+1
	MOV	A,M
	ANI	3FH
	ORI	80H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A
	JMP	CH6E

B300:	LXI	H,CT0
	MVI	A,47H
	MOV	M,A
	INX	H
	MVI	A,208
	MOV	M,A
	LXI	H,SIOA+1
	MOV	A,M
	ANI	3FH
	ORI	80H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A
	JMP	CH6E

B110:	LXI	H,CT0
	MVI	A,7H
	MOV	M,A
	INX	H
	MVI	A,71
	MOV	M,A
	LXI	H,SIOA+1
	MOV	A,M
	ANI	3FH
	ORI	80H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A

CH6E:	CALL	ILPRT
	DB	CR,LF,LF,'Hand shake?  (Yes or No) $'
CH6EA:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	CR
	JZ	DISP
	ANI	UPCASE
	CPI	'Y'
	MVI	C,1
	JZ	CH6E1
	CPI	'N'
	MVI	C,0
	JNZ	CH6EA
CH6E1:	MOV	A,C
	STA	HSA
	JMP	DISP

	
CH7:	CALL	ILPRT
	DB	CR,LF,LF,'Serial port B configuration'
	DB	CR,LF,LF,'Data bits.  (5, 6, 7 or 8) $'
CH7A:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT		; quit
	CPI	ESC
	JZ	DISP
	CPI	CR
	JZ	CH7B		; next
	CPI	'5'
	JC	CH7A		; again
	CPI	'9'
	JNC	CH7A
	CPI	'8'
	MVI	C,60H
	JZ	CH70
	CPI	'7'
	MVI	C,20H
	JZ	CH70
	CPI	'6'
	MVI	C,40H
	JZ	CH70
	MVI	C,0		; 5 bits
CH70:	LXI	H,SIOB+3
	MOV	A,M		; wr5 info
	ANI	9FH		; mask
	ORA	C		; add selection
	MOV	M,A		; store it
	MOV	A,C
	RAL
	MOV	C,A		; shift selection left
	LXI	H,SIOB+5
	MOV	A,M		; wr3 info
	ANI	3FH		; mask
	ORA	C
	MOV	M,A		; store it
CH7B:	CALL	ILPRT
	DB	CR,LF,LF,'Stop bits.  A=1, B=1.5, C=2. (A, B or C)$'
CH7BA:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	CPI	CR
	JZ	CH7C
	ANI	UPCASE
	CPI	'A'
	JC	CH7BA
	CPI	'D'
	JNC	CH7BA
	CPI	'A'
	MVI	C,4
	JZ	CH7B1
	CPI	'B'
	MVI	C,8
	JZ	CH7B1
	MVI	C,0CH
CH7B1:	LXI	H,SIOB+1
	MOV	A,M		; wr4 info
	ANI	0F3H		; mask
	ORA	C
	MOV	M,A		; store new info

CH7C:	CALL	ILPRT
	DB	CR,LF,LF,'Parity.  Odd, Even or None.  (O, E or N) $'
CH7CA:	CALL	CONIN
	CPI	CR
	JZ	CH7D
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	ANI	UPCASE
	CPI	'O'
	MVI	C,1
	JZ	CH7C0
	CPI	'E'
	MVI	C,3
	JZ	CH7C0
	CPI	'N'
	MVI	C,0
	JNZ	CH7CA
CH7C0:	LXI	H,SIOB+1
	MOV	A,M		; wr4 info
	ANI	0FCH		; mask
	ORA	C
	MOV	M,A		; store it

CH7D:	CALL	ILPRT
	DB	CR,LF,LF,'Baud rates:'
	DB	CR,LF,'0. 110                  5. 2400'
	DB	CR,LF,'1. 300                  6. 4800'
	DB	CR,LF,'2. 450                  7. 9600'
	DB	CR,LF,'3. 600'
	DB	CR,LF,'4. 1200'
	DB	CR,LF,LF,'Choose one.  (0 through 7) $'

CH7DA:	CALL	CONIN
	CPI	CR
	JZ	CH7E
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	CPI	'8'
	JNC	CH7DA
	CPI	'0'
	JC	CH7DA
	JZ	BB110
	CPI	'1'
	JZ	BB300
	CPI	'2'
	JZ	BB450
	CPI	'3'
	JZ	BB600
	CPI	'4'
	JZ	BB1200
	CPI	'5'
	JZ	BB2400
	CPI	'6'
	JZ	BB4800

BB9600:	LXI	H,CT1
	MVI	A,47H
	MOV	M,A
	INX	H
	MVI	A,13
	MOV	M,A
	LXI	H,SIOB+1
	MOV	A,M
	ANI	3FH
	ORI	40H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A
	JMP	CH7E

BB4800:	LXI	H,CT1
	MVI	A,47H
	MOV	M,A
	INX	H
	MVI	A,26
	MOV	M,A
	LXI	H,SIOB+1
	MOV	A,M
	ANI	3FH
	ORI	40H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A
	JMP	CH7E

BB2400:	LXI	H,CT1
	MVI	A,47H
	MOV	M,A
	INX	H
	MVI	A,52
	MOV	M,A
	LXI	H,SIOB+1
	MOV	A,M
	ANI	3FH
	ORI	40H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A
	JMP	CH7E

BB1200:	LXI	H,CT1
	MVI	A,47H
	MOV	M,A
	INX	H
	MVI	A,104
	MOV	M,A
	LXI	H,SIOB+1
	MOV	A,M
	ANI	3FH
	ORI	40H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A
	JMP	CH7E

BB600:	LXI	H,CT1
	MVI	A,47H
	MOV	M,A
	INX	H
	MVI	A,208
	MOV	M,A
	LXI	H,SIOB+1
	MOV	A,M
	ANI	3FH
	ORI	40H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A
	JMP	CH7E

BB450:	LXI	H,CT1
	MVI	A,47H
	MOV	M,A
	INX	H
	MVI	A,139
	MOV	M,A
	LXI	H,SIOB+1
	MOV	A,M
	ANI	3FH
	ORI	80H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A
	JMP	CH7E

BB300:	LXI	H,CT1
	MVI	A,47H
	MOV	M,A
	INX	H
	MVI	A,208
	MOV	M,A
	LXI	H,SIOB+1
	MOV	A,M
	ANI	3FH
	ORI	80H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A
	JMP	CH7E

BB110:	LXI	H,CT1
	MVI	A,7H
	MOV	M,A
	INX	H
	MVI	A,71
	MOV	M,A
	LXI	H,SIOB+1
	MOV	A,M
	ANI	3FH
	ORI	80H
	MOV	M,A
	INX	H
	INX	H
	MOV	A,M
	ORI	80H
	MOV	M,A

CH7E:	CALL	ILPRT
	DB	CR,LF,LF,'Hand shake?  (Yes or No) $'
CH7EA:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	CR
	JZ	DISP
	ANI	UPCASE
	CPI	'Y'
	MVI	C,1
	JZ	CH7E1
	CPI	'N'
	MVI	C,0
	JNZ	CH7EA
CH7E1:	MOV	A,C
	STA	HSB
	JMP	DISP

DISP16:	CALL	ILPRT
	DB	'        data bits       $'
	LDAX	D		; wr5 info
	ANI	60H		; mask
	CPI	60H		; 8 bits
	MVI	C,'8'
	JZ	DISP7
	CPI	20H		; 7 bits
	MVI	C,'7'
	JZ	DISP7
	CPI	40H		; 6 bits
	MVI	C,'6'
	JZ	DISP7
	MVI	C,'5'
DISP7:	CALL	CONOUT
	CALL	ILPRT
	DB	CR,LF,'   configuration        stop bits       $'
	DCX	D
	DCX	D
	LDAX	D		; wr4 info
	ANI	0CH		; mask
	CPI	8
	JNZ	DISP8
	CALL	ILPRT
	DB	'1.5$'
	JMP	DISP10
DISP8:	CPI	4
	MVI	C,'1'
	JZ	DISP9
	MVI	C,'2'
DISP9:	CALL	CONOUT
DISP10:	CALL	ILPRT
	DB	CR,LF,'                        parity          $'
	LDAX	D		; wr4 info
	ANI	3		; mask
	CPI	1
	LXI	H,ODD
	JZ	DISP12
	CPI	3
	LXI	H,EVEN
	JZ	DISP12
	LXI	H,NONE
DISP12:	JMP	PRINT

FINI:	CALL	ILPRT
	DB	CR,LF,LF,'Install changes in Memory or on Disk?  (M or D)'
	DB	CR,LF,'Press <ESC> to exit.$'
FINIA:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	EXIT
	ANI	UPCASE
	CPI	'M'
	JZ	PUTMEM
	CPI	'D'
	JZ	PUTDSK
	JMP	FINIA

PUTMEM:	CALL	PUTM
	CALL	IOINIT
	CALL	ILPRT
	DB	CR,LF,LF,'Changes installed in memory.$'
	JMP	FINI

PUTDSK:	lda	lb$vers
	cpi	20
	cp	display$fdev
PDSK0:	CALL	ILPRT
	DB	CR,LF,LF,'Install changes on which disk?  (A thru '
PDSK1:	DB	'P)  $'

PTDSKA:	CALL	CONIN
	CPI	CTLC
	JZ	EXIT
	CPI	ESC
	JZ	DISP
	ANI	UPCASE
	CPI	'A'
	JC	PTDSKA
DSK2:	EQU	$+1		;MODIFIED
	CPI	'P'+1
	JNC	PTDSKA
	PUSH	PSW
	MOV	C,A
	CALL	CONOUT
	POP	PSW
	STA	PDSK
	ANI	0FH
	DCR	A
	STA	DISK
	CALL	PUTD
	JNZ	FINI		;in case disk error
	CALL	ILPRT
	DB	CR,LF,LF,'Changes installed on disk '
PDSK:	DB	'A$'
	JMP	FINI


; print the baud rate
; bc points to ctc init string, de points to sio init string
PBAUD:	LDAX	B		; get first ctc byte
	CPI	3		; reset?
	JZ	DISP13
	CPI	47H
	LXI	H,B1
	JNZ	DISP14		; must be 7, print 110 baud
	INX	B		; point to second byte of ctc string
	LDAX	B
	CPI	13
	LXI	H,B96
	JZ	DISP14		; print 9600 baud
	CPI	26
	LXI	H,B48
	JZ	DISP14
	CPI	52
	LXI	H,B24
	JZ	DISP14
	CPI	104
	LXI	H,B12
	JZ	DISP14
	CPI	208
	LXI	H,B4
	JNZ	DISP14
	LDAX	D		; wr4 info
	ANI	0C0H		; mask
	CPI	40H
	LXI	H,B6
	JZ	DISP14
	LXI	H,B3
	JMP	DISP14
DISP13:	LDAX	D		; wr4 info
	ANI	0C0H
	CPI	40H
	LXI	H,B384
	JZ	DISP14
	LXI	H,B192
DISP14:	JMP	PRINT		; print returns to caller	



; get parameters from memory
GETM:	LHLD	1		; bios address
	MVI	L,64		; parameters start here
	LXI	D,IOBUF		; and go here
	LXI	B,64		; 64 bytes
	JMP	LDIR		; move it

; put parameters in memory
PUTM:	LHLD	1		; bios address
	MVI	L,64		; parms go here
	XCHG			; in de
	LXI	H,IOBUF		; parms from here
	LXI	B,64		; 64 bytes
	JMP	LDIR		; move it

; get parameters from disk
GETD:	MVI	A,1
	STA	TRACK		; track 1
	STA	RDOP		; this is a read
	MVI	A,5
	STA	SECTOR		; bios starts here
	CALL	DSKIO
		; read it

; check to see if the system is really here...

	LXI	H,BUFFER
	LXI	D,3
	LXI	B,17		;test for 17 C3 bytes
GETD0:
	MOV	A,M		;Calculate check sum on Jump table
	ORA	B	
	MOV	B,A
	DAD	D		
	DCR	C
	JNZ	GETD0
	MOV	A,B
	CPI	0C3H		; If any other bit is an error
	RNZ
GETD1:
	LXI	H,BUFFER+64	; from second half of buffer
	LXI	D,IOBUF		;  to io buffer
	LXI	B,64		; 64 bytes
	JMP	LDIR		; move it

; put parameters on disk
PUTD:	lda	disk
	call	lb$get$ldte
	mov	a,m
	ora	a
	jnz	putdok
	call	ilprt
	db	cr,lf,lf,'No disk at this letter ',cr,lf,'$'
	mvi	a,0ffh
	ora	a
	ret
putdok:	MVI	A,1
	STA	TRACK
	STA	RDOP		; read first
	MVI	A,5
	STA	SECTOR
	CALL	DSKIO		; do the read
	LXI	H,IOBUF		; parms from here
	LXI	D,BUFFER+64	;  to here
	LXI	B,64		; 64 bytes
	CALL	LDIR		; move it
	XRA	A
	STA	RDOP		; write
	CALL	DSKIO		;do the write
	ORA	A
	RZ
	CALL	ILPRT
	DB	CR,LF,LF,'Disk Write Error ',CR,LF,'$'
	MVI	A,0FFH
	ORA	A		;set nz on return
	RET


; reads or writes one sector of the disk
DSKIO:	LDA	DISK		; chosen disk
	call	lb$get$ldte
	mov	a,m
	ora	a
	rz
	lda	disk
	MOV	C,A
	MVI	E,0		; new mount, get new dpb
	CALL	SELDSK		; select the disk
	LXI	D,10		; OFFSET TO CURRENT DPB
	DAD	D
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
	MOV	A,M		; THIS IS THE SECTOR PER TRACK
	CPI	64		; IF NOT 64 THEN IS TRK 1 SECT 5 
	JNZ	DSKIF		;  NO THEN USE FLOPPY VALUES
	MVI	A,45		; SET TRACK 0 SECTOR 45 FOR HARD DISK
	STA	SECTOR
	XRA	A		; AND TRACK 0
	STA	TRACK
DSKIF:
	CALL	HOME		; reset hstact flag, forces readhst
	LDA	TRACK		; chosen track
	MOV	C,A
	CALL	SETTRK
	LDA	SECTOR		; chosen sector
	MOV	C,A
	CALL	SETSEC
	LXI	B,BUFFER	; all reads and writes to/from here
	CALL	SETDMA
	LDA	RDOP		; read operation flag
	ORA	A
	JZ	WRIT		; must be write
	JMP	READ		; read returns to caller
WRIT:	MVI	C,1		; force pre-read and write
	JMP	WRITE		; write returns to caller

; logical z80 'ldir' instruction
LDIR:	MOV	A,M		; from source
	STAX	D		; to destination
	INX	H		; next
	INX	D
	DCX	B		; decrement byte count
	MOV	A,B
	ORA	C
	JNZ	LDIR		; again
	RET

; prints the string pointed to by hl
PRINT:	MOV	A,M		; get a byte
	INX	H		; bump pointer
	CPI	'$'		; terminator?
	RZ			; yes, return
	CPI	0
	RZ
	ANI	7FH		; force ascii
	PUSH	PSW
	MOV	C,A
	CALL	CONOUT		; to console
	POP	PSW
	CPI	LF
	CZ	WAIT		; wait 10 ms after line feed
	JMP	PRINT		; again

; prints the string folloing the call to ilprt
ILPRT:	XTHL			; point hl to next byte
	CALL	PRINT
	XTHL			; put next address on stack
	RET

WAIT:	PUSH	B
	LXI	B,10 * 167	; wait x (* 167) milliseconds
WT0:	DCX	B
	MOV	A,B
	ORA	C
	JNZ	WT0
	POP	B
	RET

CONOUT:	PUSH	H
	PUSH	D
	PUSH	B
	MOV	E,C
	MVI	C,2
	CALL	5
	POP	B
	POP	D
	POP	H
	RET

; direct bios calls
CONIN:	MVI	A,CNIN
	JMP	BIOS

HOME:	MVI	A,HOM
	JMP	BIOS

SELDSK:	MVI	A,SLDSK
	JMP	BIOS

SETTRK:	MVI	A,STTRK
	JMP	BIOS

SETSEC:	MVI	A,STSEC
	JMP	BIOS

SETDMA:	MVI	A,STDMA
	JMP	BIOS

READ:	MVI	A,READS
	JMP	BIOS

WRITE:	MVI	A,WRITS
	JMP	BIOS

IOINIT:	MVI	A,IOINT

BIOS:	LHLD	1
	MOV	L,A
	PCHL

EXIT:	JMP	0

; 'stubs' for testing, to be removed later
T1:	CALL	ILPRT
	DB	'T1',CR,LF,'$'
	RET
T2:	CALL	ILPRT
	DB	'T2',CR,LF,'$'
	RET
T3:	CALL	ILPRT
	DB	'T3',CR,LF,'$'
	RET

DISK:	DB	2	; disk c:
TRACK:	DB	1
SECTOR:	DB	5
RDOP:	DB	1	; read operation

SPA:	DB	'Serial Port A$'
SPB:	DB	'Serial Port B$'
PP:	DB	'Parallel Port$'
ODD:	DB	'odd$'
EVEN:	DB	'even$'
NONE:	DB	'none$'
B384:	DB	'38400$'
B192:	DB	'19200$'
B96:	DB	'9600$'
B48:	DB	'4800$'
B24:	DB	'2400$'
B12:	DB	'1200$'
B6:	DB	'600$'
B4:	DB	'450$'
B3:	DB	'300$'
B1:	DB	'110$'
Y:	DB	'yes$'
N:	DB	'no$'

BUFFER:	EQU	$ + 7FH AND 0FF80H	; at sector boundary for readability
	ORG	BUFFER
	DS	128
IOBUF:
CT0:	DS	2
CT1:	DS	2
CT2:	DS	2
CT3:	DS	2
SIOA:	DS	10
SIOB:	DS	10
NDSKS:	DS	1
STPRAT:	DS	4
IOBYT:	DS	1
AUTOCMD:DS	10
HSA:	DS	1
HSB:	DS	1

	DS	32
STACK:	END	START


