# @(#)errstrip.awk 5.3b of Jan 27, 1988

# This Awk script takes as input an error log file and produces a report
# containing only the time and text fields of each record.
# If a gap appears in the sequence numbers, a message is added to the 
# report where the gap occurs.
# Note: sequence number 0 is used by the error logger daemon itself.

BEGIN { chkseq = 0; }

{
# check sequence number ($1)
if (chkseq && $1 != 0 && $1 != seq+1) {
	missing = $1-seq-1;
	if (missing == 1)
		printf("WARNING: 1 message missing.\n");
	else if (missing > 1)
		printf("WARNING: %d messages missing.\n", $1-seq-1);
	else
		printf("WARNING: Gap in message sequence.\n");
}
if ($1 != 0) {
	chkseq = 1;
	seq = $1;
}
# print record
printf("%s  ", $2) ; for(i=7; i<=NF; i++) printf(" %s", $i); printf("\n");
}
